/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.Fotogalerie;
import cz.triangle.domy.Jazyk;
import cz.triangle.domy.Lokalita;
import cz.triangle.domy.LokalitaJaz;
import cz.triangle.domy.Obsah;
import cz.triangle.domy.PolozkaMenu;
import cz.triangle.domy.SkupinaFotogalerie;
import cz.triangle.domy.StromMenu;
import cz.triangle.domy.Upoutavka;
import cz.triangle.domy.form.AdminPolozkaForm;
import cz.triangle.domy.www.PrezentaceDelegate;
import cz.triangle.domy.www.StringStringComparator;
import cz.triangle.util.HibernateUtil;
import cz.triangle.util.StringString;
import cz.triangle.util.UpravaRetezce;
import fr.improve.struts.taglib.layout.menu.MenuComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ClankyDelegate
implements Serializable {
    private LinkedHashMap typyPolozekMap = new LinkedHashMap();
    private String odkaz;
    private MenuComponent vybraneMenuComponent = null;
    private MessageResources res;
    private String idLang;
    public static final String TYP_POLOZKA = "polozka";
    public static final String TYP_STRANKA_CLANKY = "clanky.jsp";

    public ClankyDelegate(String idLang, String odkaz, MessageResources res) {
        this.odkaz = odkaz;
        this.res = res;
        this.idLang = idLang;
        String typys = res.getMessage("admin.typystranek");
        if (typys != null) {
            StringTokenizer st = new StringTokenizer(typys, ";,");
            while (st.hasMoreTokens()) {
                this.typyPolozekMap.put(st.nextToken(), st.nextToken());
            }
        } else {
            this.typyPolozekMap.put(TYP_STRANKA_CLANKY, "text");
            this.typyPolozekMap.put("seznam_anotaci.jsp", "\u00favodn\u00ed str\u00e1nka projektu");
            this.typyPolozekMap.put("byty.jsp", "p\u016fdorysy byt\u016f");
            this.typyPolozekMap.put("cenik.jsp", "cen\u00edk");
            this.typyPolozekMap.put("cenik_rd.jsp", "cen\u00edk RD");
            this.typyPolozekMap.put("cenik_np.jsp", "cen\u00edk nebytov\u00fdch prostor");
            this.typyPolozekMap.put("fotogalerie.jsp", "fotogalerie");
            this.typyPolozekMap.put("vp.jsp", "virtu\u00e1ln\u00ed prohl\u00eddka");
            this.typyPolozekMap.put("rozcestnik_lokality.jsp", "rozcestn\u00edk projektu");
            this.typyPolozekMap.put("vypis_lokalit.jsp", "v\u00fdpis lokalit");
            this.typyPolozekMap.put("vypis_lokalit_aktualni.jsp", "v\u00fdpis aktu\u00e1ln\u00edch lokalit");
            this.typyPolozekMap.put("vypis_lokalit_dokoncene.jsp", "v\u00fdpis dokon\u010den\u00fdch lokalit");
            this.typyPolozekMap.put("vypis_lokalit_pripravovane.jsp", "v\u00fdpis p\u0159ipravovan\u00fdch lokalit");
            this.typyPolozekMap.put("cenik_celkovy.jsp", "cen\u00edk celkov\u00fd");
            this.typyPolozekMap.put("rozcestnik_rd.jsp", "rozcestn\u00edk RD");
            this.typyPolozekMap.put("typ_rd.jsp", "typ RD");
        }
    }

    public Map nactiMenu(String kod, String typ, Session hsess) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        List polozky = hsess.createQuery("from PolozkaMenu polozka left join fetch polozka.obsahs obsah where polozka.idJazyk = ? order by polozka.razeni").setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY).setString(0, this.idLang).list();
        StromMenu strom = new StromMenu(polozky);
        strom.vytvor(null, true);
        MenuComponent treeData = new MenuComponent();
        treeData.setTitle("root");
        treeData.setDescription("root");
        treeData.setName("root");
        if (strom.getPolozky().size() > 0) {
            boolean leaf;
            List menu0 = (List)strom.getMenu().get(0);
            boolean bl = leaf = menu0 == null || menu0.size() <= 0;
            if (!leaf) {
                this.vytvorPolozky(menu0, treeData, strom, kod, typ, hsess);
            }
            if (kod != null && this.vybraneMenuComponent == null) {
                vysledek.put("chyba", this.res.getMessage("admin.chyba.vybrano_neexistujici_id"));
            }
        }
        vysledek.put("strom", (String)treeData);
        return vysledek;
    }

    private void vytvorPolozky(List polozky, MenuComponent rodic, StromMenu strom, String vybranyKod, String typ, Session hsess) {
        for (PolozkaMenu polozka : polozky) {
            List podmenu = (List)strom.getPodmenu().get(polozka.getKod());
            boolean leaf = podmenu == null;
            MenuComponent node = new MenuComponent();
            node.setTitle(String.valueOf(polozka.getPopisek()) + " (" + polozka.getRazeni() + ")");
            node.setDescription(polozka.getKod());
            node.setToolTip(TYP_POLOZKA);
            node.setImage("yellow-folder-closed.png");
            node.setLocation("admin_clanek.do?akce=editace_polozky&typ=polozka&id=" + polozka.getKod());
            if (typ != null && typ.equalsIgnoreCase(TYP_POLOZKA) && vybranyKod != null && vybranyKod.equalsIgnoreCase(polozka.getKod())) {
                node.setStyle("font-weight: bold;");
                this.vybraneMenuComponent = node;
            }
            rodic.addMenuComponent(node);
            if (!leaf) {
                this.vytvorPolozky(podmenu, node, strom, vybranyKod, typ, hsess);
            }
            for (Obsah obsah : polozka.getObsahs()) {
                MenuComponent nodeO = new MenuComponent();
                nodeO.setTitle(String.valueOf(obsah.getNazev()) + " (" + obsah.getRazeni() + ")");
                nodeO.setDescription(obsah.getId().toString());
                nodeO.setToolTip("dokument");
                nodeO.setImage("document.png");
                nodeO.setLocation("admin_dokument.do?akce=editace_dokumentu&typ=dokument&id=" + obsah.getId());
                Integer vybranyKodi = null;
                try {
                    vybranyKodi = new Integer(vybranyKod);
                }
                catch (NumberFormatException e) {
                    vybranyKodi = null;
                }
                if (typ != null && typ.equalsIgnoreCase("dokument") && vybranyKodi != null && vybranyKodi.equals(obsah.getId())) {
                    nodeO.setStyle("font-weight: bold;");
                    this.vybraneMenuComponent = nodeO;
                }
                node.addMenuComponent(nodeO);
            }
        }
    }

    public void otevriVybrany() {
        if (this.vybraneMenuComponent != null) {
            MenuComponent tmp = this.vybraneMenuComponent.getParent();
            while (tmp != null) {
                tmp.setOpen(true);
                tmp = tmp.getParent();
            }
        }
    }

    public String getRozvinutyPopisek(String kod, StromMenu strom) {
        String vysledek = "";
        PolozkaMenu polozka = (PolozkaMenu)strom.getPolozky().get(kod);
        int i = 0;
        while (polozka != null) {
            vysledek = i > 0 ? String.valueOf(polozka.getPopisek()) + " - " + vysledek : polozka.getPopisek();
            String kodRodic = polozka.getKodRodic();
            if (kodRodic == null) break;
            polozka = (PolozkaMenu)strom.getPolozky().get(kodRodic);
            ++i;
        }
        return vysledek;
    }

    public List getSeznamLokalit(Session hsess) {
        List vysledek = hsess.createQuery("from Lokalita lokalita order by lokalita.razeni").list();
        return vysledek;
    }

    public Lokalita nactiLokalitu(String id, Session hsess) {
        Lokalita vysledek;
        try {
            vysledek = (Lokalita)hsess.get(Lokalita.class, (Serializable)new Integer(id));
        }
        catch (Exception e) {
            return null;
        }
        return vysledek;
    }

    public MenuComponent getVybraneMenuComponent() {
        return this.vybraneMenuComponent;
    }

    public Map novaPolozka(String id, AdminPolozkaForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            AdminPolozkaForm form = f;
            if (form == null) {
                form = new AdminPolozkaForm();
                form.setKodRodic(id);
                form.setStranka("TYP_STRANKY_CLANKY");
            }
            vysledek.put("adminPolozkaForm", (Object)form);
            List polozky = hsess.createQuery("from PolozkaMenu polozka where polozka.idJazyk = ? order by polozka.razeni").setString(0, this.idLang).list();
            StromMenu strom = new StromMenu(polozky);
            List seznamFotogalerii = hsess.createQuery("from Fotogalerie fotogalerie order by fotogalerie.nazev").list();
            PrezentaceDelegate pd = new PrezentaceDelegate();
            PolozkaMenu polozkaRozcestnikLokality = pd.getPolozkuRozcestnikLokality((PolozkaMenu)strom.getPolozky().get(id), strom, this.idLang, hsess);
            List domy = null;
            domy = polozkaRozcestnikLokality != null && polozkaRozcestnikLokality.getLokalita() != null ? hsess.createQuery("from Dum dum where dum.lokalita=? order by dum.nazev").setEntity(0, (Object)polozkaRozcestnikLokality.getLokalita()).list() : new ArrayList();
            vysledek.put("domy", domy);
            vysledek.put("seznamFotogalerii", seznamFotogalerii);
            vysledek.put("seznamPolozek", this.getSeznamPolozek(strom, "-1", true));
            vysledek.put("seznamTypuPolozek", this.getSeznamTypuPolozek());
            vysledek.put("seznamLokalit", this.getSeznamLokalit(hsess));
            vysledek.put("seznamSkupinFotogalerii", this.nactiFlashoveSkupiny(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, AdminPolozkaForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            PolozkaMenu polozka = (PolozkaMenu)hsess.get(PolozkaMenu.class, (Serializable)((Object)id));
            AdminPolozkaForm form = f;
            List seznamFotogalerii = hsess.createQuery("from Fotogalerie fotogalerie order by fotogalerie.nazev").list();
            List polozky = hsess.createQuery("from PolozkaMenu polozka where polozka.idJazyk = ? order by polozka.razeni").setString(0, this.idLang).list();
            StromMenu strom = new StromMenu(polozky);
            if (form == null) {
                form = new AdminPolozkaForm();
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                String razeni = polozka.getRazeni();
                if (razeni == null) {
                    form.setRazeni_cislo("0");
                } else {
                    try {
                        Integer razenii = new Integer(razeni.substring(razeni.length() - 2, razeni.length()));
                        form.setRazeni_cislo(razenii.toString());
                    }
                    catch (NumberFormatException e) {
                        form.setRazeni_cislo("0");
                    }
                }
                if (polozka.getLokalita() != null) {
                    form.setLokalitaId(polozka.getLokalita().getId().toString());
                }
                if (polozka.getFotogalerie() != null) {
                    form.setFotogalerieId(polozka.getFotogalerie().getId().toString());
                }
                if (polozka.getSkupinaFotogalerie() != null) {
                    form.setSkupinaFotogalerieId(polozka.getSkupinaFotogalerie().getId().toString());
                }
                form.setHlavickaObrazekNazev(polozka.getHlavickaObrazek());
                form.setAnotaceObrazekNazev(polozka.getAnotaceObrazek());
                PrezentaceDelegate pd = new PrezentaceDelegate();
                PolozkaMenu polozkaRozcestnikLokality = pd.getPolozkuRozcestnikLokality(polozka, strom, this.idLang, hsess);
                List domy = null;
                if (polozkaRozcestnikLokality != null) {
                    if (polozka.getParametry2() != null && polozka.getParametry2().trim().length() > 0) {
                        List domyIds = hsess.createQuery("select dum.id from Dum dum where dum.id in (" + polozka.getParametry2() + ") order by dum.nazev").list();
                        form.setDomyIds(domyIds.toArray());
                    }
                    domy = hsess.createQuery("from Dum dum where dum.lokalita=? order by dum.nazev").setEntity(0, (Object)polozkaRozcestnikLokality.getLokalita()).list();
                }
                vysledek.put("domy", domy);
            }
            vysledek.put("id", polozka.getKod());
            vysledek.put("adminPolozkaForm", (Object)form);
            vysledek.put("seznamFotogalerii", seznamFotogalerii);
            vysledek.put("seznamSkupinFotogalerii", this.nactiFlashoveSkupiny(hsess));
            vysledek.put("seznamPolozek", this.getSeznamPolozek(strom, "-1", true));
            if (this.typyPolozekMap.get(polozka.getStranka()) != null) {
                vysledek.put("seznamTypuPolozek", this.getSeznamTypuPolozek());
            }
            vysledek.put("seznamLokalit", this.getSeznamLokalit(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return this.res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public List getSeznamPolozek(StromMenu strom, String kodVyjmutePolozky, boolean odstranitZakazane) {
        ArrayList<StringString> newList = new ArrayList<StringString>();
        for (PolozkaMenu element : strom.getPolozky().values()) {
            if (element.getKod().equals(kodVyjmutePolozky) || element.isZakazatDeti().booleanValue() && odstranitZakazane) continue;
            newList.add(new StringString(element.getKod(), this.getRozvinutyPopisek(element.getKod(), strom)));
        }
        Collections.sort(newList, new StringStringComparator());
        return newList;
    }

    public List getSeznamTypuPolozek() {
        ArrayList<StringString> newList = new ArrayList<StringString>();
        for (String klic : this.typyPolozekMap.keySet()) {
            newList.add(new StringString(klic, (String)this.typyPolozekMap.get(klic)));
        }
        return newList;
    }

    public Map zapsatNovouPolozku(AdminPolozkaForm form, ActionMapping mapping, HttpServletRequest request, String idJazyk, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminPolozkaForm", (Object)form);
                return vysledek;
            }
            Iterator iter = hsess.createQuery("from PolozkaMenu polozka where polozka.kod = ?").setString(0, form.getKod()).iterate();
            if (iter.hasNext()) {
                vysledek.put("validacni_chyba", this.res.getMessage("admin.chyba.duplikatni_polozka", (Object)form.getKod()));
                vysledek.put("adminPolozkaForm", (Object)form);
                return vysledek;
            }
            if (form.getLokalitaId() != null && !form.getLokalitaId().equalsIgnoreCase("-1") && (iter = hsess.createQuery("from PolozkaMenu polozka where polozka.idJazyk = ? and polozka.lokalita.id=?").setString(0, idJazyk).setInteger(1, new Integer(form.getLokalitaId()).intValue()).iterate()).hasNext()) {
                PolozkaMenu duplikat = (PolozkaMenu)iter.next();
                vysledek.put("validacni_chyba", this.res.getMessage("admin.chyba.duplikatni_lokalita", (Object)duplikat.getPopisek()));
                vysledek.put("adminPolozkaForm", (Object)form);
                return vysledek;
            }
            PolozkaMenu novaPolozka = new PolozkaMenu();
            BeanUtils.copyProperties((Object)novaPolozka, (Object)((Object)form));
            novaPolozka.setZakazatDeti(false);
            if (novaPolozka.getStranka() != null && (novaPolozka.getStranka().equalsIgnoreCase("rozcestnik_lokality.jsp") || novaPolozka.getStranka().equalsIgnoreCase(TYP_STRANKA_CLANKY))) {
                novaPolozka.setObsah(Boolean.FALSE);
            } else {
                novaPolozka.setObsah(Boolean.TRUE);
            }
            if (form.getLokalitaId() == null || form.getLokalitaId().equalsIgnoreCase("-1")) {
                novaPolozka.setLokalita(null);
            } else {
                novaPolozka.setLokalita((Lokalita)hsess.load(Lokalita.class, (Serializable)new Integer(form.getLokalitaId())));
            }
            if (form.getFotogalerieId() == null || form.getFotogalerieId().equalsIgnoreCase("-1")) {
                novaPolozka.setFotogalerie(null);
            } else {
                novaPolozka.setFotogalerie((Fotogalerie)hsess.load(Fotogalerie.class, (Serializable)new Integer(form.getFotogalerieId())));
            }
            if (form.getKodOdkaz1() == null || form.getKodOdkaz1().equalsIgnoreCase("-1")) {
                novaPolozka.setKodOdkaz1(null);
            }
            PolozkaMenu rodic = null;
            if (form.getKodRodic() == null || form.getKodRodic().equalsIgnoreCase("-1")) {
                novaPolozka.setKodRodic(null);
            } else {
                rodic = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)form.getKodRodic()));
            }
            if (form.getSkupinaFotogalerieId() == null || form.getSkupinaFotogalerieId().equalsIgnoreCase("-1")) {
                novaPolozka.setSkupinaFotogalerie(null);
            } else {
                novaPolozka.setSkupinaFotogalerie((SkupinaFotogalerie)hsess.load(SkupinaFotogalerie.class, (Serializable)new Integer(form.getSkupinaFotogalerieId())));
            }
            if (novaPolozka.getStranka() != null && novaPolozka.getStranka().equalsIgnoreCase(TYP_STRANKA_CLANKY)) {
                novaPolozka.setObsah(Boolean.FALSE);
            } else {
                novaPolozka.setObsah(Boolean.TRUE);
            }
            novaPolozka.setLink(novaPolozka.getKod());
            novaPolozka.setRazeni(this.vytvorRazeni(novaPolozka, rodic, new Integer(form.getRazeni_cislo())));
            novaPolozka.setIdJazyk(idJazyk);
            vysledek.put("adminPolozkaForm", (Object)form);
            hsess.save((Object)novaPolozka);
            FormFile file = form.getHlavickaObrazekFile();
            long privesek = Math.round(Math.random() * 1000.0);
            if (file != null && file.getFileName().length() > 0) {
                novaPolozka.setHlavickaObrazek(this.ulozHlavicku(cesta, privesek, file));
            }
            if ((file = form.getAnotaceObrazekFile()) != null && file.getFileName().length() > 0) {
                novaPolozka.setAnotaceObrazek(this.ulozAnotaceObrazek(cesta, novaPolozka.getKod(), privesek, file));
            }
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map zapsatPolozku(AdminPolozkaForm form, String id, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Iterator iter;
            Iterator iter2;
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminPolozkaForm", (Object)form);
                return vysledek;
            }
            PolozkaMenu polozka = null;
            PolozkaMenu staraPolozka = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)id));
            PolozkaMenu staryRodic = null;
            if (staraPolozka.getKodRodic() != null) {
                staryRodic = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)staraPolozka.getKodRodic()));
            }
            if (!staraPolozka.getKod().equals(form.getKod())) {
                iter2 = hsess.createQuery("from PolozkaMenu polozka where polozka.kod = ?").setString(0, form.getKod()).iterate();
                if (iter2.hasNext()) {
                    vysledek.put("validacni_chyba", this.res.getMessage("admin.chyba.duplikatni_polozka", (Object)form.getKod()));
                    vysledek.put("adminPolozkaForm", (Object)form);
                    return vysledek;
                }
                polozka = new PolozkaMenu();
                polozka.setObsah(staraPolozka.getObsah());
                polozka.setIdJazyk(staraPolozka.getIdJazyk());
                staraPolozka.setKodRodic(null);
                staraPolozka.setKodOdkaz1(null);
            } else {
                polozka = staraPolozka;
            }
            if (staraPolozka.getLokalita() != null && !staraPolozka.getLokalita().getId().toString().equals(form.getLokalitaId()) && form.getLokalitaId() != null && !form.getLokalitaId().equalsIgnoreCase("-1") && (iter2 = hsess.createQuery("from PolozkaMenu polozka where polozka.idJazyk = ? and polozka.lokalita.id=?").setString(0, staraPolozka.getIdJazyk()).setInteger(1, new Integer(form.getLokalitaId()).intValue()).iterate()).hasNext()) {
                PolozkaMenu duplikat = (PolozkaMenu)iter2.next();
                vysledek.put("validacni_chyba", this.res.getMessage("admin.chyba.duplikatni_lokalita", (Object)duplikat.getPopisek()));
                vysledek.put("adminPolozkaForm", (Object)form);
                return vysledek;
            }
            BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
            if (form.getLokalitaId() == null || form.getLokalitaId().equalsIgnoreCase("-1")) {
                polozka.setLokalita(null);
            } else {
                polozka.setLokalita((Lokalita)hsess.load(Lokalita.class, (Serializable)new Integer(form.getLokalitaId())));
            }
            if (form.getFotogalerieId() == null || form.getFotogalerieId().equalsIgnoreCase("-1")) {
                polozka.setFotogalerie(null);
            } else {
                polozka.setFotogalerie((Fotogalerie)hsess.load(Fotogalerie.class, (Serializable)new Integer(form.getFotogalerieId())));
            }
            if (form.getKodOdkaz1() == null || form.getKodOdkaz1().equalsIgnoreCase("-1")) {
                polozka.setKodOdkaz1(null);
            }
            PolozkaMenu rodic = null;
            if (form.getKodRodic() == null || form.getKodRodic().equalsIgnoreCase("-1")) {
                polozka.setKodRodic(null);
            } else {
                rodic = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)form.getKodRodic()));
            }
            if (form.getSkupinaFotogalerieId() == null || form.getSkupinaFotogalerieId().equalsIgnoreCase("-1")) {
                polozka.setSkupinaFotogalerie(null);
            } else {
                polozka.setSkupinaFotogalerie((SkupinaFotogalerie)hsess.load(SkupinaFotogalerie.class, (Serializable)new Integer(form.getSkupinaFotogalerieId())));
            }
            polozka.setObsah(Boolean.TRUE);
            if (polozka.getStranka() != null && polozka.getStranka().equalsIgnoreCase("rozcestnik_lokality.jsp")) {
                polozka.setObsah(false);
            }
            if (polozka.getStranka() != null && polozka.getStranka().equalsIgnoreCase(TYP_STRANKA_CLANKY) && !(iter = hsess.createQuery("from Obsah obsah where obsah.polozkaMenu=?").setEntity(0, (Object)staraPolozka).setMaxResults(1).iterate()).hasNext()) {
                polozka.setObsah(Boolean.FALSE);
            }
            if (!staraPolozka.getKod().equals(form.getKod())) {
                staraPolozka.setLokalita(null);
            }
            hsess.flush();
            hsess.saveOrUpdate((Object)polozka);
            if (!staraPolozka.getKod().equals(form.getKod())) {
                iter = hsess.createQuery("from Obsah obsah where obsah.polozkaMenu=?").setEntity(0, (Object)staraPolozka).iterate();
                while (iter.hasNext()) {
                    Obsah obsah = (Obsah)iter.next();
                    obsah.setPolozkaMenu(polozka);
                }
                hsess.createQuery("update PolozkaMenu polozka set polozka.kodRodic=? where polozka.kodRodic=?").setString(0, polozka.getKod()).setString(1, staraPolozka.getKod()).executeUpdate();
                hsess.delete((Object)staraPolozka);
            }
            polozka.setLink(polozka.getKod());
            String retezRazeni = this.vytvorRazeni(polozka, rodic, new Integer(form.getRazeni_cislo()));
            if (!retezRazeni.equalsIgnoreCase(polozka.getRazeni())) {
                polozka.setRazeni(retezRazeni);
                this.upravRazeniDetem(polozka, new Integer(form.getRazeni_cislo()), hsess);
            }
            if (form.getSmazatHlavickaObrazek() != null && form.getSmazatHlavickaObrazek().booleanValue()) {
                if (staraPolozka.getHlavickaObrazek() != null && !staraPolozka.getHlavickaObrazek().equalsIgnoreCase("")) {
                    this.smazObrazek(String.valueOf(cesta) + "dbimg" + File.separator, staraPolozka.getHlavickaObrazek());
                }
                polozka.setHlavickaObrazek(null);
            }
            FormFile file = form.getHlavickaObrazekFile();
            long privesek = Math.round(Math.random() * 1000.0);
            if (file != null && file.getFileName().length() > 0) {
                polozka.setHlavickaObrazek(this.prepisHlavicku(cesta, privesek, file, polozka.getHlavickaObrazek()));
            }
            if ((file = form.getAnotaceObrazekFile()) != null && file.getFileName().length() > 0) {
                polozka.setAnotaceObrazek(this.ulozAnotaceObrazek(cesta, polozka.getKod(), privesek, file));
            }
            if (polozka.getStranka().equalsIgnoreCase("cenik.jsp")) {
                StringBuffer sb = new StringBuffer();
                if (form.getDomyIds() != null && form.getDomyIds().length > 0) {
                    int j = 0;
                    while (j < form.getDomyIds().length) {
                        String idDomu = (String)form.getDomyIds()[j];
                        if (j > 0) {
                            sb.append(',');
                        }
                        sb.append(idDomu);
                        ++j;
                    }
                }
                polozka.setParametry(sb.toString());
            }
            vysledek.put("adminPolozkaForm", (Object)form);
            hsess.flush();
        }
        catch (Exception e) {
            String zprava;
            String string = zprava = e.getMessage() != null ? e.getMessage() : "";
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                zprava = String.valueOf(zprava) + ", " + e.getCause().getMessage();
                if (e.getCause().getCause() != null && e.getCause().getCause().getMessage() != null) {
                    zprava = String.valueOf(zprava) + ", " + e.getCause().getCause().getMessage();
                }
            }
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)zprava));
            HibernateUtil.rollbackTransaction();
        }
        return vysledek;
    }

    public Map smazatPolozku(String id, String cesta, Session hsess) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        try {
            Iterator iter;
            PolozkaMenu staraPolozka = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)id));
            PolozkaMenu staryRodic = null;
            if (staraPolozka.getKodRodic() != null) {
                staryRodic = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)staraPolozka.getKodRodic()));
            }
            if ((iter = hsess.createQuery("from PolozkaMenu polozka where polozka.kodRodic = ?").setString(0, id).iterate()).hasNext()) {
                vysledek.put("chyba", this.res.getMessage("admin.chyba.detska_polozka", (Object)staraPolozka.getPopisek()));
                vysledek.put("id", staraPolozka.getKod());
                return vysledek;
            }
            iter = hsess.createQuery("from PolozkaMenu polozka where polozka.kodOdkaz1 = ?").setString(0, id).iterate();
            if (iter.hasNext()) {
                vysledek.put("chyba", this.res.getMessage("admin.chyba.odkaz1_polozka", (Object)staraPolozka.getPopisek()));
                vysledek.put("id", staraPolozka.getKod());
                return vysledek;
            }
            List seznam = hsess.createQuery("from Upoutavka upoutavka where upoutavka.polozkaMenu=? ").setEntity(0, (Object)staraPolozka).list();
            for (Upoutavka upoutavka : seznam) {
                if (upoutavka.getSoubor() != null && upoutavka.getSoubor().length() > 0) {
                    this.smazObrazek(String.valueOf(cesta) + "dbimg" + File.separator, upoutavka.getSoubor());
                }
                hsess.delete((Object)upoutavka);
            }
            if (staraPolozka.getHlavickaObrazek() != null && !staraPolozka.getHlavickaObrazek().equalsIgnoreCase("")) {
                this.smazObrazek(String.valueOf(cesta) + "dbimg" + File.separator, staraPolozka.getHlavickaObrazek());
            }
            staraPolozka.setKodRodic(null);
            staraPolozka.setKodOdkaz1(null);
            hsess.delete((Object)staraPolozka);
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public String vytvorRazeni(PolozkaMenu polozka, PolozkaMenu rodic, Integer razeni) {
        String vysledek = "";
        String razenis = razeni.toString();
        if (razenis.length() < 2) {
            razenis = "0" + razenis;
        }
        if (razenis.length() > 2) {
            razenis = razenis.substring(razenis.length(), razenis.length() - 2);
        }
        vysledek = rodic != null ? String.valueOf(rodic.getRazeni()) + "-" + razenis : razenis;
        return vysledek;
    }

    public void upravRazeniDetem(PolozkaMenu polozka, Integer razeni, Session hsess) {
        List polozky = hsess.createQuery("from PolozkaMenu polozka where polozka.kodRodic='" + polozka.getKod() + "'").list();
        for (PolozkaMenu polozkaMenu : polozky) {
            polozkaMenu.setRazeni(this.vytvorRazeni(polozkaMenu, polozka, new Integer(polozkaMenu.getRazeni().substring(polozkaMenu.getRazeni().lastIndexOf(45) + 1))));
            this.upravRazeniDetem(polozkaMenu, razeni, hsess);
        }
    }

    public List nactiUpoutavky(String id, Session hsess) {
        try {
            PolozkaMenu polozkaMenu = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)id));
            List polozky = hsess.createQuery("from Upoutavka upoutavka where upoutavka.polozkaMenu=? order by upoutavka.razeni").setEntity(0, (Object)polozkaMenu).list();
            return polozky;
        }
        catch (Exception e) {
            return null;
        }
    }

    public List nactiPrevzaneUpoutavky(String id, Session hsess) {
        try {
            PolozkaMenu polozka = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)id));
            List seznamUpoutavek = hsess.createQuery("from Upoutavka upoutavka where upoutavka.polozkaMenu=? order by upoutavka.razeni").setEntity(0, (Object)polozka).list();
            if (seznamUpoutavek.size() == 0 && polozka.getKodRodic() != null && !polozka.getKodRodic().equalsIgnoreCase("")) {
                return this.nactiPrevzaneUpoutavky(polozka.getKodRodic(), hsess);
            }
            return seznamUpoutavek;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String nastavJazyk(String jaz, HttpServletRequest request, Session hsess) {
        HttpSession session = request.getSession();
        Locale locale = null;
        String id_jazyk = null;
        List jazyky = hsess.createQuery("from Jazyk jazyk order by jazyk.id").list();
        if (jaz != null) {
            int i = 0;
            for (Jazyk jazyk : jazyky) {
                if (jaz.equalsIgnoreCase(jazyk.getId())) {
                    id_jazyk = jazyk.getId();
                    locale = new Locale(jazyk.getLocale());
                    break;
                }
                if (i == 0) {
                    id_jazyk = jazyk.getId();
                    locale = new Locale(jazyk.getLocale());
                }
                ++i;
            }
        } else {
            Jazyk jazyk = (Jazyk)jazyky.get(0);
            id_jazyk = jazyk.getId();
            locale = new Locale(jazyk.getLocale());
        }
        session.setAttribute("admin_jaz_id", (Object)id_jazyk);
        return id_jazyk;
    }

    public static String nactiJazyk(HttpServletRequest request, Session hsess) {
        HttpSession session = request.getSession();
        String id_jazyk = (String)session.getAttribute("admin_jaz_id");
        if (id_jazyk == null) {
            return ClankyDelegate.nastavJazyk(null, request, hsess);
        }
        return id_jazyk;
    }

    private void smazObrazek(String cesta, String soubor) {
        if (soubor != null && !soubor.equalsIgnoreCase("")) {
            File file = new File(String.valueOf(cesta) + soubor);
            file.delete();
        }
    }

    public String ulozHlavicku(String cesta, long privesek, FormFile file) {
        if (file != null && !file.getFileName().equalsIgnoreCase("")) {
            String koncovka = file.getFileName().substring(file.getFileName().lastIndexOf("."));
            String zacatek = file.getFileName().substring(0, file.getFileName().lastIndexOf("."));
            ClankyDelegate.zapisSoubor(file, String.valueOf(cesta) + "dbimg", String.valueOf(zacatek) + "_" + privesek + koncovka);
            return String.valueOf(zacatek) + "_" + privesek + koncovka;
        }
        return null;
    }

    public String ulozAnotaceObrazek(String cesta, String kod, long privesek, FormFile file) {
        if (file != null && !file.getFileName().equalsIgnoreCase("")) {
            String koncovka = file.getFileName().substring(file.getFileName().lastIndexOf("."));
            String zacatek = file.getFileName().substring(0, file.getFileName().lastIndexOf("."));
            ClankyDelegate.zapisSoubor(file, String.valueOf(cesta) + "dbimg", String.valueOf(zacatek) + "_" + privesek + koncovka);
            return String.valueOf(zacatek) + "_" + privesek + koncovka;
        }
        return null;
    }

    public String prepisHlavicku(String cesta, long privesek, FormFile file, String staryNazev) {
        if (file != null && !file.getFileName().equalsIgnoreCase("")) {
            if (staryNazev != null && !staryNazev.equalsIgnoreCase("")) {
                this.smazObrazek(String.valueOf(cesta) + "dbimg" + File.separator, staryNazev);
            }
            String koncovka = file.getFileName().substring(file.getFileName().lastIndexOf("."));
            String zacatek = file.getFileName().substring(0, file.getFileName().lastIndexOf("."));
            ClankyDelegate.zapisSoubor(file, String.valueOf(cesta) + "dbimg", String.valueOf(zacatek) + "_" + privesek + koncovka);
            return String.valueOf(zacatek) + "_" + privesek + koncovka;
        }
        return null;
    }

    public static boolean zapisSoubor(FormFile file, String umisteni, String soubor) {
        boolean vysledek = true;
        try {
            FileOutputStream bos = new FileOutputStream(String.valueOf(umisteni) + File.separator + soubor);
            InputStream stream = file.getInputStream();
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)bos).write(buffer, 0, bytesRead);
            }
            ((OutputStream)bos).close();
        }
        catch (IOException e) {
            return false;
        }
        return vysledek;
    }

    public void vlozPolozkuXML(Lokalita lokalita, Node node, PolozkaMenu rodic, Session hsess) throws ParserConfigurationException, SAXException, IOException {
        node = node.getFirstChild();
        int i = 5;
        do {
            Element polozkaMenu;
            if (node == null || node.getNodeType() != 1 || !(polozkaMenu = (Element)node).getTagName().equalsIgnoreCase("polozkaMenu")) continue;
            PolozkaMenu novaPolozka = new PolozkaMenu();
            novaPolozka.setObsah(new Boolean(this.getObsahTagu(polozkaMenu, "obsah")));
            novaPolozka.setStranka(this.getObsahTagu(polozkaMenu, "stranka"));
            novaPolozka.setIdJazyk(this.getObsahTagu(polozkaMenu, "id_jazyk"));
            String nazevLokality = ((LokalitaJaz)lokalita.getLokalitaJazs().get(novaPolozka.getIdJazyk())).getNazev();
            String kod = UpravaRetezce.odstranVse(nazevLokality);
            novaPolozka.setKod(this.upravKod(this.getObsahTagu(polozkaMenu, "kod").replace("@@upraveny_nazev", kod), hsess));
            novaPolozka.setPopisek(this.getObsahTagu(polozkaMenu, "popisek").replace("@@nazev", nazevLokality));
            novaPolozka.setTitulek(this.getObsahTagu(polozkaMenu, "titulek").replace("@@nazev", nazevLokality));
            if (novaPolozka.getStranka().equalsIgnoreCase("rozcestnik_lokality.jsp")) {
                novaPolozka.setObsah(Boolean.FALSE);
                novaPolozka.setLokalita(lokalita);
            } else {
                novaPolozka.setObsah(Boolean.TRUE);
            }
            System.out.println(novaPolozka.getKod());
            novaPolozka.setLink(novaPolozka.getKod());
            novaPolozka.setZakazatDeti(false);
            if (rodic == null) {
                novaPolozka.setRazeni(this.vytvorRazeni(novaPolozka, rodic, new Integer(90)));
            } else {
                novaPolozka.setRazeni(this.vytvorRazeni(novaPolozka, rodic, new Integer(i)));
            }
            if (rodic != null) {
                novaPolozka.setKodRodic(rodic.getKod());
            } else {
                String podminka = null;
                if (lokalita.getTypStavuLokality() != null && lokalita.getTypStavuLokality().getId().equalsIgnoreCase("aktualni")) {
                    podminka = "vypis_lokalit.jsp";
                }
                if (lokalita.getTypStavuLokality() != null && lokalita.getTypStavuLokality().getId().equalsIgnoreCase("dokoncene")) {
                    podminka = "vypis_lokalit_dokoncene.jsp";
                }
                if (lokalita.getTypStavuLokality() != null && lokalita.getTypStavuLokality().getId().equalsIgnoreCase("pripravovane")) {
                    podminka = "vypis_lokalit_pripravovane.jsp";
                }
                if (podminka != null) {
                    PolozkaMenu novyRodic = null;
                    if (podminka.equalsIgnoreCase("vypis_lokalit.jsp")) {
                        novaPolozka.setKodRodic(null);
                    } else {
                        Iterator iter2 = hsess.createQuery("from PolozkaMenu polozka where polozka.stranka=? and polozka.idJazyk=?").setString(0, podminka).setString(1, novaPolozka.getIdJazyk()).iterate();
                        if (iter2.hasNext()) {
                            novyRodic = (PolozkaMenu)iter2.next();
                            novaPolozka.setKodRodic(novyRodic.getKod());
                        }
                    }
                }
            }
            hsess.save((Object)novaPolozka);
            this.vlozDocumentXML(lokalita, node, novaPolozka, hsess);
            this.vlozPolozkuXML(lokalita, node, novaPolozka, hsess);
            i += 5;
        } while ((node = node.getNextSibling()) != null);
    }

    public void vlozDocumentXML(Lokalita lokalita, Node node, PolozkaMenu rodic, Session hsess) {
        node = node.getFirstChild();
        int i = 0;
        DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale("cs", "CZ"));
        String nazevLokality = ((LokalitaJaz)lokalita.getLokalitaJazs().get(rodic.getIdJazyk())).getNazev();
        do {
            Element obsahTag;
            if (node == null || node.getNodeType() != 1 || !(obsahTag = (Element)node).getTagName().equalsIgnoreCase("clanek")) continue;
            Obsah obsah = new Obsah();
            obsah.setNazev("uvod");
            obsah.setPolozkaMenu(rodic);
            obsah.setRazeni(i * 10);
            obsah.setText(obsahTag.getTextContent().replaceAll("@@nazev", nazevLokality));
            Date dnes = new Date();
            Calendar cal = Calendar.getInstance();
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
            obsah.setZverejneniOd(cal.getTime());
            cal.add(1, 10);
            obsah.setZverejneniDo(cal.getTime());
            hsess.save((Object)obsah);
            ++i;
        } while ((node = node.getNextSibling()) != null);
    }

    private String getObsahTagu(Element element, String tagName) {
        try {
            NodeList list = element.getElementsByTagName(tagName);
            if (list.getLength() > 0) {
                Element nalezenec = (Element)list.item(0);
                return nalezenec.getTextContent();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private String upravKod(String vzor, Session hsess) {
        String tmpKod = vzor;
        boolean ok = false;
        int i = 0;
        while (!ok) {
            Iterator iter = hsess.createQuery("from PolozkaMenu polozka where polozka.kod = ?").setString(0, tmpKod).iterate();
            if (iter.hasNext()) {
                tmpKod = String.valueOf(vzor) + i;
            } else {
                ok = true;
            }
            ++i;
        }
        return tmpKod;
    }

    private List nactiFlashoveSkupiny(Session hsess) {
        return hsess.createQuery("from SkupinaFotogalerie skupina left join fetch skupina.skupinaFotogalerieJazs skupinaFotogalerieJaz where skupinaFotogalerieJaz.jazyk.id=? and flash is not null and flash <>''").setString(0, this.idLang).list();
    }
}

