/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;

public class FileIO {
    protected static final int BLKSIZ = 16384;

    private FileIO() {
    }

    public static void copyFile(String inName, String outName) throws FileNotFoundException, IOException {
        BufferedInputStream is = new BufferedInputStream(new FileInputStream(inName));
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(outName));
        FileIO.copyFile(is, os, true);
    }

    public static void copyFile(InputStream is, OutputStream os, boolean close) throws IOException {
        int i;
        byte[] b = new byte[16384];
        while ((i = is.read(b)) != -1) {
            os.write(b, 0, i);
        }
        is.close();
        if (close) {
            os.close();
        }
    }

    public static void copyFile(Reader is, Writer os, boolean close) throws IOException {
        int b;
        BufferedReader bis = new BufferedReader(is);
        while ((b = is.read()) != -1) {
            os.write(b);
        }
        is.close();
        if (close) {
            os.close();
        }
    }

    public static void copyFile(String inName, PrintWriter pw, boolean close) throws FileNotFoundException, IOException {
        BufferedReader ir = new BufferedReader(new FileReader(inName));
        FileIO.copyFile(ir, (Writer)pw, close);
    }

    public static String readLine(String inName) throws FileNotFoundException, IOException {
        BufferedReader is = new BufferedReader(new FileReader(inName));
        String line = null;
        line = is.readLine();
        is.close();
        return line;
    }

    public void copyFileBuffered(String inName, String outName) throws FileNotFoundException, IOException {
        FileInputStream is = new FileInputStream(inName);
        FileOutputStream os = new FileOutputStream(outName);
        int count = 0;
        byte[] b = new byte[16384];
        while ((count = ((InputStream)is).read(b)) != -1) {
            ((OutputStream)os).write(b, 0, count);
        }
        ((InputStream)is).close();
        ((OutputStream)os).close();
    }

    public static String readerToString(Reader is) throws IOException {
        int n;
        StringBuffer sb = new StringBuffer();
        char[] b = new char[16384];
        while ((n = is.read(b)) > 0) {
            sb.append(b, 0, n);
        }
        return sb.toString();
    }

    public static String inputStreamToString(InputStream is) throws IOException {
        return FileIO.readerToString(new InputStreamReader(is));
    }

    public static void stringToFile(String text, String fileName) throws IOException {
        BufferedWriter os = new BufferedWriter(new FileWriter(fileName));
        os.write(text);
        os.flush();
        os.close();
    }

    public static BufferedReader openFile(String fileName) throws IOException {
        return new BufferedReader(new FileReader(fileName));
    }
}

