/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.util;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateUtil {
    private static Log log = LogFactory.getLog(HibernateUtil.class);
    private static Configuration configuration;
    private static SessionFactory sessionFactory;

    static {
        try {
            log.debug((Object)"Initializing Hibernate");
            configuration = new Configuration();
            configuration.configure();
            HibernateUtil.rebuildSessionFactory(configuration);
            log.debug((Object)"Hibernate initialized, call HibernateUtil.getSessionFactory()");
        }
        catch (Throwable ex) {
            log.error((Object)"Building SessionFactory failed.", ex);
            throw new ExceptionInInitializerError(ex);
        }
    }

    public static Configuration getConfiguration() {
        return configuration;
    }

    public static SessionFactory getSessionFactory() {
        String sfName = configuration.getProperty("hibernate.session_factory_name");
        if (sfName != null) {
            log.debug((Object)"Looking up SessionFactory in JNDI");
            try {
                return (SessionFactory)new InitialContext().lookup(sfName);
            }
            catch (NamingException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (sessionFactory == null) {
            HibernateUtil.rebuildSessionFactory();
        }
        return sessionFactory;
    }

    public static void shutdown() {
        log.debug((Object)"Shutting down Hibernate");
        HibernateUtil.getSessionFactory().close();
        sessionFactory = null;
    }

    public static void rebuildSessionFactory() {
        log.debug((Object)"Using current Configuration to rebuild SessionFactory");
        HibernateUtil.rebuildSessionFactory(configuration);
    }

    public static void rebuildSessionFactory(Configuration cfg) {
        log.debug((Object)"Rebuilding the SessionFactory from given Configuration");
        if (sessionFactory != null && !sessionFactory.isClosed()) {
            sessionFactory.close();
        }
        if (cfg.getProperty("hibernate.session_factory_name") != null) {
            log.debug((Object)"Managing SessionFactory in JNDI");
            cfg.buildSessionFactory();
        } else {
            log.debug((Object)"Holding SessionFactory in static variable");
            sessionFactory = cfg.buildSessionFactory();
        }
        configuration = cfg;
    }

    public static void rollbackTransaction() {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        if (sf.getCurrentSession().getTransaction().isActive()) {
            sf.getCurrentSession().getTransaction().rollback();
            sf.getCurrentSession().beginTransaction();
        }
    }
}

