/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xwpf.usermodel;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.poi.util.Internal;
import org.apache.poi.xwpf.usermodel.BodyElementType;
import org.apache.poi.xwpf.usermodel.BodyType;
import org.apache.poi.xwpf.usermodel.Borders;
import org.apache.poi.xwpf.usermodel.IBody;
import org.apache.poi.xwpf.usermodel.IBodyElement;
import org.apache.poi.xwpf.usermodel.LineSpacingRule;
import org.apache.poi.xwpf.usermodel.ParagraphAlignment;
import org.apache.poi.xwpf.usermodel.PositionInParagraph;
import org.apache.poi.xwpf.usermodel.TextAlignment;
import org.apache.poi.xwpf.usermodel.TextSegement;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.apache.poi.xwpf.usermodel.XWPFFootnote;
import org.apache.poi.xwpf.usermodel.XWPFHyperlinkRun;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTFtnEdnRef;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTHyperlink;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTInd;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTP;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPBdr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTPPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTProofErr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTRunTrackChange;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtRun;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSimpleField;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSpacing;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTTextAlignment;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STBorder;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STJc;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STLineSpacingRule;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STOnOff;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.STTextAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWPFParagraph
implements IBodyElement {
    private CTP paragraph;
    protected IBody part;
    protected XWPFDocument document;
    protected List<XWPFRun> runs;
    private StringBuffer footnoteText = new StringBuffer();

    public XWPFParagraph(CTP prgrph) {
        this(prgrph, null);
    }

    public XWPFParagraph(CTP prgrph, IBody part) {
        this.paragraph = prgrph;
        this.part = part;
        if (part instanceof XWPFDocument) {
            this.document = (XWPFDocument)part;
        }
        this.runs = new ArrayList<XWPFRun>();
        XmlCursor c = this.paragraph.newCursor();
        c.selectPath("child::*");
        while (c.toNextSelection()) {
            XmlObject o = c.getObject();
            if (o instanceof CTR) {
                this.runs.add(new XWPFRun((CTR)o, this));
            }
            if (o instanceof CTHyperlink) {
                CTHyperlink link = (CTHyperlink)o;
                for (CTR r : link.getRList()) {
                    this.runs.add(new XWPFHyperlinkRun(link, r, this));
                }
            }
            if (o instanceof CTSdtRun) {
                XWPFRun run = ((CTSdtRun)o).getSdtContent();
                for (CTR r : run.getRList()) {
                    this.runs.add(new XWPFRun(r, this));
                }
            }
            if (o instanceof CTRunTrackChange) {
                for (CTR r : ((CTRunTrackChange)o).getRList()) {
                    this.runs.add(new XWPFRun(r, this));
                }
            }
            if (!(o instanceof CTSimpleField)) continue;
            for (CTR r : ((CTSimpleField)o).getRList()) {
                this.runs.add(new XWPFRun(r, this));
            }
        }
        for (XWPFRun run : this.runs) {
            CTR r;
            r = run.getCTR();
            if (this.document == null) continue;
            c = r.newCursor();
            c.selectPath("child::*");
            while (c.toNextSelection()) {
                XmlObject o = c.getObject();
                if (!(o instanceof CTFtnEdnRef)) continue;
                CTFtnEdnRef ftn = (CTFtnEdnRef)o;
                this.footnoteText.append("[").append(ftn.getId()).append(": ");
                XWPFFootnote footnote = ftn.getDomNode().getLocalName().equals("footnoteReference") ? this.document.getFootnoteByID(ftn.getId().intValue()) : this.document.getEndnoteByID(ftn.getId().intValue());
                boolean first = true;
                for (XWPFParagraph p : footnote.getParagraphs()) {
                    if (!first) {
                        this.footnoteText.append("\n");
                        first = false;
                    }
                    this.footnoteText.append(p.getText());
                }
                this.footnoteText.append("]");
            }
        }
    }

    @Internal
    public CTP getCTP() {
        return this.paragraph;
    }

    public List<XWPFRun> getRuns() {
        return Collections.unmodifiableList(this.runs);
    }

    public boolean isEmpty() {
        return !this.paragraph.getDomNode().hasChildNodes();
    }

    public XWPFDocument getDocument() {
        return this.document;
    }

    public String getText() {
        StringBuffer out = new StringBuffer();
        for (XWPFRun run : this.runs) {
            out.append(run.toString());
        }
        out.append(this.footnoteText);
        return out.toString();
    }

    public String getStyleID() {
        if (this.paragraph.getPPr() != null && this.paragraph.getPPr().getPStyle() != null && this.paragraph.getPPr().getPStyle().getVal() != null) {
            return this.paragraph.getPPr().getPStyle().getVal();
        }
        return null;
    }

    public BigInteger getNumID() {
        if (this.paragraph.getPPr() != null && this.paragraph.getPPr().getNumPr() != null && this.paragraph.getPPr().getNumPr().getNumId() != null) {
            return this.paragraph.getPPr().getNumPr().getNumId().getVal();
        }
        return null;
    }

    public void setNumID(BigInteger numPos) {
        if (this.paragraph.getPPr() == null) {
            this.paragraph.addNewPPr();
        }
        if (this.paragraph.getPPr().getNumPr() == null) {
            this.paragraph.getPPr().addNewNumPr();
        }
        if (this.paragraph.getPPr().getNumPr().getNumId() == null) {
            this.paragraph.getPPr().getNumPr().addNewNumId();
        }
        this.paragraph.getPPr().getNumPr().getNumId().setVal(numPos);
    }

    public String getParagraphText() {
        StringBuffer out = new StringBuffer();
        for (XWPFRun run : this.runs) {
            out.append(run.toString());
        }
        return out.toString();
    }

    public String getPictureText() {
        StringBuffer out = new StringBuffer();
        for (XWPFRun run : this.runs) {
            out.append(run.getPictureText());
        }
        return out.toString();
    }

    public String getFootnoteText() {
        return this.footnoteText.toString();
    }

    public XWPFRun createRun() {
        return new XWPFRun(this.paragraph.addNewR(), this);
    }

    public ParagraphAlignment getAlignment() {
        CTPPr pr = this.getCTPPr();
        return pr == null || !pr.isSetJc() ? ParagraphAlignment.LEFT : ParagraphAlignment.valueOf(pr.getJc().getVal().intValue());
    }

    public void setAlignment(ParagraphAlignment align) {
        CTPPr pr = this.getCTPPr();
        CTJc jc = pr.isSetJc() ? pr.getJc() : pr.addNewJc();
        STJc.Enum en = STJc.Enum.forInt((int)align.getValue());
        jc.setVal(en);
    }

    public TextAlignment getVerticalAlignment() {
        CTPPr pr = this.getCTPPr();
        return pr == null || !pr.isSetTextAlignment() ? TextAlignment.AUTO : TextAlignment.valueOf(pr.getTextAlignment().getVal().intValue());
    }

    public void setVerticalAlignment(TextAlignment valign) {
        CTPPr pr = this.getCTPPr();
        CTTextAlignment textAlignment = pr.isSetTextAlignment() ? pr.getTextAlignment() : pr.addNewTextAlignment();
        STTextAlignment.Enum en = STTextAlignment.Enum.forInt((int)valign.getValue());
        textAlignment.setVal(en);
    }

    public void setBorderTop(Borders border) {
        CTBorder pr;
        CTPBdr ct = this.getCTPBrd(true);
        CTBorder cTBorder = pr = ct != null && ct.isSetTop() ? ct.getTop() : ct.addNewTop();
        if (border.getValue() == Borders.NONE.getValue()) {
            ct.unsetTop();
        } else {
            pr.setVal(STBorder.Enum.forInt((int)border.getValue()));
        }
    }

    public Borders getBorderTop() {
        CTPBdr border = this.getCTPBrd(false);
        CTBorder ct = null;
        if (border != null) {
            ct = border.getTop();
        }
        STBorder.Enum ptrn = ct != null ? ct.getVal() : STBorder.NONE;
        return Borders.valueOf(ptrn.intValue());
    }

    public void setBorderBottom(Borders border) {
        CTBorder pr;
        CTPBdr ct = this.getCTPBrd(true);
        CTBorder cTBorder = pr = ct.isSetBottom() ? ct.getBottom() : ct.addNewBottom();
        if (border.getValue() == Borders.NONE.getValue()) {
            ct.unsetBottom();
        } else {
            pr.setVal(STBorder.Enum.forInt((int)border.getValue()));
        }
    }

    public Borders getBorderBottom() {
        CTPBdr border = this.getCTPBrd(false);
        CTBorder ct = null;
        if (border != null) {
            ct = border.getBottom();
        }
        STBorder.Enum ptrn = ct != null ? ct.getVal() : STBorder.NONE;
        return Borders.valueOf(ptrn.intValue());
    }

    public void setBorderLeft(Borders border) {
        CTBorder pr;
        CTPBdr ct = this.getCTPBrd(true);
        CTBorder cTBorder = pr = ct.isSetLeft() ? ct.getLeft() : ct.addNewLeft();
        if (border.getValue() == Borders.NONE.getValue()) {
            ct.unsetLeft();
        } else {
            pr.setVal(STBorder.Enum.forInt((int)border.getValue()));
        }
    }

    public Borders getBorderLeft() {
        CTPBdr border = this.getCTPBrd(false);
        CTBorder ct = null;
        if (border != null) {
            ct = border.getLeft();
        }
        STBorder.Enum ptrn = ct != null ? ct.getVal() : STBorder.NONE;
        return Borders.valueOf(ptrn.intValue());
    }

    public void setBorderRight(Borders border) {
        CTBorder pr;
        CTPBdr ct = this.getCTPBrd(true);
        CTBorder cTBorder = pr = ct.isSetRight() ? ct.getRight() : ct.addNewRight();
        if (border.getValue() == Borders.NONE.getValue()) {
            ct.unsetRight();
        } else {
            pr.setVal(STBorder.Enum.forInt((int)border.getValue()));
        }
    }

    public Borders getBorderRight() {
        CTPBdr border = this.getCTPBrd(false);
        CTBorder ct = null;
        if (border != null) {
            ct = border.getRight();
        }
        STBorder.Enum ptrn = ct != null ? ct.getVal() : STBorder.NONE;
        return Borders.valueOf(ptrn.intValue());
    }

    public void setBorderBetween(Borders border) {
        CTBorder pr;
        CTPBdr ct = this.getCTPBrd(true);
        CTBorder cTBorder = pr = ct.isSetBetween() ? ct.getBetween() : ct.addNewBetween();
        if (border.getValue() == Borders.NONE.getValue()) {
            ct.unsetBetween();
        } else {
            pr.setVal(STBorder.Enum.forInt((int)border.getValue()));
        }
    }

    public Borders getBorderBetween() {
        CTPBdr border = this.getCTPBrd(false);
        CTBorder ct = null;
        if (border != null) {
            ct = border.getBetween();
        }
        STBorder.Enum ptrn = ct != null ? ct.getVal() : STBorder.NONE;
        return Borders.valueOf(ptrn.intValue());
    }

    public void setPageBreak(boolean pageBreak) {
        CTOnOff ct_pageBreak;
        CTPPr ppr = this.getCTPPr();
        CTOnOff cTOnOff = ct_pageBreak = ppr.isSetPageBreakBefore() ? ppr.getPageBreakBefore() : ppr.addNewPageBreakBefore();
        if (pageBreak) {
            ct_pageBreak.setVal(STOnOff.TRUE);
        } else {
            ct_pageBreak.setVal(STOnOff.FALSE);
        }
    }

    public boolean isPageBreak() {
        CTOnOff ct_pageBreak;
        CTPPr ppr = this.getCTPPr();
        CTOnOff cTOnOff = ct_pageBreak = ppr.isSetPageBreakBefore() ? ppr.getPageBreakBefore() : null;
        return ct_pageBreak != null && ct_pageBreak.getVal().intValue() == 1;
    }

    public void setSpacingAfter(int spaces) {
        CTSpacing spacing = this.getCTSpacing(true);
        if (spacing != null) {
            BigInteger bi = new BigInteger("" + spaces);
            spacing.setAfter(bi);
        }
    }

    public int getSpacingAfter() {
        CTSpacing spacing = this.getCTSpacing(false);
        return spacing != null && spacing.isSetAfter() ? spacing.getAfter().intValue() : -1;
    }

    public void setSpacingAfterLines(int spaces) {
        CTSpacing spacing = this.getCTSpacing(true);
        BigInteger bi = new BigInteger("" + spaces);
        spacing.setAfterLines(bi);
    }

    public int getSpacingAfterLines() {
        CTSpacing spacing = this.getCTSpacing(false);
        return spacing != null && spacing.isSetAfterLines() ? spacing.getAfterLines().intValue() : -1;
    }

    public void setSpacingBefore(int spaces) {
        CTSpacing spacing = this.getCTSpacing(true);
        BigInteger bi = new BigInteger("" + spaces);
        spacing.setBefore(bi);
    }

    public int getSpacingBefore() {
        CTSpacing spacing = this.getCTSpacing(false);
        return spacing != null && spacing.isSetBefore() ? spacing.getBefore().intValue() : -1;
    }

    public void setSpacingBeforeLines(int spaces) {
        CTSpacing spacing = this.getCTSpacing(true);
        BigInteger bi = new BigInteger("" + spaces);
        spacing.setBeforeLines(bi);
    }

    public int getSpacingBeforeLines() {
        CTSpacing spacing = this.getCTSpacing(false);
        return spacing != null && spacing.isSetBeforeLines() ? spacing.getBeforeLines().intValue() : -1;
    }

    public void setSpacingLineRule(LineSpacingRule rule) {
        CTSpacing spacing = this.getCTSpacing(true);
        spacing.setLineRule(STLineSpacingRule.Enum.forInt((int)rule.getValue()));
    }

    public LineSpacingRule getSpacingLineRule() {
        CTSpacing spacing = this.getCTSpacing(false);
        return spacing != null && spacing.isSetLineRule() ? LineSpacingRule.valueOf(spacing.getLineRule().intValue()) : LineSpacingRule.AUTO;
    }

    public void setIndentationLeft(int indentation) {
        CTInd indent = this.getCTInd(true);
        BigInteger bi = new BigInteger("" + indentation);
        indent.setLeft(bi);
    }

    public int getIndentationLeft() {
        CTInd indentation = this.getCTInd(false);
        return indentation != null && indentation.isSetLeft() ? indentation.getLeft().intValue() : -1;
    }

    public void setIndentationRight(int indentation) {
        CTInd indent = this.getCTInd(true);
        BigInteger bi = new BigInteger("" + indentation);
        indent.setRight(bi);
    }

    public int getIndentationRight() {
        CTInd indentation = this.getCTInd(false);
        return indentation != null && indentation.isSetRight() ? indentation.getRight().intValue() : -1;
    }

    public void setIndentationHanging(int indentation) {
        CTInd indent = this.getCTInd(true);
        BigInteger bi = new BigInteger("" + indentation);
        indent.setHanging(bi);
    }

    public int getIndentationHanging() {
        CTInd indentation = this.getCTInd(false);
        return indentation != null && indentation.isSetHanging() ? indentation.getHanging().intValue() : -1;
    }

    public void setIndentationFirstLine(int indentation) {
        CTInd indent = this.getCTInd(true);
        BigInteger bi = new BigInteger("" + indentation);
        indent.setFirstLine(bi);
    }

    public int getIndentationFirstLine() {
        CTInd indentation = this.getCTInd(false);
        return indentation != null && indentation.isSetFirstLine() ? indentation.getFirstLine().intValue() : -1;
    }

    public void setWordWrap(boolean wrap) {
        CTOnOff wordWrap;
        CTOnOff cTOnOff = wordWrap = this.getCTPPr().isSetWordWrap() ? this.getCTPPr().getWordWrap() : this.getCTPPr().addNewWordWrap();
        if (wrap) {
            wordWrap.setVal(STOnOff.TRUE);
        } else {
            wordWrap.unsetVal();
        }
    }

    public boolean isWordWrap() {
        CTOnOff wordWrap;
        CTOnOff cTOnOff = wordWrap = this.getCTPPr().isSetWordWrap() ? this.getCTPPr().getWordWrap() : null;
        if (wordWrap != null) {
            return wordWrap.getVal() == STOnOff.ON || wordWrap.getVal() == STOnOff.TRUE || wordWrap.getVal() == STOnOff.X_1;
        }
        return false;
    }

    public void setStyle(String newStyle) {
        CTPPr pr = this.getCTPPr();
        CTString style = pr.getPStyle() != null ? pr.getPStyle() : pr.addNewPStyle();
        style.setVal(newStyle);
    }

    public String getStyle() {
        CTPPr pr = this.getCTPPr();
        CTString style = pr.isSetPStyle() ? pr.getPStyle() : null;
        return style != null ? style.getVal() : null;
    }

    private CTPBdr getCTPBrd(boolean create) {
        CTPBdr ct;
        CTPPr pr = this.getCTPPr();
        CTPBdr cTPBdr = ct = pr.isSetPBdr() ? pr.getPBdr() : null;
        if (create && ct == null) {
            ct = pr.addNewPBdr();
        }
        return ct;
    }

    private CTSpacing getCTSpacing(boolean create) {
        CTSpacing ct;
        CTPPr pr = this.getCTPPr();
        CTSpacing cTSpacing = ct = pr.getSpacing() == null ? null : pr.getSpacing();
        if (create && ct == null) {
            ct = pr.addNewSpacing();
        }
        return ct;
    }

    private CTInd getCTInd(boolean create) {
        CTInd ct;
        CTPPr pr = this.getCTPPr();
        CTInd cTInd = ct = pr.getInd() == null ? null : pr.getInd();
        if (create && ct == null) {
            ct = pr.addNewInd();
        }
        return ct;
    }

    private CTPPr getCTPPr() {
        CTPPr pr = this.paragraph.getPPr() == null ? this.paragraph.addNewPPr() : this.paragraph.getPPr();
        return pr;
    }

    protected void addRun(CTR run) {
        int pos = this.paragraph.getRList().size();
        this.paragraph.addNewR();
        this.paragraph.setRArray(pos, run);
    }

    public TextSegement searchText(String searched, PositionInParagraph startPos) {
        int startRun = startPos.getRun();
        int startText = startPos.getText();
        int startChar = startPos.getChar();
        int beginRunPos = 0;
        int candCharPos = 0;
        boolean newList = false;
        for (int runPos = startRun; runPos < this.paragraph.getRList().size(); ++runPos) {
            int beginTextPos = 0;
            int beginCharPos = 0;
            int textPos = 0;
            int charPos = 0;
            CTR ctRun = this.paragraph.getRArray(runPos);
            XmlCursor c = ctRun.newCursor();
            c.selectPath("./*");
            while (c.toNextSelection()) {
                XmlObject o = c.getObject();
                if (o instanceof CTText) {
                    if (textPos >= startText) {
                        String candidate = ((CTText)o).getStringValue();
                        for (charPos = runPos == startRun ? startChar : 0; charPos < candidate.length(); ++charPos) {
                            if (candidate.charAt(charPos) == searched.charAt(0) && candCharPos == 0) {
                                beginTextPos = textPos;
                                beginCharPos = charPos;
                                beginRunPos = runPos;
                                newList = true;
                            }
                            if (candidate.charAt(charPos) == searched.charAt(candCharPos)) {
                                if (candCharPos + 1 < searched.length()) {
                                    ++candCharPos;
                                    continue;
                                }
                                if (!newList) continue;
                                TextSegement segement = new TextSegement();
                                segement.setBeginRun(beginRunPos);
                                segement.setBeginText(beginTextPos);
                                segement.setBeginChar(beginCharPos);
                                segement.setEndRun(runPos);
                                segement.setEndText(textPos);
                                segement.setEndChar(charPos);
                                return segement;
                            }
                            candCharPos = 0;
                        }
                    }
                    ++textPos;
                    continue;
                }
                if (o instanceof CTProofErr) {
                    c.removeXml();
                    continue;
                }
                if (o instanceof CTRPr) continue;
                candCharPos = 0;
            }
        }
        return null;
    }

    public XWPFRun insertNewRun(int pos) {
        if (pos >= 0 && pos <= this.paragraph.sizeOfRArray()) {
            CTR ctRun = this.paragraph.insertNewR(pos);
            XWPFRun newRun = new XWPFRun(ctRun, this);
            this.runs.add(newRun);
            return newRun;
        }
        return null;
    }

    public String getText(TextSegement segment) {
        int runBegin = segment.getBeginRun();
        int textBegin = segment.getBeginText();
        int charBegin = segment.getBeginChar();
        int runEnd = segment.getEndRun();
        int textEnd = segment.getEndText();
        int charEnd = segment.getEndChar();
        StringBuffer out = new StringBuffer();
        for (int i = runBegin; i <= runEnd; ++i) {
            int startText = 0;
            int endText = this.paragraph.getRArray(i).getTList().size() - 1;
            if (i == runBegin) {
                startText = textBegin;
            }
            if (i == runEnd) {
                endText = textEnd;
            }
            for (int j = startText; j <= endText; ++j) {
                String tmpText = this.paragraph.getRArray(i).getTArray(j).getStringValue();
                int startChar = 0;
                int endChar = tmpText.length() - 1;
                if (j == textBegin && i == runBegin) {
                    startChar = charBegin;
                }
                if (j == textEnd && i == runEnd) {
                    endChar = charEnd;
                }
                out.append(tmpText.substring(startChar, endChar + 1));
            }
        }
        return out.toString();
    }

    public boolean removeRun(int pos) {
        if (pos >= 0 && pos < this.paragraph.sizeOfRArray()) {
            this.getCTP().removeR(pos);
            this.runs.remove(pos);
            return true;
        }
        return false;
    }

    @Override
    public BodyElementType getElementType() {
        return BodyElementType.PARAGRAPH;
    }

    @Override
    public IBody getPart() {
        if (this.part != null) {
            return this.part.getPart();
        }
        return null;
    }

    @Override
    public BodyType getPartType() {
        return this.part.getPartType();
    }

    public void addRun(XWPFRun r) {
        this.runs.add(r);
    }

    public XWPFRun getRun(CTR r) {
        for (int i = 0; i < this.getRuns().size(); ++i) {
            if (this.getRuns().get(i).getCTR() != r) continue;
            return this.getRuns().get(i);
        }
        return null;
    }
}

