/*
 * Decompiled with CFR 0.152.
 */
package magick.util;

import java.io.UnsupportedEncodingException;

class DisplayIPTCData {
    public static final int TITLE_ID = 517;
    public static final int KEYWORDS_ID = 537;
    public static final int CREATOR_ID = 592;
    public static final int CREATOR_JOB_TITLE_ID = 597;
    public static final int HEADLINE_ID = 617;
    public static final int DESCRIPTION_WRITE_ID = 634;

    DisplayIPTCData() {
    }

    public static String idToName(int id) {
        switch (id) {
            case 517: {
                return "Title";
            }
            case 537: {
                return "Keywords";
            }
            case 592: {
                return "Creator";
            }
            case 597: {
                return "Creator's Job Title";
            }
            case 617: {
                return "Headline";
            }
            case 634: {
                return "Description Writer";
            }
        }
        return null;
    }

    public void parse(byte[] data) {
        int valueLength;
        int length = data.length;
        for (int index = 0; index < length && length - index >= 1 && data[index] == 28 && length - ++index >= 2; index += valueLength) {
            String value;
            int id = data[index++] * 256 + data[index++];
            String name = DisplayIPTCData.idToName(id);
            if (length - index < 2 || length - index < (valueLength = data[index++] * 256 + data[index++])) break;
            try {
                value = new String(data, index, valueLength, "UTF-8");
                continue;
            }
            catch (UnsupportedEncodingException uee) {
                value = "Always supported.";
            }
        }
    }
}

