/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.cache;

import java.util.Properties;
import net.sf.hibernate.cache.Cache;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.cache.CacheProvider;
import net.sf.hibernate.cache.SwarmCache;
import net.sf.swarmcache.CacheConfiguration;
import net.sf.swarmcache.CacheConfigurationManager;
import net.sf.swarmcache.CacheFactory;
import net.sf.swarmcache.ObjectCache;

public class SwarmCacheProvider
implements CacheProvider {
    public Cache buildCache(String regionName, Properties properties) throws CacheException {
        CacheConfiguration config = CacheConfigurationManager.getConfig((Properties)properties);
        CacheFactory factory = new CacheFactory(config);
        ObjectCache cache = factory.createCache(regionName);
        if (cache == null) {
            throw new CacheException("SwarmCache did not create a cache: " + regionName);
        }
        return new SwarmCache(cache);
    }

    public long nextTimestamp() {
        return System.currentTimeMillis() / 100L;
    }
}

