/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.connection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.cfg.Environment;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.PropertiesHelper;
import net.sf.hibernate.util.ReflectHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DriverManagerConnectionProvider
implements ConnectionProvider {
    private String url;
    private Properties connectionProps;
    private Integer isolation;
    private final ArrayList pool = new ArrayList();
    private int poolSize;
    private int checkedOut = 0;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$connection$DriverManagerConnectionProvider == null ? (class$net$sf$hibernate$connection$DriverManagerConnectionProvider = DriverManagerConnectionProvider.class$("net.sf.hibernate.connection.DriverManagerConnectionProvider")) : class$net$sf$hibernate$connection$DriverManagerConnectionProvider));
    static /* synthetic */ Class class$net$sf$hibernate$connection$DriverManagerConnectionProvider;

    public void configure(Properties props) throws HibernateException {
        String driverClass = props.getProperty("hibernate.connection.driver_class");
        this.poolSize = PropertiesHelper.getInt("hibernate.connection.pool_size", props, 20);
        log.info((Object)"Using Hibernate built-in connection pool (not for production use!)");
        log.info((Object)("Hibernate connection pool size: " + this.poolSize));
        this.isolation = PropertiesHelper.getInteger("hibernate.connection.isolation", props);
        if (this.isolation != null) {
            log.info((Object)("JDBC isolation level: " + Environment.isolationLevelToString(this.isolation)));
        }
        if (driverClass == null) {
            log.warn((Object)"no JDBC Driver class was specified by property hibernate.connection.driver_class");
        } else {
            try {
                Class.forName(driverClass);
            }
            catch (ClassNotFoundException cnfe) {
                try {
                    ReflectHelper.classForName(driverClass);
                }
                catch (ClassNotFoundException e) {
                    String msg = "JDBC Driver class not found: " + driverClass;
                    log.fatal((Object)msg);
                    throw new HibernateException(msg);
                }
            }
        }
        this.url = props.getProperty("hibernate.connection.url");
        if (this.url == null) {
            String msg = "JDBC URL was not specified by property hibernate.connection.url";
            log.fatal((Object)msg);
            throw new HibernateException(msg);
        }
        this.connectionProps = ConnectionProviderFactory.getConnectionProperties(props);
        log.info((Object)("using driver: " + driverClass + " at URL: " + this.url));
        log.info((Object)("connection properties: " + this.connectionProps));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws SQLException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("total checked-out connections: " + this.checkedOut));
        }
        ArrayList arrayList = this.pool;
        synchronized (arrayList) {
            if (!this.pool.isEmpty()) {
                int last = this.pool.size() - 1;
                if (log.isTraceEnabled()) {
                    log.trace((Object)("using pooled JDBC connection, pool size: " + last));
                    ++this.checkedOut;
                }
                Connection pooled = (Connection)this.pool.remove(last);
                if (this.isolation != null) {
                    pooled.setTransactionIsolation(this.isolation);
                }
                if (pooled.getAutoCommit()) {
                    pooled.setAutoCommit(false);
                }
                return pooled;
            }
        }
        log.debug((Object)"opening new JDBC connection");
        Connection conn = DriverManager.getConnection(this.url, this.connectionProps);
        if (this.isolation != null) {
            conn.setTransactionIsolation(this.isolation);
        }
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("created connection to: " + this.url + ", Isolation Level: " + conn.getTransactionIsolation()));
        }
        if (log.isTraceEnabled()) {
            ++this.checkedOut;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection(Connection conn) throws SQLException {
        if (log.isDebugEnabled()) {
            --this.checkedOut;
        }
        ArrayList arrayList = this.pool;
        synchronized (arrayList) {
            int currentSize = this.pool.size();
            if (currentSize < this.poolSize) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("returning connection to pool, pool size: " + (currentSize + 1)));
                }
                this.pool.add(conn);
                return;
            }
        }
        log.debug((Object)"closing JDBC connection");
        try {
            conn.close();
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    protected void finalize() {
        this.close();
    }

    public void close() {
        log.info((Object)("cleaning up connection pool: " + this.url));
        Iterator iter = this.pool.iterator();
        while (iter.hasNext()) {
            try {
                ((Connection)iter.next()).close();
            }
            catch (SQLException sqle) {
                log.warn((Object)"problem closing pooled connection", (Throwable)sqle);
            }
        }
        this.pool.clear();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

