/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import net.sf.hibernate.Hibernate;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.NoArgSQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;
import net.sf.hibernate.exception.ErrorCodeConverter;
import net.sf.hibernate.exception.SQLExceptionConverter;
import net.sf.hibernate.exception.ViolatedConstraintNameExtracter;
import net.sf.hibernate.util.StringHelper;

public class MySQLDialect
extends Dialect {
    public MySQLDialect() {
        this.registerColumnType(-7, "bit");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "longtext");
        this.registerColumnType(12, 0xFFFFFF, "mediumtext");
        this.registerColumnType(12, 65535, "text");
        this.registerColumnType(12, 255, "varchar($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time");
        this.registerColumnType(93, "datetime");
        this.registerColumnType(-3, "longblob");
        this.registerColumnType(-3, 0xFFFFFF, "mediumblob");
        this.registerColumnType(-3, 65535, "blob");
        this.registerColumnType(-3, 255, "tinyblob");
        this.registerColumnType(2, "numeric(19, $l)");
        this.registerColumnType(2004, "longblob");
        this.registerColumnType(2004, 0xFFFFFF, "mediumblob");
        this.registerColumnType(2004, 65535, "blob");
        this.registerColumnType(2005, "longtext");
        this.registerColumnType(2005, 0xFFFFFF, "mediumtext");
        this.registerColumnType(2005, 65535, "text");
        this.registerFunction("ascii", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("bin", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("char_length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("character_length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("lcase", new StandardSQLFunction());
        this.registerFunction("lower", new StandardSQLFunction());
        this.registerFunction("length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("ltrim", new StandardSQLFunction());
        this.registerFunction("ord", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("quote", new StandardSQLFunction());
        this.registerFunction("reverse", new StandardSQLFunction());
        this.registerFunction("rtrim", new StandardSQLFunction());
        this.registerFunction("soundex", new StandardSQLFunction());
        this.registerFunction("space", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("ucase", new StandardSQLFunction());
        this.registerFunction("upper", new StandardSQLFunction());
        this.registerFunction("unhex", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("abs", new StandardSQLFunction());
        this.registerFunction("sign", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cot", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("crc32", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("exp", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log2", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("log10", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("pi", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("rand", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sin", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sqrt", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("tan", new NoArgSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("radians", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("degrees", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("ceiling", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("ceil", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("floor", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("round", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("curdate", new NoArgSQLFunction(Hibernate.DATE));
        this.registerFunction("current_date", new NoArgSQLFunction(Hibernate.DATE));
        this.registerFunction("curtime", new NoArgSQLFunction(Hibernate.TIME));
        this.registerFunction("current_time", new NoArgSQLFunction(Hibernate.TIME));
        this.registerFunction("current_timestamp", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("date", new StandardSQLFunction(Hibernate.DATE));
        this.registerFunction("day", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayofmonth", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayname", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("dayofweek", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("dayofyear", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("from_days", new StandardSQLFunction(Hibernate.DATE));
        this.registerFunction("from_unixtime", new StandardSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("hour", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("last_day", new StandardSQLFunction(Hibernate.DATE));
        this.registerFunction("localtime", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("localtimestamp", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("microseconds", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("minute", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("month", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("monthname", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("now", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("quarter", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("second", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("sec_to_time", new StandardSQLFunction(Hibernate.TIME));
        this.registerFunction("sysdate", new NoArgSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("time", new StandardSQLFunction(Hibernate.TIME));
        this.registerFunction("time", new StandardSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("time_to_sec", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("to_days", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("unix_timestamp", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("utc_date", new NoArgSQLFunction(Hibernate.STRING));
        this.registerFunction("utc_time", new NoArgSQLFunction(Hibernate.STRING));
        this.registerFunction("utc_timestamp", new NoArgSQLFunction(Hibernate.STRING));
        this.registerFunction("week", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("weekday", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("weekofyear", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("year", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("yearweek", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("hex", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("oct", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("octet_length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("bit_length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("bit_count", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("encrypt", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("md5", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("sha1", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("sha", new StandardSQLFunction(Hibernate.STRING));
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.getDefaultProperties().setProperty("hibernate.max_fetch_depth", "2");
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getDropForeignKeyString() {
        return " drop foreign key ";
    }

    public boolean dropConstraints() {
        return true;
    }

    public boolean qualifyIndexName() {
        return false;
    }

    public boolean supportsIdentityColumns() {
        return true;
    }

    public String getIdentitySelectString() {
        return "select last_insert_id()";
    }

    public String getIdentityColumnString() {
        return "not null auto_increment";
    }

    public String getAddForeignKeyConstraintString(String constraintName, String[] foreignKey, String referencedTable, String[] primaryKey) {
        String cols = StringHelper.join(", ", foreignKey);
        return new StringBuffer(30).append(" add index ").append(constraintName).append(" (").append(cols).append("), add constraint ").append(constraintName).append(" foreign key (").append(cols).append(") references ").append(referencedTable).append(" (").append(StringHelper.join(", ", primaryKey)).append(')').toString();
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        return new StringBuffer(sql.length() + 20).append(sql).append(hasOffset ? " limit ?, ?" : " limit ?").toString();
    }

    public char closeQuote() {
        return '`';
    }

    public char openQuote() {
        return '`';
    }

    public boolean supportsIfExistsBeforeTableName() {
        return true;
    }

    public char getSchemaSeparator() {
        return '_';
    }

    public SQLExceptionConverter buildSQLExceptionConverter() {
        return new ExceptionConverter(this.getViolatedConstraintNameExtracter());
    }

    private static class ExceptionConverter
    extends ErrorCodeConverter {
        private int[] sqlGrammarCodes = new int[]{1054, 1064, 1146};
        private int[] integrityViolationCodes = new int[]{1062, 1216};
        private int[] connectionCodes = new int[]{1049};

        public ExceptionConverter(ViolatedConstraintNameExtracter extracter) {
            super(extracter);
        }

        protected int[] getSQLGrammarErrorCodes() {
            return this.sqlGrammarCodes;
        }

        protected int[] getIntegrityViolationErrorCodes() {
            return this.integrityViolationCodes;
        }

        protected int[] getConnectionErrorCodes() {
            return this.connectionCodes;
        }
    }
}

