/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.dialect;

import java.sql.SQLException;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.NoArgSQLFunction;
import net.sf.hibernate.dialect.StandardSQLFunction;
import net.sf.hibernate.exception.ErrorCodeConverter;
import net.sf.hibernate.exception.JDBCExceptionHelper;
import net.sf.hibernate.exception.SQLExceptionConverter;
import net.sf.hibernate.exception.TemplatedViolatedConstraintNameExtracter;
import net.sf.hibernate.exception.ViolatedConstraintNameExtracter;

public class Oracle9Dialect
extends Dialect {
    private static ViolatedConstraintNameExtracter EXTRACTER = new TemplatedViolatedConstraintNameExtracter(){

        public String extractConstraintName(SQLException sqle) {
            int errorCode = JDBCExceptionHelper.extractErrorCode(sqle);
            if (errorCode == 1 || errorCode == 2291) {
                return this.extractUsingTemplate("constraint (", ") violated", sqle.getMessage());
            }
            if (errorCode == 1400) {
                return null;
            }
            return null;
        }
    };

    public Oracle9Dialect() {
        this.registerColumnType(-7, "number(1,0)");
        this.registerColumnType(-5, "number(19,0)");
        this.registerColumnType(5, "number(5,0)");
        this.registerColumnType(-6, "number(3,0)");
        this.registerColumnType(4, "number(10,0)");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, "varchar2($l)");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "double precision");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "date");
        this.registerColumnType(93, "date");
        this.registerColumnType(-3, "raw($l)");
        this.registerColumnType(2, "number(19, $l)");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_streams_for_binary", "true");
        this.getDefaultProperties().setProperty("hibernate.jdbc.batch_size", "15");
        this.registerFunction("abs", new StandardSQLFunction());
        this.registerFunction("sign", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("acos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("asin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("atan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cos", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("cosh", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("exp", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("ln", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sin", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sinh", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("stddev", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("sqrt", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("tan", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("tanh", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("variance", new StandardSQLFunction(Hibernate.DOUBLE));
        this.registerFunction("round", new StandardSQLFunction());
        this.registerFunction("trunc", new StandardSQLFunction());
        this.registerFunction("ceil", new StandardSQLFunction());
        this.registerFunction("floor", new StandardSQLFunction());
        this.registerFunction("chr", new StandardSQLFunction(Hibernate.CHARACTER));
        this.registerFunction("initcap", new StandardSQLFunction());
        this.registerFunction("lower", new StandardSQLFunction());
        this.registerFunction("ltrim", new StandardSQLFunction());
        this.registerFunction("rtrim", new StandardSQLFunction());
        this.registerFunction("soundex", new StandardSQLFunction());
        this.registerFunction("upper", new StandardSQLFunction());
        this.registerFunction("ascii", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("length", new StandardSQLFunction(Hibernate.LONG));
        this.registerFunction("to_char", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("to_date", new StandardSQLFunction(Hibernate.TIMESTAMP));
        this.registerFunction("lastday", new StandardSQLFunction(Hibernate.DATE));
        this.registerFunction("sysdate", new NoArgSQLFunction(Hibernate.DATE, false));
        this.registerFunction("uid", new NoArgSQLFunction(Hibernate.INTEGER, false));
        this.registerFunction("user", new NoArgSQLFunction(Hibernate.STRING, false));
        this.registerFunction("concat", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("instr", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("instrb", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("lpad", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("replace", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("rpad", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("substr", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("substrb", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("translate", new StandardSQLFunction(Hibernate.STRING));
        this.registerFunction("atan2", new StandardSQLFunction(Hibernate.FLOAT));
        this.registerFunction("log", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("mod", new StandardSQLFunction(Hibernate.INTEGER));
        this.registerFunction("nvl", new StandardSQLFunction());
        this.registerFunction("power", new StandardSQLFunction(Hibernate.FLOAT));
        this.registerFunction("add_months", new StandardSQLFunction(Hibernate.DATE));
        this.registerFunction("months_between", new StandardSQLFunction(Hibernate.FLOAT));
        this.registerFunction("next_day", new StandardSQLFunction(Hibernate.DATE));
    }

    public String getAddColumnString() {
        return "add";
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select " + sequenceName + ".nextval from dual";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName;
    }

    public String getCascadeConstraintsString() {
        return " cascade constraints";
    }

    public boolean supportsForUpdateNowait() {
        return true;
    }

    public boolean supportsSequences() {
        return true;
    }

    public boolean supportsLimit() {
        return true;
    }

    public String getLimitString(String sql, boolean hasOffset) {
        StringBuffer pagingSelect = new StringBuffer(sql.length() + 100);
        if (hasOffset) {
            pagingSelect.append("select * from ( select row_.*, rownum rownum_ from ( ");
        } else {
            pagingSelect.append("select * from ( ");
        }
        pagingSelect.append(sql);
        if (hasOffset) {
            pagingSelect.append(" ) row_ where rownum <= ?) where rownum_ > ?");
        } else {
            pagingSelect.append(" ) where rownum <= ?");
        }
        return pagingSelect.toString();
    }

    public boolean bindLimitParametersInReverseOrder() {
        return true;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsForUpdateOf() {
        return false;
    }

    public String getQuerySequencesString() {
        return "select SEQUENCE_NAME from user_sequences";
    }

    public SQLExceptionConverter buildSQLExceptionConverter() {
        return new ExceptionConverter(this.getViolatedConstraintNameExtracter());
    }

    public ViolatedConstraintNameExtracter getViolatedConstraintNameExtracter() {
        return EXTRACTER;
    }

    private static class ExceptionConverter
    extends ErrorCodeConverter {
        private int[] sqlGrammarCodes = new int[]{900, 903, 904, 917, 936, 942, 17006};
        private int[] integrityViolationCodes = new int[]{1, 1400, 2291};
        private int[] lockAcquisitionCodes = new int[]{54, 55};

        public ExceptionConverter(ViolatedConstraintNameExtracter extracter) {
            super(extracter);
        }

        protected int[] getSQLGrammarErrorCodes() {
            return this.sqlGrammarCodes;
        }

        protected int[] getIntegrityViolationErrorCodes() {
            return this.integrityViolationCodes;
        }

        protected int[] getLockAcquisitionErrorCodes() {
            return this.lockAcquisitionCodes;
        }
    }
}

