/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.id;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.Properties;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.TransientObjectException;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.id.Configurable;
import net.sf.hibernate.id.IdentifierGenerationException;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.id.IdentifierGeneratorFactory;
import net.sf.hibernate.type.Type;

public class ForeignGenerator
implements IdentifierGenerator,
Configurable {
    private String propertyName;

    public Serializable generate(SessionImplementor session, Object object) throws SQLException, HibernateException {
        Serializable id;
        Object associatedObject = session.getFactory().getClassMetadata(object.getClass()).getPropertyValue(object, this.propertyName);
        if (associatedObject == null) {
            throw new IdentifierGenerationException("attempted to assign id from null one-to-one property: " + this.propertyName);
        }
        try {
            id = session.getEntityIdentifierIfNotUnsaved(associatedObject);
        }
        catch (TransientObjectException toe) {
            id = session.save(associatedObject);
        }
        if (session.contains(object)) {
            return IdentifierGeneratorFactory.SHORT_CIRCUIT_INDICATOR;
        }
        return id;
    }

    public void configure(Type type, Properties params, Dialect d) throws MappingException {
        this.propertyName = params.getProperty("property");
        if (this.propertyName == null) {
            throw new MappingException("param named \"property\" is required for foreign id generation strategy");
        }
    }
}

