/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.lang.reflect.Constructor;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.engine.QueryParameters;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.exception.JDBCExceptionHelper;
import net.sf.hibernate.hql.QueryTranslator;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.ReflectHelper;

public class ScrollableResultsImpl
implements ScrollableResults {
    private final ResultSet rs;
    private final PreparedStatement ps;
    private final SessionImplementor sess;
    private final QueryTranslator queryTranslator;
    private final QueryParameters queryParameters;
    private final Type[] types;
    private final String[][] names;
    private Constructor holderConstructor;
    private Object[] currentRow;

    public boolean scroll(int i) throws HibernateException {
        try {
            boolean result = this.rs.relative(i);
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error performing scroll()");
        }
    }

    public boolean first() throws HibernateException {
        try {
            boolean result = this.rs.first();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error performing first()");
        }
    }

    public boolean last() throws HibernateException {
        try {
            boolean result = this.rs.last();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error performing last()");
        }
    }

    public boolean next() throws HibernateException {
        try {
            boolean result = this.rs.next();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error performing next()");
        }
    }

    public boolean previous() throws HibernateException {
        try {
            boolean result = this.rs.previous();
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error performing previous");
        }
    }

    public Object[] get() throws HibernateException {
        return this.currentRow;
    }

    public Object get(int col) throws HibernateException {
        return this.currentRow[col];
    }

    private Object getFinal(int col, Type returnType) throws HibernateException {
        if (this.holderConstructor != null) {
            throw new HibernateException("query specifies a holder class");
        }
        if (returnType.getReturnedClass() == this.types[col].getReturnedClass()) {
            return this.get(col);
        }
        return this.throwInvalidColumnTypeException(col, this.types[col], returnType);
    }

    private Object getNonFinal(int col, Type returnType) throws HibernateException {
        if (this.holderConstructor != null) {
            throw new HibernateException("query specifies a holder class");
        }
        if (returnType.getReturnedClass().isAssignableFrom(this.types[col].getReturnedClass())) {
            return this.get(col);
        }
        return this.throwInvalidColumnTypeException(col, this.types[col], returnType);
    }

    public ScrollableResultsImpl(ResultSet rs, PreparedStatement ps, SessionImplementor sess, QueryTranslator queryTranslator, QueryParameters queryParameters, Type[] types, String[][] columnNames, Class holderClass) throws MappingException {
        this.rs = rs;
        this.ps = ps;
        this.sess = sess;
        this.queryTranslator = queryTranslator;
        this.queryParameters = queryParameters;
        this.types = types;
        this.names = columnNames;
        if (holderClass != null) {
            this.holderConstructor = ReflectHelper.getConstructor(holderClass, types);
        }
    }

    public BigDecimal getBigDecimal(int col) throws HibernateException {
        return (BigDecimal)this.getFinal(col, Hibernate.BIG_DECIMAL);
    }

    public byte[] getBinary(int col) throws HibernateException {
        return (byte[])this.getFinal(col, Hibernate.BINARY);
    }

    public String getText(int col) throws HibernateException {
        return (String)this.getFinal(col, Hibernate.TEXT);
    }

    public Blob getBlob(int col) throws HibernateException {
        return (Blob)this.getNonFinal(col, Hibernate.BLOB);
    }

    public Clob getClob(int col) throws HibernateException {
        return (Clob)this.getNonFinal(col, Hibernate.CLOB);
    }

    public Boolean getBoolean(int col) throws HibernateException {
        return (Boolean)this.getFinal(col, Hibernate.BOOLEAN);
    }

    public Byte getByte(int col) throws HibernateException {
        return (Byte)this.getFinal(col, Hibernate.BYTE);
    }

    public Character getCharacter(int col) throws HibernateException {
        return (Character)this.getFinal(col, Hibernate.CHARACTER);
    }

    public Date getDate(int col) throws HibernateException {
        return (Date)this.getNonFinal(col, Hibernate.TIMESTAMP);
    }

    public Calendar getCalendar(int col) throws HibernateException {
        return (Calendar)this.getNonFinal(col, Hibernate.CALENDAR);
    }

    public Double getDouble(int col) throws HibernateException {
        return (Double)this.getFinal(col, Hibernate.DOUBLE);
    }

    public Float getFloat(int col) throws HibernateException {
        return (Float)this.getFinal(col, Hibernate.FLOAT);
    }

    public Integer getInteger(int col) throws HibernateException {
        return (Integer)this.getFinal(col, Hibernate.INTEGER);
    }

    public Long getLong(int col) throws HibernateException {
        return (Long)this.getFinal(col, Hibernate.LONG);
    }

    public Short getShort(int col) throws HibernateException {
        return (Short)this.getFinal(col, Hibernate.SHORT);
    }

    public String getString(int col) throws HibernateException {
        return (String)this.getFinal(col, Hibernate.STRING);
    }

    public void afterLast() throws HibernateException {
        try {
            this.rs.afterLast();
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error performing afterLast()");
        }
    }

    public void beforeFirst() throws HibernateException {
        try {
            this.rs.beforeFirst();
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error performing beforeFirst()");
        }
    }

    public void close() throws HibernateException {
        try {
            this.sess.getBatcher().closeQueryStatement(this.ps, this.rs);
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error performing close()");
        }
    }

    public Locale getLocale(int col) throws HibernateException {
        return (Locale)this.getFinal(col, Hibernate.LOCALE);
    }

    public TimeZone getTimeZone(int col) throws HibernateException {
        return (TimeZone)this.getNonFinal(col, Hibernate.TIMEZONE);
    }

    public Type getType(int i) {
        return this.types[i];
    }

    public boolean isFirst() throws HibernateException {
        try {
            return this.rs.isFirst();
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error performing isFirst()");
        }
    }

    public boolean isLast() throws HibernateException {
        try {
            return this.rs.isLast();
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error performing isLast()");
        }
    }

    private Object throwInvalidColumnTypeException(int i, Type type, Type returnType) throws HibernateException {
        throw new HibernateException("incompatible column types: " + type.getName() + ", " + returnType.getName());
    }

    public int getRowNumber() throws HibernateException {
        try {
            return this.rs.getRow() - 1;
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error performing getRowNumber()");
        }
    }

    public boolean setRowNumber(int rowNumber) throws HibernateException {
        if (rowNumber >= 0) {
            ++rowNumber;
        }
        try {
            boolean result = this.rs.absolute(rowNumber);
            this.prepareCurrentRow(result);
            return result;
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error performing setRrowNumber()");
        }
    }

    private void prepareCurrentRow(boolean underlyingScrollSuccessful) throws HibernateException {
        if (!underlyingScrollSuccessful) {
            this.currentRow = null;
            return;
        }
        try {
            Object result = this.queryTranslator.loadSingleRow(this.rs, this.sess, this.queryParameters, false);
            this.currentRow = result != null && result.getClass().isArray() ? (Object[])result : new Object[]{result};
        }
        catch (SQLException sqle) {
            throw this.convert(sqle, "error processing current row");
        }
        if (this.holderConstructor != null) {
            try {
                this.currentRow = new Object[]{this.holderConstructor.newInstance(this.currentRow)};
            }
            catch (Throwable t) {
                throw new QueryException("Could not instantiate: " + this.holderConstructor.getDeclaringClass(), t);
            }
        }
    }

    protected JDBCException convert(SQLException sqlException, String message) {
        return JDBCExceptionHelper.convert(this.sess.getFactory().getSQLExceptionConverter(), sqlException, message);
    }
}

