/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.cache.CacheConcurrencyStrategy;
import net.sf.hibernate.engine.Mapping;
import net.sf.hibernate.mapping.MetaAttribute;
import net.sf.hibernate.mapping.PrimaryKey;
import net.sf.hibernate.mapping.Property;
import net.sf.hibernate.mapping.RootClass;
import net.sf.hibernate.mapping.SimpleValue;
import net.sf.hibernate.mapping.Subclass;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.sql.Alias;
import net.sf.hibernate.util.JoinedIterator;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.collections.SequencedHashMap;

public abstract class PersistentClass {
    private static final Alias PK_ALIAS = new Alias(15, "PK");
    public static final String NULL_DISCRIMINATOR_MAPPING = "null";
    public static final String NOT_NULL_DISCRIMINATOR_MAPPING = "not null";
    private Class mappedClass;
    private String discriminatorValue;
    private Map properties = new SequencedHashMap();
    private Table table;
    private Class proxyInterface;
    private final ArrayList subclasses = new ArrayList();
    private final ArrayList subclassProperties = new ArrayList();
    private final ArrayList subclassTables = new ArrayList();
    private boolean dynamicInsert;
    private boolean dynamicUpdate;
    private int batchSize = 1;
    private boolean selectBeforeUpdate;
    private int optimisticLockMode;
    private Map metaAttributes;

    public boolean useDynamicInsert() {
        return this.dynamicInsert;
    }

    public boolean useDynamicUpdate() {
        return this.dynamicUpdate;
    }

    public void setDynamicInsert(boolean dynamicInsert) {
        this.dynamicInsert = dynamicInsert;
    }

    public void setDynamicUpdate(boolean dynamicUpdate) {
        this.dynamicUpdate = dynamicUpdate;
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void addSubclass(Subclass subclass) throws MappingException {
        for (PersistentClass superclass = this.getSuperclass(); superclass != null; superclass = superclass.getSuperclass()) {
            if (!subclass.getName().equals(superclass.getName())) continue;
            throw new MappingException("Circular inheritance mapping detected: " + subclass.getName() + " will have it self as superclass when extending " + this.getName());
        }
        this.subclasses.add(subclass);
    }

    public boolean hasSubclasses() {
        return this.subclasses.size() > 0;
    }

    public int getSubclassSpan() {
        int n = this.subclasses.size();
        Iterator iter = this.subclasses.iterator();
        while (iter.hasNext()) {
            n += ((Subclass)iter.next()).getSubclassSpan();
        }
        return n;
    }

    public Iterator getSubclassIterator() {
        Iterator[] iters = new Iterator[this.subclasses.size() + 1];
        Iterator iter = this.subclasses.iterator();
        int i = 0;
        while (iter.hasNext()) {
            iters[i++] = ((Subclass)iter.next()).getSubclassIterator();
        }
        iters[i] = this.subclasses.iterator();
        return new JoinedIterator(iters);
    }

    public Iterator getDirectSubclasses() {
        return this.subclasses.iterator();
    }

    public void addNewProperty(Property prop) throws MappingException {
        Property old = this.properties.put(prop.getName(), prop);
        if (old != null) {
            throw new MappingException("duplicate mapping for property: " + this.getName() + '.' + prop.getName());
        }
    }

    public void addProperty(Property prop) {
        this.properties.put(prop.getName(), prop);
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public Iterator getPropertyIterator() {
        return this.properties.values().iterator();
    }

    public Table getTable() {
        return this.table;
    }

    public Class getMappedClass() {
        return this.mappedClass;
    }

    public String getName() {
        return this.mappedClass.getName();
    }

    public abstract boolean isMutable();

    public abstract boolean hasIdentifierProperty();

    public abstract Property getIdentifierProperty();

    public abstract SimpleValue getIdentifier();

    public abstract Property getVersion();

    public abstract Value getDiscriminator();

    public abstract boolean isInherited();

    public abstract boolean isPolymorphic();

    public abstract boolean isVersioned();

    public abstract CacheConcurrencyStrategy getCache();

    public abstract PersistentClass getSuperclass();

    public abstract boolean isExplicitPolymorphism();

    public abstract Iterator getPropertyClosureIterator();

    public abstract Iterator getTableClosureIterator();

    protected void addSubclassProperty(Property p) {
        this.subclassProperties.add(p);
    }

    protected void addSubclassTable(Table subclassTable) {
        this.subclassTables.add(subclassTable);
    }

    public Iterator getSubclassPropertyClosureIterator() {
        return new JoinedIterator(this.getPropertyClosureIterator(), this.subclassProperties.iterator());
    }

    public Iterator getSubclassTableClosureIterator() {
        return new JoinedIterator(this.getTableClosureIterator(), this.subclassTables.iterator());
    }

    public Class getProxyInterface() {
        return this.proxyInterface;
    }

    public abstract boolean hasEmbeddedIdentifier();

    public abstract Class getClassPersisterClass();

    public abstract void setClassPersisterClass(Class var1);

    public abstract Table getRootTable();

    public abstract RootClass getRootClass();

    public abstract SimpleValue getKey();

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public void setMappedClass(Class persistentClass) {
        this.mappedClass = persistentClass;
    }

    public void setProxyInterface(Class proxyInterface) {
        this.proxyInterface = proxyInterface;
    }

    public boolean isForceDiscriminator() {
        return false;
    }

    public void createPrimaryKey() {
        PrimaryKey pk = new PrimaryKey();
        pk.setTable(this.table);
        pk.setName(PK_ALIAS.toAliasString(this.table.getName()));
        this.table.setPrimaryKey(pk);
        pk.addColumns(this.getKey().getColumnIterator());
    }

    public abstract String getWhere();

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public boolean hasSelectBeforeUpdate() {
        return this.selectBeforeUpdate;
    }

    public void setSelectBeforeUpdate(boolean selectBeforeUpdate) {
        this.selectBeforeUpdate = selectBeforeUpdate;
    }

    public Property getProperty(String propertyName) throws MappingException {
        Iterator iter = this.getPropertyClosureIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (!prop.getName().equals(propertyName)) continue;
            return prop;
        }
        throw new MappingException("property not found: " + propertyName);
    }

    public int getOptimisticLockMode() {
        return this.optimisticLockMode;
    }

    public void setOptimisticLockMode(int optimisticLockMode) {
        this.optimisticLockMode = optimisticLockMode;
    }

    public void validate(Mapping mapping) throws MappingException {
        Iterator iter = this.getPropertyIterator();
        while (iter.hasNext()) {
            Property prop = (Property)iter.next();
            if (prop.isValid(mapping)) continue;
            throw new MappingException("property mapping has wrong number of columns: " + StringHelper.qualify(this.getMappedClass().getName(), prop.getName()) + " type: " + prop.getType().getName());
        }
    }

    public boolean isDiscriminatorValueNotNull() {
        return NOT_NULL_DISCRIMINATOR_MAPPING.equals(this.getDiscriminatorValue());
    }

    public boolean isDiscriminatorValueNull() {
        return NULL_DISCRIMINATOR_MAPPING.equals(this.getDiscriminatorValue());
    }

    public Map getMetaAttributes() {
        return this.metaAttributes;
    }

    public void setMetaAttributes(Map metas) {
        this.metaAttributes = metas;
    }

    public MetaAttribute getMetaAttribute(String name) {
        return (MetaAttribute)this.metaAttributes.get(name);
    }

    public String toString() {
        return this.getClass() + " for " + this.getMappedClass();
    }

    public abstract boolean isJoinedSubclass();

    public abstract boolean isDiscriminatorInsertable();
}

