/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.tool.hbm2ddl;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.sf.hibernate.tool.hbm2ddl.ColumnMetadata;
import net.sf.hibernate.tool.hbm2ddl.ForeignKeyMetadata;
import net.sf.hibernate.tool.hbm2ddl.IndexMetadata;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TableMetadata {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$tool$hbm2ddl$TableMetadata == null ? (class$net$sf$hibernate$tool$hbm2ddl$TableMetadata = TableMetadata.class$("net.sf.hibernate.tool.hbm2ddl.TableMetadata")) : class$net$sf$hibernate$tool$hbm2ddl$TableMetadata));
    private final String catalog;
    private final String schema;
    private final String name;
    private final Map columns = new HashMap();
    private final Map foreignKeys = new HashMap();
    private final Map indexes = new HashMap();
    static /* synthetic */ Class class$net$sf$hibernate$tool$hbm2ddl$TableMetadata;

    TableMetadata(ResultSet rs, DatabaseMetaData meta) throws SQLException {
        this.catalog = rs.getString("TABLE_CAT");
        this.schema = rs.getString("TABLE_SCHEM");
        this.name = rs.getString("TABLE_NAME");
        this.initColumns(meta);
        this.initForeignKeys(meta);
        this.initIndexes(meta);
        String cat = this.catalog == null ? "" : this.catalog + '.';
        String schem = this.schema == null ? "" : this.schema + '.';
        log.info((Object)("table found: " + cat + schem + this.name));
        log.info((Object)("columns: " + this.columns.keySet()));
        log.info((Object)("foreign keys: " + this.foreignKeys.keySet()));
        log.info((Object)("indexes: " + this.indexes.keySet()));
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return "TableMetadata(" + this.name + ')';
    }

    public ColumnMetadata getColumnMetadata(String columnName) {
        return (ColumnMetadata)this.columns.get(columnName.toLowerCase());
    }

    public ForeignKeyMetadata getForeignKeyMetadata(String keyName) {
        return (ForeignKeyMetadata)this.foreignKeys.get(keyName.toLowerCase());
    }

    public IndexMetadata getIndexMetadata(String indexName) {
        return (IndexMetadata)this.indexes.get(indexName.toLowerCase());
    }

    private void addForeignKey(ResultSet rs) throws SQLException {
        String fk = rs.getString("FK_NAME");
        if (fk == null) {
            return;
        }
        ForeignKeyMetadata info = this.getForeignKeyMetadata(fk);
        if (info == null) {
            info = new ForeignKeyMetadata(rs);
            this.foreignKeys.put(info.getName().toLowerCase(), info);
        }
        info.addColumn(this.getColumnMetadata(rs.getString("FKCOLUMN_NAME")));
    }

    private void addIndex(ResultSet rs) throws SQLException {
        String index = rs.getString("INDEX_NAME");
        if (index == null) {
            return;
        }
        IndexMetadata info = this.getIndexMetadata(index);
        if (info == null) {
            info = new IndexMetadata(rs);
            this.indexes.put(info.getName().toLowerCase(), info);
        }
        info.addColumn(this.getColumnMetadata(rs.getString("COLUMN_NAME")));
    }

    public void addColumn(ResultSet rs) throws SQLException {
        String column = rs.getString("COLUMN_NAME");
        if (column == null) {
            return;
        }
        if (this.getColumnMetadata(column) == null) {
            ColumnMetadata info = new ColumnMetadata(rs);
            this.columns.put(info.getName().toLowerCase(), info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initForeignKeys(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = null;
        try {
            rs = meta.storesUpperCaseIdentifiers() ? meta.getImportedKeys(StringHelper.toUpperCase(this.catalog), StringHelper.toUpperCase(this.schema), StringHelper.toUpperCase(this.name)) : meta.getImportedKeys(this.catalog, this.schema, this.name);
            while (rs.next()) {
                this.addForeignKey(rs);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initIndexes(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = null;
        try {
            rs = meta.storesUpperCaseIdentifiers() ? meta.getIndexInfo(StringHelper.toUpperCase(this.catalog), StringHelper.toUpperCase(this.schema), StringHelper.toUpperCase(this.name), false, true) : meta.getIndexInfo(this.catalog, this.schema, this.name, false, true);
            while (rs.next()) {
                if (rs.getShort("TYPE") == 0) continue;
                this.addIndex(rs);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initColumns(DatabaseMetaData meta) throws SQLException {
        ResultSet rs = null;
        try {
            rs = meta.storesUpperCaseIdentifiers() ? meta.getColumns(StringHelper.toUpperCase(this.catalog), StringHelper.toUpperCase(this.schema), StringHelper.toUpperCase(this.name), "%") : meta.getColumns(this.catalog, this.schema, this.name, "%");
            while (rs.next()) {
                this.addColumn(rs);
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

