/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.transaction;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import javax.transaction.UserTransaction;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.TransactionException;
import net.sf.hibernate.engine.CacheSynchronization;
import net.sf.hibernate.engine.SessionImplementor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JTATransaction
implements Transaction {
    private final SessionImplementor session;
    private UserTransaction ut;
    private boolean newTransaction;
    private boolean synchronization;
    private boolean begun;
    private boolean commitFailed;
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$transaction$JTATransaction == null ? (class$net$sf$hibernate$transaction$JTATransaction = JTATransaction.class$("net.sf.hibernate.transaction.JTATransaction")) : class$net$sf$hibernate$transaction$JTATransaction));
    private static final int NULL = Integer.MIN_VALUE;
    static /* synthetic */ Class class$net$sf$hibernate$transaction$JTATransaction;

    public void commit() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"commit");
        if (this.session.getFlushMode() != FlushMode.NEVER) {
            this.session.flush();
        }
        if (this.newTransaction) {
            try {
                log.debug((Object)"Committing UserTransaction started by Hibernate");
                this.ut.commit();
            }
            catch (Exception e) {
                this.commitFailed = true;
                log.error((Object)"Commit failed", (Throwable)e);
                throw new TransactionException("Commit failed with exception: ", e);
            }
            finally {
                this.afterCommitRollback();
            }
        } else {
            this.afterCommitRollback();
        }
    }

    public void rollback() throws HibernateException {
        if (!this.begun) {
            throw new TransactionException("Transaction not successfully started");
        }
        log.debug((Object)"rollback");
        try {
            if (this.newTransaction) {
                if (!this.commitFailed) {
                    this.ut.rollback();
                }
            } else {
                this.ut.setRollbackOnly();
            }
        }
        catch (Exception e) {
            log.error((Object)"Rollback failed", (Throwable)e);
            throw new TransactionException("Rollback failed with exception", e);
        }
        finally {
            this.afterCommitRollback();
        }
    }

    private void afterCommitRollback() throws TransactionException {
        if (!this.synchronization) {
            if (!this.newTransaction) {
                log.warn((Object)"You should set hibernate.transaction.manager_lookup_class if cache is enabled");
            }
            int status = Integer.MIN_VALUE;
            try {
                status = this.ut.getStatus();
                this.session.afterTransactionCompletion(status == 3);
            }
            catch (Exception e) {
                try {
                    log.error((Object)"Could not determine transaction status after commit", (Throwable)e);
                    throw new TransactionException("Could not determine transaction status after commit", e);
                }
                catch (Throwable throwable) {
                    this.session.afterTransactionCompletion(status == 3);
                    throw throwable;
                }
            }
        }
    }

    public JTATransaction(SessionImplementor session) {
        this.session = session;
    }

    public void begin(InitialContext context, String utName, TransactionManager transactionManager) throws HibernateException {
        log.debug((Object)("Looking for UserTransaction under: " + utName));
        try {
            this.ut = (UserTransaction)context.lookup(utName);
        }
        catch (NamingException ne) {
            log.error((Object)"Could not find UserTransaction in JNDI", (Throwable)ne);
            throw new TransactionException("Could not find UserTransaction in JNDI: ", ne);
        }
        if (this.ut == null) {
            throw new AssertionFailure("A naming service lookup returned null");
        }
        log.debug((Object)"Obtained UserTransaction");
        try {
            boolean bl = this.newTransaction = this.ut.getStatus() == 6;
            if (this.newTransaction) {
                log.debug((Object)"beginning new transaction");
                this.ut.begin();
            }
        }
        catch (Exception e) {
            log.error((Object)"Begin failed", (Throwable)e);
            throw new TransactionException("Begin failed with exception", e);
        }
        if (this.newTransaction) {
            this.synchronization = false;
        } else if (transactionManager == null) {
            this.synchronization = false;
            if (!this.newTransaction) {
                log.warn((Object)"You should set hibernate.transaction.manager_lookup_class if cache is enabled");
            }
        } else {
            try {
                transactionManager.getTransaction().registerSynchronization((Synchronization)new CacheSynchronization(this.session));
            }
            catch (Exception se) {
                log.error((Object)"Could not register Synchronization", (Throwable)se);
                throw new TransactionException("Could not register Synchronization", se);
            }
            this.synchronization = true;
        }
        this.begun = true;
    }

    public boolean wasRolledBack() throws TransactionException {
        int status;
        if (!this.begun) {
            return false;
        }
        if (this.commitFailed) {
            return true;
        }
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 1 || status == 9 || status == 4;
    }

    public boolean wasCommitted() throws TransactionException {
        int status;
        if (!this.begun || this.commitFailed) {
            return false;
        }
        try {
            status = this.ut.getStatus();
        }
        catch (SystemException se) {
            log.error((Object)"Could not determine transaction status", (Throwable)se);
            throw new TransactionException("Could not determine transaction status: ", (Exception)((Object)se));
        }
        if (status == 5) {
            throw new TransactionException("Could not determine transaction status");
        }
        return status == 3;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

