/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.utils;

import java.io.File;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import org.im4java.core.CommandException;
import org.im4java.core.ConvertCmd;
import org.im4java.core.IM4JavaException;
import org.im4java.core.Operation;
import org.im4java.process.ProcessEvent;
import org.im4java.process.ProcessExecutor;
import org.im4java.process.ProcessTask;
import org.im4java.utils.FilenamePatternResolver;

public class BatchConverter
extends ProcessExecutor {
    private Mode iMode = null;
    private List<ConvertException> iExceptions = null;

    public BatchConverter(Mode mode) {
        this.iMode = mode;
    }

    public void run(Operation operation, List<String> list, String string) throws Exception, IOException, InterruptedException, IM4JavaException {
        if (list.isEmpty()) {
            return;
        }
        this.iExceptions = new LinkedList<ConvertException>();
        try {
            switch (this.iMode) {
                case SEQUENTIAL: {
                    this.runSeq(operation, list, string);
                    break;
                }
                case PARALLEL: {
                    this.runPar(operation, list, string);
                    break;
                }
                case BATCH: {
                    this.runBatch(operation, list, string);
                }
            }
            this.shutdown();
        }
        catch (Exception exception) {
            this.shutdown();
            throw exception;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runSeq(Operation operation, List<String> list, String string) throws IOException, InterruptedException, IM4JavaException {
        ConvertCmd convertCmd = new ConvertCmd();
        FilenamePatternResolver filenamePatternResolver = new FilenamePatternResolver(string);
        int n = 0;
        for (String string2 : list) {
            try {
                convertCmd.run(operation, string2, filenamePatternResolver.createName(string2));
            }
            catch (Exception exception) {
                this.addException(n, exception);
            }
            finally {
                ++n;
            }
        }
    }

    private void runPar(Operation operation, List<String> list, String string) throws IOException, InterruptedException, IM4JavaException {
        FilenamePatternResolver filenamePatternResolver = new FilenamePatternResolver(string);
        int n = 0;
        for (String string2 : list) {
            ConvertCmd convertCmd = new ConvertCmd();
            convertCmd.setPID(n++);
            ProcessTask processTask = convertCmd.getProcessTask(operation, string2, filenamePatternResolver.createName(string2));
            this.execute(processTask);
        }
    }

    @Override
    public void processTerminated(ProcessEvent processEvent) {
        if (processEvent.getReturnCode() != 0) {
            this.addException(processEvent.getPID(), processEvent.getException());
        }
        super.processTerminated(processEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatch(Operation operation, List<String> list, String string) throws IOException, InterruptedException, IM4JavaException {
        int n;
        FilenamePatternResolver filenamePatternResolver = new FilenamePatternResolver(string);
        File file = new File(filenamePatternResolver.createName(list.get(0)));
        String string2 = filenamePatternResolver.getFullpath(file);
        String string3 = filenamePatternResolver.getExt(file);
        String string4 = String.format("%04d", new Random().nextInt(10000));
        String string5 = String.format("%s%cim4java_%s.%s", string2, Character.valueOf(File.separatorChar), string4, string3);
        Operation operation2 = new Operation();
        LinkedList<String> linkedList = operation.getCmdArgs();
        boolean bl = false;
        for (String stringArray2 : linkedList) {
            if (!bl && stringArray2.startsWith("?img?")) {
                for (n = 0; n < list.size(); ++n) {
                    operation2.addRawArgs(stringArray2);
                }
                bl = true;
                continue;
            }
            operation2.addRawArgs(stringArray2);
        }
        ConvertCmd convertCmd = new ConvertCmd();
        String[] stringArray2 = new String[list.size() + 1];
        stringArray2 = list.toArray(stringArray2);
        stringArray2[list.size()] = string5;
        try {
            convertCmd.run(operation2, stringArray2);
        }
        catch (CommandException commandException) {
            String string6 = string2 + File.separatorChar + "im4java_" + string4 + "-";
            String string7 = "." + string3;
            for (int i = 0; i < list.size(); ++i) {
                File file2 = new File(string6 + i + string7);
                file2.delete();
            }
            this.addException(0, commandException);
            return;
        }
        n = 0;
        String string8 = string2 + File.separatorChar + "im4java_" + string4 + "-";
        String string9 = "." + string3;
        for (String string10 : list) {
            try {
                File file3 = new File(string8 + n + string9);
                File file4 = new File(filenamePatternResolver.createName(string10));
                file4.delete();
                if (file3.renameTo(file4)) continue;
                this.addException(0, new Exception("rename failed"));
            }
            catch (Exception exception) {
                this.addException(0, exception);
                return;
            }
            finally {
                ++n;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addException(int n, Exception exception) {
        List<ConvertException> list = this.iExceptions;
        synchronized (list) {
            this.iExceptions.add(new ConvertException(n, exception));
        }
    }

    public List<ConvertException> getFailedConversions() {
        return this.iExceptions;
    }

    public Mode getMode() {
        return this.iMode;
    }

    public class ConvertException
    extends Exception {
        private int iIndex;

        public ConvertException(int n, Exception exception) {
            super(exception);
            this.fillInStackTrace();
            this.iIndex = n;
        }

        public int getIndex() {
            return this.iIndex;
        }
    }

    public static enum Mode {
        SEQUENTIAL,
        PARALLEL,
        BATCH;

    }
}

