/*
 * Decompiled with CFR 0.152.
 */
package com.mortennobel.imagescaling;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;

public class ImageUtils {
    public static String imageTypeName(BufferedImage img) {
        switch (img.getType()) {
            case 5: {
                return "TYPE_3BYTE_BGR";
            }
            case 6: {
                return "TYPE_4BYTE_ABGR";
            }
            case 7: {
                return "TYPE_4BYTE_ABGR_PRE";
            }
            case 12: {
                return "TYPE_BYTE_BINARY";
            }
            case 10: {
                return "TYPE_BYTE_GRAY";
            }
            case 13: {
                return "TYPE_BYTE_INDEXED";
            }
            case 0: {
                return "TYPE_CUSTOM";
            }
            case 2: {
                return "TYPE_INT_ARGB";
            }
            case 3: {
                return "TYPE_INT_ARGB_PRE";
            }
            case 4: {
                return "TYPE_INT_BGR";
            }
            case 1: {
                return "TYPE_INT_RGB";
            }
            case 9: {
                return "TYPE_USHORT_555_RGB";
            }
            case 8: {
                return "TYPE_USHORT_565_RGB";
            }
            case 11: {
                return "TYPE_USHORT_GRAY";
            }
        }
        return "unknown image type #" + img.getType();
    }

    public static int nrChannels(BufferedImage img) {
        switch (img.getType()) {
            case 5: {
                return 3;
            }
            case 6: {
                return 4;
            }
            case 10: {
                return 1;
            }
            case 4: {
                return 3;
            }
            case 2: {
                return 4;
            }
            case 1: {
                return 3;
            }
            case 0: {
                return 4;
            }
            case 7: {
                return 4;
            }
            case 3: {
                return 4;
            }
            case 9: {
                return 3;
            }
            case 8: {
                return 3;
            }
            case 11: {
                return 1;
            }
        }
        return 0;
    }

    public static byte[] getPixelsBGR(BufferedImage img, int y, int w, byte[] array, int[] temp) {
        boolean x = false;
        boolean h = true;
        assert (array.length == temp.length * ImageUtils.nrChannels(img));
        assert (temp.length == w);
        int imageType = img.getType();
        switch (imageType) {
            case 5: 
            case 6: 
            case 7: 
            case 10: {
                WritableRaster raster = img.getRaster();
                raster.getDataElements(0, y, w, 1, array);
                break;
            }
            case 4: {
                WritableRaster raster = img.getRaster();
                raster.getDataElements(0, y, w, 1, temp);
                ImageUtils.ints2bytes(temp, array, 0, 1, 2);
                break;
            }
            case 1: {
                WritableRaster raster = img.getRaster();
                raster.getDataElements(0, y, w, 1, temp);
                ImageUtils.ints2bytes(temp, array, 2, 1, 0);
                break;
            }
            case 2: 
            case 3: {
                WritableRaster raster = img.getRaster();
                raster.getDataElements(0, y, w, 1, temp);
                ImageUtils.ints2bytes(temp, array, 2, 1, 0, 3);
                break;
            }
            case 0: {
                img.getRGB(0, y, w, 1, temp, 0, w);
                ImageUtils.ints2bytes(temp, array, 2, 1, 0, 3);
                break;
            }
            default: {
                img.getRGB(0, y, w, 1, temp, 0, w);
                ImageUtils.ints2bytes(temp, array, 2, 1, 0);
            }
        }
        return array;
    }

    public static void setBGRPixels(byte[] bgrPixels, BufferedImage img, int x, int y, int w, int h) {
        int imageType = img.getType();
        WritableRaster raster = img.getRaster();
        if (imageType == 5 || imageType == 6 || imageType == 7 || imageType == 10) {
            raster.setDataElements(x, y, w, h, bgrPixels);
        } else {
            int[] pixels = imageType == 4 ? ImageUtils.bytes2int(bgrPixels, 2, 1, 0) : (imageType == 2 || imageType == 3 ? ImageUtils.bytes2int(bgrPixels, 3, 0, 1, 2) : ImageUtils.bytes2int(bgrPixels, 0, 1, 2));
            if (w == 0 || h == 0) {
                return;
            }
            if (pixels.length < w * h) {
                throw new IllegalArgumentException("pixels array must have a length >= w*h");
            }
            if (imageType == 2 || imageType == 1 || imageType == 3 || imageType == 4) {
                raster.setDataElements(x, y, w, h, pixels);
            } else {
                img.setRGB(x, y, w, h, pixels, 0, w);
            }
        }
    }

    public static void ints2bytes(int[] in, byte[] out, int index1, int index2, int index3) {
        for (int i = 0; i < in.length; ++i) {
            int index = i * 3;
            int value = in[i];
            out[index + index1] = (byte)value;
            out[index + index2] = (byte)(value >>= 8);
            out[index + index3] = (byte)(value >>= 8);
        }
    }

    public static void ints2bytes(int[] in, byte[] out, int index1, int index2, int index3, int index4) {
        for (int i = 0; i < in.length; ++i) {
            int index = i * 4;
            int value = in[i];
            out[index + index1] = (byte)value;
            out[index + index2] = (byte)(value >>= 8);
            out[index + index3] = (byte)(value >>= 8);
            out[index + index4] = (byte)(value >>= 8);
        }
    }

    public static int[] bytes2int(byte[] in, int index1, int index2, int index3) {
        int[] out = new int[in.length / 3];
        for (int i = 0; i < out.length; ++i) {
            int index = i * 3;
            int b1 = (in[index + index1] & 0xFF) << 16;
            int b2 = (in[index + index2] & 0xFF) << 8;
            int b3 = in[index + index3] & 0xFF;
            out[i] = b1 | b2 | b3;
        }
        return out;
    }

    public static int[] bytes2int(byte[] in, int index1, int index2, int index3, int index4) {
        int[] out = new int[in.length / 4];
        for (int i = 0; i < out.length; ++i) {
            int index = i * 4;
            int b1 = (in[index + index1] & 0xFF) << 24;
            int b2 = (in[index + index2] & 0xFF) << 16;
            int b3 = (in[index + index3] & 0xFF) << 8;
            int b4 = in[index + index4] & 0xFF;
            out[i] = b1 | b2 | b3 | b4;
        }
        return out;
    }

    public static BufferedImage convert(BufferedImage src, int bufImgType) {
        BufferedImage img = new BufferedImage(src.getWidth(), src.getHeight(), bufImgType);
        Graphics2D g2d = img.createGraphics();
        g2d.drawImage((Image)src, 0, 0, null);
        g2d.dispose();
        return img;
    }
}

