/*
 * Decompiled with CFR 0.152.
 */
package magick;

import java.awt.Dimension;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import java.util.Vector;
import magick.Magick;
import magick.MagickException;
import magick.MagickImage;

public class MagickProducer
extends Magick
implements ImageProducer {
    private MagickImage image = null;
    private Vector consumers = null;

    public MagickProducer(MagickImage image) {
        this.image = image;
        this.consumers = new Vector();
    }

    @Override
    public void addConsumer(ImageConsumer consumer) {
        if (consumer != null && !this.consumers.contains(consumer)) {
            this.consumers.addElement(consumer);
        }
    }

    @Override
    public boolean isConsumer(ImageConsumer consumer) {
        return this.consumers.contains(consumer);
    }

    @Override
    public void removeConsumer(ImageConsumer consumer) {
        this.consumers.removeElement(consumer);
    }

    @Override
    public void startProduction(ImageConsumer consumer) {
        int i;
        byte[] pixels;
        int size;
        Dimension dim;
        this.addConsumer(consumer);
        try {
            dim = this.image.getDimension();
            size = dim.width * dim.height;
            pixels = new byte[size * 4];
            this.image.dispatchImage(0, 0, dim.width, dim.height, "RGBA", pixels);
        }
        catch (MagickException ex) {
            for (int i2 = 0; i2 < this.consumers.size(); ++i2) {
                ImageConsumer aConsumer = (ImageConsumer)this.consumers.elementAt(i2);
                aConsumer.imageComplete(1);
            }
            return;
        }
        int[] img = new int[size];
        DirectColorModel cmodel = new DirectColorModel(32, -16777216, 0xFF0000, 65280, 255);
        for (i = 0; i < size; ++i) {
            img[i] = (pixels[i * 4] & 0xFF) << 24 | (pixels[i * 4 + 1] & 0xFF) << 16 | (pixels[i * 4 + 2] & 0xFF) << 8 | pixels[i * 4 + 3] & 0xFF;
        }
        for (i = 0; i < this.consumers.size(); ++i) {
            ImageConsumer aConsumer = (ImageConsumer)this.consumers.elementAt(i);
            aConsumer.setHints(30);
            aConsumer.setDimensions(dim.width, dim.height);
            aConsumer.setPixels(0, 0, dim.width, dim.height, (ColorModel)cmodel, img, 0, dim.width);
            aConsumer.imageComplete(3);
        }
    }

    @Override
    public void requestTopDownLeftRightResend(ImageConsumer consumer) {
        this.startProduction(consumer);
    }
}

