/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.soap.axiom;

import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPFactory;
import org.springframework.util.Assert;
import org.springframework.util.xml.StaxUtils;
import org.springframework.ws.soap.axiom.AxiomSoapBodyException;
import org.springframework.ws.soap.axiom.Payload;
import org.springframework.ws.soap.axiom.support.AxiomUtils;

abstract class AbstractPayload
extends Payload {
    private final SOAPBody axiomBody;
    private final SOAPFactory axiomFactory;

    protected AbstractPayload(SOAPBody axiomBody, SOAPFactory axiomFactory) {
        Assert.notNull((Object)axiomBody, (String)"'axiomBody' must not be null");
        Assert.notNull((Object)axiomFactory, (String)"'axiomFactory' must not be null");
        this.axiomBody = axiomBody;
        this.axiomFactory = axiomFactory;
    }

    @Override
    public final Source getSource() {
        try {
            OMElement payloadElement = this.getPayloadElement();
            if (payloadElement != null) {
                XMLStreamReader streamReader = this.getStreamReader(payloadElement);
                return StaxUtils.createCustomStaxSource((XMLStreamReader)streamReader);
            }
            return null;
        }
        catch (OMException ex) {
            throw new AxiomSoapBodyException(ex);
        }
    }

    protected abstract XMLStreamReader getStreamReader(OMElement var1);

    @Override
    public final Result getResult() {
        AxiomUtils.removeContents((OMContainer)this.getAxiomBody());
        return this.getResultInternal();
    }

    protected abstract Result getResultInternal();

    public SOAPFactory getAxiomFactory() {
        return this.axiomFactory;
    }

    protected SOAPBody getAxiomBody() {
        return this.axiomBody;
    }

    protected OMElement getPayloadElement() throws OMException {
        return this.getAxiomBody().getFirstElement();
    }
}

