/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout;

import fr.improve.struts.taglib.layout.LayoutTagSupport;
import fr.improve.struts.taglib.layout.event.ComputeLayoutSpanEvent;
import fr.improve.struts.taglib.layout.event.ComputeLayoutSpanEventListener;
import fr.improve.struts.taglib.layout.event.EndLayoutEvent;
import fr.improve.struts.taglib.layout.event.LayoutEventListener;
import fr.improve.struts.taglib.layout.event.StartLayoutEvent;
import fr.improve.struts.taglib.layout.event.StaticCodeIncludeLayoutEvent;
import fr.improve.struts.taglib.layout.event.StaticCodeIncludeListener;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import fr.improve.struts.taglib.layout.util.TagUtils;
import javax.servlet.jsp.JspException;

public class GridLayoutTag
extends LayoutTagSupport
implements LayoutEventListener,
ComputeLayoutSpanEventListener,
StaticCodeIncludeListener {
    protected String cols = "2";
    protected boolean space = true;
    protected String styleClass;
    protected String width;
    protected String align;
    protected int borderSpacing = 0;
    protected String id;
    protected String height;
    protected int currentCols = 1;
    protected int currentSpan = 1;
    protected String jspStyleClass;
    protected StringBuffer staticCode = new StringBuffer();

    protected void initDynamicValues() {
        this.jspStyleClass = this.styleClass;
        if (this.styleClass == null) {
            this.styleClass = LayoutUtils.getSkin(this.pageContext.getSession()).getProperty("styleclass.grid", null);
        }
    }

    protected void reset() {
        this.styleClass = this.jspStyleClass;
        this.jspStyleClass = null;
        this.staticCode = new StringBuffer();
    }

    public int doStartLayoutTag() throws JspException {
        int lc_fieldColumnNumber = LayoutUtils.getSkin(this.pageContext.getSession()).getFieldInterface().getColumnNumber();
        new StartLayoutEvent(this, "<td colspan=\"" + lc_fieldColumnNumber + "\">").send();
        if (this.id != null || this.height != null) {
            TagUtils.write(this.pageContext, "<div style=\"");
            if (this.height != null) {
                TagUtils.write(this.pageContext, "height:");
                TagUtils.write(this.pageContext, this.height);
                TagUtils.write(this.pageContext, ";");
            }
            TagUtils.write(this.pageContext, "overflow-y:scroll;overflow:-moz-scrollbars-vertical;");
            if (this.id != null) {
                TagUtils.write(this.pageContext, "\" id=\"");
                TagUtils.write(this.pageContext, this.id);
            }
            TagUtils.write(this.pageContext, "\">");
        }
        TagUtils.write(this.pageContext, "<table border=\"0\" cellspacing=\"");
        TagUtils.write(this.pageContext, String.valueOf(this.borderSpacing));
        TagUtils.write(this.pageContext, "\" cellpadding=\"0\"");
        if (this.styleClass != null) {
            TagUtils.write(this.pageContext, " class=\"");
            TagUtils.write(this.pageContext, this.styleClass);
            TagUtils.write(this.pageContext, "\"");
        }
        if (this.width != null) {
            TagUtils.write(this.pageContext, " width=\"");
            TagUtils.write(this.pageContext, this.width);
            TagUtils.write(this.pageContext, "\"");
        }
        if (this.align != null) {
            TagUtils.write(this.pageContext, " align=\"");
            TagUtils.write(this.pageContext, this.align);
            TagUtils.write(this.pageContext, "\"");
        }
        TagUtils.write(this.pageContext, "><tr>");
        return 1;
    }

    public int doEndLayoutTag() throws JspException {
        this.currentCols = 1;
        TagUtils.write(this.pageContext, "</tr></table>");
        if (this.id != null || this.height != null) {
            TagUtils.write(this.pageContext, "</div>");
        }
        if (this.staticCode.length() != 0) {
            TagUtils.write(this.pageContext, this.staticCode.toString());
        }
        new EndLayoutEvent(this, "</td>").send();
        return 6;
    }

    public void release() {
        super.release();
        this.cols = "2";
        this.space = true;
        this.styleClass = null;
        this.height = null;
        this.id = null;
        this.width = null;
        this.align = null;
        this.borderSpacing = 0;
    }

    public Object processStartLayoutEvent(StartLayoutEvent in_event) throws JspException {
        if (this.currentCols > Integer.parseInt(this.cols)) {
            TagUtils.write(this.pageContext, "</tr><tr>");
            this.currentCols = 1;
        }
        this.currentCols += this.currentSpan;
        this.currentSpan = 1;
        return in_event.consume(this.pageContext, "");
    }

    public Object processEndLayoutEvent(EndLayoutEvent in_event) throws JspException {
        return in_event.consume(this.pageContext, this.space ? "<td>&nbsp;</td>" : "");
    }

    public Integer computeColspan(ComputeLayoutSpanEvent in_event) throws JspException {
        this.currentSpan = in_event.getColspan();
        if (this.space) {
            int lc_value = (Integer)in_event.consume(this);
            lc_value += in_event.getColspan();
            return new Integer(--lc_value);
        }
        return (Integer)in_event.consume(this);
    }

    public void setCols(String cols) {
        this.cols = cols;
    }

    public boolean isSpace() {
        return this.space;
    }

    public void setSpace(boolean space) {
        this.space = space;
    }

    public void setStyleClass(String styleClass) {
        this.styleClass = styleClass;
    }

    public void setHeight(String height) {
        this.height = height;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setWidth(String in_string) {
        this.width = in_string;
    }

    public void setBorderSpacing(int in_spacing) {
        this.borderSpacing = in_spacing;
    }

    public String getAlign() {
        return this.align;
    }

    public void setAlign(String align) {
        this.align = align;
    }

    public Object processStaticCodeIncludeEvent(StaticCodeIncludeLayoutEvent in_event) throws JspException {
        String lc_value = (String)in_event.sendToParent(this);
        if (this.height == null && this.id == null) {
            return lc_value;
        }
        this.staticCode.append(lc_value);
        return "";
    }
}

