/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.datagrid;

import fr.improve.struts.taglib.layout.datagrid.Datagrid;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.beanutils.BasicDynaBean;
import org.apache.commons.beanutils.BasicDynaClass;
import org.apache.commons.beanutils.DynaBean;
import org.apache.commons.beanutils.DynaClass;
import org.apache.commons.beanutils.DynaProperty;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatagridImpl
extends Datagrid
implements DynaBean {
    private static Log LOG = LogFactory.getLog(DatagridImpl.class);
    private List data;
    private Map addedData;
    private Map modifiedData;
    private Map dataWithStates = new HashMap();
    private Map indexWithStates = new HashMap();
    private Set addedAndRemoved = new HashSet();
    private Class dataClass;
    private DynaClass dataDynaClass;
    private Set booleans = new HashSet();
    private Map booleanStates = new HashMap();
    private static final int STATUS_NEW = 0;
    private static final int STATUS_SET = 1;
    private static final int STATUS_DIRTY = 2;
    private static final int STATUS_READ = 3;
    private int status = 0;

    DatagridImpl() {
    }

    protected Object getModifiedObject(int in_index) {
        Object o = this.data.get(in_index);
        this.modifiedData.put(new Integer(in_index), o);
        return o;
    }

    protected Object getAddedObject(int in_index) {
        Integer lc_int = new Integer(in_index);
        Object o = this.addedData.get(lc_int);
        if (o == null) {
            if (this.dataClass == null) {
                throw new RuntimeException("dataClass property is not set");
            }
            try {
                o = this.dataClass.newInstance();
            }
            catch (InstantiationException e) {
                this.throwException(e);
            }
            catch (IllegalAccessException e) {
                this.throwException(e);
            }
            if (!this.addedAndRemoved.contains(lc_int)) {
                this.addedData.put(lc_int, o);
            }
        }
        return o;
    }

    private void throwException(Exception e) {
        LOG.error((Object)("Fail to create an object of class " + this.dataClass.getName()), (Throwable)e);
        throw new RuntimeException("A " + e.getClass().getName() + " occured while creating an object of class " + this.dataClass.getName() + " : " + e.getMessage());
    }

    protected boolean checkNotAddedAndRemoved(int in_index, Object in_value) {
        if (in_index >= this.data.size() && "removed".equals(in_value)) {
            Integer lc_int = new Integer(in_index);
            this.addedData.remove(lc_int);
            this.addedAndRemoved.add(lc_int);
            return false;
        }
        return true;
    }

    public DynaClass getDynaClass() {
        return this.dataDynaClass;
    }

    public void set(String in_propertyName, int in_index, Object in_value) {
        Object o;
        this.moveToStatus(2);
        if (in_index < 0) {
            throw new IllegalArgumentException("Negative in_index !");
        }
        if ("dataState".equals(in_propertyName)) {
            if (in_value != null && this.checkNotAddedAndRemoved(in_index, in_value)) {
                this.setDataState(in_index, in_value.toString());
            }
            return;
        }
        if (in_index >= this.data.size()) {
            o = this.getAddedObject(in_index);
        } else if (this.booleans.contains(in_propertyName)) {
            o = this.data.get(in_index);
        } else {
            if (in_value.equals(this.get(in_propertyName, in_index))) {
                return;
            }
            o = this.getModifiedObject(in_index);
        }
        try {
            PropertyUtils.setProperty((Object)o, (String)in_propertyName, (Object)in_value);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Could not set new object property value", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"Could not set new object property value", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"Could not set new object property value", (Throwable)e);
        }
    }

    public Object get(String in_propertyName, int in_index) {
        Object o = this.data.get(in_index);
        Object ret = null;
        try {
            ret = PropertyUtils.getProperty(o, (String)in_propertyName);
        }
        catch (IllegalAccessException e) {
            LOG.error((Object)"Could not get object property value", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Object)"Could not get object property value", (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Object)"Could not get object property value", (Throwable)e);
        }
        return ret;
    }

    public void setData(List in_list) {
        this.data = in_list;
        this.addedData = new TreeMap();
        this.modifiedData = new HashMap();
        this.dataWithStates.clear();
        this.indexWithStates.clear();
        this.addedAndRemoved.clear();
        this.status = 1;
    }

    public void setDataClass(Class in_class) {
        this.dataClass = in_class;
        PropertyDescriptor[] lc_descriptors = PropertyUtils.getPropertyDescriptors((Class)in_class);
        ArrayList<DynaProperty> lc_list = new ArrayList<DynaProperty>(lc_descriptors.length + 1);
        int i = 0;
        while (i < lc_descriptors.length) {
            PropertyDescriptor lc_descriptor = lc_descriptors[i];
            if (lc_descriptor.getWriteMethod() != null) {
                DynaProperty lc_property = new DynaProperty(lc_descriptor.getName(), lc_descriptor.getPropertyType());
                lc_list.add(lc_property);
            }
            ++i;
        }
        DynaProperty lc_property = new DynaProperty("dataState", String.class);
        lc_list.add(lc_property);
        DynaProperty[] lc_properties = lc_list.toArray(new DynaProperty[lc_list.size()]);
        this.dataDynaClass = new BasicDynaClass(in_class.getName(), BasicDynaBean.class, lc_properties);
    }

    public void setDataState(int in_index, String in_state) {
        HashSet<Integer> lc_list;
        if (in_state == null) {
            throw new IllegalArgumentException("in_state null");
        }
        Integer lc_int = new Integer(in_index);
        String lc_oldState = (String)this.indexWithStates.get(lc_int);
        if (lc_oldState != null && (lc_list = (HashSet<Integer>)this.dataWithStates.get(lc_oldState)) != null) {
            lc_list.remove(lc_int);
        }
        if ((lc_list = (Collection)this.dataWithStates.get(in_state)) == null) {
            lc_list = new HashSet<Integer>();
            this.dataWithStates.put(in_state, lc_list);
        }
        lc_list.add(lc_int);
        this.indexWithStates.put(lc_int, in_state);
    }

    public Collection getData() {
        ArrayList lc_collection = new ArrayList();
        lc_collection.addAll(this.data);
        lc_collection.addAll(this.addedData.values());
        return lc_collection;
    }

    public Collection getDeletedData() {
        this.moveToStatus(3);
        return this.getDataWithState("removed");
    }

    public Collection getDataWithState(String in_state) {
        this.moveToStatus(3);
        Collection goodStateList = (Collection)this.dataWithStates.get(in_state);
        if (goodStateList == null || goodStateList.isEmpty()) {
            return Collections.EMPTY_LIST;
        }
        ArrayList lc_list = new ArrayList();
        for (Integer lc_int : goodStateList) {
            Object o;
            if (lc_int < this.data.size()) {
                o = this.data.get(lc_int);
                lc_list.add(o);
                continue;
            }
            o = this.addedData.get(lc_int);
            lc_list.add(o);
        }
        return lc_list;
    }

    public Collection getSelectedData() {
        this.moveToStatus(3);
        return this.getDataWithState("selected");
    }

    public Collection getAddedData() {
        this.moveToStatus(3);
        return this.addedData.values();
    }

    public Collection getModifiedData() {
        this.moveToStatus(3);
        return this.modifiedData.values();
    }

    public String getObjectState(int in_index) {
        String lc_state = (String)this.indexWithStates.get(new Integer(in_index));
        return lc_state == null ? "" : lc_state;
    }

    public boolean contains(String name, String key) {
        return false;
    }

    public Object get(String name, String key) {
        return null;
    }

    public Object get(String name) {
        return null;
    }

    public void remove(String name, String key) {
    }

    public void set(String name, Object value) {
    }

    public void set(String name, String key, Object value) {
    }

    public void preUpdate() {
        Iterator lc_it = this.booleans.iterator();
        Boolean falseValue = Boolean.FALSE;
        while (lc_it.hasNext()) {
            String lc_booleanProperty = (String)lc_it.next();
            HashMap objects = (HashMap)this.booleanStates.get(lc_booleanProperty);
            if (objects == null) {
                objects = new HashMap();
                this.booleanStates.put(lc_booleanProperty, objects);
            }
            for (Object lc_element : this.data) {
                try {
                    objects.put(lc_element, PropertyUtils.getProperty(lc_element, (String)lc_booleanProperty));
                    PropertyUtils.setProperty(lc_element, (String)lc_booleanProperty, (Object)falseValue);
                }
                catch (Exception e) {
                    LOG.error((Object)("Fail to reset property " + lc_booleanProperty), (Throwable)e);
                }
            }
        }
        this.status = 2;
    }

    private void postUpdate() {
        for (String lc_booleanProperty : this.booleans) {
            Map objects = (Map)this.booleanStates.get(lc_booleanProperty);
            Iterator lc_elements = this.data.iterator();
            int i = 0;
            while (lc_elements.hasNext()) {
                try {
                    Object lc_element = lc_elements.next();
                    Boolean oldValue = (Boolean)objects.get(lc_element);
                    Boolean newValue = (Boolean)PropertyUtils.getProperty(lc_element, (String)lc_booleanProperty);
                    if (!oldValue.equals(newValue)) {
                        this.getModifiedObject(i);
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Fail to check property " + lc_booleanProperty), (Throwable)e);
                }
                ++i;
            }
        }
    }

    private void moveToStatus(int in_status) {
        if (this.status != in_status) {
            switch (in_status) {
                case 2: {
                    this.preUpdate();
                    break;
                }
                case 3: {
                    this.postUpdate();
                }
            }
            this.status = in_status;
        }
    }

    void addBooleanProperty(String in_property) {
        this.booleans.add(in_property);
    }
}

