/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSActionObject;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSInitialize
extends FSMovieObject {
    private int identifier = 0;
    private ArrayList actions = null;
    private byte[] encodedActions = null;

    public FSInitialize(FSCoder fSCoder) {
        super(59);
        this.decode(fSCoder);
    }

    public FSInitialize(int n, ArrayList arrayList) {
        super(59);
        this.setIdentifier(n);
        this.setActions(arrayList);
    }

    public FSInitialize(int n, byte[] byArray) {
        super(59);
        this.setIdentifier(n);
        this.setEncodedActions(byArray);
    }

    public FSInitialize(FSInitialize fSInitialize) {
        super(fSInitialize);
        this.identifier = fSInitialize.identifier;
        if (fSInitialize.actions != null) {
            this.actions = new ArrayList(fSInitialize.actions.size());
            Iterator iterator = fSInitialize.actions.iterator();
            while (iterator.hasNext()) {
                this.actions.add(((FSActionObject)iterator.next()).clone());
            }
        } else {
            this.encodedActions = Transform.clone(fSInitialize.encodedActions);
        }
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int n) {
        this.identifier = n;
    }

    public void add(FSActionObject fSActionObject) {
        if (this.encodedActions != null) {
            this.actions = FSMovie.decodeActions(this.encodedActions);
            this.encodedActions = null;
        }
        this.actions.add(fSActionObject);
    }

    public ArrayList getActions() {
        if (this.encodedActions != null) {
            this.actions = FSMovie.decodeActions(this.encodedActions);
            this.encodedActions = null;
        }
        return this.actions;
    }

    public void setActions(ArrayList arrayList) {
        this.actions = arrayList;
        this.encodedActions = null;
    }

    public byte[] getEncodedActions() {
        return this.encodedActions;
    }

    public void setEncodedActions(byte[] byArray) {
        this.encodedActions = byArray;
        this.actions = null;
    }

    public Object clone() {
        FSInitialize fSInitialize = (FSInitialize)super.clone();
        if (this.actions != null) {
            fSInitialize.actions = new ArrayList();
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                fSInitialize.actions.add(((FSActionObject)iterator.next()).clone());
            }
        } else {
            fSInitialize.encodedActions = Transform.clone(this.encodedActions);
        }
        return fSInitialize;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSInitialize fSInitialize = (FSInitialize)object;
            boolean bl2 = bl = this.identifier == fSInitialize.identifier;
            bl = this.actions != null ? bl && this.actions.equals(fSInitialize.actions) : bl && Transform.equals(this.encodedActions, fSInitialize.encodedActions);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "identifier", this.identifier);
            if (this.actions != null) {
                Transform.append(stringBuffer, "actions", this.actions, n);
            } else {
                stringBuffer.append("actions = <data>; ");
            }
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 2;
        if (this.actions != null) {
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                FSActionObject fSActionObject = (FSActionObject)iterator.next();
                this.length += fSActionObject.length(fSCoder);
                this.length += fSActionObject.getType() > 128 ? 3 : 1;
            }
        } else {
            this.length += this.encodedActions.length;
        }
        ++this.length;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeWord(this.identifier, 2);
        if (this.actions != null) {
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                FSActionObject fSActionObject = (FSActionObject)iterator.next();
                int n = fSCoder.getPointer();
                int n2 = fSActionObject.getLength();
                int n3 = fSCoder.getPointer() + (fSActionObject.getType() > 128 ? 24 : 8);
                int n4 = n3 + (n2 << 3);
                fSActionObject.encode(fSCoder);
                fSCoder.setPointer(n4);
                int n5 = fSCoder.getPointer() - n4 >> 3;
                if (n5 == 0) continue;
                fSCoder.context[14] = 1;
                fSCoder.context[15] = fSActionObject.getType();
                fSCoder.context[16] = n >>> 3;
                fSCoder.context[17] = n4 - n >>> 3;
                fSCoder.context[13] = n5;
            }
        } else {
            fSCoder.writeBytes(this.encodedActions);
        }
        fSCoder.writeWord(0, 1);
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        this.identifier = fSCoder.readWord(2, false);
        if (fSCoder.context[18] == 1) {
            int n;
            this.actions = new ArrayList();
            for (int i = this.length - 2; i > 1; i -= fSCoder.getPointer() - n >>> 3) {
                n = fSCoder.getPointer();
                this.actions.add(FSMovie.decodeAction(fSCoder));
            }
        } else {
            this.encodedActions = new byte[this.length - 3];
            fSCoder.readBytes(this.encodedActions);
        }
        fSCoder.readWord(1, false);
        fSCoder.endObject(this.name());
    }
}

