/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSShape
extends FSTransformObject {
    private ArrayList objects = null;
    private byte[] encodedObjects = null;

    FSShape(FSCoder fSCoder, int n) {
        if (n > 1) {
            this.encodedObjects = new byte[n];
        }
        this.decode(fSCoder);
    }

    public FSShape(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSShape() {
        this.objects = new ArrayList();
    }

    public FSShape(ArrayList arrayList) {
        this.setObjects(arrayList);
    }

    public FSShape(FSShape fSShape) {
        if (this.objects != null) {
            this.objects = new ArrayList();
            Iterator iterator = fSShape.objects.iterator();
            while (iterator.hasNext()) {
                this.objects.add(((FSTransformObject)iterator.next()).clone());
            }
        } else {
            this.encodedObjects = Transform.clone(fSShape.encodedObjects);
        }
    }

    public void add(FSTransformObject fSTransformObject) {
        if (this.encodedObjects != null) {
            this.objects = FSMovie.decodeShape(this.encodedObjects);
            this.encodedObjects = null;
        }
        this.objects.add(fSTransformObject);
    }

    public ArrayList getObjects() {
        if (this.encodedObjects != null) {
            this.objects = FSMovie.decodeShape(this.encodedObjects);
            this.encodedObjects = null;
        }
        return this.objects;
    }

    public void setObjects(ArrayList arrayList) {
        this.objects = arrayList;
    }

    public Object clone() {
        FSShape fSShape = (FSShape)super.clone();
        if (this.objects != null) {
            fSShape.objects = new ArrayList();
            Iterator iterator = this.objects.iterator();
            while (iterator.hasNext()) {
                fSShape.objects.add(((FSTransformObject)iterator.next()).clone());
            }
        } else {
            fSShape.encodedObjects = Transform.clone(this.encodedObjects);
        }
        return fSShape;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSShape fSShape = (FSShape)object;
            bl = this.objects != null ? this.objects.equals(fSShape.objects) : this.objects == fSShape.objects;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "objects", this.objects, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n;
        fSCoder.context[10] = n = 0;
        if (this.objects != null) {
            n += 8;
            Iterator iterator = this.objects.iterator();
            while (iterator.hasNext()) {
                n += ((FSTransformObject)iterator.next()).length(fSCoder);
            }
            n += (n += 6) % 8 > 0 ? 8 - n % 8 : 0;
        } else {
            n += this.encodedObjects.length << 3;
        }
        return n >> 3;
    }

    public void encode(FSCoder fSCoder) {
        if (this.objects != null) {
            fSCoder.writeBits(fSCoder.context[6], 4);
            fSCoder.writeBits(fSCoder.context[7], 4);
            Iterator iterator = this.objects.iterator();
            while (iterator.hasNext()) {
                ((FSTransformObject)iterator.next()).encode(fSCoder);
            }
            fSCoder.writeBits(0, 6);
            fSCoder.alignToByte();
        } else {
            fSCoder.writeBytes(this.encodedObjects);
        }
    }

    public void decode(FSCoder fSCoder) {
        if (this.encodedObjects != null) {
            fSCoder.readBytes(this.encodedObjects);
        } else {
            this.objects = FSMovie.decodeShape(fSCoder);
        }
    }
}

