/*
 * Decompiled with CFR 0.152.
 */
package org.im4java.test;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.im4java.core.ConvertCmd;
import org.im4java.core.DisplayCmd;
import org.im4java.core.IMOperation;
import org.im4java.process.ProcessEvent;
import org.im4java.process.ProcessTask;
import org.im4java.test.AbstractTestCase;

public class TestCase16a
extends AbstractTestCase {
    @Override
    public String getDescription() {
        return "asynchronous execution";
    }

    public static void main(String[] stringArray) {
        TestCase16a testCase16a = new TestCase16a();
        testCase16a.runTest(stringArray);
    }

    @Override
    public void run() throws Exception {
        System.err.println("16a. Testing asynchronous execution ...");
        IMOperation iMOperation = new IMOperation();
        iMOperation.size(400, 200);
        iMOperation.addImage("gradient:red", iTmpImage);
        ConvertCmd convertCmd = new ConvertCmd();
        convertCmd.run(iMOperation, new Object[0]);
        DisplayCmd displayCmd = new DisplayCmd();
        IMOperation iMOperation2 = new IMOperation();
        iMOperation2.addImage(iTmpImage);
        ProcessTask processTask = displayCmd.getProcessTask(iMOperation2, new Object[0]);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        executorService.execute(processTask);
        executorService.shutdown();
        String string = "sleep";
        if (this.iArgs != null && this.iArgs.length > 0) {
            string = this.iArgs[0];
        }
        if (string.equals("sleep")) {
            this.waitSleep(executorService, processTask);
        } else if (string.equals("get")) {
            this.waitGet(processTask);
        } else {
            this.waitWait(executorService, processTask);
        }
    }

    private void waitSleep(ExecutorService executorService, ProcessTask processTask) throws InterruptedException {
        for (int i = 0; i < 10; ++i) {
            System.err.println("sleeping for one second...");
            Thread.sleep(1000L);
            if (executorService.isTerminated()) break;
        }
        if (!executorService.isTerminated()) {
            System.err.println("Trying to shutdown execution...");
            processTask.cancel(true);
            executorService.shutdownNow();
        } else {
            System.err.println("already terminated");
        }
        System.err.println("Terminated execution");
    }

    private void waitGet(ProcessTask processTask) throws Exception {
        try {
            System.err.println("waiting 10 seconds for process to finish with get ...");
            ProcessEvent processEvent = (ProcessEvent)processTask.get(10L, TimeUnit.SECONDS);
            System.err.println("process ended with " + processEvent.getReturnCode());
        }
        catch (TimeoutException timeoutException) {
            System.err.println("canceling process ...");
            processTask.cancel(true);
            System.err.println("process terminated");
        }
    }

    private void waitWait(ExecutorService executorService, ProcessTask processTask) throws Exception {
        System.err.println("waiting 10 seconds for process to finish with awaitTermination ...");
        if (executorService.awaitTermination(10L, TimeUnit.SECONDS)) {
            System.err.println("process ended with " + ((ProcessEvent)processTask.get()).getReturnCode());
        } else {
            System.err.println("Trying to shutdown execution...");
            processTask.cancel(true);
            executorService.shutdownNow();
            System.err.println("process terminated");
        }
    }
}

