/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSTransformObject;

public class FSCoordTransform
extends FSTransformObject {
    private float[][] matrix = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};

    public FSCoordTransform(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSCoordTransform() {
    }

    public FSCoordTransform(int n, int n2) {
        float f = n;
        float f2 = n2;
        this.matrix[0][2] = f;
        this.matrix[1][2] = f2;
    }

    public FSCoordTransform(int n, int n2, double d, double d2) {
        this.matrix[0][0] = (float)d;
        this.matrix[1][1] = (float)d2;
        this.matrix[0][2] = n;
        this.matrix[1][2] = n2;
    }

    public FSCoordTransform(float[][] fArray) {
        this.setMatrix(fArray);
    }

    public FSCoordTransform(FSCoordTransform fSCoordTransform) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.matrix[i][j] = fSCoordTransform.matrix[i][j];
            }
        }
    }

    public void translate(int n, int n2) {
        float[][] fArrayArray = new float[][]{{1.0f, 0.0f, n}, {0.0f, 1.0f, n2}, {0.0f, 0.0f, 1.0f}};
        this.composite(fArrayArray);
    }

    public void scale(double d, double d2) {
        float[][] fArrayArray = new float[][]{{(float)d, 0.0f, 0.0f}, {0.0f, (float)d2, 0.0f}, {0.0f, 0.0f, 1.0f}};
        this.composite(fArrayArray);
    }

    public void rotate(double d) {
        float[][] fArrayArray = new float[][]{{1.0f, 0.0f, 0.0f}, {0.0f, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        fArrayArray[0][0] = (float)Math.cos(Math.toRadians(d));
        fArrayArray[0][1] = -((float)Math.sin(Math.toRadians(d)));
        fArrayArray[1][0] = (float)Math.sin(Math.toRadians(d));
        fArrayArray[1][1] = (float)Math.cos(Math.toRadians(d));
        this.composite(fArrayArray);
    }

    public void shear(double d, double d2) {
        float[][] fArrayArray = new float[][]{{1.0f, (float)d2, 0.0f}, {(float)d, 1.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
        this.composite(fArrayArray);
    }

    public int[] transformPoint(int n, int n2) {
        float[] fArray = new float[]{n, n2, 1.0f};
        int[] nArray = new int[]{(int)(this.matrix[0][0] * fArray[0] + this.matrix[0][1] * fArray[1] + this.matrix[0][2] * fArray[2]), (int)(this.matrix[1][0] * fArray[0] + this.matrix[1][1] * fArray[1] + this.matrix[1][2] * fArray[2])};
        return nArray;
    }

    public float[][] getMatrix() {
        return this.matrix;
    }

    public void setMatrix(float[][] fArray) {
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                this.matrix[i][j] = fArray[i][j];
            }
        }
    }

    public void composite(FSCoordTransform fSCoordTransform) {
        this.composite(fSCoordTransform.getMatrix());
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSCoordTransform fSCoordTransform = (FSCoordTransform)object;
            float[][] fArray = fSCoordTransform.matrix;
            bl = true;
            for (int i = 0; i < 3; ++i) {
                for (int j = 0; j < 3; ++j) {
                    if (this.matrix[i][j] == fArray[i][j]) continue;
                    bl = false;
                }
            }
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            stringBuffer.append("[ ");
            stringBuffer.append("[" + this.matrix[0][0] + ", " + this.matrix[0][1] + ", " + this.matrix[0][2] + "], ");
            stringBuffer.append("[" + this.matrix[1][0] + ", " + this.matrix[1][1] + ", " + this.matrix[1][2] + "], ");
            stringBuffer.append("[" + this.matrix[2][0] + ", " + this.matrix[2][1] + ", " + this.matrix[2][2] + "] ");
            stringBuffer.append("]; ");
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        int n = 7 + this.translateFieldSize() * 2;
        if (this.containsScaling()) {
            n += 5 + this.scaleFieldSize() * 2;
        }
        if (this.containsRotation()) {
            n += 5 + this.rotateFieldSize() * 2;
        }
        return (n += n % 8 > 0 ? 8 - n % 8 : 0) >> 3;
    }

    public void encode(FSCoder fSCoder) {
        int n;
        int n2 = this.translateFieldSize();
        fSCoder.alignToByte();
        fSCoder.writeBits(this.containsScaling() ? 1 : 0, 1);
        if (this.containsScaling()) {
            n = this.scaleFieldSize();
            fSCoder.writeBits(n, 5);
            fSCoder.writeFixedBits(this.matrix[0][0], n, 16);
            fSCoder.writeFixedBits(this.matrix[1][1], n, 16);
        }
        fSCoder.writeBits(this.containsRotation() ? 1 : 0, 1);
        if (this.containsRotation()) {
            n = this.rotateFieldSize();
            fSCoder.writeBits(n, 5);
            fSCoder.writeFixedBits(this.matrix[1][0], n, 16);
            fSCoder.writeFixedBits(this.matrix[0][1], n, 16);
        }
        fSCoder.writeBits(n2, 5);
        fSCoder.writeBits((int)this.matrix[0][2], n2);
        fSCoder.writeBits((int)this.matrix[1][2], n2);
        fSCoder.alignToByte();
    }

    public void decode(FSCoder fSCoder) {
        boolean bl;
        boolean bl2;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        fSCoder.alignToByte();
        boolean bl3 = bl2 = fSCoder.readBits(1, false) != 0;
        if (bl2) {
            n = fSCoder.readBits(5, false);
            this.matrix[0][0] = fSCoder.readFixedBits(n, 16);
            this.matrix[1][1] = fSCoder.readFixedBits(n, 16);
        }
        boolean bl4 = bl = fSCoder.readBits(1, false) != 0;
        if (bl) {
            n2 = fSCoder.readBits(5, false);
            this.matrix[1][0] = fSCoder.readFixedBits(n2, 16);
            this.matrix[0][1] = fSCoder.readFixedBits(n2, 16);
        }
        n3 = fSCoder.readBits(5, false);
        this.matrix[0][2] = fSCoder.readBits(n3, true);
        this.matrix[1][2] = fSCoder.readBits(n3, true);
        fSCoder.alignToByte();
    }

    public boolean isUnityTransform() {
        return !this.containsScaling() && !this.containsRotation() && !this.containsTranslation();
    }

    private boolean containsScaling() {
        return this.matrix[0][0] != 1.0f || this.matrix[1][1] != 1.0f;
    }

    private boolean containsRotation() {
        return this.matrix[1][0] != 0.0f || this.matrix[0][1] != 0.0f;
    }

    private boolean containsTranslation() {
        return this.matrix[0][2] != 0.0f || this.matrix[1][2] != 0.0f;
    }

    private int scaleFieldSize() {
        int n = 0;
        if (!this.isUnityTransform()) {
            n = FSCoder.fixedSize(new float[]{this.matrix[0][0], this.matrix[1][1]});
        }
        return n;
    }

    private int rotateFieldSize() {
        int n = FSCoder.fixedSize(new float[]{this.matrix[1][0], this.matrix[0][1]});
        return n;
    }

    private int translateFieldSize() {
        int n = 0;
        if (this.containsTranslation()) {
            n = FSCoder.size(new int[]{(int)this.matrix[0][2], (int)this.matrix[1][2]}, true);
        }
        return n;
    }

    private void composite(float[][] fArray) {
        float[][] fArray2 = new float[3][3];
        fArray2[0][0] = this.matrix[0][0] * fArray[0][0] + this.matrix[0][1] * fArray[1][0] + this.matrix[0][2] * fArray[2][0];
        fArray2[0][1] = this.matrix[0][0] * fArray[0][1] + this.matrix[0][1] * fArray[1][1] + this.matrix[0][2] * fArray[2][1];
        fArray2[0][2] = this.matrix[0][0] * fArray[0][2] + this.matrix[0][1] * fArray[1][2] + this.matrix[0][2] * fArray[2][2];
        fArray2[1][0] = this.matrix[1][0] * fArray[0][0] + this.matrix[1][1] * fArray[1][0] + this.matrix[1][2] * fArray[2][0];
        fArray2[1][1] = this.matrix[1][0] * fArray[0][1] + this.matrix[1][1] * fArray[1][1] + this.matrix[1][2] * fArray[2][1];
        fArray2[1][2] = this.matrix[1][0] * fArray[0][2] + this.matrix[1][1] * fArray[1][2] + this.matrix[1][2] * fArray[2][2];
        fArray2[2][0] = this.matrix[2][0] * fArray[0][0] + this.matrix[2][1] * fArray[1][0] + this.matrix[2][2] * fArray[2][0];
        fArray2[2][1] = this.matrix[2][0] * fArray[0][1] + this.matrix[2][1] * fArray[1][1] + this.matrix[2][2] * fArray[2][1];
        fArray2[2][2] = this.matrix[2][0] * fArray[0][2] + this.matrix[2][1] * fArray[1][2] + this.matrix[2][2] * fArray[2][2];
        this.matrix[0][0] = fArray2[0][0];
        this.matrix[0][1] = fArray2[0][1];
        this.matrix[0][2] = fArray2[0][2];
        this.matrix[1][0] = fArray2[1][0];
        this.matrix[1][1] = fArray2[1][1];
        this.matrix[1][2] = fArray2[1][2];
        this.matrix[2][0] = fArray2[2][0];
        this.matrix[2][1] = fArray2[2][1];
        this.matrix[2][2] = fArray2[2][2];
    }
}

