/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSDefineMovieClip
extends FSDefineObject {
    private ArrayList objects = null;

    public FSDefineMovieClip(FSCoder fSCoder) {
        super(39, 0);
        this.decode(fSCoder);
    }

    public FSDefineMovieClip(int n) {
        super(39, n);
        this.setObjects(new ArrayList());
    }

    public FSDefineMovieClip(int n, ArrayList arrayList) {
        super(39, n);
        this.setObjects(arrayList);
    }

    public FSDefineMovieClip(FSDefineMovieClip fSDefineMovieClip) {
        super(fSDefineMovieClip);
        this.objects = new ArrayList();
        Iterator iterator = fSDefineMovieClip.objects.iterator();
        while (iterator.hasNext()) {
            this.objects.add(((FSMovieObject)iterator.next()).clone());
        }
    }

    public void add(FSMovieObject fSMovieObject) {
        this.objects.add(fSMovieObject);
    }

    public ArrayList getObjects() {
        return this.objects;
    }

    public void setObjects(ArrayList arrayList) {
        this.objects = arrayList;
    }

    public int getFrameCount() {
        return this.numberOfFrames();
    }

    public Object clone() {
        FSDefineMovieClip fSDefineMovieClip = (FSDefineMovieClip)super.clone();
        fSDefineMovieClip.objects = new ArrayList();
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            fSDefineMovieClip.objects.add(((FSMovieObject)iterator.next()).clone());
        }
        return fSDefineMovieClip;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSDefineMovieClip fSDefineMovieClip = (FSDefineMovieClip)object;
            bl = this.objects != null ? this.objects.equals(fSDefineMovieClip.objects) : this.objects == fSDefineMovieClip.objects;
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "objects", this.objects, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 4;
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            FSMovieObject fSMovieObject = (FSMovieObject)iterator.next();
            int n = fSMovieObject.length(fSCoder);
            this.length += fSMovieObject.getExtendLength() || n >= 63 ? n + 6 : n + 2;
        }
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeWord(this.numberOfFrames(), 2);
        FSMovie.encodeObjects(fSCoder, this.objects);
        fSCoder.writeWord(0, 2);
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        super.decode(fSCoder);
        fSCoder.readWord(2, false);
        this.objects = new ArrayList();
        FSMovieObject fSMovieObject = null;
        while ((fSMovieObject = FSMovie.decodeObject(fSCoder)) != null) {
            this.objects.add(fSMovieObject);
        }
        fSCoder.endObject(this.name());
    }

    private int numberOfFrames() {
        int n = 0;
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            FSMovieObject fSMovieObject = (FSMovieObject)iterator.next();
            if (fSMovieObject.getType() != 1) continue;
            ++n;
        }
        return n;
    }
}

