/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSColorTransform;
import com.flagstone.transform.FSCoordTransform;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.Transform;

public class FSPlaceObject
extends FSMovieObject {
    private int identifier = 0;
    private int layer = 0;
    private FSCoordTransform transform = null;
    private FSColorTransform colorTransform = null;

    public FSPlaceObject(FSCoder fSCoder) {
        super(4);
        this.decode(fSCoder);
    }

    public FSPlaceObject(int n, int n2, int n3, int n4) {
        super(4);
        this.setIdentifier(n);
        this.setLayer(n2);
        this.setTransform(new FSCoordTransform(n3, n4));
    }

    public FSPlaceObject(int n, int n2, FSCoordTransform fSCoordTransform) {
        super(4);
        this.setIdentifier(n);
        this.setLayer(n2);
        this.setTransform(fSCoordTransform);
    }

    public FSPlaceObject(int n, int n2, FSCoordTransform fSCoordTransform, FSColorTransform fSColorTransform) {
        super(4);
        this.setIdentifier(n);
        this.setLayer(n2);
        this.setTransform(fSCoordTransform);
        this.setColorTransform(fSColorTransform);
    }

    public FSPlaceObject(FSPlaceObject fSPlaceObject) {
        super(fSPlaceObject);
        this.identifier = fSPlaceObject.identifier;
        this.layer = fSPlaceObject.layer;
        this.transform = new FSCoordTransform(fSPlaceObject.transform);
        if (fSPlaceObject.colorTransform != null) {
            this.colorTransform = new FSColorTransform(fSPlaceObject.colorTransform);
        }
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public int getLayer() {
        return this.layer;
    }

    public FSCoordTransform getTransform() {
        return this.transform;
    }

    public FSColorTransform getColorTransform() {
        return this.colorTransform;
    }

    public void setIdentifier(int n) {
        this.identifier = n;
    }

    public void setLayer(int n) {
        this.layer = n;
    }

    public void setTransform(FSCoordTransform fSCoordTransform) {
        this.transform = fSCoordTransform;
    }

    public void setColorTransform(FSColorTransform fSColorTransform) {
        this.colorTransform = fSColorTransform;
    }

    public Object clone() {
        FSPlaceObject fSPlaceObject = (FSPlaceObject)super.clone();
        fSPlaceObject.transform = this.transform != null ? (FSCoordTransform)this.transform.clone() : null;
        fSPlaceObject.colorTransform = this.colorTransform != null ? (FSColorTransform)this.colorTransform.clone() : null;
        return fSPlaceObject;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSPlaceObject fSPlaceObject = (FSPlaceObject)object;
            bl = this.identifier == fSPlaceObject.identifier;
            boolean bl2 = bl = bl && this.layer == fSPlaceObject.layer;
            if (this.transform != null) {
                bl = bl && this.transform.equals(fSPlaceObject.transform);
            } else {
                boolean bl3 = bl = bl && this.transform == fSPlaceObject.transform;
            }
            bl = this.colorTransform == null ? bl && fSPlaceObject.getColorTransform() == null : bl && this.colorTransform.equals(fSPlaceObject.colorTransform);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "identifier", this.identifier);
            Transform.append(stringBuffer, "layer", this.layer);
            Transform.append(stringBuffer, "transform", this.transform, n);
            Transform.append(stringBuffer, "colorTransform", this.colorTransform, n);
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        super.length(fSCoder);
        this.length += 4;
        this.length += this.transform.length(fSCoder);
        this.length += this.colorTransform != null ? this.colorTransform.length(fSCoder) : 0;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        super.encode(fSCoder);
        fSCoder.writeWord(this.identifier, 2);
        fSCoder.writeWord(this.layer, 2);
        this.transform.encode(fSCoder);
        if (this.colorTransform != null) {
            this.colorTransform.encode(fSCoder);
        }
        fSCoder.endObject(this.name());
    }

    public void decode(FSCoder fSCoder) {
        int n = fSCoder.getPointer();
        super.decode(fSCoder);
        this.identifier = fSCoder.readWord(2, false);
        this.layer = fSCoder.readWord(2, false);
        this.transform = new FSCoordTransform(fSCoder);
        n = fSCoder.getPointer() - n >> 3;
        if (this.length > n) {
            this.colorTransform = new FSColorTransform(fSCoder);
        }
        fSCoder.endObject(this.name());
    }
}

