/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util;

import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSCurve;
import com.flagstone.transform.FSDefineShape2;
import com.flagstone.transform.FSDefineShape3;
import com.flagstone.transform.FSFillStyle;
import com.flagstone.transform.FSLine;
import com.flagstone.transform.FSLineStyle;
import com.flagstone.transform.FSShape;
import com.flagstone.transform.FSShapeStyle;
import com.flagstone.transform.FSSolidLine;
import java.util.ArrayList;

public class FSShapeConstructor {
    private double flattenLimit = 0.25;
    public boolean COORDINATES_ARE_PIXELS = false;
    private double[] Px = new double[4];
    private double[] Py = new double[4];
    private boolean pathInProgress = false;
    private int initialX = 0;
    private int initialY = 0;
    private int currentX = 0;
    private int currentY = 0;
    private int controlX = 0;
    private int controlY = 0;
    private int minX = 0;
    private int minY = 0;
    private int maxX = 0;
    private int maxY = 0;
    private int lineWidth = 0;
    ArrayList objects = new ArrayList();
    ArrayList lineStyles = new ArrayList();
    ArrayList fillStyles = new ArrayList();

    public void set(int n, FSLineStyle fSLineStyle) {
        this.lineStyles.set(n, fSLineStyle);
    }

    public void add(FSLineStyle fSLineStyle) {
        this.lineStyles.add(fSLineStyle);
    }

    public void set(int n, FSFillStyle fSFillStyle) {
        this.fillStyles.set(n, fSFillStyle);
    }

    public void add(FSFillStyle fSFillStyle) {
        this.fillStyles.add(fSFillStyle);
    }

    public ArrayList getLineStyles() {
        return this.lineStyles;
    }

    public void setLineStyles(ArrayList arrayList) {
        this.lineStyles = arrayList;
    }

    public ArrayList getFillStyles() {
        return this.fillStyles;
    }

    public void setFillStyles(ArrayList arrayList) {
        this.fillStyles = arrayList;
    }

    public void selectLineStyle(int n) {
        this.lineWidth = ((FSSolidLine)this.lineStyles.get(n)).getWidth();
        this.objects.add(new FSShapeStyle(n + 1, Integer.MIN_VALUE, Integer.MIN_VALUE));
    }

    public void selectFillStyle(int n) {
        this.objects.add(new FSShapeStyle(Integer.MIN_VALUE, n + 1, Integer.MIN_VALUE));
    }

    public void selectAltStyle(int n) {
        this.objects.add(new FSShapeStyle(Integer.MIN_VALUE, Integer.MIN_VALUE, n + 1));
    }

    public void selectStyle(int n, int n2) {
        this.lineWidth = ((FSSolidLine)this.lineStyles.get(n)).getWidth();
        this.objects.add(new FSShapeStyle(n + 1, n2 + 1, Integer.MIN_VALUE));
    }

    public void selectStyle(int n, int n2, int n3) {
        this.lineWidth = ((FSSolidLine)this.lineStyles.get(n)).getWidth();
        this.objects.add(new FSShapeStyle(n + 1, n2 + 1, n3 + 1));
    }

    public FSBounds bounds() {
        return new FSBounds(this.minX, this.minY, this.maxX, this.maxY);
    }

    public FSShape shape() {
        return new FSShape((ArrayList)this.objects.clone());
    }

    public FSDefineShape2 defineShape(int n) {
        return new FSDefineShape2(n, this.bounds(), (ArrayList)this.fillStyles.clone(), (ArrayList)this.lineStyles.clone(), new FSShape((ArrayList)this.objects.clone()));
    }

    public FSDefineShape3 defineTransparentShape(int n) {
        return new FSDefineShape3(n, this.bounds(), (ArrayList)this.fillStyles.clone(), (ArrayList)this.lineStyles.clone(), new FSShape((ArrayList)this.objects.clone()));
    }

    public void newPath() {
        this.pathInProgress = false;
        this.setInitial(0, 0);
        this.setCurrent(0, 0);
        this.setControl(0, 0);
        this.setBounds(0, 0, 0, 0);
        this.objects.clear();
        this.lineWidth = 0;
    }

    public void closePath() {
        int n = this.initialX - this.currentX;
        int n2 = this.initialY - this.currentY;
        if (n != 0 || n2 != 0) {
            this.objects.add(new FSLine(n, n2));
        }
        this.setCurrent(this.initialX, this.initialY);
        this.pathInProgress = false;
    }

    public void move(int n, int n2) {
        n = this.COORDINATES_ARE_PIXELS ? n * 20 : n;
        n2 = this.COORDINATES_ARE_PIXELS ? n2 * 20 : n2;
        this.objects.add(new FSShapeStyle(n, n2));
        this.setControl((this.currentX + n) / 2, (this.currentY + n2) / 2);
        this.setCurrent(n, n2);
        this.setInitial(n, n2);
    }

    void moveForFont(int n, int n2) {
        n = this.COORDINATES_ARE_PIXELS ? n * 20 : n;
        n2 = this.COORDINATES_ARE_PIXELS ? n2 * 20 : n2;
        this.objects.add(new FSShapeStyle(1, Integer.MIN_VALUE, 1, n, n2));
        this.setControl((this.currentX + n) / 2, (this.currentY + n2) / 2);
        this.setCurrent(n, n2);
        this.setInitial(n, n2);
    }

    public void rmove(int n, int n2) {
        n = this.COORDINATES_ARE_PIXELS ? n * 20 : n;
        n2 = this.COORDINATES_ARE_PIXELS ? n2 * 20 : n2;
        this.objects.add(new FSShapeStyle(n + this.currentX, n2 + this.currentY));
        this.setControl(this.currentX + n / 2, this.currentY + n2 / 2);
        this.setCurrent(this.currentX + n, this.currentY + n2);
    }

    public void line(int n, int n2) {
        n = (this.COORDINATES_ARE_PIXELS ? n * 20 : n) - this.currentX;
        n2 = (this.COORDINATES_ARE_PIXELS ? n2 * 20 : n2) - this.currentY;
        this.objects.add(new FSLine(n, n2));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(this.currentX + n / 2, this.currentY + n2 / 2);
        this.setCurrent(this.currentX + n, this.currentY + n2);
    }

    public void rline(int n, int n2) {
        n = this.COORDINATES_ARE_PIXELS ? n * 20 : n;
        n2 = this.COORDINATES_ARE_PIXELS ? n2 * 20 : n2;
        this.objects.add(new FSLine(n, n2));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(this.currentX + n / 2, this.currentY + n2 / 2);
        this.setCurrent(this.currentX + n, this.currentY + n2);
    }

    public void curve(int n, int n2, int n3, int n4) {
        n = (this.COORDINATES_ARE_PIXELS ? n * 20 : n) - this.currentX;
        n2 = (this.COORDINATES_ARE_PIXELS ? n2 * 20 : n2) - this.currentY;
        n3 = (this.COORDINATES_ARE_PIXELS ? n3 * 20 : n3) - this.currentX - n;
        n4 = (this.COORDINATES_ARE_PIXELS ? n4 * 20 : n4) - this.currentY - n2;
        this.objects.add(new FSCurve(n, n2, n3, n4));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(this.currentX + n, this.currentY + n2);
        this.setCurrent(this.currentX + n + n3, this.currentY + n2 + n4);
    }

    public void rcurve(int n, int n2, int n3, int n4) {
        n = this.COORDINATES_ARE_PIXELS ? n * 20 : n;
        n2 = this.COORDINATES_ARE_PIXELS ? n2 * 20 : n2;
        n3 = this.COORDINATES_ARE_PIXELS ? n3 * 20 : n3;
        n4 = this.COORDINATES_ARE_PIXELS ? n4 * 20 : n4;
        this.objects.add(new FSCurve(n, n2, n3, n4));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(this.currentX + n, this.currentY + n2);
        this.setCurrent(this.currentX + n + n3, this.currentY + n2 + n4);
    }

    public void curve(int n, int n2, int n3, int n4, int n5, int n6) {
        this.Px[0] = this.currentX;
        this.Py[0] = this.currentY;
        this.Px[1] = this.COORDINATES_ARE_PIXELS ? (double)(n * 20) : (double)n;
        this.Py[1] = this.COORDINATES_ARE_PIXELS ? (double)(n2 * 20) : (double)n2;
        this.Px[2] = this.COORDINATES_ARE_PIXELS ? (double)(n3 * 20) : (double)n3;
        this.Py[2] = this.COORDINATES_ARE_PIXELS ? (double)(n4 * 20) : (double)n4;
        this.Px[3] = this.COORDINATES_ARE_PIXELS ? (double)(n5 * 20) : (double)n5;
        this.Py[3] = this.COORDINATES_ARE_PIXELS ? (double)(n6 * 20) : (double)n6;
        this.flatten();
    }

    public void rcurve(int n, int n2, int n3, int n4, int n5, int n6) {
        this.Px[0] = this.currentX;
        this.Py[0] = this.currentY;
        this.Px[1] = this.currentX + (this.COORDINATES_ARE_PIXELS ? n * 20 : n);
        this.Py[1] = this.currentY + (this.COORDINATES_ARE_PIXELS ? n2 * 20 : n2);
        this.Px[2] = this.currentX + (this.COORDINATES_ARE_PIXELS ? n3 * 20 : n3);
        this.Py[2] = this.currentY + (this.COORDINATES_ARE_PIXELS ? n4 * 20 : n4);
        this.Px[3] = this.currentX + (this.COORDINATES_ARE_PIXELS ? n5 * 20 : n5);
        this.Py[3] = this.currentY + (this.COORDINATES_ARE_PIXELS ? n6 * 20 : n6);
        this.flatten();
    }

    public void reflect(int n, int n2) {
        int n3 = this.currentX - this.controlX;
        int n4 = this.currentY - this.controlY;
        n = (this.COORDINATES_ARE_PIXELS ? n * 20 : n) - this.currentX;
        n2 = (this.COORDINATES_ARE_PIXELS ? n2 * 20 : n2) - this.currentY;
        this.objects.add(new FSCurve(n3, n4, n, n2));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(n3 + this.currentX, n4 + this.currentY);
        this.setCurrent(n + this.currentX, n2 + this.currentY);
    }

    public void rreflect(int n, int n2) {
        int n3 = this.currentX - this.controlX;
        int n4 = this.currentY - this.controlY;
        n = this.COORDINATES_ARE_PIXELS ? n * 20 : n;
        n2 = this.COORDINATES_ARE_PIXELS ? n2 * 20 : n2;
        this.objects.add(new FSCurve(n3, n4, n, n2));
        if (!this.pathInProgress) {
            this.setInitial(this.currentX, this.currentY);
            this.pathInProgress = true;
        }
        this.setControl(n3 + this.currentX, n4 + this.currentY);
        this.setCurrent(n + this.currentX, n2 + this.currentY);
    }

    public void reflect(int n, int n2, int n3, int n4) {
        int n5 = this.currentX - this.controlX;
        int n6 = this.currentY - this.controlY;
        n = (this.COORDINATES_ARE_PIXELS ? n * 20 : n) - this.currentX;
        n2 = (this.COORDINATES_ARE_PIXELS ? n2 * 20 : n2) - this.currentY;
        n3 = (this.COORDINATES_ARE_PIXELS ? n3 * 20 : n3) - this.currentX;
        n4 = (this.COORDINATES_ARE_PIXELS ? n4 * 20 : n4) - this.currentY;
        this.rcurve(n5, n6, n, n2, n3, n4);
    }

    public void rreflect(int n, int n2, int n3, int n4) {
        int n5 = this.currentX - this.controlX;
        int n6 = this.currentY - this.controlY;
        n = this.COORDINATES_ARE_PIXELS ? n * 20 : n;
        n2 = this.COORDINATES_ARE_PIXELS ? n2 * 20 : n2;
        n3 = this.COORDINATES_ARE_PIXELS ? n3 * 20 : n3;
        n4 = this.COORDINATES_ARE_PIXELS ? n4 * 20 : n4;
        this.rcurve(n5, n6, n, n2, n3, n4);
    }

    public void rect(int n, int n2, int n3, int n4) {
        this.newPath();
        this.selectStyle(0, 0);
        this.move(n - n3 / 2, n2 - n4 / 2);
        this.rline(n3, 0);
        this.rline(0, n4);
        this.rline(-n3, 0);
        this.rline(0, -n4);
        this.closePath();
    }

    public void rect(int n, int n2) {
        this.rect(0, 0, n, n2);
    }

    public void rect(int n, int n2, int n3, int n4, int n5) {
        int n6;
        int n7 = n6 = n4 < n3 ? n4 : n3;
        if (n5 > n6 / 2) {
            n5 = n6 / 2;
        }
        this.newPath();
        this.selectStyle(0, 0);
        this.move(n, n2 - n4 / 2);
        this.rline(n3 / 2 - n5, 0);
        this.rcurve(n5, 0, 0, n5);
        this.rline(0, n4 - 2 * n5);
        this.rcurve(0, n5, -n5, 0);
        this.rline(-(n3 - 2 * n5), 0);
        this.rcurve(-n5, 0, 0, -n5);
        this.rline(0, -(n4 - 2 * n5));
        this.rcurve(0, -n5, n5, 0);
        this.closePath();
    }

    public void rect(int n, int n2, int n3) {
        this.rect(0, 0, n, n2, n3);
    }

    public void ellipse(int n, int n2, int n3, int n4) {
        boolean bl = false;
        if (this.COORDINATES_ARE_PIXELS) {
            this.COORDINATES_ARE_PIXELS = false;
            bl = true;
            n *= 20;
            n2 *= 20;
            n3 *= 20;
            n4 *= 20;
        }
        int n5 = (int)(0.707 * (double)n3) + n;
        int n6 = (int)(0.707 * (double)n4) + n2;
        int n7 = (int)(0.293 * (double)n3);
        int n8 = (int)(0.293 * (double)n4);
        int n9 = (int)(0.414 * (double)n3);
        int n10 = (int)(0.414 * (double)n4);
        this.newPath();
        this.selectStyle(0, 0);
        this.move(n5, n6);
        this.rcurve(-n7, n8, -n9, 0);
        this.rcurve(-n9, 0, -n7, -n8);
        this.rcurve(-n7, -n8, 0, -n10);
        this.rcurve(0, -n10, n7, -n8);
        this.rcurve(n7, -n8, n9, 0);
        this.rcurve(n9, 0, n7, n8);
        this.rcurve(n7, n8, 0, n10);
        this.rcurve(0, n10, -n7, n8);
        this.closePath();
        if (bl) {
            this.COORDINATES_ARE_PIXELS = true;
        }
    }

    public void ellipse(int n, int n2) {
        this.ellipse(0, 0, n, n2);
    }

    public void circle(int n, int n2, int n3) {
        this.ellipse(n, n2, n3, n3);
    }

    public void circle(int n) {
        this.ellipse(0, 0, n, n);
    }

    public void polygon(int[] nArray) {
        int n = nArray.length;
        if (n % 2 == 1) {
            --n;
        }
        this.rmove(nArray[0], nArray[1]);
        for (int i = 2; i < n; i += 2) {
            this.rline(nArray[i], nArray[i + 1]);
        }
        this.closePath();
    }

    private void setInitial(int n, int n2) {
        this.initialX = n;
        this.initialY = n2;
    }

    private void setCurrent(int n, int n2) {
        this.currentX = n;
        this.currentY = n2;
        if (n - this.lineWidth / 2 < this.minX) {
            this.minX = n - this.lineWidth / 2;
        }
        if (n2 - this.lineWidth / 2 < this.minY) {
            this.minY = n2 - this.lineWidth / 2;
        }
        if (n + this.lineWidth / 2 > this.maxX) {
            this.maxX = n + this.lineWidth / 2;
        }
        if (n2 + this.lineWidth / 2 > this.maxY) {
            this.maxY = n2 + this.lineWidth / 2;
        }
    }

    private void setControl(int n, int n2) {
        this.controlX = n;
        this.controlY = n2;
        if (n - this.lineWidth / 2 < this.minX) {
            this.minX = n - this.lineWidth / 2;
        }
        if (n2 - this.lineWidth / 2 < this.minY) {
            this.minY = n2 - this.lineWidth / 2;
        }
        if (n + this.lineWidth / 2 > this.maxX) {
            this.maxX = n + this.lineWidth / 2;
        }
        if (n2 + this.lineWidth / 2 > this.maxY) {
            this.maxY = n2 + this.lineWidth / 2;
        }
    }

    private void setBounds(int n, int n2, int n3, int n4) {
        this.minX = n;
        this.minY = n2;
        this.maxX = n3;
        this.maxY = n4;
    }

    private void flatten() {
        double[] dArray = new double[]{0.0, 0.0, 0.0, 0.0};
        double[] dArray2 = new double[]{0.0, 0.0, 0.0, 0.0};
        while (true) {
            double d = 2.0 * this.Px[0] + this.Px[3] - 3.0 * this.Px[1];
            d *= d;
            double d2 = 2.0 * this.Px[3] + this.Px[0] - 3.0 * this.Px[2];
            if (d < (d2 *= d2)) {
                d = d2;
            }
            double d3 = 2.0 * this.Py[0] + this.Py[3] - 3.0 * this.Py[1];
            d3 *= d3;
            double d4 = 2.0 * this.Py[3] + this.Py[0] - 3.0 * this.Py[2];
            if (d3 < (d4 *= d4)) {
                d3 = d4;
            }
            if (d + d3 < this.flattenLimit) break;
            dArray[3] = this.Px[3];
            double d5 = (this.Px[1] + this.Px[2]) / 2.0;
            this.Px[1] = (this.Px[0] + this.Px[1]) / 2.0;
            dArray[2] = (this.Px[2] + this.Px[3]) / 2.0;
            this.Px[2] = (this.Px[1] + d5) / 2.0;
            dArray[1] = (d5 + dArray[2]) / 2.0;
            this.Px[3] = dArray[0] = (this.Px[2] + dArray[1]) / 2.0;
            dArray2[3] = this.Py[3];
            d5 = (this.Py[1] + this.Py[2]) / 2.0;
            this.Py[1] = (this.Py[0] + this.Py[1]) / 2.0;
            dArray2[2] = (this.Py[2] + this.Py[3]) / 2.0;
            this.Py[2] = (this.Py[1] + d5) / 2.0;
            dArray2[1] = (d5 + dArray2[2]) / 2.0;
            this.Py[3] = dArray2[0] = (this.Py[2] + dArray2[1]) / 2.0;
            this.flatten();
            this.Px[0] = dArray[0];
            this.Py[0] = dArray2[0];
            this.Px[1] = dArray[1];
            this.Py[1] = dArray2[1];
            this.Px[2] = dArray[2];
            this.Py[2] = dArray2[2];
            this.Px[3] = dArray[3];
            this.Py[3] = dArray2[3];
        }
        this.objects.add(new FSLine((int)this.Px[3] - this.currentX, (int)this.Py[3] - this.currentY));
        this.setControl((int)this.Px[1], (int)this.Py[1]);
        this.setControl((int)this.Px[2], (int)this.Py[2]);
        this.setCurrent((int)this.Px[3], (int)this.Py[3]);
    }
}

