/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.rs.config;

import cn.bluejoe.elfinder.controller.executor.CommandExecutor;
import cn.bluejoe.elfinder.controller.executor.DefaultCommandExecutorFactory;
import cn.bluejoe.elfinder.impl.DefaultFsService;
import cn.bluejoe.elfinder.impl.DefaultFsServiceConfig;
import cn.bluejoe.elfinder.impl.FsSecurityCheckFilterMapping;
import cn.bluejoe.elfinder.impl.FsSecurityCheckForAll;
import cn.bluejoe.elfinder.impl.FsSecurityCheckerChain;
import cn.bluejoe.elfinder.impl.StaticFsServiceFactory;
import cn.bluejoe.elfinder.localfs.LocalFsVolume;
import cn.bluejoe.elfinder.service.FsVolume;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.web.servlet.config.annotation.DefaultServletHandlerConfigurer;
import org.springframework.web.servlet.config.annotation.EnableWebMvc;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;
import org.springframework.web.servlet.view.UrlBasedViewResolver;

@Configuration
@EnableWebMvc
@ComponentScan(basePackages={"cz.rtnext.rs.web", "cn.bluejoe.elfinder.controller", "cz.rtnext.smartclient.mvc"})
public class SpringWebConfig
extends WebMvcConfigurerAdapter {
    @Autowired
    private ServletContext servletContext;

    @Bean
    public UrlBasedViewResolver internalResourceViewResolver() {
        InternalResourceViewResolver internalResourceViewResolver = new InternalResourceViewResolver();
        internalResourceViewResolver.setViewClass(JstlView.class);
        internalResourceViewResolver.setPrefix("/WEB-INF/jsp/");
        internalResourceViewResolver.setSuffix(".jsp");
        return internalResourceViewResolver;
    }

    public void configureDefaultServletHandling(DefaultServletHandlerConfigurer configurer) {
        configurer.enable();
    }

    @Bean
    public DefaultCommandExecutorFactory commandExecutorFactory() {
        DefaultCommandExecutorFactory commandExecutorFactory = new DefaultCommandExecutorFactory();
        commandExecutorFactory.setClassNamePattern("cn.bluejoe.elfinder.controller.executors.%sCommandExecutor");
        commandExecutorFactory.setMap(new HashMap<String, CommandExecutor>());
        return commandExecutorFactory;
    }

    @Bean
    public StaticFsServiceFactory fsServiceFactory() {
        LocalFsVolume volume = new LocalFsVolume();
        volume.setName("dbimg");
        File file = new File(this.servletContext.getRealPath("/dbimg"));
        volume.setRootDir(file);
        FsSecurityCheckForAll fsSecurityCheckForAll = new FsSecurityCheckForAll();
        fsSecurityCheckForAll.setReadable(true);
        fsSecurityCheckForAll.setWritable(true);
        FsSecurityCheckFilterMapping secMapping = new FsSecurityCheckFilterMapping();
        secMapping.setPattern(".*");
        secMapping.setChecker(fsSecurityCheckForAll);
        ArrayList<FsSecurityCheckFilterMapping> filterMappings = new ArrayList<FsSecurityCheckFilterMapping>();
        filterMappings.add(secMapping);
        FsSecurityCheckerChain securityChecker = new FsSecurityCheckerChain();
        securityChecker.setFilterMappings(filterMappings);
        DefaultFsServiceConfig serviceConfig = new DefaultFsServiceConfig();
        serviceConfig.setTmbWidth(80);
        DefaultFsService fsService = new DefaultFsService();
        fsService.setServiceConfig(serviceConfig);
        fsService.setVolumes(new FsVolume[]{volume});
        fsService.setSecurityChecker(securityChecker);
        StaticFsServiceFactory fsServiceFactory = new StaticFsServiceFactory();
        fsServiceFactory.setFsService(fsService);
        return fsServiceFactory;
    }

    @Scheduled(fixedDelay=5000L)
    public void doSomething() {
        System.out.println("siofhdioh");
    }
}

