/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.Fotogalerie;
import cz.triangle.domy.Jazyk;
import cz.triangle.domy.Obrazek;
import cz.triangle.domy.ObrazekJaz;
import cz.triangle.domy.SkupinaFotogalerie;
import cz.triangle.domy.form.AdminObrazekForm;
import cz.triangle.domy.www.LokalitaDelegate;
import cz.triangle.util.ConvertService;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class ObrazekDelegate
implements Serializable {
    private MessageResources res;
    private String localeId;
    private final int nahledx = 100;
    private final int nahledy = 100;

    public ObrazekDelegate(MessageResources res, String localeId, Session hsess) {
        this.res = res;
        Jazyk jazyk = (Jazyk)hsess.load(Jazyk.class, (Serializable)((Object)localeId));
        this.localeId = localeId;
    }

    public Map novaPolozka(AdminObrazekForm f, String id, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            AdminObrazekForm form = f;
            if (form == null) {
                form = new AdminObrazekForm();
                form.setSkupinaFotogalerieId(id);
                List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
                for (Jazyk jazyk : jazyky) {
                    form.setPopis(jazyk.getId(), "");
                }
            }
            vysledek.put("adminObrazekForm", (Object)form);
            vysledek.put("seznamSkupinFotogalerii", this.getSeznamSkupinFotogalerii(id, hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, AdminObrazekForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Obrazek polozka = (Obrazek)hsess.load(Obrazek.class, (Serializable)new Integer(id));
            AdminObrazekForm form = f;
            if (form == null) {
                form = new AdminObrazekForm();
                ConvertService.registrujCeske();
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                form.setObrazekNazev(polozka.getNazev());
                ConvertService.odregistrujCeske();
                List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
                for (Jazyk jazyk : jazyky) {
                    ObrazekJaz obrazekJaz = (ObrazekJaz)polozka.getObrazekJazs().get(jazyk.getId());
                    if (obrazekJaz != null) {
                        form.setPopis(jazyk.getId(), obrazekJaz.getPopis());
                        continue;
                    }
                    form.setPopis(jazyk.getId(), "");
                }
                form.setSkupinaFotogalerieId(polozka.getSkupinaFotogalerie().getId().toString());
            }
            vysledek.put("id", polozka.getId());
            vysledek.put("adminObrazekForm", (Object)form);
            vysledek.put("seznamSkupinFotogalerii", this.getSeznamSkupinFotogalerii(polozka.getSkupinaFotogalerie().getId().toString(), hsess));
            vysledek.put("seznamObrazku", this.getSeznamObrazku(polozka.getSkupinaFotogalerie().getId(), hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return this.res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(AdminObrazekForm form, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminObrazekForm", (Object)form);
                return vysledek;
            }
            Obrazek novaPolozka = new Obrazek();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)novaPolozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            vysledek.put("adminObrazekForm", (Object)form);
            SkupinaFotogalerie skupinaFotogalerie = (SkupinaFotogalerie)hsess.load(SkupinaFotogalerie.class, (Serializable)new Integer(form.getSkupinaFotogalerieId()));
            novaPolozka.setSkupinaFotogalerie(skupinaFotogalerie);
            hsess.save((Object)novaPolozka);
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                String nazev = (String)form.getPopis(jazyk.getId());
                ObrazekJaz obrazekJaz = new ObrazekJaz();
                obrazekJaz.setJazyk(jazyk);
                novaPolozka.getObrazekJazs().put(jazyk.getId(), obrazekJaz);
                obrazekJaz.setObrazek(novaPolozka);
                if (nazev != null) {
                    obrazekJaz.setPopis(nazev);
                } else {
                    obrazekJaz.setPopis("");
                }
                hsess.save((Object)obrazekJaz);
            }
            long privesek = Math.round(Math.random() * 1000.0);
            FormFile file = form.getObrazekFile();
            if (file != null && file.getFileName().length() > 0) {
                String watermark = null;
                watermark = this.res.getMessage("watermark");
                String nazevSouboru = this.ulozSoubor(cesta, privesek, file, "obr", novaPolozka.getId().toString());
                novaPolozka.setNazev(nazevSouboru);
                Fotogalerie fotogalerie = novaPolozka.getSkupinaFotogalerie().getFotogalerie();
                String cestaCelkem = String.valueOf(ObrazekDelegate.getCestaObrazek(cesta)) + File.separator;
                int[] info = cz.triangle.util.Obrazek.resize5(String.valueOf(cestaCelkem) + nazevSouboru, String.valueOf(cestaCelkem) + "m" + nazevSouboru, fotogalerie.getX1(), fotogalerie.getY1(), "both", 80);
                if (watermark != null && watermark.trim().length() > 0) {
                    String celaCesta = String.valueOf(ObrazekDelegate.getCestaObrazek(cesta)) + File.separator + nazevSouboru;
                    cz.triangle.util.Obrazek.addImageWatermark(String.valueOf(cesta) + "dbimg" + File.separator + watermark, String.valueOf(cestaCelkem) + "m" + nazevSouboru, String.valueOf(cestaCelkem) + "m" + nazevSouboru);
                    cz.triangle.util.Obrazek.addImageWatermark(String.valueOf(cesta) + "dbimg" + File.separator + watermark, celaCesta, celaCesta);
                }
                novaPolozka.setX1(info[0]);
                novaPolozka.setY1(info[1]);
                info = cz.triangle.util.Obrazek.resize5(String.valueOf(cestaCelkem) + "m" + nazevSouboru, String.valueOf(cestaCelkem) + "mm" + nazevSouboru, fotogalerie.getX2(), fotogalerie.getY2(), "both", 80);
                novaPolozka.setX2(info[0]);
                novaPolozka.setY2(info[1]);
                info = cz.triangle.util.Obrazek.resize5(String.valueOf(cestaCelkem) + "mm" + nazevSouboru, String.valueOf(cestaCelkem) + "t" + nazevSouboru, 100, 100, "both", 80);
            }
            vysledek.put("id", novaPolozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map zapsatPolozku(AdminObrazekForm form, String id, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminObrazekForm", (Object)form);
                return vysledek;
            }
            Obrazek polozka = (Obrazek)hsess.load(Obrazek.class, (Serializable)new Integer(id));
            ConvertService.registrujCeske();
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                String nazev;
                ObrazekJaz obrazekJaz = (ObrazekJaz)polozka.getObrazekJazs().get(jazyk.getId());
                if (obrazekJaz == null) {
                    obrazekJaz = new ObrazekJaz();
                    obrazekJaz.setJazyk(jazyk);
                    obrazekJaz.setObrazek(polozka);
                    hsess.save((Object)obrazekJaz);
                }
                if ((nazev = (String)form.getPopis(jazyk.getId())) != null) {
                    obrazekJaz.setPopis(nazev);
                } else {
                    obrazekJaz.setPopis("");
                }
                hsess.save((Object)obrazekJaz);
            }
            BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            SkupinaFotogalerie staraSkupinaFotogalerie = polozka.getSkupinaFotogalerie();
            SkupinaFotogalerie skupinaFotogalerie = (SkupinaFotogalerie)hsess.load(SkupinaFotogalerie.class, (Serializable)new Integer(form.getSkupinaFotogalerieId()));
            polozka.setSkupinaFotogalerie(skupinaFotogalerie);
            long privesek = Math.round(Math.random() * 1000.0);
            FormFile file = form.getObrazekFile();
            if (file != null && file.getFileName().length() > 0) {
                String cestaCelkem = String.valueOf(ObrazekDelegate.getCestaObrazek(cesta)) + File.separator;
                if (polozka.getNazev() != null && polozka.getNazev().length() > 0) {
                    ObrazekDelegate.smazatSoubor(String.valueOf(cestaCelkem) + polozka.getNazev());
                    ObrazekDelegate.smazatSoubor(String.valueOf(cestaCelkem) + "m" + polozka.getNazev());
                    ObrazekDelegate.smazatSoubor(String.valueOf(cestaCelkem) + "mm" + polozka.getNazev());
                }
                String watermark = null;
                watermark = this.res.getMessage("watermark");
                String nazevSouboru = this.ulozSoubor(cesta, privesek, file, "obr", polozka.getId().toString());
                polozka.setNazev(nazevSouboru);
                Fotogalerie fotogalerie = polozka.getSkupinaFotogalerie().getFotogalerie();
                int[] info = cz.triangle.util.Obrazek.resize5(String.valueOf(cestaCelkem) + nazevSouboru, String.valueOf(cestaCelkem) + "m" + nazevSouboru, fotogalerie.getX1(), fotogalerie.getY1(), "both", 90);
                if (watermark != null && watermark.trim().length() > 0) {
                    String celaCesta = String.valueOf(ObrazekDelegate.getCestaObrazek(cesta)) + File.separator + nazevSouboru;
                    cz.triangle.util.Obrazek.addImageWatermark(String.valueOf(cesta) + "dbimg" + File.separator + watermark, String.valueOf(cestaCelkem) + "m" + nazevSouboru, String.valueOf(cestaCelkem) + "m" + nazevSouboru);
                    cz.triangle.util.Obrazek.addImageWatermark(String.valueOf(cesta) + "dbimg" + File.separator + watermark, celaCesta, celaCesta);
                }
                polozka.setX1(info[0]);
                polozka.setY1(info[1]);
                info = cz.triangle.util.Obrazek.resize5(String.valueOf(cestaCelkem) + "m" + nazevSouboru, String.valueOf(cestaCelkem) + "mm" + nazevSouboru, fotogalerie.getX2(), fotogalerie.getY2(), "both", 90);
                polozka.setX2(info[0]);
                polozka.setY2(info[1]);
                info = cz.triangle.util.Obrazek.resize5(String.valueOf(cestaCelkem) + "mm" + nazevSouboru, String.valueOf(cestaCelkem) + "t" + nazevSouboru, 100, 100, "both", 80);
            }
            vysledek.put("adminObrazekForm", (Object)form);
            vysledek.put("id", polozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map smazatPolozku(String id, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            String cestaCelkem = String.valueOf(ObrazekDelegate.getCestaObrazek(cesta)) + File.separator;
            Obrazek staraPolozka = (Obrazek)hsess.load(Obrazek.class, (Serializable)new Integer(id));
            if (staraPolozka.getNazev() != null && staraPolozka.getNazev().length() > 0) {
                ObrazekDelegate.smazatSoubor(String.valueOf(cestaCelkem) + staraPolozka.getNazev());
                ObrazekDelegate.smazatSoubor(String.valueOf(cestaCelkem) + "m" + staraPolozka.getNazev());
                ObrazekDelegate.smazatSoubor(String.valueOf(cestaCelkem) + "mm" + staraPolozka.getNazev());
                ObrazekDelegate.smazatSoubor(String.valueOf(cestaCelkem) + "t" + staraPolozka.getNazev());
            }
            vysledek.put("id", staraPolozka.getSkupinaFotogalerie().getId());
            hsess.delete((Object)staraPolozka);
            hsess.flush();
        }
        catch (HibernateException e) {
            e.printStackTrace();
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public List getSeznamSkupinFotogalerii(String id, Session hsess) {
        SkupinaFotogalerie skupinaFotogalerie = (SkupinaFotogalerie)hsess.load(SkupinaFotogalerie.class, (Serializable)new Integer(id));
        return hsess.createQuery("from SkupinaFotogalerie skupinaFotogalerie where skupinaFotogalerie.fotogalerie = ? order by skupinaFotogalerie.id").setEntity(0, (Object)skupinaFotogalerie.getFotogalerie()).list();
    }

    private List getSeznamObrazku(Integer id, Session hsess) {
        return hsess.createQuery("from Obrazek obrazek where obrazek.skupinaFotogalerie.id = ? order by obrazek.razeni, obrazek.id").setInteger(0, id.intValue()).list();
    }

    public String ulozSoubor(String cesta, long privesek, FormFile file, String prefix, String id) {
        if (file != null && !file.getFileName().equalsIgnoreCase("")) {
            String koncovka = file.getFileName().substring(file.getFileName().lastIndexOf("."));
            String nazevSouboru = String.valueOf(prefix) + "_" + id + "_" + privesek + koncovka;
            LokalitaDelegate.zapisSoubor(file, ObrazekDelegate.getCestaObrazek(cesta), nazevSouboru);
            return nazevSouboru;
        }
        return null;
    }

    public static String getCestaObrazek(String cesta) {
        return String.valueOf(cesta) + "dbimg" + File.separator + "fotogalerie";
    }

    public static boolean smazatSoubor(String soubor) {
        File file = new File(soubor);
        if (file.exists() && file.isFile()) {
            return file.delete();
        }
        return false;
    }

    public void vytvorNahledy(Session hsess, PrintWriter writer, String cesta) {
        List obrazky = hsess.createQuery("from Obrazek").list();
        String cestaCelkem = String.valueOf(cesta) + "dbimg" + File.separator + "fotogalerie" + File.separator;
        for (Obrazek obrazek : obrazky) {
            if (obrazek.getNazev() == null || obrazek.getNazev().length() <= 0) continue;
            try {
                cz.triangle.util.Obrazek.resize5(String.valueOf(cestaCelkem) + "mm" + obrazek.getNazev(), String.valueOf(cestaCelkem) + "t" + obrazek.getNazev(), 100, 100, "both", 90);
                writer.write("Vytvoren nahled pro " + obrazek.getNazev() + "<br>");
            }
            catch (Exception e) {
                writer.write("Nepodarilo se vytvorit nahled pro " + obrazek.getNazev() + ": " + e.getMessage() + "<br>");
                writer.flush();
            }
        }
    }

    public void naplnRazeni(Session hsess, PrintWriter writer) {
        List skupinyFotogalerii = hsess.createQuery("from SkupinaFotogalerie").list();
        for (SkupinaFotogalerie skupina : skupinyFotogalerii) {
            int i = 10;
            for (Obrazek obrazek : skupina.getObrazeks()) {
                obrazek.setRazeni(i);
                writer.write("Ocislovan obrazek " + obrazek.getNazev() + "<br>");
                i += 10;
            }
        }
    }
}

