/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout;

import fr.improve.struts.taglib.layout.BaseHandlerTag;
import fr.improve.struts.taglib.layout.el.Expression;
import fr.improve.struts.taglib.layout.event.EndLayoutEvent;
import fr.improve.struts.taglib.layout.event.LayoutEventListener;
import fr.improve.struts.taglib.layout.event.StartLayoutEvent;
import fr.improve.struts.taglib.layout.policy.AbstractPolicy;
import fr.improve.struts.taglib.layout.skin.Skin;
import fr.improve.struts.taglib.layout.util.FormUtils;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import fr.improve.struts.taglib.layout.util.ParentFinder;
import fr.improve.struts.taglib.layout.util.TagUtils;
import javax.servlet.jsp.JspException;

public abstract class ActionTag
extends BaseHandlerTag
implements LayoutEventListener {
    protected String property;
    protected boolean display = true;
    protected String valign;
    private String mode;
    protected String policy = null;
    protected boolean cell = false;
    protected String jspMode;
    protected boolean jspDisabled;
    protected String jspOnclick;

    public final int doStartTag() throws JspException {
        ParentFinder.registerTag(this.pageContext, this);
        this.initDynamicValues();
        return this.doStartLayoutTag();
    }

    public final int doEndTag() throws JspException {
        try {
            int n = this.doEndLayoutTag();
            return n;
        }
        finally {
            this.reset();
            ParentFinder.deregisterTag(this.pageContext);
        }
    }

    public int doEndLayoutTag() throws JspException {
        if (!this.display) {
            this.display = true;
            return 6;
        }
        if (this.cell) {
            this.cell = false;
            return 6;
        }
        int ret = this.tag.doEndTag();
        StringBuffer lc_buffer = new StringBuffer("");
        this.endActionLayout(lc_buffer);
        new EndLayoutEvent(this, lc_buffer.toString()).send();
        return ret;
    }

    public int doStartLayoutTag() throws JspException {
        if (this.policy != null) {
            Skin lc_currentSkin = LayoutUtils.getSkin(this.getPageContext().getSession());
            AbstractPolicy lc_policy = lc_currentSkin.getPolicy();
            switch (lc_policy.getAuthorizedDisplayMode(this.getPolicy(), this.getReqCode(), this.getProperty(), this.getPageContext())) {
                case 2: {
                    break;
                }
                case 0: {
                    this.display = false;
                    break;
                }
                case 7: {
                    this.display = true;
                    this.setDisabled(true);
                    break;
                }
                case 8: {
                    this.cell = true;
                    break;
                }
                default: {
                    throw new IllegalStateException(String.valueOf(lc_policy.getClass().getName()) + " returns an illegal value");
                }
            }
        }
        if (!this.display) {
            return 0;
        }
        if (this.cell) {
            return this.doCellMode();
        }
        StringBuffer lc_buffer = new StringBuffer("");
        this.beginActionLayout(lc_buffer);
        new StartLayoutEvent(this, lc_buffer.toString()).send();
        this.copyProperties();
        String onclick = null;
        if (this.reqCode != null) {
            onclick = this.getRequestCode();
        }
        if (onclick != null) {
            String previousOnclick = this.getOnclick();
            if (previousOnclick != null) {
                onclick = String.valueOf(onclick) + ";" + previousOnclick;
            }
            this.tag.setOnclick(onclick);
        }
        return this.tag.doStartTag();
    }

    protected int doCellMode() throws JspException {
        new StartLayoutEvent(this, null).send();
        TagUtils.write(this.pageContext, "<th colspan=\"");
        TagUtils.write(this.pageContext, String.valueOf(LayoutUtils.getSkin(this.pageContext.getSession()).getFieldInterface().getColumnNumber()));
        if (this.getStyleClass() != null) {
            TagUtils.write(this.pageContext, "\" class=\"");
            TagUtils.write(this.pageContext, this.getStyleClass());
        }
        TagUtils.write(this.pageContext, "\">&nbsp;</th>");
        new EndLayoutEvent(this, null).send();
        return 0;
    }

    public void setMode(String in_mode) {
        this.mode = in_mode;
    }

    public String getProperty() {
        return this.property;
    }

    protected void initDynamicValues() {
        this.jspMode = this.mode;
        this.mode = Expression.evaluate(this.mode, this.pageContext);
        this.jspDisabled = this.getDisabled();
        if (this.mode != null) {
            int lc_visible = FormUtils.computeVisibilityMode(this.pageContext, this.mode);
            switch (lc_visible) {
                case 2: {
                    this.display = true;
                    break;
                }
                case 0: {
                    this.display = false;
                    break;
                }
                case 7: {
                    this.display = true;
                    this.setDisabled(true);
                    break;
                }
                case 8: {
                    this.cell = true;
                }
            }
        }
        this.jspOnclick = this.getOnclick();
        this.setOnclick(Expression.evaluate(this.jspOnclick, this.pageContext));
    }

    protected void reset() {
        this.mode = this.jspMode;
        this.jspMode = null;
        this.setDisabled(this.jspDisabled);
        this.display = true;
        this.cell = false;
        this.setOnclick(this.jspOnclick);
        this.jspOnclick = null;
    }

    public void release() {
        super.release();
        this.tag.release();
        this.policy = null;
        this.property = null;
        this.valign = null;
        this.mode = null;
    }

    protected void beginActionLayout(StringBuffer in_buffer) throws JspException {
        in_buffer.append("<td>&nbsp;</td><td");
        if (this.valign != null) {
            in_buffer.append(" valign=\"");
            in_buffer.append(this.valign);
            in_buffer.append("\"");
        }
        in_buffer.append(">");
    }

    protected void endActionLayout(StringBuffer in_buffer) {
        in_buffer.append("</td>");
    }

    public void setProperty(String property) {
        this.property = property;
    }

    public void setValign(String valign) {
        this.valign = valign;
    }

    public Object processEndLayoutEvent(EndLayoutEvent in_event) throws JspException {
        return Boolean.FALSE;
    }

    public Object processStartLayoutEvent(StartLayoutEvent in_event) throws JspException {
        return Boolean.FALSE;
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    protected void copyProperties() throws JspException {
        LayoutUtils.copyProperties(this.tag, this);
    }
}

