/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.tab;

import fr.improve.struts.taglib.layout.LabelledTag;
import fr.improve.struts.taglib.layout.el.Expression;
import fr.improve.struts.taglib.layout.event.EndLayoutEvent;
import fr.improve.struts.taglib.layout.event.LayoutEventListener;
import fr.improve.struts.taglib.layout.event.StartLayoutEvent;
import fr.improve.struts.taglib.layout.event.StaticCodeIncludeLayoutEvent;
import fr.improve.struts.taglib.layout.event.StaticCodeIncludeListener;
import fr.improve.struts.taglib.layout.tab.TabsTag;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import fr.improve.struts.taglib.layout.util.TagUtils;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TabTag
extends LabelledTag
implements LayoutEventListener,
StaticCodeIncludeListener {
    public static final String TABS_COOKIE_FIX = "tabs.cookie.fix";
    public static final String ATG_FIX_KEY = "fr.improve.struts.taglib.layout.tab.TabTag.ATG_FIX_KEY";
    public static final String SESSION_STATE_KEY = "fr.improve.struts.taglib.layout.tab.TabTag.SESSION_STATE_KEY";
    protected static final Log LOG = LogFactory.getLog(TabsTag.class);
    private String width;
    private String href;
    private String forward;
    private String page;
    private String reqCode;
    private boolean include;
    private String staticCode = "";

    public int doStartLayoutTag() throws JspException {
        TabsTag lc_tabs = (TabsTag)TabTag.findAncestorWithClass((Tag)this, TabsTag.class);
        if (lc_tabs == null) {
            throw new JspException("Invalid use of <layout:tab>");
        }
        this.include = false;
        String lc_href = null;
        if (this.href != null || this.forward != null || this.page != null) {
            lc_href = LayoutUtils.computeURL(this.pageContext, this.forward, Expression.evaluate(this.href, this.pageContext), this.page, null, null, null, null, false, null);
        } else if (this.reqCode == null) {
            this.include = true;
        }
        boolean lc_selected = this.isTabSelected(lc_tabs);
        if (lc_selected) {
            this.include = true;
        }
        String lc_id = lc_tabs.addTab(this.key, this.getLabel(), lc_href, this.reqCode, this.width, lc_selected);
        if (this.include) {
            TagUtils.write(this.pageContext, "<div id=\"");
            TagUtils.write(this.pageContext, lc_id);
            if (!lc_selected) {
                TagUtils.write(this.pageContext, "\" style=\"display:none;");
            }
            TagUtils.write(this.pageContext, "\"><table border=\"0\" cellspacing=\"0\" cellpadding=\"0\" class=\"clsAction\">");
            return 1;
        }
        return 0;
    }

    protected boolean isTabSelected(TabsTag lc_tabs) {
        boolean lc_selected;
        boolean bl = lc_selected = !lc_tabs.isTabAlreadySelected();
        if (lc_selected && lc_tabs.getSelectedTabKeyName() != null) {
            LOG.debug((Object)("Looking for the selection of tab " + this.key + " in tabs " + lc_tabs.getSelectedTabKeyName()));
            String lc_selectedTab = TabTag.getSelectedTabNameFromCookie((HttpServletRequest)this.pageContext.getRequest(), lc_tabs.getSelectedTabKeyName());
            if (lc_selectedTab != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Selected tab from cookie=" + lc_selectedTab));
            }
            if (lc_selectedTab == null && (lc_selectedTab = (String)this.pageContext.findAttribute(lc_tabs.getSelectedTabKeyName())) != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Selected tab from attribute=" + lc_selectedTab));
            }
            if (lc_selectedTab == null && (lc_selectedTab = this.pageContext.getRequest().getParameter(lc_tabs.getSelectedTabKeyName())) != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Selected tab from parameter=" + lc_selectedTab));
            }
            if (lc_selectedTab == null && (lc_selectedTab = TabTag.getSelectedTabNameFromSession((HttpServletRequest)this.pageContext.getRequest(), lc_tabs.getSelectedTabKeyName())) != null && LOG.isDebugEnabled()) {
                LOG.debug((Object)("Selected tab from session=" + lc_selectedTab));
            }
            if (lc_selectedTab != null && !lc_selectedTab.equals(this.key)) {
                LOG.debug((Object)"Deselecting non matching tab");
                lc_selected = false;
            }
            if (lc_selected) {
                LOG.debug((Object)"Selecting matching tab");
                lc_tabs.setSelectedTabKey(this.key);
            }
        } else {
            LOG.debug((Object)"Tab already selected in tabs or default selection to first tab");
        }
        return lc_selected;
    }

    private static boolean isATGFix(HttpServletRequest in_request, String in_group) {
        return in_request.getAttribute("fr.improve.struts.taglib.layout.tab.TabTag.ATG_FIX_KEY." + in_group) != null;
    }

    private static void setATGFix(HttpServletRequest in_request, String in_group) {
        if (!"false".equals(LayoutUtils.getSkin(in_request.getSession()).getProperty(TABS_COOKIE_FIX, "false"))) {
            LOG.debug((Object)"Ignore tab cookie value");
            in_request.setAttribute("fr.improve.struts.taglib.layout.tab.TabTag.ATG_FIX_KEY." + in_group, (Object)"");
        }
    }

    public static String getSelectedTabNameFromCookie(HttpServletRequest in_request, String in_keyName) {
        Cookie[] lc_cookies = in_request.getCookies();
        LOG.debug((Object)("Looking for tabs cookie with key=" + in_keyName));
        if (TabTag.isATGFix(in_request, in_keyName)) {
            LOG.debug((Object)"Ignoring buggy tab cookie value");
            return null;
        }
        if (lc_cookies == null) {
            LOG.debug((Object)"No cookie");
            return null;
        }
        int i = 0;
        while (i < lc_cookies.length) {
            Cookie lc_cookie = lc_cookies[i];
            if (lc_cookie.getName().equals("selectedTab")) {
                String lc_value = lc_cookie.getValue();
                if ((lc_value = URLDecoder.decode(lc_value)) == null) {
                    LOG.debug((Object)"No cookie value");
                    return null;
                }
                LOG.debug((Object)("Cookie value=" + lc_value));
                int lc_keyNameStart = 0;
                String lc_keyName = null;
                int lc_keyValueStart = -1;
                String lc_keyValue = null;
                int j = 0;
                while (j < lc_value.length()) {
                    switch (lc_value.charAt(j)) {
                        case '=': {
                            if (lc_keyNameStart == -1) break;
                            lc_keyName = lc_value.substring(lc_keyNameStart, j).trim();
                            lc_keyValueStart = j + 1;
                            break;
                        }
                        case ';': {
                            if (lc_keyName != null) {
                                lc_keyValue = lc_value.substring(lc_keyValueStart, j).trim();
                                if (in_keyName.equals(lc_keyName)) {
                                    return lc_keyValue;
                                }
                            }
                            lc_keyName = null;
                            lc_keyValue = null;
                            lc_keyNameStart = j + 1;
                            lc_keyValueStart = -1;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static void setSelectedTabNameFromCookie(HttpServletRequest in_request, HttpServletResponse in_response, String in_group, String in_keyName) {
        Cookie[] lc_cookies = in_request.getCookies();
        Cookie lc_oldCookie = null;
        HashMap<String, String> lc_tabsInformation = new HashMap<String, String>();
        if (lc_cookies != null) {
            int i = 0;
            while (i < lc_cookies.length) {
                Cookie lc_cookie = lc_cookies[i];
                if (lc_cookie.getName().equals("selectedTab")) {
                    String lc_value = lc_cookie.getValue();
                    StringTokenizer lc_tokenizer = new StringTokenizer(URLDecoder.decode(lc_value), ";=");
                    while (lc_tokenizer.hasMoreTokens()) {
                        String lc_keyName = lc_tokenizer.nextToken();
                        String lc_keyValue = null;
                        if (lc_tokenizer.hasMoreTokens()) {
                            lc_keyValue = lc_tokenizer.nextToken();
                        }
                        lc_tabsInformation.put(lc_keyName, lc_keyValue);
                    }
                    lc_oldCookie = lc_cookie;
                    break;
                }
                ++i;
            }
        }
        lc_tabsInformation.put(in_group, in_keyName);
        StringBuffer lc_value = new StringBuffer();
        for (String lc_tabName : lc_tabsInformation.keySet()) {
            String lc_tabValue = (String)lc_tabsInformation.get(lc_tabName);
            lc_value.append(lc_tabName).append('=').append(lc_tabValue).append(';');
        }
        String lc_newCookieValue = URLEncoder.encode(lc_value.toString());
        Cookie lc_cookie = new Cookie("selectedTab", lc_newCookieValue);
        lc_cookie.setPath(in_request.getContextPath());
        if (lc_oldCookie != null) {
            lc_oldCookie.setValue(lc_newCookieValue);
            TabTag.setATGFix(in_request, in_group);
        }
        in_response.addCookie(lc_cookie);
    }

    public static String getSelectedTabNameFromSession(HttpServletRequest in_request, String in_keyName) {
        HttpSession lc_session = in_request.getSession(false);
        if (lc_session == null) {
            return null;
        }
        Map lc_tabstate = (Map)lc_session.getAttribute(SESSION_STATE_KEY);
        if (lc_tabstate == null) {
            return null;
        }
        return (String)lc_tabstate.get(in_keyName);
    }

    public static void setSelectedTabNameFromSession(HttpServletRequest in_request, String in_group, String in_keyName) {
        HashMap<String, String> lc_tabState = (HashMap<String, String>)in_request.getSession().getAttribute(SESSION_STATE_KEY);
        if (lc_tabState == null) {
            lc_tabState = new HashMap<String, String>();
            in_request.getSession().setAttribute(SESSION_STATE_KEY, lc_tabState);
        }
        lc_tabState.put(in_group, in_keyName);
    }

    public int doEndLayoutTag() throws JspException {
        if (this.include) {
            TagUtils.write(this.pageContext, "</table></div>");
        }
        if (this.staticCode.length() != 0) {
            TagUtils.write(this.pageContext, this.staticCode);
            this.staticCode = "";
        }
        return 6;
    }

    public void release() {
        super.release();
        this.width = null;
        this.href = null;
        this.forward = null;
        this.page = null;
        this.reqCode = null;
    }

    public Object processStartLayoutEvent(StartLayoutEvent in_event) throws JspException {
        return in_event.consume(this.pageContext, "<tr>");
    }

    public Object processEndLayoutEvent(EndLayoutEvent in_event) throws JspException {
        return in_event.consume(this.pageContext, "</tr>");
    }

    public Object processStaticCodeIncludeEvent(StaticCodeIncludeLayoutEvent in_event) throws JspException {
        this.staticCode = String.valueOf(this.staticCode) + in_event.sendToParent(this);
        return "";
    }

    public String getWidth() {
        return this.width;
    }

    public void setWidth(String width) {
        this.width = width;
    }

    public String getForward() {
        return this.forward;
    }

    public String getHref() {
        return this.href;
    }

    public void setForward(String forward) {
        this.forward = forward;
    }

    public void setHref(String href) {
        this.href = href;
    }

    public String getPage() {
        return this.page;
    }

    public void setPage(String page) {
        this.page = page;
    }

    public String getReqCode() {
        return this.reqCode;
    }

    public void setReqCode(String reqCode) {
        this.reqCode = reqCode;
    }
}

