/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.Dum;
import cz.triangle.domy.Jazyk;
import cz.triangle.domy.Lokalita;
import cz.triangle.domy.Podlazi;
import cz.triangle.domy.PolozkaMenu;
import cz.triangle.domy.Rd;
import cz.triangle.domy.RdJaz;
import cz.triangle.domy.StromMenu;
import cz.triangle.domy.TypBloku;
import cz.triangle.domy.TypStavu;
import cz.triangle.domy.form.AdminRdForm;
import cz.triangle.domy.www.ClankyDelegate;
import cz.triangle.domy.www.LokalitaDelegate;
import cz.triangle.util.ConvertService;
import cz.triangle.util.HibernateUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class RdDelegate
implements Serializable {
    private MessageResources res;
    private String localeId;

    public RdDelegate(MessageResources res, String localeId, Session hsess) {
        this.res = res;
        Jazyk jazyk = (Jazyk)hsess.load(Jazyk.class, (Serializable)((Object)localeId));
        this.localeId = localeId;
    }

    public Map novaPolozka(AdminRdForm f, String id, String id2, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            AdminRdForm form = f;
            if (form == null) {
                form = new AdminRdForm();
                if (id2 != null) {
                    form.setLokalitaId(id2);
                    form.setTypBlokuId(id);
                } else {
                    form.setLokalitaId(id);
                }
            }
            vysledek.put("adminRdForm", (Object)form);
            vysledek.put("seznamTypuBloku", this.getSeznamTypuBloku(hsess));
            vysledek.put("seznamLokalit", this.getSeznamLokalit(hsess));
            vysledek.put("seznamTypuStavu", this.getSeznamTypuStavu(hsess));
            vysledek.put("seznamPolozek", this.getSeznamPolozek(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, AdminRdForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Rd polozka = (Rd)hsess.load(Rd.class, (Serializable)new Integer(id));
            AdminRdForm form = f;
            if (form == null) {
                form = new AdminRdForm();
                ConvertService.registrujCeske();
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                ConvertService.odregistrujCeske();
                form.setTypBlokuId(polozka.getTypBloku().getId().toString());
                form.setTypStavuId(polozka.getTypStavu().getId().toString());
                form.setLokalitaId(polozka.getLokalita().getId().toString());
                form.setObrazekNazev(polozka.getObrazek());
                List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
                for (Jazyk jazyk : jazyky) {
                    RdJaz RdJaz2 = (RdJaz)polozka.getRdJazs().get(jazyk.getId());
                    if (RdJaz2 != null) {
                        form.setPoznamka(jazyk.getId(), RdJaz2.getPoznamka());
                        form.setPopis(jazyk.getId(), RdJaz2.getPopis());
                        if (RdJaz2.getKodOdkaz() == null || RdJaz2.getKodOdkaz().equalsIgnoreCase("")) continue;
                        form.setKodOdkaz(jazyk.getId(), RdJaz2.getKodOdkaz());
                        continue;
                    }
                    form.setPoznamka(jazyk.getId(), "");
                }
            }
            vysledek.put("id", polozka.getId());
            vysledek.put("adminRdForm", (Object)form);
            vysledek.put("seznamTypuBloku", this.getSeznamTypuBloku(hsess));
            vysledek.put("seznamLokalit", this.getSeznamLokalit(hsess));
            vysledek.put("seznamTypuStavu", this.getSeznamTypuStavu(hsess));
            vysledek.put("seznamPolozek", this.getSeznamPolozek(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return this.res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(AdminRdForm form, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminRdForm", (Object)form);
                return vysledek;
            }
            Rd novaPolozka = new Rd();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)novaPolozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            vysledek.put("adminRdForm", (Object)form);
            novaPolozka.setTypBloku((TypBloku)hsess.load(TypBloku.class, (Serializable)new Integer(form.getTypBlokuId())));
            Lokalita lokalita = (Lokalita)hsess.load(Lokalita.class, (Serializable)new Integer(form.getLokalitaId()));
            novaPolozka.setLokalita(lokalita);
            novaPolozka.setTypStavu((TypStavu)hsess.load(TypStavu.class, (Serializable)((Object)form.getTypStavuId())));
            hsess.save((Object)novaPolozka);
            long privesek = Math.round(Math.random() * 1000.0);
            FormFile file = form.getObrazekFile();
            if (file != null && file.getFileName().length() > 0) {
                novaPolozka.setObrazek(LokalitaDelegate.ulozSoubor(cesta, lokalita, privesek, file, "rd_obrazek"));
            }
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                String poznamka = (String)form.getPoznamka(jazyk.getId());
                RdJaz RdJaz2 = new RdJaz();
                RdJaz2.setJazyk(jazyk);
                novaPolozka.getRdJazs().put(jazyk.getId(), RdJaz2);
                RdJaz2.setRd(novaPolozka);
                if (poznamka != null) {
                    RdJaz2.setPoznamka(poznamka);
                } else {
                    RdJaz2.setPoznamka("");
                }
                String popis = (String)form.getPopis(jazyk.getId());
                if (popis != null) {
                    RdJaz2.setPopis(popis);
                } else {
                    RdJaz2.setPopis("");
                }
                String kodOdkaz = (String)form.getKodOdkaz(jazyk.getId());
                if (kodOdkaz != null && !kodOdkaz.equalsIgnoreCase("-1")) {
                    RdJaz2.setKodOdkaz(((PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)kodOdkaz))).getKod());
                } else {
                    RdJaz2.setKodOdkaz(null);
                }
                hsess.save((Object)RdJaz2);
            }
            vysledek.put("id", novaPolozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map zapsatPolozku(AdminRdForm form, String id, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminRdForm", (Object)form);
                return vysledek;
            }
            Rd polozka = (Rd)hsess.load(Rd.class, (Serializable)new Integer(id));
            ConvertService.registrujCeske();
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                String poznamka;
                RdJaz RdJaz2 = (RdJaz)polozka.getRdJazs().get(jazyk.getId());
                if (RdJaz2 == null) {
                    RdJaz2 = new RdJaz();
                    RdJaz2.setJazyk(jazyk);
                    RdJaz2.setRd(polozka);
                    hsess.save((Object)RdJaz2);
                }
                if ((poznamka = (String)form.getPoznamka(jazyk.getId())) != null) {
                    RdJaz2.setPoznamka(poznamka);
                } else {
                    RdJaz2.setPoznamka("");
                }
                String popis = (String)form.getPopis(jazyk.getId());
                if (popis != null) {
                    RdJaz2.setPopis(popis);
                } else {
                    RdJaz2.setPopis("");
                }
                String kodOdkaz = (String)form.getKodOdkaz(jazyk.getId());
                if (kodOdkaz != null && !kodOdkaz.equalsIgnoreCase("-1")) {
                    RdJaz2.setKodOdkaz(((PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)kodOdkaz))).getKod());
                    continue;
                }
                RdJaz2.setKodOdkaz(null);
            }
            BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            polozka.setTypBloku((TypBloku)hsess.load(TypBloku.class, (Serializable)new Integer(form.getTypBlokuId())));
            Lokalita lokalita = (Lokalita)hsess.load(Lokalita.class, (Serializable)new Integer(form.getLokalitaId()));
            polozka.setLokalita(lokalita);
            long privesek = Math.round(Math.random() * 1000.0);
            FormFile file = form.getObrazekFile();
            if (file != null && file.getFileName().length() > 0) {
                polozka.setObrazek(LokalitaDelegate.prepisSoubor(cesta, lokalita, privesek, file, polozka.getObrazek(), "rd_obrazek"));
            }
            polozka.setTypStavu((TypStavu)hsess.load(TypStavu.class, (Serializable)((Object)form.getTypStavuId())));
            vysledek.put("adminRdForm", (Object)form);
            vysledek.put("id", polozka.getId());
            vysledek.put("idLokalita", polozka.getLokalita().getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map smazatPolozku(String id, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Rd staraPolozka = (Rd)hsess.load(Rd.class, (Serializable)new Integer(id));
            vysledek.put("idLokalita", staraPolozka.getLokalita().getId());
            vysledek.put("idTypBloku", staraPolozka.getTypBloku().getId());
            if (staraPolozka.getObrazek() != null && staraPolozka.getObrazek().length() > 0) {
                LokalitaDelegate.smazatSwf(cesta, staraPolozka.getLokalita().getId(), staraPolozka.getObrazek());
            }
            hsess.delete((Object)staraPolozka);
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public List getSeznamDomu(String id, Session hsess) {
        Dum dum = (Dum)hsess.load(Dum.class, (Serializable)new Integer(id));
        return hsess.createQuery("from Dum dum where dum.lokalita = ? order by dum.razeni").setEntity(0, (Object)dum.getLokalita()).list();
    }

    public List getSeznamPodlazi(String id, Session hsess) {
        List vysledek = null;
        Podlazi podlazi = (Podlazi)hsess.load(Podlazi.class, (Serializable)new Integer(id));
        vysledek = hsess.createQuery("from Podlazi podlazi where podlazi.dum = ? order by typPodlazi.razeni").setEntity(0, (Object)podlazi.getDum()).list();
        return vysledek;
    }

    public List getSeznamTypuProstor(Session hsess) {
        return hsess.createQuery("from TypProstor typProstor order by typProstor.id").list();
    }

    public List getSeznamTypuBloku(Session hsess) {
        return hsess.createQuery("from TypBloku typBloku order by typBloku.razeni").list();
    }

    public List getSeznamTypuStavu(Session hsess) {
        return hsess.createQuery("from TypStavu typStavu order by typStavu.id").list();
    }

    public List getSeznamLokalit(Session hsess) {
        return hsess.createQuery("from Lokalita lokalita order by lokalita.razeni").list();
    }

    private Map getSeznamPolozek(Session hsess) {
        HashMap<String, List> vysledek = new HashMap<String, List>();
        ClankyDelegate cd = new ClankyDelegate(this.localeId, null, this.res);
        List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
        for (Jazyk jazyk : jazyky) {
            List polozky = hsess.createQuery("from PolozkaMenu polozka where polozka.idJazyk = ? order by polozka.razeni").setString(0, jazyk.getId()).list();
            StromMenu strom = new StromMenu(polozky);
            List seznamPolozek = cd.getSeznamPolozek(strom, "-1", false);
            vysledek.put(jazyk.getId(), seznamPolozek);
        }
        return vysledek;
    }
}

