/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import com.flagstone.transform.FSMovie;
import cz.triangle.domy.Fotogalerie;
import cz.triangle.domy.Jazyk;
import cz.triangle.domy.Obrazek;
import cz.triangle.domy.SkupinaFotogalerie;
import cz.triangle.domy.SkupinaFotogalerieJaz;
import cz.triangle.domy.form.AdminSkupinaFotogalerieForm;
import cz.triangle.domy.www.LokalitaDelegate;
import cz.triangle.domy.www.ObrazekDelegate;
import cz.triangle.flash.Test1;
import cz.triangle.util.ConvertService;
import cz.triangle.util.HibernateUtil;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class SkupinaFotogalerieDelegate
implements Serializable {
    private MessageResources res;
    private String localeId;

    public SkupinaFotogalerieDelegate(MessageResources res, String localeId, Session hsess) {
        this.res = res;
        Jazyk jazyk = (Jazyk)hsess.load(Jazyk.class, (Serializable)((Object)localeId));
        this.localeId = localeId;
    }

    public Map novaPolozka(AdminSkupinaFotogalerieForm f, String id, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            AdminSkupinaFotogalerieForm form = f;
            if (form == null) {
                form = new AdminSkupinaFotogalerieForm();
                form.setFotogalerieId(id);
                List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
                for (Jazyk jazyk : jazyky) {
                    form.setNazev(jazyk.getId(), "");
                }
            }
            vysledek.put("adminSkupinaFotogalerieForm", (Object)form);
            vysledek.put("seznamFotogalerii", this.getSeznamFotogalerii(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, AdminSkupinaFotogalerieForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            SkupinaFotogalerie polozka = (SkupinaFotogalerie)hsess.load(SkupinaFotogalerie.class, (Serializable)new Integer(id));
            AdminSkupinaFotogalerieForm form = f;
            if (form == null) {
                form = new AdminSkupinaFotogalerieForm();
                ConvertService.registrujCeske();
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                ConvertService.odregistrujCeske();
                List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
                for (Jazyk jazyk : jazyky) {
                    SkupinaFotogalerieJaz skupinaFotogalerieJaz = (SkupinaFotogalerieJaz)polozka.getSkupinaFotogalerieJazs().get(jazyk.getId());
                    if (skupinaFotogalerieJaz != null) {
                        form.setNazev(jazyk.getId(), skupinaFotogalerieJaz.getNazev());
                        continue;
                    }
                    form.setNazev(jazyk.getId(), "");
                }
                form.setFotogalerieId(polozka.getFotogalerie().getId().toString());
            }
            form.setX1(polozka.getFotogalerie().getX1());
            form.setY1(polozka.getFotogalerie().getY1());
            vysledek.put("id", polozka.getId());
            vysledek.put("adminSkupinaFotogalerieForm", (Object)form);
            vysledek.put("seznamFotogalerii", this.getSeznamFotogalerii(hsess));
            vysledek.put("seznamObrazku", this.getSeznamObrazku(polozka.getId(), hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return this.res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(AdminSkupinaFotogalerieForm form, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminSkupinaFotogalerieForm", (Object)form);
                return vysledek;
            }
            SkupinaFotogalerie novaPolozka = new SkupinaFotogalerie();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)novaPolozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            vysledek.put("adminSkupinaFotogalerieForm", (Object)form);
            Fotogalerie fotogalerie = (Fotogalerie)hsess.load(Fotogalerie.class, (Serializable)new Integer(form.getFotogalerieId()));
            novaPolozka.setFotogalerie(fotogalerie);
            hsess.save((Object)novaPolozka);
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                String nazev = (String)form.getNazev(jazyk.getId());
                SkupinaFotogalerieJaz skupinaFotogalerieJaz = new SkupinaFotogalerieJaz();
                skupinaFotogalerieJaz.setJazyk(jazyk);
                novaPolozka.getSkupinaFotogalerieJazs().put(jazyk.getId(), skupinaFotogalerieJaz);
                skupinaFotogalerieJaz.setSkupinaFotogalerie(novaPolozka);
                if (nazev != null) {
                    skupinaFotogalerieJaz.setNazev(nazev);
                } else {
                    skupinaFotogalerieJaz.setNazev("");
                }
                hsess.save((Object)skupinaFotogalerieJaz);
            }
            vysledek.put("id", novaPolozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map zapsatPolozku(AdminSkupinaFotogalerieForm form, String id, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminSkupinaFotogalerieForm", (Object)form);
                return vysledek;
            }
            SkupinaFotogalerie polozka = (SkupinaFotogalerie)hsess.load(SkupinaFotogalerie.class, (Serializable)new Integer(id));
            ConvertService.registrujCeske();
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                String nazev;
                SkupinaFotogalerieJaz skupinaFotogalerieJaz = (SkupinaFotogalerieJaz)polozka.getSkupinaFotogalerieJazs().get(jazyk.getId());
                if (skupinaFotogalerieJaz == null) {
                    skupinaFotogalerieJaz = new SkupinaFotogalerieJaz();
                    skupinaFotogalerieJaz.setJazyk(jazyk);
                    skupinaFotogalerieJaz.setSkupinaFotogalerie(polozka);
                    hsess.save((Object)skupinaFotogalerieJaz);
                }
                if ((nazev = (String)form.getNazev(jazyk.getId())) != null) {
                    skupinaFotogalerieJaz.setNazev(nazev);
                } else {
                    skupinaFotogalerieJaz.setNazev("");
                }
                hsess.save((Object)skupinaFotogalerieJaz);
            }
            BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            Fotogalerie staraFotogalerie = polozka.getFotogalerie();
            Fotogalerie fotogalerie = (Fotogalerie)hsess.load(Fotogalerie.class, (Serializable)new Integer(form.getFotogalerieId()));
            polozka.setFotogalerie(fotogalerie);
            vysledek.put("adminSkupinaFotogalerieForm", (Object)form);
            vysledek.put("id", polozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map flash(String id, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            SkupinaFotogalerie polozka = (SkupinaFotogalerie)hsess.load(SkupinaFotogalerie.class, (Serializable)new Integer(id));
            List seznamObrazku = this.getSeznamObrazku(polozka.getId(), hsess);
            Test1 example = new Test1(polozka.getFotogalerie().getX1(), polozka.getFotogalerie().getY1(), 360, 255, 252, 229);
            FSMovie movie = new FSMovie();
            String cestaCela = String.valueOf(cesta) + "dbimg" + File.separator + "fotogalerie" + File.separator;
            example.createMovie(movie, cestaCela, String.valueOf(cesta) + "obrazky" + File.separator + "testovaci_preloader.swf", seznamObrazku, this.localeId);
            long privesek = Math.round(Math.random() * 1000.0);
            String soubor = "flash" + polozka.getId() + "_" + privesek + ".swf";
            movie.encodeToFile(String.valueOf(cestaCela) + soubor);
            if (polozka.getFlash() != null && polozka.getFlash().trim().length() > 0) {
                ObrazekDelegate.smazatSoubor(String.valueOf(cestaCela) + polozka.getFlash());
            }
            polozka.setFlash(soubor);
            vysledek.put("id", polozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map smazatPolozku(String id, String cesta, Session hsess) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        try {
            SkupinaFotogalerie staraPolozka = (SkupinaFotogalerie)hsess.load(SkupinaFotogalerie.class, (Serializable)new Integer(id));
            String cestaCelkem = String.valueOf(ObrazekDelegate.getCestaObrazek(cesta)) + File.separator;
            for (Obrazek obrazek : staraPolozka.getObrazeks()) {
                if (obrazek.getNazev() == null || obrazek.getNazev().length() <= 0) continue;
                ObrazekDelegate.smazatSoubor(String.valueOf(cestaCelkem) + obrazek.getNazev());
                ObrazekDelegate.smazatSoubor(String.valueOf(cestaCelkem) + "m" + obrazek.getNazev());
                ObrazekDelegate.smazatSoubor(String.valueOf(cestaCelkem) + "mm" + obrazek.getNazev());
            }
            if (staraPolozka.getFlash() != null && staraPolozka.getFlash().trim().length() > 0) {
                ObrazekDelegate.smazatSoubor(String.valueOf(cestaCelkem) + staraPolozka.getFlash());
            }
            hsess.delete((Object)staraPolozka);
            hsess.flush();
        }
        catch (HibernateException e) {
            e.printStackTrace();
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public List getSeznamFotogalerii(Session hsess) {
        return hsess.createQuery("from Fotogalerie fotogalerie order by fotogalerie.nazev").list();
    }

    private List getSeznamObrazku(Integer id, Session hsess) {
        return hsess.createQuery("from Obrazek obrazek where obrazek.skupinaFotogalerie.id = ? order by obrazek.razeni, obrazek.id").setInteger(0, id.intValue()).list();
    }
}

