/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.elementy.www;

import cz.triangle.elementy.Historie;
import cz.triangle.elementy.Objekt;
import cz.triangle.elementy.PolozkaObjektu;
import cz.triangle.elementy.ZasilaniObjektu;
import cz.triangle.elementy.form.AdminObjektForm;
import cz.triangle.util.ConvertService;
import cz.triangle.util.HibernateUtil;
import cz.triangle.util.Obrazek;
import cz.triangle.util.UpravaRetezce;
import fr.improve.struts.taglib.layout.menu.MenuComponent;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.validator.GenericValidator;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjektDelegate
implements Serializable {
    private DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale("CS", "cz"));
    private MenuComponent vybraneMenuComponent = null;

    public Map nactiObjekty(String kod, String konkretni_id, org.hibernate.Session hsess, MessageResources res, String obsah) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        List polozky = hsess.createQuery("from Objekt objekt where (objekt.objekt is null or objekt.objekt=objekt) order by objekt.razeni").list();
        MenuComponent treeData = new MenuComponent();
        treeData.setTitle("root");
        treeData.setDescription("root");
        treeData.setName("root");
        if (polozky.size() > 0) {
            this.vytvorPrvniUroven(polozky, treeData, kod, konkretni_id, hsess);
        }
        vysledek.put("strom", treeData);
        if (kod != null && this.vybraneMenuComponent == null) {
            vysledek.put("chyba", res.getMessage("admin.chyba.vybrano_neexistujici_id"));
        }
        if (obsah != null && obsah.equalsIgnoreCase("vypis") && this.vybraneMenuComponent != null) {
            Objekt vybranyObjekt = (Objekt)hsess.load(Objekt.class, (Serializable)((Object)this.vybraneMenuComponent.getDescription()));
            try {
                vysledek.put("vybranyObjekt", vybranyObjekt);
                String podminkaKonkretni = "1=1";
                List seznamPolozekTmp = null;
                if (konkretni_id != null) {
                    Object polozka = hsess.load(Class.forName("cz.triangle.elementy." + this.nazevObjektu(vybranyObjekt.getId())), (Serializable)new Integer(konkretni_id));
                    vysledek.put("vybranaKonkretniPolozka", polozka);
                    LinkedHashMap<Objekt, List> seznamPolozekMap = new LinkedHashMap<Objekt, List>();
                    for (Objekt objekt : vybranyObjekt.getObjekts()) {
                        String vycetPolozek;
                        String razeni = this.seznamPolozekRazeni(objekt.getSeznamRazeniPolozky());
                        if (razeni == null || razeni.equalsIgnoreCase("")) {
                            razeni = "id";
                        }
                        vycetPolozek = (vycetPolozek = this.seznamPolozek(objekt.getSeznamZobrazeniPolozky())) == null || vycetPolozek.equalsIgnoreCase("") ? "id" : String.valueOf(vycetPolozek) + "," + this.nazevObjektuSMalym(vybranyObjekt.getId()) + ".id,id";
                        seznamPolozekTmp = hsess.createQuery("select " + vycetPolozek + " from " + this.nazevObjektu(objekt.getId()) + " " + " where " + this.nazevObjektuSMalym(vybranyObjekt.getId()) + ".id=" + konkretni_id + " order by " + razeni).list();
                        seznamPolozekMap.put(objekt, seznamPolozekTmp);
                    }
                    vysledek.put("seznamPolozekMap", seznamPolozekMap);
                } else {
                    String vycetPolozek;
                    String razeni = this.seznamPolozekRazeni(vybranyObjekt.getSeznamRazeniPolozky());
                    if (razeni == null || razeni.equalsIgnoreCase("")) {
                        razeni = "id";
                    }
                    vycetPolozek = (vycetPolozek = this.seznamPolozek(vybranyObjekt.getSeznamZobrazeniPolozky())) == null || vycetPolozek.equalsIgnoreCase("") ? "id" : String.valueOf(vycetPolozek) + ",id";
                    String podminka = "1=1";
                    if (vybranyObjekt.getObjekt() != null && vybranyObjekt.getObjekt().getClass() == vybranyObjekt.getClass()) {
                        podminka = String.valueOf(this.nazevObjektuSMalym(vybranyObjekt.getId())) + " is null";
                    }
                    List seznamPolozek = hsess.createQuery("select " + vycetPolozek + " from " + this.nazevObjektu(vybranyObjekt.getId()) + " " + "where " + podminka + " " + " order by " + razeni).list();
                    vysledek.put("seznamPolozek", seznamPolozek);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return vysledek;
    }

    private void vytvorPrvniUroven(Collection polozky, MenuComponent rodic, String kod, String konkretni_id, org.hibernate.Session hsess) {
        for (Objekt objekt : polozky) {
            MenuComponent node = new MenuComponent();
            node.setTitle(objekt.getNazev());
            node.setDescription(objekt.getId());
            node.setImage("yellow-folder-closed.png");
            node.setLocation("admin_objekt.do?akce=vybrat_rodic&id=" + objekt.getId());
            Object vybranyKod = null;
            if (kod != null && kod.equals(objekt.getId()) && konkretni_id == null) {
                node.setStyle("font-weight: bold;");
                this.vybraneMenuComponent = node;
            }
            rodic.addMenuComponent(node);
            if (objekt.getObjekts().size() <= 0) continue;
            String razeni = this.seznamPolozekRazeni(objekt.getSeznamRazeniPolozky());
            if (razeni == null || razeni.equalsIgnoreCase("")) {
                razeni = "id";
            }
            String podminka = "1=1";
            if (objekt.getObjekt() != null && objekt.getObjekt().getClass() == objekt.getClass()) {
                podminka = String.valueOf(this.nazevObjektuSMalym(objekt.getId())) + " is null";
            }
            List seznamPolozek = hsess.createQuery("select id, nazev  from " + this.nazevObjektu(objekt.getId()) + " " + "where " + podminka + " " + "order by " + razeni).list();
            this.vytvorDalsiUroven(seznamPolozek, node, objekt, kod, konkretni_id, hsess);
        }
    }

    private void vytvorDalsiUroven(Collection seznamPolozek, MenuComponent rodic, Objekt objekt, String kod, String konkretni_id, org.hibernate.Session hsess) {
        for (Object[] object : seznamPolozek) {
            MenuComponent node = new MenuComponent();
            node.setTitle(object[1].toString());
            node.setDescription(objekt.getId());
            node.setImage("yellow-folder-closed.png");
            node.setLocation("admin_objekt.do?akce=vybrat_rodic&id=" + objekt.getId() + "&konkretni_id=" + object[0]);
            Object vybranyKod = null;
            if (kod != null && kod.equals(objekt.getId()) && konkretni_id != null && konkretni_id.equals(object[0].toString())) {
                node.setStyle("font-weight: bold;");
                this.vybraneMenuComponent = node;
            }
            rodic.addMenuComponent(node);
            for (Objekt oTmp : objekt.getObjekts()) {
                if (oTmp.getObjekts().size() <= 0) continue;
                String razeni = this.seznamPolozekRazeni(oTmp.getSeznamRazeniPolozky());
                if (razeni == null || razeni.equalsIgnoreCase("")) {
                    razeni = "id";
                }
                List seznam = hsess.createQuery("select id, nazev from " + this.nazevObjektu(oTmp.getId()) + " " + " where " + this.nazevObjektuSMalym(rodic.getDescription()) + ".id=" + object[0] + " order by " + razeni).list();
                this.vytvorDalsiUroven(seznam, node, oTmp, kod, konkretni_id, hsess);
            }
        }
    }

    public Map novaPolozka(AdminObjektForm f, String id, String konkretni_id, org.hibernate.Session hsess, MessageResources res) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Objekt objekt = (Objekt)hsess.load(Objekt.class, (Serializable)((Object)id));
            vysledek.put("vybranyObjekt", objekt);
            Objekt nadrazeny = objekt.getObjekt();
            AdminObjektForm form = f;
            if (form == null) {
                form = new AdminObjektForm();
                form.novy(objekt);
                try {
                    if (nadrazeny != null) {
                        form.setAtribut("kod_nadrazeny", BeanUtils.getProperty((Object)nadrazeny, (String)"id"));
                    } else {
                        form.setAtribut("kod_nadrazeny", id);
                    }
                    form.setAtribut("id_nadrazeny", konkretni_id);
                    form.setKonkretni_id(konkretni_id);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            vysledek.put("adminObjektForm", (Object)form);
            if (konkretni_id != null) {
                List seznamRodicu = this.nactiRodiceProEditaci(konkretni_id, hsess, nadrazeny);
                vysledek.put("seznamRodicu", seznamRodicu);
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, String id_rodic, String konkretni_id, AdminObjektForm f, org.hibernate.Session hsess, MessageResources res) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Objekt objekt = (Objekt)hsess.load(Objekt.class, (Serializable)((Object)id_rodic));
            vysledek.put("vybranyObjekt", objekt);
            Objekt nadrazeny = objekt.getObjekt();
            Object polozka = hsess.load(Class.forName("cz.triangle.elementy." + this.nazevObjektu(objekt.getId())), (Serializable)new Integer(id));
            objekt.getObjekt();
            AdminObjektForm form = f;
            if (form == null) {
                form = new AdminObjektForm();
                ConvertService.registrujCeske();
                this.copyProperties(form.getAtributy(), polozka, objekt);
                ConvertService.odregistrujCeske();
                form.setId_rodic(id_rodic);
                form.setKonkretni_id(id);
            }
            if (nadrazeny != null) {
                form.setAtribut("kod_nadrazeny", BeanUtils.getProperty((Object)nadrazeny, (String)"id"));
            } else {
                form.setAtribut("kod_nadrazeny", id_rodic);
            }
            form.setAtribut("id_nadrazeny", konkretni_id);
            form.setKonkretni_id(konkretni_id);
            try {
                List seznamHistorii = hsess.createQuery("from Historie historie where historie.idObjekt=? and historie.predmet=? order by historie.id desc").setInteger(0, new Integer(id).intValue()).setString(1, this.nazevObjektu(objekt.getId())).setMaxResults(1).list();
                if (seznamHistorii.size() > 0) {
                    Historie historie = (Historie)seznamHistorii.get(0);
                    vysledek.put("historie", historie);
                }
            }
            catch (Exception seznamHistorii) {
                // empty catch block
            }
            form.setAtribut("id", id);
            vysledek.put("adminObjektForm", (Object)form);
            if (konkretni_id != null) {
                List seznamRodicu = this.nactiRodiceProEditaci(konkretni_id, hsess, nadrazeny);
                vysledek.put("seznamRodicu", seznamRodicu);
            }
        }
        catch (Exception e) {
            String zprava;
            String string = zprava = e.getMessage() != null ? e.getMessage() : "";
            if (e.getCause() != null && e.getCause().getMessage() != null) {
                zprava = String.valueOf(zprava) + ", " + e.getCause().getMessage();
                if (e.getCause().getCause() != null && e.getCause().getCause().getMessage() != null) {
                    zprava = String.valueOf(zprava) + ", " + e.getCause().getCause().getMessage();
                }
            }
            vysledek.put("chyba", res.getMessage("admin.chyba.editace_polozky", (Object)zprava));
            HibernateUtil.rollbackTransaction();
        }
        return vysledek;
    }

    private void copyProperties(Map<String, Object> cil, Object zdroj, Objekt popis) throws Exception {
        for (PolozkaObjektu polozkaObjektu : popis.getPolozkaObjektus()) {
            String hodnota = null;
            hodnota = BeanUtils.getProperty((Object)zdroj, (String)this.nazevAtributu(polozkaObjektu.getKod()));
            cil.put(polozkaObjektu.getKod(), hodnota);
        }
        if (popis.getObjekt() != null) {
            Objekt nadrazeny = popis.getObjekt();
            try {
                Object nadrazenaInstance = PropertyUtils.getProperty((Object)zdroj, (String)this.nazevObjektuSMalym(BeanUtils.getProperty((Object)nadrazeny, (String)"id")));
                cil.put("id_nadrazeny", BeanUtils.getProperty((Object)nadrazenaInstance, (String)"id"));
                cil.put("kod_nadrazeny", BeanUtils.getProperty((Object)nadrazeny, (String)"id"));
            }
            catch (Exception e) {
                return;
            }
        }
        try {
            cil.put("kod_nadrazeny", BeanUtils.getProperty((Object)popis, (String)"id"));
        }
        catch (Exception e) {
            return;
        }
    }

    private void copyProperties(Object cil, Map<String, Object> zdroj, Objekt popis) {
        for (PolozkaObjektu polozkaObjektu : popis.getPolozkaObjektus()) {
            Object hodnota = null;
            try {
                Object o = zdroj.get(polozkaObjektu.getKod());
                if (o != null) {
                    BeanUtils.setProperty((Object)cil, (String)this.nazevAtributu(polozkaObjektu.getKod()), (Object)o);
                }
                if (!polozkaObjektu.getTypFormular().equalsIgnoreCase("checkbox") || o != null) continue;
                BeanUtils.setProperty((Object)cil, (String)this.nazevAtributu(polozkaObjektu.getKod()), (Object)Boolean.FALSE);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private String validacniChyba(ActionMessages messages, MessageResources res) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(AdminObjektForm form, ActionMapping mapping, HttpServletRequest request, String cesta, org.hibernate.Session hsess, MessageResources res, String user) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Objekt objekt = (Objekt)hsess.load(Objekt.class, (Serializable)((Object)form.getId_rodic()));
            String hlaska = this.validuj(objekt, form, res);
            if (hlaska != null) {
                vysledek.put("validacni_chyba", hlaska);
                vysledek.put("adminObjektForm", (Object)form);
                return vysledek;
            }
            Class<?> t = Class.forName("cz.triangle.elementy." + this.nazevObjektu(objekt.getId()));
            Object novaPolozka = t.newInstance();
            ConvertService.registrujCeske();
            this.copyProperties(novaPolozka, form.getAtributy(), objekt);
            ConvertService.odregistrujCeske();
            PropertyUtils.setProperty(novaPolozka, (String)"objekt", (Object)objekt);
            if (objekt.getObjekt() != null) {
                Object nadrazenaPolozka = hsess.load(Class.forName("cz.triangle.elementy." + this.nazevObjektu(objekt.getObjekt().getId())), (Serializable)new Integer(form.getKonkretni_id()));
                PropertyUtils.setProperty(novaPolozka, (String)this.nazevObjektuSMalym(objekt.getObjekt().getId()), (Object)nadrazenaPolozka);
            }
            this.zapisSoubory(form, cesta, hsess, objekt, novaPolozka);
            vysledek.put("adminObjektForm", (Object)form);
            Integer noveId = (Integer)hsess.save(novaPolozka);
            vysledek.put("id", noveId);
            if (user != null && user.length() > 0) {
                Historie historie = new Historie();
                historie.setCas(new Date());
                historie.setIdObjekt(noveId);
                historie.setJmeno(user);
                historie.setPredmet(this.nazevObjektu(objekt.getId()));
                hsess.save((Object)historie);
            }
            hsess.flush();
            String zasilat = (String)form.getAtribut("zasilat");
            if (zasilat != null && zasilat.equalsIgnoreCase("ano")) {
                String zakladAdresy = request.getRequestURL().substring(0, request.getRequestURL().indexOf(request.getServletPath()) + 1);
                this.rozesliMail(novaPolozka, objekt, res, cesta, zakladAdresy, hsess);
            }
            if (objekt.getObjekt() != null) {
                form.setAtribut("kod_nadrazeny", objekt.getObjekt().getId());
                form.setAtribut("id_nadrazeny", form.getKonkretni_id());
            } else {
                form.setAtribut("kod_nadrazeny", form.getId_rodic());
            }
        }
        catch (HibernateException e) {
            vysledek.put("chyba", res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private void rozesliMail(Object novaPolozka, Objekt objekt, MessageResources res, String cesta, String zakladAdresy, org.hibernate.Session hsess) throws AddressException, MessagingException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        ConvertService.registrujCeske();
        List seznamMailu = hsess.createQuery("from ZasilaniObjektu zasilaniObjektu where zasilaniObjektu.objekt=? and zasilaniObjektu.potvrzeno = true").setEntity(0, (Object)objekt).list();
        Properties props = new Properties();
        props.put("mail.smtp.host", res.getMessage("mail.host"));
        Session mailsession = Session.getDefaultInstance((Properties)props, null);
        StringBuffer obsah = new StringBuffer(res.getMessage("odebirani.1"));
        for (PolozkaObjektu polozkaObjektu : objekt.getPolozkaObjektus()) {
            String hodnota = null;
            String nazevAtributu = this.nazevAtributu(polozkaObjektu.getKod());
            hodnota = BeanUtils.getProperty((Object)novaPolozka, (String)nazevAtributu);
            if (polozkaObjektu.getKod().equalsIgnoreCase("id") || polozkaObjektu.getKod().equalsIgnoreCase("id_objekt") || polozkaObjektu.getKod().equalsIgnoreCase("zasilat") || hodnota == null) continue;
            if (polozkaObjektu.getTypFormular().equalsIgnoreCase("file")) {
                obsah.append(polozkaObjektu.getNazev());
                obsah.append(": ");
                obsah.append(zakladAdresy);
                obsah.append("dbimg/");
                obsah.append(hodnota);
                obsah.append("\n");
                continue;
            }
            obsah.append(polozkaObjektu.getNazev());
            obsah.append(": ");
            obsah.append(hodnota);
            obsah.append("\n");
        }
        Iterator iter2 = seznamMailu.iterator();
        while (iter2.hasNext()) {
            StringBuffer obsahKonkretni = new StringBuffer(obsah);
            ZasilaniObjektu zasilaniObjektu = (ZasilaniObjektu)iter2.next();
            MimeMessage mesg = new MimeMessage(mailsession);
            mesg.setFrom((Address)new InternetAddress(res.getMessage("mail.from")));
            mesg.addRecipient(Message.RecipientType.TO, (Address)new InternetAddress(zasilaniObjektu.getEmail()));
            mesg.setSubject(String.valueOf(res.getMessage("odebirani.subject")) + ": " + BeanUtils.getProperty((Object)novaPolozka, (String)this.nazevAtributu("nazev")), "UTF-8");
            obsahKonkretni.append(res.getMessage("odebirani.2"));
            obsahKonkretni.append(String.valueOf(zakladAdresy) + "oznamovani-akci.do?akce=odregistrovani&id=" + zasilaniObjektu.getId() + "&kontrola=" + zasilaniObjektu.getKontrola());
            mesg.setText(obsahKonkretni.toString(), "UTF-8");
            Transport.send((Message)mesg);
        }
        ConvertService.odregistrujCeske();
    }

    private void zapisSoubory(AdminObjektForm form, String cesta, org.hibernate.Session hsess, Objekt objekt, Object polozka) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        long privesek = Math.round(Math.random() * 1000.0);
        List atributySoubory = hsess.createQuery("from PolozkaObjektu polozka where polozka.typFormular='file' and polozka.objekt=?").setEntity(0, (Object)objekt).list();
        for (PolozkaObjektu polozkaObjektu : atributySoubory) {
            String smazatSoubor = (String)form.getAtribut("smazatsoubor" + polozkaObjektu.getKod());
            String staryNazev = BeanUtils.getProperty((Object)polozka, (String)polozkaObjektu.getKod());
            if (smazatSoubor != null && smazatSoubor.equalsIgnoreCase("true")) {
                this.smazatSoubor(String.valueOf(cesta) + "dbimg", staryNazev);
                if (polozkaObjektu.getHodnoty() != null && polozkaObjektu.getHodnoty().length() > 0) {
                    this.smazatSoubor(String.valueOf(cesta) + "dbimg", "m" + staryNazev);
                    this.smazatSoubor(String.valueOf(cesta) + "dbimg", "mm" + staryNazev);
                }
                BeanUtils.setProperty((Object)polozka, (String)polozkaObjektu.getKod(), null);
                continue;
            }
            FormFile file = (FormFile)form.getAtribut("soubor" + polozkaObjektu.getKod());
            if (file == null || file.getFileName().length() <= 0) continue;
            String nazevSouboru = this.prepisSoubor(String.valueOf(cesta) + "dbimg", privesek, file, staryNazev);
            this.smazatSoubor(String.valueOf(cesta) + "dbimg", "m" + staryNazev);
            this.smazatSoubor(String.valueOf(cesta) + "dbimg", "mm" + staryNazev);
            BeanUtils.setProperty((Object)polozka, (String)polozkaObjektu.getKod(), (Object)nazevSouboru);
            if (polozkaObjektu.getHodnoty() == null || polozkaObjektu.getHodnoty().length() <= 0) continue;
            try {
                StringTokenizer st = new StringTokenizer(polozkaObjektu.getHodnoty(), ",");
                Map info = Obrazek.resize(String.valueOf(cesta) + "dbimg" + File.separator + nazevSouboru, String.valueOf(cesta) + "dbimg" + File.separator + "m" + nazevSouboru, Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), "both", 90, false);
                info = Obrazek.resize(String.valueOf(cesta) + "dbimg" + File.separator + "m" + nazevSouboru, String.valueOf(cesta) + "dbimg" + File.separator + "mm" + nazevSouboru, Integer.parseInt(st.nextToken()), Integer.parseInt(st.nextToken()), "both", 90, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void smazatSoubory(String cesta, org.hibernate.Session hsess, Objekt objekt, Object polozka) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        long privesek = Math.round(Math.random() * 1000.0);
        List atributySoubory = hsess.createQuery("from PolozkaObjektu polozka where polozka.typFormular='file' and polozka.objekt=?").setEntity(0, (Object)objekt).list();
        for (PolozkaObjektu polozkaObjektu : atributySoubory) {
            String nazevSouboru = BeanUtils.getProperty((Object)polozka, (String)polozkaObjektu.getKod());
            if (nazevSouboru == null || nazevSouboru.length() <= 0) continue;
            this.smazatSoubor(String.valueOf(cesta) + "dbimg", nazevSouboru);
            if (polozkaObjektu.getHodnoty() == null || polozkaObjektu.getHodnoty().length() <= 0) continue;
            this.smazatSoubor(String.valueOf(cesta) + "dbimg", "m" + nazevSouboru);
            this.smazatSoubor(String.valueOf(cesta) + "dbimg", "mm" + nazevSouboru);
        }
    }

    public Map zapsatPolozku(AdminObjektForm form, String id, ActionMapping mapping, HttpServletRequest request, String cesta, org.hibernate.Session hsess, MessageResources res, String user) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Objekt objekt = (Objekt)hsess.load(Objekt.class, (Serializable)((Object)form.getId_rodic()));
            String hlaska = this.validuj(objekt, form, res);
            if (hlaska != null) {
                vysledek.put("validacni_chyba", hlaska);
                vysledek.put("adminObjektForm", (Object)form);
                return vysledek;
            }
            Object polozka = hsess.load(Class.forName("cz.triangle.elementy." + this.nazevObjektu(objekt.getId())), (Serializable)new Integer(id));
            ConvertService.registrujCeske();
            this.copyProperties(polozka, form.getAtributy(), objekt);
            ConvertService.odregistrujCeske();
            PropertyUtils.setProperty((Object)polozka, (String)"objekt", (Object)objekt);
            if (objekt.getObjekt() != null) {
                Object nadrazenaPolozka = hsess.load(Class.forName("cz.triangle.elementy." + this.nazevObjektu(objekt.getObjekt().getId())), (Serializable)new Integer(form.getKonkretni_id()));
                PropertyUtils.setProperty((Object)polozka, (String)this.nazevObjektuSMalym(objekt.getObjekt().getId()), (Object)nadrazenaPolozka);
            }
            this.zapisSoubory(form, cesta, hsess, objekt, polozka);
            vysledek.put("adminObjektForm", (Object)form);
            vysledek.put("id", new Integer(id));
            if (user != null && user.length() > 0) {
                Historie historie = new Historie();
                historie.setCas(new Date());
                historie.setIdObjekt(new Integer(id));
                historie.setJmeno(user);
                historie.setPredmet(this.nazevObjektu(objekt.getId()));
                hsess.save((Object)historie);
            }
            hsess.flush();
            String zasilat = (String)form.getAtribut("zasilat");
            if (zasilat != null && zasilat.equalsIgnoreCase("ano")) {
                String zakladAdresy = request.getRequestURL().substring(0, request.getRequestURL().indexOf(request.getServletPath()) + 1);
                this.rozesliMail(polozka, objekt, res, cesta, zakladAdresy, hsess);
            }
            if (objekt.getObjekt() != null) {
                form.setAtribut("kod_nadrazeny", objekt.getObjekt().getId());
                form.setAtribut("id_nadrazeny", form.getKonkretni_id());
            } else {
                form.setAtribut("kod_nadrazeny", form.getId_rodic());
            }
        }
        catch (HibernateException e) {
            vysledek.put("chyba", res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map smazatPolozku(String id, String id_rodic, String cesta, String konkretni_id, org.hibernate.Session hsess, MessageResources res, String user) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        try {
            Objekt objekt = (Objekt)hsess.load(Objekt.class, (Serializable)((Object)id_rodic));
            Object polozka = hsess.load(Class.forName("cz.triangle.elementy." + this.nazevObjektu(objekt.getId())), (Serializable)new Integer(id));
            this.smazatSoubory(cesta, hsess, objekt, polozka);
            hsess.delete(polozka);
            if (user != null && user.length() > 0) {
                Historie historie = new Historie();
                historie.setCas(new Date());
                historie.setIdObjekt(new Integer(id));
                historie.setJmeno(user);
                historie.setPredmet(this.nazevObjektu(objekt.getId()));
                hsess.save((Object)historie);
            }
            if (objekt.getObjekt() != null) {
                vysledek.put("kod_nadrazeny", objekt.getObjekt().getId());
                vysledek.put("id_nadrazeny", konkretni_id);
            } else {
                vysledek.put("kod_nadrazeny", id_rodic);
            }
            hsess.flush();
        }
        catch (HibernateException e) {
            e.printStackTrace();
            vysledek.put("chyba", res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            HibernateUtil.rollbackTransaction();
        }
        catch (Exception e) {
            vysledek.put("chyba", res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public void otevriVybrany() {
        if (this.vybraneMenuComponent != null) {
            MenuComponent tmp = this.vybraneMenuComponent.getParent();
            while (tmp != null) {
                tmp.setOpen(true);
                tmp = tmp.getParent();
            }
        }
    }

    private String prepisSoubor(String cesta, long privesek, FormFile file, String staryNazev) {
        if (file != null && !file.getFileName().equalsIgnoreCase("")) {
            if (staryNazev != null && staryNazev.length() > 0) {
                this.smazatSoubor(cesta, staryNazev);
            }
            String koncovka = file.getFileName().substring(file.getFileName().lastIndexOf("."));
            String predek = file.getFileName().substring(0, file.getFileName().lastIndexOf("."));
            String novyNazev = this.vytvorNazevSouboru(predek, cesta, koncovka);
            this.zapisSoubor(file, cesta, String.valueOf(novyNazev) + koncovka);
            return String.valueOf(novyNazev) + koncovka;
        }
        return null;
    }

    private void smazatSoubor(String cesta, String staryNazev) {
        new File(String.valueOf(cesta) + File.separator + staryNazev).delete();
    }

    private String vytvorNazevSouboru(String soubor, String umisteni, String koncovka) {
        String vysledek = UpravaRetezce.odstranVse(soubor);
        int i = 1;
        while (new File(String.valueOf(umisteni) + File.separator + vysledek + koncovka).exists()) {
            vysledek = String.valueOf(vysledek) + i;
        }
        return vysledek;
    }

    private boolean zapisSoubor(FormFile file, String umisteni, String soubor) {
        boolean vysledek = true;
        try {
            FileOutputStream bos = new FileOutputStream(String.valueOf(umisteni) + File.separator + soubor);
            InputStream stream = file.getInputStream();
            int bytesRead = 0;
            byte[] buffer = new byte[8192];
            while ((bytesRead = stream.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)bos).write(buffer, 0, bytesRead);
            }
            ((OutputStream)bos).close();
        }
        catch (IOException e) {
            return false;
        }
        return vysledek;
    }

    public String velkePrvniPismeno(String vstup) {
        return String.valueOf(vstup.substring(0, 1).toUpperCase()) + vstup.substring(1);
    }

    public String nazevObjektu(String vstup) {
        StringBuffer sb = new StringBuffer("Objekt");
        int i = 0;
        while (i < vstup.length()) {
            char znak = vstup.charAt(i);
            if (i == 0) {
                sb.append(vstup.substring(0, 1).toUpperCase());
            } else if (znak == '_' && vstup.length() > i + 1) {
                sb.append(vstup.substring(++i, i + 1).toUpperCase());
            } else {
                sb.append(vstup.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public String nazevObjektuSMalym(String vstup) {
        StringBuffer sb = new StringBuffer("objekt");
        int i = 0;
        while (i < vstup.length()) {
            char znak = vstup.charAt(i);
            if (i == 0) {
                sb.append(vstup.substring(0, 1).toUpperCase());
            } else if (znak == '_' && vstup.length() > i + 1) {
                sb.append(vstup.substring(++i, i + 1).toUpperCase());
            } else {
                sb.append(vstup.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public String nazevAtributu(String vstup) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < vstup.length()) {
            char znak = vstup.charAt(i);
            if (znak == '_' && vstup.length() > i + 1) {
                sb.append(vstup.substring(++i, i + 1).toUpperCase());
            } else {
                sb.append(vstup.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }

    public String seznamPolozek(Set set) {
        int i = 0;
        StringBuffer sb = new StringBuffer();
        for (PolozkaObjektu polozka : set) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.nazevAtributu(polozka.getKod()));
            ++i;
        }
        return sb.toString();
    }

    public String seznamPolozekRazeni(Set set) {
        int i = 0;
        StringBuffer sb = new StringBuffer();
        for (PolozkaObjektu polozka : set) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(this.nazevAtributu(polozka.getKod()));
            if (polozka.getSeznamRazeniSmer() != null && polozka.getSeznamRazeniSmer().equalsIgnoreCase("desc")) {
                sb.append(" desc");
            }
            ++i;
        }
        return sb.toString();
    }

    public String SqlCreateObjekt(Objekt objekt) {
        StringBuffer sb = new StringBuffer("create table objekt_");
        sb.append(objekt.getId());
        sb.append("\n(\n");
        sb.append("\tid serial not null,\n");
        sb.append("\tid_objekt character varying(40),\n");
        for (PolozkaObjektu polozka : objekt.getPolozkaObjektus()) {
            sb.append("\t");
            sb.append(polozka.getKod());
            sb.append(" ");
            sb.append(polozka.getTypDatabaze());
            if (polozka.getTypDatabaze().equalsIgnoreCase("character varying")) {
                sb.append("(" + polozka.getPocetZnaku() + ")");
            }
            sb.append(",\n");
        }
        if (objekt.getObjekt() != null) {
            sb.append("\tid_objekt_" + objekt.getObjekt().getId() + " integer,\n");
            sb.append("\tCONSTRAINT fk_objekt_" + objekt.getId() + "_objekt_" + objekt.getObjekt().getId() + " FOREIGN KEY " + "(id_objekt_" + objekt.getObjekt().getId() + ") REFERENCES objekt_" + objekt.getObjekt().getId() + " (id) MATCH SIMPLE " + "ON UPDATE CASCADE ON DELETE CASCADE,\n");
        }
        sb.append("\tCONSTRAINT fk_objekt_" + objekt.getId() + "_objekt FOREIGN KEY " + "(id_objekt) REFERENCES objekt (id) MATCH SIMPLE " + "ON UPDATE CASCADE ON DELETE CASCADE,\n");
        sb.append("\tconstraint objekt_" + objekt.getId() + "_pkey primary key (id)\n");
        sb.append(");");
        return sb.toString();
    }

    private String validuj(Objekt objekt, AdminObjektForm f, MessageResources res) {
        String hlaska = null;
        for (PolozkaObjektu polozkaObjektu : objekt.getPolozkaObjektus()) {
            String hodnota = (String)f.getAtribut(polozkaObjektu.getKod());
            if (polozkaObjektu.getValidacePozadovan() != null && polozkaObjektu.getValidacePozadovan().booleanValue() && GenericValidator.isBlankOrNull((String)hodnota)) {
                return res.getMessage(new Locale("CS", "cz"), "errors.required", (Object)polozkaObjektu.getNazev());
            }
            if (polozkaObjektu.getValidaceTyp() == null || polozkaObjektu.getValidaceTyp().length() <= 0 || GenericValidator.isBlankOrNull((String)hodnota)) continue;
            if (polozkaObjektu.getValidaceTyp().equals("bezdiak") && !GenericValidator.matchRegexp((String)hodnota, (String)"^[a-z\\-]*$")) {
                return res.getMessage(new Locale("CS", "cz"), "errors.invalid", (Object)polozkaObjektu.getNazev(), (Object)res.getMessage(new Locale("CS", "cz"), "format.bezdiak"));
            }
            if (polozkaObjektu.getValidaceTyp().equals("rozpeti")) {
                int max;
                StringTokenizer st;
                int min;
                if (!GenericValidator.isInt((String)hodnota)) {
                    return res.getMessage(new Locale("CS", "cz"), "errors.integer", (Object)polozkaObjektu.getNazev());
                }
                int hodnotaInt = Integer.parseInt(hodnota);
                if (!GenericValidator.isInRange((int)hodnotaInt, (int)(min = Integer.parseInt((st = new StringTokenizer(polozkaObjektu.getValidaceParametry(), ",")).nextToken())), (int)(max = Integer.parseInt(st.nextToken())))) {
                    return res.getMessage(new Locale("CS", "cz"), "errors.range", (Object)polozkaObjektu.getNazev(), (Object)min, (Object)max);
                }
            }
            if (polozkaObjektu.getValidaceTyp().equals("datum") && !GenericValidator.matchRegexp((String)hodnota, (String)"^(([0-2]?[0-9])|(3[01])).?((0?[0-9])|(1[012])).((19|20)[0-9]{2})$")) {
                return res.getMessage(new Locale("CS", "cz"), "errors.invalid", (Object)polozkaObjektu.getNazev(), (Object)res.getMessage(new Locale("CS", "cz"), "format.datum"));
            }
            if (polozkaObjektu.getValidaceTyp().equals("ceske_cislo") && !GenericValidator.matchRegexp((String)hodnota, (String)"^[0-9]*,?[0-9]*$")) {
                return res.getMessage(new Locale("CS", "cz"), "errors.invalid", (Object)polozkaObjektu.getNazev(), (Object)res.getMessage(new Locale("CS", "cz"), "format.ceske_cislo"));
            }
            if (polozkaObjektu.getValidaceTyp().equals("url") && !GenericValidator.matchRegexp((String)hodnota, (String)"^s?https?:\\/\\/[-_.!~*'()a-zA-Z0-9;\\/?:\\@&=+\\$,%#]+$")) {
                return res.getMessage(new Locale("CS", "cz"), "errors.url", (Object)polozkaObjektu.getNazev());
            }
            if (!polozkaObjektu.getValidaceTyp().equals("email") || GenericValidator.isEmail((String)hodnota)) continue;
            return res.getMessage(new Locale("CS", "cz"), "errors.email", (Object)polozkaObjektu.getNazev());
        }
        return hlaska;
    }

    private List nactiRodiceProEditaci(String konkretni_id, org.hibernate.Session hsess, Objekt nadrazeny) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        List seznamRodicu = null;
        if (nadrazeny.getObjekt() != null) {
            Object nadrazenaPolozka = hsess.load(Class.forName("cz.triangle.elementy." + this.nazevObjektu(nadrazeny.getId())), (Serializable)new Integer(konkretni_id));
            Object nadrazenaNadrazenePolozky = PropertyUtils.getProperty((Object)nadrazenaPolozka, (String)this.nazevObjektuSMalym(nadrazeny.getObjekt().getId()));
            Integer nadrazene_konkretni_id = null;
            nadrazene_konkretni_id = nadrazenaNadrazenePolozky == null ? (Integer)PropertyUtils.getProperty((Object)nadrazenaPolozka, (String)"id") : (Integer)PropertyUtils.getProperty((Object)nadrazenaNadrazenePolozky, (String)"id");
            seznamRodicu = hsess.createQuery(" from " + this.nazevObjektu(BeanUtils.getProperty((Object)nadrazeny, (String)"id")) + " " + " where " + this.nazevObjektuSMalym(nadrazeny.getObjekt().getId()) + ".id=" + nadrazene_konkretni_id + " order by nazev").list();
        } else {
            seznamRodicu = hsess.createQuery(" from " + this.nazevObjektu(BeanUtils.getProperty((Object)nadrazeny, (String)"id")) + " " + " order by nazev").list();
        }
        return seznamRodicu;
    }

    public String getPodminkaFiltr(Objekt objekt, Map parametryZeStranky) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        Iterator iterator = objekt.getFiltry().keySet().iterator();
        while (iterator.hasNext()) {
            String klic = this.nazevAtributu((String)iterator.next());
            String[] parametrPole = (String[])parametryZeStranky.get(String.valueOf(objekt.getId()) + "_" + klic);
            String hodnota = null;
            if (parametrPole != null) {
                hodnota = parametrPole[0];
            }
            if (hodnota == null || hodnota.trim().length() <= 0 || hodnota.equalsIgnoreCase("-1")) continue;
            if (i > 0) {
                sb.append(" and ");
            }
            sb.append(klic);
            sb.append("='");
            sb.append(hodnota);
            sb.append("'");
            ++i;
        }
        return sb.toString();
    }
}

