/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.util;

import cz.triangle.util.HibernateUtil;
import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.SessionFactory;
import org.hibernate.StaleObjectStateException;

public class HibernateSessionRequestFilter
implements Filter {
    private static Log log = LogFactory.getLog(HibernateSessionRequestFilter.class);

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SessionFactory sf = HibernateUtil.getSessionFactory();
        try {
            log.debug((Object)"Starting a database transaction");
            sf.getCurrentSession().beginTransaction();
            chain.doFilter(request, response);
            log.debug((Object)"Committing the database transaction");
            if (sf.getCurrentSession().getTransaction().isActive()) {
                sf.getCurrentSession().getTransaction().commit();
            }
        }
        catch (StaleObjectStateException staleEx) {
            log.error((Object)"This interceptor does not implement optimistic concurrency control!");
            log.error((Object)"Your application will not work until you add compensation actions!");
            throw staleEx;
        }
        catch (Throwable ex) {
            ex.printStackTrace();
            try {
                if (sf.getCurrentSession().getTransaction().isActive()) {
                    log.debug((Object)"Trying to rollback database transaction after exception");
                    sf.getCurrentSession().getTransaction().rollback();
                }
            }
            catch (Throwable rbEx) {
                log.error((Object)"Could not rollback transaction after exception!", rbEx);
            }
            throw new ServletException(ex);
        }
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void destroy() {
    }
}

