/*
 * Decompiled with CFR 0.152.
 */
package org.ajaxtags.tags;

import java.io.IOException;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import javax.servlet.jsp.tagext.Tag;
import org.ajaxtags.helpers.AjaxHtmlHelper;
import org.apache.commons.lang.StringUtils;
import org.apache.taglibs.standard.lang.support.ExpressionEvaluatorManager;

public class AjaxAreaTag
extends BodyTagSupport {
    private static final long serialVersionUID = -7940387487602588115L;
    private String ajaxFlag = "ajax";
    private String style;
    private String styleClass;
    private String ajaxAnchors = "false";
    private boolean ajax = false;

    public String getAjaxFlag() {
        return this.ajaxFlag;
    }

    public void setAjaxFlag(String string) {
        this.ajaxFlag = string;
    }

    public String getStyle() {
        return this.style;
    }

    public void setStyle(String string) {
        this.style = string;
    }

    public String getStyleClass() {
        return this.styleClass;
    }

    public void setStyleClass(String string) {
        this.styleClass = string;
    }

    public String getAjaxAnchors() {
        return this.ajaxAnchors;
    }

    public void setAjaxAnchors(String string) {
        this.ajaxAnchors = string;
    }

    public int doStartTag() throws JspException {
        this.initParameters();
        if (this.ajax) {
            try {
                this.pageContext.getOut().clearBuffer();
            }
            catch (IOException iOException) {
                throw new JspException(iOException.getMessage());
            }
        }
        JspWriter jspWriter = this.pageContext.getOut();
        try {
            jspWriter.print("<div");
            if (StringUtils.isNotBlank((String)this.id)) {
                jspWriter.print(" id='" + this.id + "'");
            }
            if (StringUtils.isNotBlank((String)this.styleClass)) {
                jspWriter.print(" class='" + this.styleClass + "'");
            }
            if (StringUtils.isNotBlank((String)this.style)) {
                jspWriter.print(" style='" + this.style + "'");
            }
            jspWriter.print(">");
        }
        catch (IOException iOException) {
            throw new JspException(iOException.getMessage());
        }
        return 2;
    }

    public int doEndTag() throws JspException {
        JspWriter jspWriter = this.pageContext.getOut();
        String string = this.bodyContent.getString();
        try {
            string = this.processContent(string);
            jspWriter.println(string);
            if (!this.ajax) {
                jspWriter.println("</div>");
            }
        }
        catch (IOException iOException) {
            throw new JspException(iOException.getMessage());
        }
        return this.ajax ? 5 : 6;
    }

    public void release() {
        this.ajaxFlag = null;
        this.style = null;
        this.ajaxAnchors = null;
        this.styleClass = null;
        super.release();
    }

    protected void initParameters() throws JspException {
        if (this.ajaxFlag != null) {
            this.ajaxFlag = (String)ExpressionEvaluatorManager.evaluate((String)"ajaxFlag", (String)this.ajaxFlag, String.class, (Tag)this, (PageContext)this.pageContext);
        }
        if (this.style != null) {
            this.style = (String)ExpressionEvaluatorManager.evaluate((String)"style", (String)this.style, String.class, (Tag)this, (PageContext)this.pageContext);
        }
        if (this.styleClass != null) {
            this.styleClass = (String)ExpressionEvaluatorManager.evaluate((String)"styleClass", (String)this.styleClass, String.class, (Tag)this, (PageContext)this.pageContext);
        }
        if (this.ajaxAnchors != null) {
            this.ajaxAnchors = (String)ExpressionEvaluatorManager.evaluate((String)"ajaxAnchors", (String)this.ajaxAnchors, String.class, (Tag)this, (PageContext)this.pageContext);
        }
        this.ajax = Boolean.valueOf(this.pageContext.getRequest().getParameter(this.ajaxFlag));
    }

    protected String processContent(String string) {
        return Boolean.valueOf(this.ajaxAnchors) != false ? AjaxHtmlHelper.ajaxAnchors(string, this.id, this.ajaxFlag) : string;
    }
}

