/*
 * Decompiled with CFR 0.152.
 */
package cn.bluejoe.elfinder.controller.executors;

import cn.bluejoe.elfinder.controller.executor.AbstractCommandExecutor;
import cn.bluejoe.elfinder.controller.executor.CommandExecutor;
import cn.bluejoe.elfinder.controller.executor.FsItemEx;
import cn.bluejoe.elfinder.service.FsService;
import com.mortennobel.imagescaling.DimensionConstrain;
import com.mortennobel.imagescaling.ResampleOp;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Date;
import javax.imageio.ImageIO;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.time.DateUtils;

public class TmbCommandExecutor
extends AbstractCommandExecutor
implements CommandExecutor {
    @Override
    public void execute(FsService fsService, HttpServletRequest request, HttpServletResponse response, ServletContext servletContext) throws Exception {
        String target = request.getParameter("target");
        FsItemEx fsi = super.findItem(fsService, target);
        InputStream is = fsi.openInputStream();
        BufferedImage image = ImageIO.read(is);
        int width = fsService.getServiceConfig().getTmbWidth();
        ResampleOp rop = new ResampleOp(DimensionConstrain.createMaxDimension((int)width, (int)-1));
        rop.setNumberOfThreads(4);
        BufferedImage b = rop.filter(image, null);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)b, "png", baos);
        byte[] bytesOut = baos.toByteArray();
        is.close();
        response.setHeader("Last-Modified", DateUtils.addDays((Date)Calendar.getInstance().getTime(), (int)720).toGMTString());
        response.setHeader("Expires", DateUtils.addDays((Date)Calendar.getInstance().getTime(), (int)720).toGMTString());
        ImageIO.write((RenderedImage)b, "png", (OutputStream)response.getOutputStream());
    }
}

