/*
 * Decompiled with CFR 0.152.
 */
package cz.rtnext.smartclient.service;

import cz.rtnext.smartclient.mvc.SmartClientRequest;
import cz.rtnext.smartclient.util.ScDateConverter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.sql.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.beanutils.Converter;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.SimpleExpression;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.type.IntegerType;
import org.hibernate.type.Type;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Lazy
@Transactional
public class ScDataService {
    @Autowired
    protected SessionFactory sessionFactory;

    public Map execute(SmartClientRequest parametry, Map<String, String> predaneAtributy, String cesta) throws Exception {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        vysledek.put("typ", parametry.get_operationType());
        vysledek.put("typDat", parametry.get_typDat());
        vysledek.put("status", new Integer(0));
        try {
            if (parametry.get_operationType().equalsIgnoreCase("fetch")) {
                this.fetch(parametry, predaneAtributy, vysledek);
            }
            if (parametry.get_operationType().equalsIgnoreCase("add")) {
                this.add(parametry, predaneAtributy, vysledek);
            }
            if (parametry.get_operationType().equalsIgnoreCase("update")) {
                this.update(parametry, predaneAtributy, vysledek);
            }
            if (parametry.get_operationType().equalsIgnoreCase("remove")) {
                this.remove(parametry, predaneAtributy, vysledek, cesta);
            }
            if (parametry.get_operationType().equalsIgnoreCase("reorder")) {
                this.reorder(parametry, predaneAtributy, vysledek);
            }
        }
        catch (HibernateException e) {
            e.printStackTrace();
            vysledek.put("chyba", e.getMessage() != null ? e.getMessage() : "");
            vysledek.put("typ", "chyba");
        }
        catch (Exception e) {
            e.printStackTrace();
            vysledek.put("chyba", e.getMessage() != null ? e.getMessage() : "");
            vysledek.put("typ", "chyba");
        }
        return vysledek;
    }

    @Transactional
    public void reorder(SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek) throws Exception {
        Class<?> trida = Class.forName(parametry.get_class());
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(trida);
        String idName = this.sessionFactory.getClassMetadata(trida).getIdentifierPropertyName();
        for (String klic : predaneAtributy.keySet()) {
            if (klic.equalsIgnoreCase(idName)) continue;
            String hodnota = new String(predaneAtributy.get(klic).getBytes("ISO-8859-1"), "utf-8");
            if (klic.startsWith("id_")) {
                String podklic = this.nazevAtributu(klic.substring(3));
                if (hodnota.equalsIgnoreCase("null") || hodnota.equalsIgnoreCase("-1")) {
                    Criterion itemNameRestriction = Restrictions.isNull((String)(String.valueOf(podklic) + ".id"));
                    criteria.add(itemNameRestriction);
                    continue;
                }
                Serializable idZavisleho = this.vratKonvertovanouHodnotu(trida, klic, hodnota);
                SimpleExpression zavislostNaObjektu = Restrictions.eq((String)(String.valueOf(podklic) + ".id"), (Object)idZavisleho);
                criteria.add((Criterion)zavislostNaObjektu);
                continue;
            }
            Criterion itemNameRestriction = Restrictions.ilike((String)klic, (String)hodnota, (MatchMode)MatchMode.ANYWHERE);
            criteria.add(itemNameRestriction);
        }
        criteria.addOrder(Order.asc((String)"razeni"));
        List matchingItems = criteria.list();
        Object polozka = this.sessionFactory.getCurrentSession().load(trida, (Serializable)new Integer(predaneAtributy.get(idName)));
        this.predejPromenne(polozka, parametry, predaneAtributy, vysledek);
        int index = parametry.get_index();
        int vyhozeneRazeni = 0;
        vyhozeneRazeni = index == 0 ? 0 : (index == matchingItems.size() ? (Integer)PropertyUtils.getProperty(matchingItems.get(index - 1), (String)"razeni") + 1 : (Integer)PropertyUtils.getProperty(matchingItems.get(index), (String)"razeni"));
        PropertyUtils.setProperty((Object)polozka, (String)"razeni", (Object)vyhozeneRazeni);
        int noveRazeni = vyhozeneRazeni + 1;
        int i = index;
        while (i < matchingItems.size()) {
            Object tmpO = matchingItems.get(i);
            if (tmpO != polozka) {
                PropertyUtils.setProperty(tmpO, (String)"razeni", (Object)noveRazeni);
                ++noveRazeni;
            }
            ++i;
        }
        vysledek.put("zaznam", polozka);
    }

    @Transactional
    public void remove(SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek, String cesta) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException {
        Class<?> trida = Class.forName(parametry.get_class());
        String idName = this.sessionFactory.getClassMetadata(trida).getIdentifierPropertyName();
        Serializable id = this.pripravId(trida, (Serializable)((Object)predaneAtributy.get(idName)));
        Object polozka = this.sessionFactory.getCurrentSession().load(trida, id);
        this.sessionFactory.getCurrentSession().delete(polozka);
        vysledek.put(idName, id);
    }

    @Transactional
    public void fetch(SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek) throws Exception {
        if (parametry.get_typDat() != null && parametry.get_typDat().equalsIgnoreCase("sql")) {
            this.sqlFetch(vysledek, parametry, predaneAtributy);
        } else {
            vysledek.put("dodatecneAtributy", parametry.get_dodatecneAtributy());
            this.hibernateFetch(vysledek, parametry, predaneAtributy);
        }
    }

    @Transactional
    public void add(SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek) throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception, InvocationTargetException, NoSuchMethodException {
        Class<?> trida = Class.forName(parametry.get_class());
        Object novaPolozka = trida.newInstance();
        if (!this.predejPromenne(novaPolozka, parametry, predaneAtributy, vysledek)) {
            return;
        }
        if (PropertyUtils.describe(novaPolozka).containsKey("razeni") && PropertyUtils.getProperty(novaPolozka, (String)"razeni") == null) {
            Integer nej = (Integer)this.sessionFactory.getCurrentSession().createQuery("select max(razeni) from " + novaPolozka.getClass().getSimpleName()).uniqueResult();
            nej = nej == null ? Integer.valueOf(0) : Integer.valueOf(nej + 1);
            PropertyUtils.setProperty(novaPolozka, (String)"razeni", (Object)nej);
        }
        this.sessionFactory.getCurrentSession().save(novaPolozka);
        this.sessionFactory.getCurrentSession().flush();
        vysledek.put("zaznam", novaPolozka);
    }

    @Transactional
    public void update(SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek) throws ClassNotFoundException, InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, Exception {
        Class<?> trida = Class.forName(parametry.get_class());
        String idName = this.sessionFactory.getClassMetadata(trida).getIdentifierPropertyName();
        Serializable id = this.pripravId(trida, (Serializable)((Object)predaneAtributy.get(idName)));
        Object polozka = this.sessionFactory.getCurrentSession().load(trida, id);
        if (!this.predejPromenne(polozka, parametry, predaneAtributy, vysledek)) {
            return;
        }
        this.sessionFactory.getCurrentSession().flush();
        vysledek.put("zaznam", polozka);
    }

    @Transactional
    protected Map hibernateFetch(Map vysledek, SmartClientRequest parametry, Map<String, String> predaneAtributy) throws ClassNotFoundException, UnsupportedEncodingException, SecurityException, InstantiationException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException {
        String _sortBy;
        Long _startRow = parametry.get_startRow();
        Long _endRow = parametry.get_endRow();
        if (_startRow == null) {
            _startRow = 0L;
        }
        if (_endRow == null) {
            _endRow = 0L;
        }
        Class<?> trida = Class.forName(parametry.get_class());
        ClassMetadata meta = this.sessionFactory.getClassMetadata(trida);
        String idName = meta.getIdentifierPropertyName();
        Criteria criteria = this.sessionFactory.getCurrentSession().createCriteria(trida);
        for (String klic : predaneAtributy.keySet()) {
            String hodnota;
            if (klic.startsWith("_") || !this.specialniFiltr(klic, hodnota = predaneAtributy.get(klic), criteria)) continue;
            if (klic.startsWith("id_")) {
                String podklic = this.nazevAtributu(klic.substring(3));
                if (hodnota.equalsIgnoreCase("null") || hodnota.equalsIgnoreCase("-1")) {
                    Criterion itemNameRestriction = Restrictions.isNull((String)(String.valueOf(podklic) + ".id"));
                    criteria.add(itemNameRestriction);
                    continue;
                }
                Serializable idZavisleho = this.vratKonvertovanouHodnotu(trida, klic, hodnota);
                SimpleExpression zavislostNaObjektu = Restrictions.eq((String)(String.valueOf(podklic) + ".id"), (Object)idZavisleho);
                criteria.add((Criterion)zavislostNaObjektu);
                continue;
            }
            if (klic.equalsIgnoreCase(idName)) {
                Serializable id = this.pripravId(trida, (Serializable)((Object)hodnota));
                criteria.add((Criterion)Restrictions.eq((String)klic, (Object)id));
                continue;
            }
            Object itemNameRestriction = null;
            itemNameRestriction = hodnota.equalsIgnoreCase("false") || hodnota.equalsIgnoreCase("true") ? (hodnota.equalsIgnoreCase("false") ? Restrictions.or((Criterion)Restrictions.isNull((String)klic), (Criterion)Restrictions.eq((String)klic, (Object)new Boolean(hodnota))) : Restrictions.eq((String)klic, (Object)new Boolean(hodnota))) : Restrictions.ilike((String)klic, (String)hodnota, (MatchMode)MatchMode.ANYWHERE);
            criteria.add(itemNameRestriction);
        }
        if (parametry.get_joinObjekty() != null) {
            StringTokenizer st = new StringTokenizer(parametry.get_joinObjekty(), ",");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                criteria.createAlias(token, token, 1);
            }
        }
        if (parametry.get_distinct() != null && parametry.get_distinct().length() > 0) {
            criteria.setProjection((Projection)Projections.countDistinct((String)parametry.get_distinct()));
            vysledek.put("distinct", parametry.get_distinct());
        } else {
            criteria.setProjection(Projections.rowCount());
        }
        long totalRows = (Long)criteria.uniqueResult();
        _endRow = _endRow > 0L ? Long.valueOf(Math.min(_endRow, totalRows)) : Long.valueOf(totalRows);
        criteria.setProjection(null);
        if (parametry.get_distinct() != null && parametry.get_distinct().length() > 0) {
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)parametry.get_distinct())));
        }
        if ((_sortBy = parametry.get_sortBy()) != null) {
            String specialniRazeni;
            if (_sortBy.startsWith("-")) {
                specialniRazeni = this.getSpecialniRazeni(_sortBy = _sortBy.substring(1));
                if (specialniRazeni != null) {
                    _sortBy = specialniRazeni;
                }
                criteria.addOrder(Order.desc((String)_sortBy));
            } else {
                specialniRazeni = this.getSpecialniRazeni(_sortBy);
                if (specialniRazeni != null) {
                    _sortBy = specialniRazeni;
                }
                criteria.addOrder(Order.asc((String)_sortBy));
            }
        }
        criteria.setFirstResult(_startRow.intValue());
        if (_endRow.intValue() - _startRow.intValue() > 0) {
            criteria.setMaxResults(_endRow.intValue() - _startRow.intValue());
        }
        this.setTransformer(criteria);
        List matchingItems = criteria.list();
        if (parametry.get_atributy() != null) {
            vysledek.put("atributy", parametry.get_atributy());
        }
        vysledek.put("startRow", _startRow);
        vysledek.put("endRow", _endRow);
        vysledek.put("totalRows", totalRows);
        vysledek.put("seznam", matchingItems);
        return vysledek;
    }

    @Transactional
    protected Map sqlFetch(Map vysledek, SmartClientRequest parametry, Map<String, String> predaneAtributy) throws ClassNotFoundException, UnsupportedEncodingException {
        long startRow = 0L;
        long endRow = 0L;
        try {
            startRow = parametry.get_startRow();
            endRow = parametry.get_endRow();
        }
        catch (Exception e) {
            startRow = 0L;
            endRow = 0L;
        }
        String tabulka = parametry.get_class();
        String pole = new String(parametry.get_atributy().getBytes("ISO-8859-1"), "utf-8");
        StringBuffer podminka = new StringBuffer("1=1");
        int i = 0;
        for (String klic : predaneAtributy.keySet()) {
            String hodnota = new String(predaneAtributy.get(klic).getBytes("ISO-8859-1"), "utf-8");
            if (klic.startsWith("id_")) {
                if (i == 0) {
                    podminka.delete(0, podminka.length());
                } else {
                    podminka.append(", ");
                }
                podminka.append(String.valueOf(klic) + "=" + hodnota);
            } else {
                if (i == 0) {
                    podminka.delete(0, podminka.length());
                } else {
                    podminka.append(", ");
                }
                podminka.append("upper(" + klic + ") like upper('%" + hodnota + "%')");
            }
            ++i;
        }
        String sqlDotaz = "select count(*) from " + tabulka + " where " + podminka.toString();
        long totalRows = ((BigInteger)this.sessionFactory.getCurrentSession().createSQLQuery(sqlDotaz).uniqueResult()).intValue();
        endRow = endRow > 0L ? Math.min(endRow, totalRows) : totalRows;
        String sortByField = parametry.get_sortBy();
        String order = null;
        if (sortByField != null) {
            order = sortByField.startsWith("-") ? "order by " + sortByField.substring(1) + " desc" : "order by " + sortByField + " asc";
        }
        String limit = "limit " + endRow + " offset " + startRow;
        sqlDotaz = "select " + pole.replace(';', ',') + " from " + tabulka + " where " + podminka.toString() + " " + (order == null ? "" : String.valueOf(order) + " ") + limit;
        List matchingItems = this.sessionFactory.getCurrentSession().createSQLQuery(sqlDotaz).list();
        if (parametry.get_atributy() != null) {
            vysledek.put("atributy", parametry.get_atributy());
        }
        vysledek.put("startRow", startRow);
        vysledek.put("endRow", endRow);
        vysledek.put("totalRows", totalRows);
        vysledek.put("seznam", matchingItems);
        return vysledek;
    }

    @Transactional
    protected boolean predejPromenne(Object novaPolozka, SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek) throws Exception {
        Class<?> trida = Class.forName(parametry.get_class());
        ConvertUtils.register((Converter)new ScDateConverter(), java.util.Date.class);
        ConvertUtils.register((Converter)new ScDateConverter(), Date.class);
        for (String klic : predaneAtributy.keySet()) {
            if (klic.startsWith("_")) continue;
            String hodnota = predaneAtributy.get(klic);
            if (klic.equalsIgnoreCase("t") && hodnota.length() == 0) {
                PropertyUtils.setProperty((Object)novaPolozka, (String)klic, (Object)new java.util.Date());
                continue;
            }
            if (klic.startsWith("id_")) {
                String podklic = this.nazevAtributu(klic.substring(3));
                if (hodnota.equalsIgnoreCase("null") || hodnota.equalsIgnoreCase("-1")) {
                    try {
                        PropertyUtils.setProperty((Object)novaPolozka, (String)podklic, null);
                    }
                    catch (Exception e) {}
                    continue;
                }
                try {
                    Class navazanaTrida = this.getNavazanaTrida(trida, podklic);
                    Serializable idZavisleho = this.vratKonvertovanouHodnotu(trida, klic, hodnota);
                    Object podpolozka = this.sessionFactory.getCurrentSession().load(navazanaTrida, idZavisleho);
                    PropertyUtils.setProperty((Object)novaPolozka, (String)podklic, (Object)podpolozka);
                }
                catch (Exception e) {}
                continue;
            }
            try {
                System.out.println(klic);
                if (hodnota.equalsIgnoreCase("null")) {
                    PropertyUtils.setProperty((Object)novaPolozka, (String)klic, null);
                    continue;
                }
                BeanUtils.copyProperty((Object)novaPolozka, (String)klic, (Object)hodnota);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        ConvertUtils.deregister();
        return this.doupravPredani(novaPolozka, parametry, predaneAtributy, vysledek);
    }

    protected boolean doupravPredani(Object novaPolozka, SmartClientRequest parametry, Map<String, String> predaneAtributy, Map vysledek) throws Exception {
        return true;
    }

    public void setTransformer(Criteria criteria) {
        criteria.setResultTransformer(Criteria.ROOT_ENTITY);
    }

    public String getSpecialniRazeni(String sortByField) {
        return null;
    }

    public String[] getDodatecneAtributy() {
        return null;
    }

    protected Serializable pripravId(Class trida, Serializable id) throws InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException, NoSuchMethodException {
        Type typ = this.sessionFactory.getClassMetadata(trida).getIdentifierType();
        if (typ instanceof IntegerType) {
            id = new Integer((String)((Object)id));
        }
        return id;
    }

    protected boolean specialniFiltr(String klic, String hodnota, Criteria criteria) {
        return true;
    }

    private Serializable vratKonvertovanouHodnotu(Class trida, String metoda, String hodnota) throws InstantiationException, IllegalAccessException, NoSuchFieldException, SecurityException, NoSuchMethodException, ClassNotFoundException {
        Class navazanaTrida = this.getNavazanaTrida(trida, this.nazevAtributu(metoda.substring(3)));
        Class<?> idClass = navazanaTrida.getMethod("getId", new Class[0]).getReturnType();
        Object vysledek = hodnota;
        if (idClass == Integer.class || idClass == Integer.TYPE) {
            vysledek = new Integer(hodnota);
        }
        return vysledek;
    }

    protected Class getNavazanaTrida(Class trida, String podklic) throws ClassNotFoundException {
        String podtrida = String.valueOf(podklic.substring(0, 1).toUpperCase()) + podklic.substring(1);
        int iby = podtrida.indexOf("By");
        if (iby > 0) {
            podtrida = podtrida.substring(0, iby);
        }
        Class<?> navazanaTrida = Class.forName(String.valueOf(trida.getPackage().getName()) + "." + podtrida);
        return navazanaTrida;
    }

    protected String nazevAtributu(String vstup) {
        StringBuffer sb = new StringBuffer("");
        int i = 0;
        while (i < vstup.length()) {
            char znak = vstup.charAt(i);
            if (znak == '_' && vstup.length() > i + 1) {
                sb.append(vstup.substring(++i, i + 1).toUpperCase());
            } else {
                sb.append(vstup.charAt(i));
            }
            ++i;
        }
        return sb.toString();
    }
}

