/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.Byt;
import cz.triangle.domy.BytJaz;
import cz.triangle.domy.Dum;
import cz.triangle.domy.Jazyk;
import cz.triangle.domy.Podlazi;
import cz.triangle.domy.TypBloku;
import cz.triangle.domy.TypProstor;
import cz.triangle.domy.TypStavu;
import cz.triangle.domy.form.AdminBytForm;
import cz.triangle.domy.www.LokalitaDelegate;
import cz.triangle.domy.www.PodlaziDelegate;
import cz.triangle.util.ConvertService;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class BytDelegate
implements Serializable {
    private MessageResources res;
    private String localeId;

    public BytDelegate(MessageResources res, String localeId, Session hsess) {
        this.res = res;
        Jazyk jazyk = (Jazyk)hsess.load(Jazyk.class, (Serializable)((Object)localeId));
        this.localeId = localeId;
    }

    public Map novaPolozka(AdminBytForm f, String id, String id2, String navrat, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            AdminBytForm form = f;
            if (form == null) {
                form = new AdminBytForm();
                if (navrat != null && navrat.equalsIgnoreCase("admin_blok")) {
                    form.setTypBlokuId(id);
                    form.setDumId(new Integer(id2));
                    form.setNavrat(navrat);
                } else {
                    form.setPodlaziId(id);
                    form.setNavrat(navrat);
                }
            }
            vysledek.put("adminBytForm", (Object)form);
            vysledek.put("seznamTypuProstor", this.getSeznamTypuProstor(hsess));
            vysledek.put("seznamTypuBloku", this.getSeznamTypuBloku(hsess));
            if (navrat != null && navrat.equalsIgnoreCase("admin_blok")) {
                vysledek.put("seznamPodlazi", this.getSeznamPodlaziVDome(id2, hsess));
            } else {
                vysledek.put("seznamPodlazi", this.getSeznamPodlazi(id, hsess));
            }
            vysledek.put("seznamTypuStavu", this.getSeznamTypuStavu(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, AdminBytForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Byt polozka = (Byt)hsess.load(Byt.class, (Serializable)new Integer(id));
            AdminBytForm form = f;
            if (form == null) {
                form = new AdminBytForm();
                ConvertService.registrujCeske();
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                ConvertService.odregistrujCeske();
                form.setPodlaziId(polozka.getPodlazi().getId().toString());
                form.setDumId(polozka.getPodlazi().getDum().getId());
                form.setTypProstorId(polozka.getTypProstor().getId().toString());
                form.setTypBlokuId(polozka.getTypBloku().getId().toString());
                form.setTypStavuId(polozka.getTypStavu().getId().toString());
                form.setObrazekNazev(polozka.getObrazek());
                form.setLokalitaId(polozka.getPodlazi().getDum().getLokalita().getId());
                List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
                for (Jazyk jazyk : jazyky) {
                    BytJaz bytJaz = (BytJaz)polozka.getBytJazs().get(jazyk.getId());
                    if (bytJaz != null) {
                        form.setPoznamka(jazyk.getId(), bytJaz.getPoznamka());
                        form.setPriloha1Nazev(jazyk.getId(), bytJaz.getPriloha1());
                        form.setPriloha2Nazev(jazyk.getId(), bytJaz.getPriloha2());
                        continue;
                    }
                    form.setPoznamka(jazyk.getId(), "");
                }
            }
            vysledek.put("id", polozka.getId());
            vysledek.put("adminBytForm", (Object)form);
            vysledek.put("seznamTypuProstor", this.getSeznamTypuProstor(hsess));
            vysledek.put("seznamTypuBloku", this.getSeznamTypuBloku(hsess));
            vysledek.put("seznamPodlazi", this.getSeznamPodlazi(polozka.getPodlazi().getId().toString(), hsess));
            vysledek.put("seznamTypuStavu", this.getSeznamTypuStavu(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return this.res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(AdminBytForm form, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminBytForm", (Object)form);
                return vysledek;
            }
            Byt novaPolozka = new Byt();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)novaPolozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            vysledek.put("adminBytForm", (Object)form);
            novaPolozka.setTypProstor((TypProstor)hsess.load(TypProstor.class, (Serializable)new Integer(form.getTypProstorId())));
            novaPolozka.setTypBloku((TypBloku)hsess.load(TypBloku.class, (Serializable)new Integer(form.getTypBlokuId())));
            Podlazi podlazi = (Podlazi)hsess.load(Podlazi.class, (Serializable)new Integer(form.getPodlaziId()));
            novaPolozka.setPodlazi(podlazi);
            novaPolozka.setTypStavu((TypStavu)hsess.load(TypStavu.class, (Serializable)((Object)form.getTypStavuId())));
            novaPolozka.setZmena(new Date());
            hsess.save((Object)novaPolozka);
            long privesek = novaPolozka.getId().intValue();
            FormFile file = form.getObrazekFile();
            if (file != null && file.getFileName().length() > 0) {
                novaPolozka.setObrazek(LokalitaDelegate.ulozSoubor(cesta, podlazi.getDum().getLokalita(), privesek, file, "byt_obrazek"));
            }
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                String poznamka = (String)form.getPoznamka(jazyk.getId());
                BytJaz bytJaz = new BytJaz();
                bytJaz.setJazyk(jazyk);
                novaPolozka.getBytJazs().put(jazyk.getId(), bytJaz);
                bytJaz.setByt(novaPolozka);
                if (poznamka != null) {
                    bytJaz.setPoznamka(poznamka);
                } else {
                    bytJaz.setPoznamka("");
                }
                file = (FormFile)form.getPriloha1File(jazyk.getId());
                if (file != null && file.getFileName().length() > 0) {
                    bytJaz.setPriloha1(LokalitaDelegate.ulozSoubor(cesta, podlazi.getDum().getLokalita(), privesek, file, "pdf", "priloha1" + jazyk.getId()));
                }
                if ((file = (FormFile)form.getPriloha2File(jazyk.getId())) != null && file.getFileName().length() > 0) {
                    bytJaz.setPriloha2(LokalitaDelegate.ulozSoubor(cesta, podlazi.getDum().getLokalita(), privesek, file, "pdf", "priloha2" + jazyk.getId()));
                }
                hsess.save((Object)bytJaz);
            }
            try {
                PodlaziDelegate pd = new PodlaziDelegate(this.res, this.localeId, hsess);
                pd.vytvorZapisSWF(cesta, hsess, null, podlazi);
            }
            catch (Exception exception) {
                // empty catch block
            }
            vysledek.put("id", novaPolozka.getId());
            vysledek.put("idPodlazi", novaPolozka.getPodlazi().getId());
            vysledek.put("idDum", novaPolozka.getPodlazi().getDum().getId());
            vysledek.put("idBlok", novaPolozka.getTypBloku().getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map zapsatPolozku(AdminBytForm form, String id, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminBytForm", (Object)form);
                return vysledek;
            }
            Byt polozka = (Byt)hsess.load(Byt.class, (Serializable)new Integer(id));
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            polozka.setTypProstor((TypProstor)hsess.load(TypProstor.class, (Serializable)new Integer(form.getTypProstorId())));
            polozka.setTypBloku((TypBloku)hsess.load(TypBloku.class, (Serializable)new Integer(form.getTypBlokuId())));
            Podlazi podlazi = (Podlazi)hsess.load(Podlazi.class, (Serializable)new Integer(form.getPodlaziId()));
            Podlazi starePodlazi = polozka.getPodlazi();
            polozka.setPodlazi(podlazi);
            polozka.setZmena(new Date());
            long privesek = polozka.getId().intValue();
            FormFile file = form.getObrazekFile();
            if (file != null && file.getFileName().length() > 0) {
                polozka.setObrazek(LokalitaDelegate.prepisSoubor(cesta, podlazi.getDum().getLokalita(), privesek, file, polozka.getObrazek(), "byt_obrazek"));
            }
            TypStavu staryTypStavu = polozka.getTypStavu();
            TypStavu typStavu = (TypStavu)hsess.load(TypStavu.class, (Serializable)((Object)form.getTypStavuId()));
            polozka.setTypStavu(typStavu);
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                String poznamka;
                BytJaz bytJaz = (BytJaz)polozka.getBytJazs().get(jazyk.getId());
                if (bytJaz == null) {
                    bytJaz = new BytJaz();
                    bytJaz.setJazyk(jazyk);
                    bytJaz.setByt(polozka);
                    hsess.save((Object)bytJaz);
                }
                if ((poznamka = (String)form.getPoznamka(jazyk.getId())) != null) {
                    bytJaz.setPoznamka(poznamka);
                } else {
                    bytJaz.setPoznamka("");
                }
                file = (FormFile)form.getPriloha1File(jazyk.getId());
                if (file != null && file.getFileName().length() > 0) {
                    bytJaz.setPriloha1(LokalitaDelegate.ulozSoubor(cesta, podlazi.getDum().getLokalita(), privesek, file, "pdf", "priloha1" + jazyk.getId()));
                }
                if ((file = (FormFile)form.getPriloha2File(jazyk.getId())) != null && file.getFileName().length() > 0) {
                    bytJaz.setPriloha2(LokalitaDelegate.ulozSoubor(cesta, podlazi.getDum().getLokalita(), privesek, file, "pdf", "priloha2" + jazyk.getId()));
                }
                hsess.save((Object)bytJaz);
            }
            PodlaziDelegate pd = new PodlaziDelegate(this.res, this.localeId, hsess);
            try {
                pd.vytvorZapisSWF(cesta, hsess, null, podlazi);
                if (!starePodlazi.getId().equals(podlazi.getId())) {
                    pd.vytvorZapisSWF(cesta, hsess, null, starePodlazi);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            vysledek.put("adminBytForm", (Object)form);
            vysledek.put("id", polozka.getId());
            vysledek.put("idPodlazi", polozka.getPodlazi().getId());
            vysledek.put("idDum", polozka.getPodlazi().getDum().getId());
            vysledek.put("idBlok", polozka.getTypBloku().getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map smazatPolozku(String id, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Byt staraPolozka = (Byt)hsess.load(Byt.class, (Serializable)new Integer(id));
            vysledek.put("idPodlazi", staraPolozka.getPodlazi().getId());
            vysledek.put("idDum", staraPolozka.getPodlazi().getDum().getId());
            vysledek.put("idBlok", staraPolozka.getTypBloku().getId());
            if (staraPolozka.getObrazek() != null && staraPolozka.getObrazek().length() > 0) {
                LokalitaDelegate.smazatSwf(cesta, staraPolozka.getPodlazi().getDum().getLokalita().getId(), staraPolozka.getObrazek());
            }
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                BytJaz bytJaz = (BytJaz)staraPolozka.getBytJazs().get(jazyk.getId());
                if (bytJaz == null) continue;
                if (bytJaz.getPriloha1() != null && bytJaz.getPriloha1().length() > 0) {
                    LokalitaDelegate.smazatSoubor(cesta, staraPolozka.getPodlazi().getDum().getLokalita().getId(), "pdf", bytJaz.getPriloha1());
                }
                if (bytJaz.getPriloha2() == null || bytJaz.getPriloha2().length() <= 0) continue;
                LokalitaDelegate.smazatSoubor(cesta, staraPolozka.getPodlazi().getDum().getLokalita().getId(), "pdf", bytJaz.getPriloha2());
            }
            hsess.delete((Object)staraPolozka);
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public List getSeznamDomu(String id, Session hsess) {
        Dum dum = (Dum)hsess.load(Dum.class, (Serializable)new Integer(id));
        return hsess.createQuery("from Dum dum where dum.lokalita = ? order by dum.razeni").setEntity(0, (Object)dum.getLokalita()).list();
    }

    public List getSeznamPodlazi(String id, Session hsess) {
        List vysledek = null;
        Podlazi podlazi = (Podlazi)hsess.load(Podlazi.class, (Serializable)new Integer(id));
        vysledek = hsess.createQuery("from Podlazi podlazi where podlazi.dum = ? order by typPodlazi.razeni").setEntity(0, (Object)podlazi.getDum()).list();
        return vysledek;
    }

    public List getSeznamPodlaziVDome(String id, Session hsess) {
        List vysledek = null;
        vysledek = hsess.createQuery("from Podlazi podlazi where podlazi.dum.id = ? order by typPodlazi.razeni").setInteger(0, Integer.parseInt(id)).list();
        return vysledek;
    }

    public List getSeznamTypuProstor(Session hsess) {
        return hsess.createQuery("from TypProstor typProstor order by typProstor.id").list();
    }

    public List getSeznamTypuBloku(Session hsess) {
        return hsess.createQuery("from TypBloku typBloku order by typBloku.razeni").list();
    }

    public List getSeznamTypuStavu(Session hsess) {
        return hsess.createQuery("from TypStavu typStavu order by typStavu.id").list();
    }
}

