/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.collection;

import fr.improve.struts.taglib.layout.collection.BaseCollectionTag;
import fr.improve.struts.taglib.layout.collection.ItemContext;
import fr.improve.struts.taglib.layout.collection.header.MultiLevelHeader;
import fr.improve.struts.taglib.layout.el.Expression;
import fr.improve.struts.taglib.layout.event.StaticCodeIncludeLayoutEvent;
import fr.improve.struts.taglib.layout.event.StaticCodeIncludeListener;
import fr.improve.struts.taglib.layout.sort.SortUtil;
import fr.improve.struts.taglib.layout.util.IFooterRenderer;
import fr.improve.struts.taglib.layout.util.IMathCollectionRenderer;
import fr.improve.struts.taglib.layout.util.IMultiLevelHeaderRenderer;
import fr.improve.struts.taglib.layout.util.LayoutUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import org.apache.struts.util.RequestUtils;

public class CollectionTag
extends BaseCollectionTag
implements StaticCodeIncludeListener {
    static Class mathClass;
    private String staticCode = "";
    protected Map numbers = new HashMap();
    private MultiLevelHeader currentHeader;

    static {
        try {
            mathClass = RequestUtils.applicationClass((String)"org.apache.commons.math.stat.StatUtils");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    protected void reset() {
        this.numbers.clear();
        super.reset();
    }

    protected void storeMathData(double in_value) throws JspException {
        if (!this.isFirst()) {
            int lc_ligne = this.getIndex();
            int lc_col = this.getColumn();
            Object bean = this.getBean();
            String property = ((ItemContext)this.headers.get(lc_col)).getProperty();
            String mathOp = ((ItemContext)this.headers.get(lc_col)).getMathOperation();
            if (mathOp != null) {
                double[] lc_list;
                String key = String.valueOf(lc_col);
                if (!this.numbers.containsKey(key)) {
                    lc_list = new double[this.size];
                    this.numbers.put(key, lc_list);
                }
                lc_list = (double[])this.numbers.get(key);
                lc_list[this.index - 1] = in_value;
            }
        }
    }

    protected String doMathOperation(String in_operation, double[] in_data, String in_mathPattern) throws JspException {
        if (in_data != null && in_operation != null && in_operation.length() > 0) {
            double total = this.computeMathResult(in_operation, in_data);
            if (in_mathPattern != null) {
                DecimalFormat lc_format = new DecimalFormat(in_mathPattern);
                return lc_format.format(total);
            }
            return String.valueOf(total);
        }
        return null;
    }

    protected double computeMathResult(String in_operation, double[] in_data) throws JspException {
        Method m;
        if (mathClass == null) {
            throw new IllegalStateException("Math operation is not available, please put commons-math.jar in the classpath");
        }
        try {
            m = mathClass.getMethod(in_operation, double[].class);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Math operation " + in_operation + " is not supported");
        }
        Double result = null;
        try {
            result = (Double)m.invoke(null, new Object[]{in_data});
        }
        catch (InvocationTargetException e) {
            throw new JspException("Math operation " + in_operation + " failed : " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new JspException("Math operation " + in_operation + " failed : " + e.getMessage());
        }
        return result;
    }

    protected void addItem(StringBuffer in_buffer, String in_item, String in_url, String in_target, String in_onclick) throws JspException {
        if (in_url == null) {
            this.renderItem(in_buffer, in_item);
        } else {
            StringBuffer lc_buffer = new StringBuffer();
            String lc_item = in_item;
            if (this.sortType == 3) {
                if (lc_item.startsWith("<!--")) {
                    int lc_index = lc_item.indexOf("-->");
                    lc_buffer.append(lc_item.substring(0, lc_index + 3));
                    lc_item = lc_item.substring(lc_index + 3);
                } else {
                    lc_buffer.append("<!-- ");
                    lc_buffer.append(in_item);
                    lc_buffer.append("-->");
                }
            }
            lc_buffer.append("<a href=\"");
            lc_buffer.append(((HttpServletResponse)this.pageContext.getResponse()).encodeURL(in_url));
            if (in_onclick != null) {
                lc_buffer.append("\" onClick=\"");
                lc_buffer.append(Expression.evaluate(in_onclick, this.pageContext));
            }
            if (in_target != null) {
                lc_buffer.append("\" target=\"");
                lc_buffer.append(in_target);
            }
            String lc_styleClass = this.styleClass;
            if (this.tempStyleClass != null) {
                lc_styleClass = this.tempStyleClass;
            }
            if (lc_styleClass != null) {
                lc_buffer.append("\" class=\"");
                lc_buffer.append(lc_styleClass);
            }
            lc_buffer.append("\">");
            lc_buffer.append(lc_item);
            lc_buffer.append("</a>");
            this.renderItem(in_buffer, lc_buffer.toString());
        }
    }

    protected void renderBlankCollection(StringBuffer in_buffer) throws JspException {
        this.panel.doPrintEmptyCollection(in_buffer, LayoutUtils.getLabel(this.pageContext, this.getBundle(), this.emptyKey, null, false));
    }

    protected void renderEnd(StringBuffer buffer) throws JspException {
        this.renderMathData(buffer);
        this.renderFooter(buffer);
        this.panel.doEndPanel(buffer);
        this.renderStaticCode(buffer);
    }

    protected void renderMathData(StringBuffer in_buffer) throws JspException {
        if (!(this.panel instanceof IMathCollectionRenderer)) {
            return;
        }
        IMathCollectionRenderer lc_renderer = (IMathCollectionRenderer)((Object)this.panel);
        boolean started = false;
        int consecutiveNull = 0;
        String uniqueParam = this.mathOperationId;
        int lc_nbOfSpan = 0;
        int i = 0;
        while (i < this.headers.size()) {
            ItemContext lc_header = (ItemContext)this.headers.get(i);
            String lc_operation = lc_header.getMathOperation();
            String lc_mathStyleClass = this.tempStyleClass != null ? this.tempStyleClass : this.styleClass;
            String lc_mathPattern = lc_header.getMathPattern();
            double[] data = (double[])this.numbers.get(String.valueOf(i));
            String lc_data = this.doMathOperation(lc_operation, data, lc_mathPattern);
            String resultId = "mathData_t" + uniqueParam + "r" + i;
            if (lc_operation == null) {
                ++consecutiveNull;
            } else {
                if (!started) {
                    lc_renderer.startMathData(in_buffer);
                    started = true;
                }
                if (consecutiveNull > 0) {
                    lc_renderer.renderMathData(in_buffer, "&nbsp;", consecutiveNull, null, lc_mathStyleClass);
                    lc_nbOfSpan += consecutiveNull;
                }
                lc_renderer.renderMathData(in_buffer, lc_data, 1, resultId, lc_mathStyleClass);
                consecutiveNull = 0;
                ++lc_nbOfSpan;
            }
            ++i;
        }
        if (started) {
            if (this.headers.size() - lc_nbOfSpan > 0) {
                lc_renderer.renderMathData(in_buffer, "&nbsp;", this.headers.size() - lc_nbOfSpan, null, this.styleClass);
            }
            lc_renderer.endMathData(in_buffer);
        }
    }

    protected void renderFooter(StringBuffer in_buffer) throws JspException {
        if (!(this.panel instanceof IFooterRenderer)) {
            return;
        }
        IFooterRenderer lc_renderer = (IFooterRenderer)((Object)this.panel);
        boolean started = false;
        int consecutiveNull = 0;
        int i = 0;
        while (i < this.headers.size()) {
            ItemContext lc_header = (ItemContext)this.headers.get(i);
            String lc_footer = lc_header.getFooter();
            if (lc_footer == null) {
                ++consecutiveNull;
            } else {
                if (!started) {
                    lc_renderer.startFooter(in_buffer);
                    started = true;
                }
                if (consecutiveNull > 0) {
                    lc_renderer.printFooterElement(in_buffer, "&nbsp;", consecutiveNull);
                }
                Object[] lc_args = new Object[5];
                lc_args[0] = Expression.evaluate(lc_header.getFooterArg0(), this.pageContext);
                lc_args[1] = Expression.evaluate(lc_header.getFooterArg1(), this.pageContext);
                String lc_label = LayoutUtils.getLabel(this.pageContext, this.getBundle(), lc_footer, lc_args, false);
                lc_renderer.printFooterElement(in_buffer, lc_label, 1);
                consecutiveNull = 0;
            }
            ++i;
        }
        if (started) {
            lc_renderer.endFooter(in_buffer);
        }
    }

    protected void renderHeader(StringBuffer buffer, ItemContext in_header) throws JspException {
        String lc_key = in_header.getTitle();
        String lc_arg0 = Expression.evaluate(in_header.getArg0(), this.pageContext);
        String lc_arg1 = Expression.evaluate(in_header.getArg1(), this.pageContext);
        Object[] lc_args = new Object[]{lc_arg0, lc_arg1};
        String lc_title = LayoutUtils.getLabel(this.pageContext, this.getBundle(), lc_key, lc_args, false);
        String lc_sortUrl = this.computeSortUrl(in_header.getSortProperty());
        this.panel.doPrintHeader(buffer, lc_title, in_header.getWidth(), lc_sortUrl);
    }

    protected String computeSortUrl(String in_sortProperty) {
        String lc_sortUrl = null;
        if (in_sortProperty != null) {
            StringBuffer lc_tempBuffer = new StringBuffer();
            switch (this.sortType) {
                case 1: {
                    String lc_unEncodedUrl = SortUtil.getURLForCollection(in_sortProperty, (HttpServletRequest)this.pageContext.getRequest());
                    lc_tempBuffer.append(((HttpServletResponse)this.pageContext.getResponse()).encodeURL(lc_unEncodedUrl));
                    break;
                }
                case 2: {
                    if (!this.sortAction.toLowerCase().startsWith("javascript:")) {
                        lc_tempBuffer.append(this.sortAction);
                        if (this.sortAction.indexOf("?") != -1) {
                            lc_tempBuffer.append("&");
                        } else {
                            lc_tempBuffer.append("?");
                        }
                        lc_tempBuffer.append(this.sortParam);
                        lc_tempBuffer.append("=");
                        lc_tempBuffer.append(in_sortProperty);
                        break;
                    }
                    String javascriptSortParamName = "sortParam";
                    if (this.sortParam != null && this.sortParam.trim().length() > 0) {
                        javascriptSortParamName = this.sortParam;
                    }
                    this.pageContext.setAttribute(javascriptSortParamName, (Object)in_sortProperty);
                    lc_tempBuffer.append(Expression.evaluate(this.sortAction, this.pageContext));
                    this.pageContext.removeAttribute(javascriptSortParamName);
                    break;
                }
                case 3: {
                    lc_tempBuffer.append("javascript:arraySort(");
                    lc_tempBuffer.append(this.sortParam);
                    lc_tempBuffer.append(",");
                    lc_tempBuffer.append(this.column);
                    lc_tempBuffer.append(",");
                    lc_tempBuffer.append(this.size);
                    lc_tempBuffer.append(",");
                    lc_tempBuffer.append(this.nbOfColumns);
                    lc_tempBuffer.append(")");
                }
            }
            lc_sortUrl = lc_tempBuffer.toString();
        }
        return lc_sortUrl;
    }

    protected void renderMultiLevelHeaders(StringBuffer in_buffer, List in_multiLevelHeaders, int in_level) throws JspException {
        if (in_multiLevelHeaders != null) {
            ArrayList lc_nestedLevels = null;
            Iterator lc_it = in_multiLevelHeaders.iterator();
            IMultiLevelHeaderRenderer lc_panel = (IMultiLevelHeaderRenderer)((Object)this.panel);
            this.column = 0;
            boolean lc_started = false;
            while (lc_it.hasNext()) {
                MultiLevelHeader lc_header = (MultiLevelHeader)lc_it.next();
                List lc_headerChildren = lc_header.getChildHeaders();
                int lc_rowSpan = lc_headerChildren != null ? 1 : in_level + 1 - lc_header.getLevel();
                Object[] lc_args = new Object[]{Expression.evaluate(lc_header.getArg0(), this.pageContext), Expression.evaluate(lc_header.getArg1(), this.pageContext)};
                String lc_title = LayoutUtils.getLabel(this.pageContext, this.getBundle(), lc_header.getTitle(), lc_args, false);
                String lc_sortUrl = this.computeSortUrl(lc_header.getSortProperty());
                String lc_styleClass = lc_header.getStyleClass() == null ? this.getStyleClass() : lc_header.getStyleClass();
                String lc_tooltip = LayoutUtils.getLabel(this.pageContext, this.getBundle(), lc_header.getTooltip(), null, false);
                this.currentHeader = lc_header;
                if (lc_title != null) {
                    if (!lc_started) {
                        lc_panel.startMultiLevelHeaderRow(in_buffer);
                        lc_started = true;
                    }
                    lc_panel.renderMultiLevelHeader(in_buffer, lc_title, lc_sortUrl, lc_styleClass, lc_header.getColSpan(), lc_rowSpan, lc_header.getWidth());
                }
                this.currentHeader = null;
                if (lc_headerChildren != null) {
                    if (lc_nestedLevels == null) {
                        lc_nestedLevels = new ArrayList();
                    }
                    lc_nestedLevels.addAll(lc_headerChildren);
                }
                ++this.column;
            }
            if (lc_started) {
                lc_panel.endMultiLevelHeaderRow(in_buffer);
            }
            this.renderMultiLevelHeaders(in_buffer, lc_nestedLevels, in_level - 1);
        }
    }

    public MultiLevelHeader getCurrentHeader() {
        return this.currentHeader;
    }

    protected void renderItem(StringBuffer buffer, String in_item) throws JspException {
        String lc_item = in_item;
        if (this.needSelect && !this.selectHidden) {
            StringBuffer lc_tempBuffer = new StringBuffer();
            if (this.sortType == 3 && lc_item.startsWith("<!--")) {
                int lc_index = lc_item.indexOf("-->");
                lc_tempBuffer.append(lc_item.substring(0, lc_index + 3));
                lc_item = lc_item.substring(lc_index + 3);
            }
            this.renderSelection(lc_tempBuffer);
            this.needSelect = false;
            lc_tempBuffer.append(lc_item);
            lc_item = lc_tempBuffer.toString();
        }
        String[] lc_styleClasses = new String[1 + this.tempStyles.size()];
        lc_styleClasses[0] = this.tempStyleClass != null ? this.tempStyleClass : this.styleClass;
        int i = 0;
        while (i < this.tempStyles.size()) {
            lc_styleClasses[i + 1] = (String)this.tempStyles.get(i);
            ++i;
        }
        this.panel.doPrintItem(buffer, lc_item, lc_styleClasses, this.sortType == 3 ? "t" + this.sortParam + "l" + this.index + "c" + this.column : null);
    }

    protected void renderSelection(StringBuffer lc_tempBuffer) throws JspException {
        lc_tempBuffer.append("<input type=\"");
        if ("checkbox".equalsIgnoreCase(this.selectType)) {
            lc_tempBuffer.append("checkbox");
        } else {
            lc_tempBuffer.append("radio");
        }
        lc_tempBuffer.append("\" name=\"");
        if (this.selectName != null) {
            lc_tempBuffer.append(this.selectName);
        } else {
            lc_tempBuffer.append(this.selectProperty);
        }
        if ("checkbox".equalsIgnoreCase(this.selectType)) {
            if (this.selectId != null) {
                lc_tempBuffer.append("(");
                lc_tempBuffer.append(LayoutUtils.getProperty(this.bean, this.selectId));
                lc_tempBuffer.append(")");
            } else {
                lc_tempBuffer.append("[");
                lc_tempBuffer.append(this.index - 1);
                lc_tempBuffer.append("]");
                if (this.selectIndex != null) {
                    lc_tempBuffer.append(".");
                    lc_tempBuffer.append(this.selectIndex);
                }
            }
        }
        if (this.onClick != null) {
            lc_tempBuffer.append("\" onclick=\"");
            lc_tempBuffer.append(this.onClick);
        }
        lc_tempBuffer.append("\" value=\"");
        Object lc_value = LayoutUtils.getProperty(this.bean, this.selectProperty);
        lc_tempBuffer.append(lc_value);
        lc_tempBuffer.append("\"");
        if (this.isCurrentBeanSelected()) {
            lc_tempBuffer.append(" checked");
        }
        lc_tempBuffer.append(">");
    }

    protected void renderStart(StringBuffer out_buffer) throws JspException {
        Object[] lc_args = new Object[5];
        Object lc_arg0 = null;
        if (this.arg0Name != null) {
            lc_arg0 = LayoutUtils.getBeanFromPageContext(this.pageContext, this.arg0Name, null);
        }
        lc_args[0] = lc_arg0;
        this.panel.doPrintTitle(out_buffer, LayoutUtils.getLabel(this.pageContext, this.getBundle(), this.title, lc_args, false));
        this.panel.doStartPanel(out_buffer, this.align, this.width);
    }

    public boolean isCurrentBeanSelected() throws JspException {
        if (this.selectName != null) {
            Object lc_selectedValue = null;
            lc_selectedValue = "checkbox".equalsIgnoreCase(this.selectType) ? (this.selectId == null ? LayoutUtils.getBeanFromPageContext(this.pageContext, "org.apache.struts.taglib.html.BEAN", String.valueOf(this.selectName) + "[" + (this.index - 1) + "]") : LayoutUtils.getBeanFromPageContext(this.pageContext, "org.apache.struts.taglib.html.BEAN", String.valueOf(this.selectName) + "(" + LayoutUtils.getProperty(this.bean, this.selectId) + ")")) : LayoutUtils.getBeanFromPageContext(this.pageContext, "org.apache.struts.taglib.html.BEAN", this.selectName);
            if (lc_selectedValue != null && lc_selectedValue.equals(LayoutUtils.getProperty(this.bean, this.selectProperty))) {
                return true;
            }
        }
        return false;
    }

    public Object processStaticCodeIncludeEvent(StaticCodeIncludeLayoutEvent in_event) throws JspException {
        String lc_codeToPrint = (String)in_event.sendToParent(this);
        this.staticCode = String.valueOf(this.staticCode) + lc_codeToPrint;
        return "";
    }

    protected void renderStaticCode(StringBuffer out_buffer) {
        if (this.staticCode.length() > 0) {
            out_buffer.append(this.staticCode);
            this.staticCode = "";
        }
    }
}

