/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.field;

import fr.improve.struts.taglib.layout.el.Expression;
import fr.improve.struts.taglib.layout.field.AbstractFieldTag;
import fr.improve.struts.taglib.layout.formatter.FormatException;
import fr.improve.struts.taglib.layout.util.TagUtils;
import javax.servlet.jsp.JspException;
import org.apache.struts.taglib.html.BaseHandlerTag;
import org.apache.struts.taglib.html.TextTag;
import org.apache.struts.util.ResponseUtils;

public class TextFieldTag
extends AbstractFieldTag {
    private TextTag textFieldTag = new TextTag();
    protected String format;
    protected String editFormat;
    protected String jspFormat;
    protected String jspEditFormat;

    protected boolean doBeforeValue() throws JspException {
        this.fieldTag = this.textFieldTag;
        return true;
    }

    protected Object getFieldValue() throws JspException {
        Object lc_value = super.getFieldValue();
        if (lc_value != null) {
            switch (this.getFieldDisplayMode()) {
                case 2: {
                    if (this.editFormat == null) break;
                    try {
                        lc_value = this.getSkin().getFormatter().format(lc_value, this.editFormat, this.pageContext);
                        break;
                    }
                    catch (FormatException fe) {
                        TagUtils.saveException(this.pageContext, fe);
                        throw new JspException("Format " + this.editFormat + "failed: " + fe.getMessage());
                    }
                }
                default: {
                    if (this.format == null) break;
                    try {
                        lc_value = this.getSkin().getFormatter().format(lc_value, this.format, this.pageContext);
                        break;
                    }
                    catch (FormatException fe) {
                        TagUtils.saveException(this.pageContext, fe);
                        throw new JspException("Format " + this.format + "failed: " + fe.getMessage());
                    }
                }
            }
        }
        return lc_value;
    }

    public int doStartInspectField() throws JspException {
        if (!this.doBeforeValue()) {
            return 0;
        }
        Object lc_value = this.getFieldValue();
        if (lc_value != null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("<span class=\"");
            buffer.append(this.styleClass);
            buffer.append("\">");
            if (this.format == null) {
                if (this.filter) {
                    buffer.append(ResponseUtils.filter((String)lc_value.toString()));
                } else {
                    buffer.append(lc_value.toString());
                }
            } else {
                buffer.append(lc_value);
            }
            buffer.append("</span>");
            TagUtils.write(this.pageContext, buffer.toString());
        }
        this.doAfterValue();
        return 1;
    }

    public void release() {
        super.release();
        this.format = null;
        this.editFormat = null;
    }

    public void setType(String type) {
        this.format = type;
    }

    public void setEditType(String type) {
        this.editFormat = type;
    }

    public String getType() {
        return this.format;
    }

    protected void copyProperties(BaseHandlerTag in_dest) throws JspException {
        super.copyProperties(in_dest);
        this.textFieldTag.setCols(this.getCols());
        this.textFieldTag.setMaxlength(this.getMaxlength());
        this.textFieldTag.setProperty(this.getProperty());
        this.textFieldTag.setRows(this.getRows());
        this.textFieldTag.setValue(this.getValue());
        this.textFieldTag.setAccept(this.getAccept());
        this.textFieldTag.setName(this.getName());
    }

    protected void initDynamicValues() {
        super.initDynamicValues();
        this.jspFormat = this.format;
        this.format = Expression.evaluate(this.format, this.pageContext);
        this.jspEditFormat = this.editFormat;
        this.editFormat = Expression.evaluate(this.editFormat, this.pageContext);
    }

    protected void reset() {
        this.format = this.jspFormat;
        this.jspFormat = null;
        this.editFormat = this.jspEditFormat;
        this.jspEditFormat = null;
        super.reset();
    }
}

