/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.treeview;

import fr.improve.struts.taglib.layout.menu.MenuComponent;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class TreeViewReconciler {
    private static final String RECONCEILE_KEY = "fr.improve.struts.taglib.layout.treeview.TreeViewReconciler";
    private static final Log Log = LogFactory.getLog(TreeViewReconciler.class);

    public static void reconceileFromCookie(MenuComponent in_menu, HttpServletRequest in_request) {
        if (!TreeViewReconciler.isReconcile(in_menu, in_request)) {
            String lc_cookie = TreeViewReconciler.getTreeviewCookie(in_request);
            Log.debug((Object)("Reconceiling menu " + in_menu.getName() + " from cookie value " + lc_cookie));
            if (lc_cookie != null) {
                in_menu.closeAll();
                StringTokenizer lc_tokenizer = new StringTokenizer(lc_cookie, "_");
                while (lc_tokenizer.hasMoreTokens()) {
                    MenuComponent lc_component;
                    String lc_token = lc_tokenizer.nextToken();
                    if (lc_token.startsWith("treeView")) {
                        lc_token = lc_token.substring(8);
                    }
                    if (!lc_token.startsWith(String.valueOf(in_menu.getName()) + "*") || (lc_component = TreeViewReconciler.getComponentWithPath(in_menu, lc_token.substring(in_menu.getName().length() + 1))) == null) continue;
                    lc_component.setOpen(true);
                }
                TreeViewReconciler.setReconceile(in_menu, in_request);
            }
        }
    }

    private static void setReconceile(MenuComponent in_menu, HttpServletRequest in_request) {
        HashSet<MenuComponent> lc_map = (HashSet<MenuComponent>)in_request.getAttribute(RECONCEILE_KEY);
        if (lc_map == null) {
            lc_map = new HashSet<MenuComponent>();
            in_request.setAttribute(RECONCEILE_KEY, lc_map);
        }
        lc_map.add(in_menu);
    }

    private static boolean isReconcile(MenuComponent in_menu, HttpServletRequest in_request) {
        Set lc_map = (Set)in_request.getAttribute(RECONCEILE_KEY);
        if (lc_map == null) {
            return false;
        }
        return lc_map.contains(in_menu);
    }

    private static Set getReconciledMenu(HttpServletRequest in_request) {
        Set lc_map = (Set)in_request.getAttribute(RECONCEILE_KEY);
        if (lc_map == null) {
            return Collections.EMPTY_SET;
        }
        return lc_map;
    }

    private static String getTreeviewCookie(HttpServletRequest in_request) {
        Cookie[] lc_cookies = in_request.getCookies();
        if (lc_cookies == null) {
            return null;
        }
        int i = 0;
        while (i < lc_cookies.length) {
            Cookie lc_cookie = lc_cookies[i];
            if (lc_cookie.getName().equals("treeView")) {
                return lc_cookie.getValue();
            }
            ++i;
        }
        return null;
    }

    static MenuComponent getComponentWithPath(MenuComponent in_menu, String in_path) {
        int lc_starPos = in_path.indexOf(42);
        if (lc_starPos != -1) {
            String lc_id = in_path.substring(0, lc_starPos);
            String lc_subPath = in_path.substring(lc_starPos + 1);
            MenuComponent lc_menu = in_menu.getChild(lc_id);
            if (lc_menu != null) {
                return TreeViewReconciler.getComponentWithPath(lc_menu, lc_subPath);
            }
            return null;
        }
        return in_menu.getChild(in_path);
    }

    public static void reconceileFromMenu(HttpServletRequest in_request, HttpServletResponse in_response) {
        Set lc_menus = TreeViewReconciler.getReconciledMenu(in_request);
        for (MenuComponent lc_menu : lc_menus) {
            TreeViewReconciler.reconceileFromMenu(lc_menu, in_request, in_response);
            lc_menu.closeAll();
        }
        in_request.removeAttribute(RECONCEILE_KEY);
    }

    private static void reconceileFromMenu(MenuComponent in_menu, HttpServletRequest in_request, HttpServletResponse in_response) {
        StringBuffer lc_cookievalue = new StringBuffer();
        String lc_path = in_menu.getName();
        TreeViewReconciler.reconceileFromMenu(in_menu, lc_cookievalue, lc_path);
        if (lc_cookievalue.length() > 0) {
            lc_cookievalue.append("_");
        }
        String lc_newCookieValue = lc_cookievalue.toString();
        Log.debug((Object)("Reconceiling cookie with menu " + in_menu.getName() + ". New cookie value is : " + lc_newCookieValue));
        Cookie lc_cookie = new Cookie("treeView", lc_newCookieValue);
        lc_cookie.setPath(in_request.getContextPath());
        in_response.addCookie(lc_cookie);
        Cookie[] lc_cookies = in_request.getCookies();
        if (lc_cookies != null) {
            int i = 0;
            while (i < lc_cookies.length) {
                Cookie lc_oldCookie = lc_cookies[i];
                if (lc_oldCookie.getName().equals("treeView")) {
                    lc_oldCookie.setValue(lc_newCookieValue);
                }
                ++i;
            }
        }
        in_menu.closeAll();
    }

    private static void reconceileFromMenu(MenuComponent in_menu, StringBuffer lc_cookievalue, String lc_path) {
        if (in_menu.isOpen() || in_menu.getParent() == null) {
            MenuComponent[] lc_children = in_menu.getMenuComponents();
            if (in_menu.getParent() != null) {
                lc_cookievalue.append("_treeView");
                lc_cookievalue.append(lc_path);
            }
            int i = 0;
            while (i < lc_children.length) {
                MenuComponent lc_child = lc_children[i];
                String lc_id = lc_child.getId();
                if (lc_id == null) {
                    lc_id = String.valueOf(i);
                }
                TreeViewReconciler.reconceileFromMenu(lc_child, lc_cookievalue, String.valueOf(lc_path) + "*" + lc_id);
                ++i;
            }
        }
    }
}

