/*
 * Decompiled with CFR 0.152.
 */
package fr.improve.struts.taglib.layout.menu;

import fr.improve.struts.taglib.layout.menu.MenuAction;
import fr.improve.struts.taglib.layout.menu.MenuBase;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class MenuComponent
extends MenuBase
implements Serializable {
    protected ArrayList menuComponents = new ArrayList();
    protected Map children = new HashMap();
    protected static MenuComponent[] _menuComponent = new MenuComponent[0];
    protected static MenuAction[] _menuAction = new MenuAction[0];
    protected MenuComponent parentMenu = null;
    private transient ThreadLocal open = new ThreadLocal();
    protected ArrayList menuActions = new ArrayList();

    public MenuComponent() {
    }

    public MenuComponent(String in_id) {
        super(in_id);
        if (in_id == null || in_id.indexOf(42) != -1 || in_id.indexOf(95) != -1) {
            throw new IllegalArgumentException("MenuComponent id cannot be null, nor contain '*' or '_'");
        }
    }

    public void addMenuComponent(MenuComponent menuComponent) {
        String lc_id;
        this.menuComponents.add(menuComponent);
        menuComponent.setParent(this);
        if (menuComponent.getName() == null || menuComponent.getName().equals("")) {
            menuComponent.setName(String.valueOf(this.name) + this.menuComponents.size());
        }
        if ((lc_id = menuComponent.getId()) != null) {
            this.children.put(lc_id, menuComponent);
        }
    }

    public MenuComponent[] getMenuComponents() {
        MenuComponent[] menus = this.menuComponents.toArray(_menuComponent);
        return menus;
    }

    public MenuComponent getChild(String in_id) {
        if (this.children.isEmpty() && this.hasMenuComponents()) {
            try {
                int lc_pos = Integer.parseInt(in_id);
                if (lc_pos < this.menuComponents.size()) {
                    return (MenuComponent)this.menuComponents.get(lc_pos);
                }
                return null;
            }
            catch (NumberFormatException e) {
                return null;
            }
        }
        return (MenuComponent)this.children.get(in_id);
    }

    public void setParent(MenuComponent parentMenu) {
        this.parentMenu = parentMenu;
    }

    public MenuComponent getParent() {
        return this.parentMenu;
    }

    public MenuAction[] getMenuAction() {
        return this.menuActions.toArray(_menuAction);
    }

    public void addMenuAction(MenuAction in_action) {
        this.menuActions.add(in_action);
    }

    public boolean hasMenuComponents() {
        return !this.menuComponents.isEmpty();
    }

    public void addMenuComponent(int in_index, MenuComponent in_menuComponent) {
        this.menuComponents.add(in_index, in_menuComponent);
        String lc_id = in_menuComponent.getId();
        if (lc_id != null) {
            this.children.put(lc_id, in_menuComponent);
        }
    }

    public void removeMenuComponent(int in_index) {
        MenuComponent lc_element = (MenuComponent)this.menuComponents.get(in_index);
        String lc_id = lc_element.getId();
        if (lc_id != null) {
            this.children.remove(lc_id);
        }
        this.menuComponents.remove(in_index);
    }

    public void removeMenuComponent(MenuComponent in_menuComponent) {
        String lc_id = in_menuComponent.getId();
        if (lc_id != null) {
            this.children.remove(lc_id);
        }
        this.menuComponents.remove(in_menuComponent);
    }

    public void setOpen(boolean in_open) {
        this.checkOpen();
        this.open.set(in_open ? Boolean.TRUE : Boolean.FALSE);
    }

    private void checkOpen() {
        if (this.open == null) {
            this.open = new ThreadLocal();
        }
    }

    public boolean isOpen() {
        this.checkOpen();
        Boolean lc_open = (Boolean)this.open.get();
        if (lc_open == null) {
            return false;
        }
        return lc_open;
    }

    public void setOpen(boolean in_open, int in_level) {
        this.setOpen(in_open);
        int lc_level = in_level - 1;
        if (lc_level > 0) {
            MenuComponent[] lc_menus = this.getMenuComponents();
            int i = 0;
            while (i < lc_menus.length) {
                lc_menus[i].setOpen(in_open, lc_level);
                ++i;
            }
        }
    }

    public int indexOf(MenuComponent in_component) {
        return this.menuComponents.indexOf(in_component);
    }

    public void closeAll() {
        if (this.isOpen() || this.getParent() == null) {
            MenuComponent[] lc_menus = this.getMenuComponents();
            int i = 0;
            while (i < lc_menus.length) {
                lc_menus[i].closeAll();
                ++i;
            }
        }
        this.setOpen(false);
    }
}

