/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.rtnext.rs.data.Obsah;
import cz.triangle.domy.PolozkaMenu;
import cz.triangle.domy.StromMenu;
import cz.triangle.domy.form.AdminDokumentForm;
import cz.triangle.domy.www.ClankyDelegate;
import cz.triangle.util.ConvertService;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class DokumentDelegate
implements Serializable {
    private MessageResources res;
    private String idLang;
    public static final String TYP_DOKUMENT = "dokument";

    public DokumentDelegate(String idLang, MessageResources res) {
        this.res = res;
        this.idLang = idLang;
    }

    public Map novaPolozka(String kodPolozka, AdminDokumentForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            AdminDokumentForm form = f;
            if (form == null) {
                form = new AdminDokumentForm();
                form.setKodPolozka(kodPolozka);
            }
            DateFormat dateFormat = DateFormat.getDateInstance(2, new Locale("cs", "CZ"));
            Calendar cal = Calendar.getInstance();
            form.setZverejneniOd(dateFormat.format(cal.getTime()));
            cal.add(1, 10);
            form.setZverejneniDo(dateFormat.format(cal.getTime()));
            vysledek.put("adminDokumentForm", (Object)form);
            List polozky = hsess.createQuery("from PolozkaMenu polozka order by polozka.razeni").list();
            StromMenu strom = new StromMenu(polozky);
            ClankyDelegate cd = new ClankyDelegate(this.idLang, "", this.res);
            vysledek.put("seznamPolozek", cd.getSeznamPolozek(strom, "-1", false));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, AdminDokumentForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Obsah polozka = (Obsah)hsess.get(Obsah.class, (Serializable)new Integer(id));
            AdminDokumentForm form = f;
            if (form == null) {
                form = new AdminDokumentForm();
                ConvertService.registrujCeske();
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                ConvertService.odregistrujCeske();
                form.setKodPolozka(polozka.getPolozkaMenu().getKod());
            }
            vysledek.put("id", polozka.getId());
            vysledek.put("adminDokumentForm", (Object)form);
            List polozky = hsess.createQuery("from PolozkaMenu polozka where polozka.idJazyk = ? order by polozka.razeni").setString(0, this.idLang).list();
            StromMenu strom = new StromMenu(polozky);
            ClankyDelegate cd = new ClankyDelegate(this.idLang, "", this.res);
            vysledek.put("seznamPolozek", cd.getSeznamPolozek(strom, "-1", false));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return this.res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(AdminDokumentForm form, ActionMapping mapping, HttpServletRequest request, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminDokumentForm", (Object)form);
                return vysledek;
            }
            Obsah novaPolozka = new Obsah();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)novaPolozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            PolozkaMenu rodic = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)form.getKodPolozka()));
            novaPolozka.setPolozkaMenu(rodic);
            rodic.setObsah(Boolean.TRUE);
            vysledek.put("adminDokumentForm", (Object)form);
            hsess.save((Object)novaPolozka);
            vysledek.put("id", novaPolozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive() && hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map zapsatPolozku(AdminDokumentForm form, String id, ActionMapping mapping, HttpServletRequest request, Session hsess) {
        HashMap<String, Object> vysledek;
        block5: {
            vysledek = new HashMap<String, Object>();
            try {
                ActionErrors errors = form.validate(mapping, request);
                if (errors != null && !errors.isEmpty()) {
                    vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                    vysledek.put("adminDokumentForm", (Object)form);
                    return vysledek;
                }
                Obsah polozka = (Obsah)hsess.load(Obsah.class, (Serializable)new Integer(id));
                PolozkaMenu staryRodic = polozka.getPolozkaMenu();
                ConvertService.registrujCeske();
                BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
                ConvertService.odregistrujCeske();
                PolozkaMenu rodic = (PolozkaMenu)hsess.load(PolozkaMenu.class, (Serializable)((Object)form.getKodPolozka()));
                polozka.setPolozkaMenu(rodic);
                vysledek.put("adminDokumentForm", (Object)form);
                vysledek.put("id", polozka.getId());
                this.prenastavObsah(staryRodic, hsess);
                rodic.setObsah(Boolean.TRUE);
                hsess.flush();
            }
            catch (Exception e) {
                String zprava;
                String string = zprava = e.getMessage() != null ? e.getMessage() : "";
                if (e.getCause() != null && e.getCause().getMessage() != null) {
                    zprava = String.valueOf(zprava) + ", " + e.getCause().getMessage();
                    if (e.getCause().getCause() != null && e.getCause().getCause().getMessage() != null) {
                        zprava = String.valueOf(zprava) + ", " + e.getCause().getCause().getMessage();
                    }
                }
                vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)zprava));
                if (!hsess.getTransaction().isActive()) break block5;
                hsess.getTransaction().rollback();
            }
        }
        return vysledek;
    }

    public Map smazatPolozku(String id, Session hsess) {
        HashMap<String, String> vysledek = new HashMap<String, String>();
        try {
            Obsah staraPolozka = (Obsah)hsess.load(Obsah.class, (Serializable)new Integer(id));
            PolozkaMenu staryRodic = staraPolozka.getPolozkaMenu();
            hsess.delete((Object)staraPolozka);
            this.prenastavObsah(staryRodic, hsess);
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private void prenastavObsah(PolozkaMenu polozka, Session hsess) {
        try {
            if (polozka.getStranka().equalsIgnoreCase("clanky.jsp")) {
                Iterator iter = hsess.createQuery("from Obsah obsah where obsah.polozkaMenu = ?").setEntity(0, (Object)polozka).iterate();
                if (iter.hasNext()) {
                    polozka.setObsah(Boolean.TRUE);
                } else {
                    polozka.setObsah(Boolean.FALSE);
                }
            } else {
                polozka.setObsah(Boolean.TRUE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

