/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.Jazyk;
import cz.triangle.domy.Uzivatel;
import cz.triangle.domy.UzivatelVO;
import cz.triangle.domy.form.FotoAdmRegistraceForm;
import cz.triangle.util.ConvertService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class FotoAdmUzivatelDelegate
implements Serializable {
    private MessageResources res;
    private String localeId;

    public FotoAdmUzivatelDelegate(MessageResources res, String localeId, Session hsess) {
        this.res = res;
        Jazyk jazyk = (Jazyk)hsess.load(Jazyk.class, (Serializable)((Object)localeId));
        this.localeId = localeId;
    }

    public Map novaPolozka(FotoAdmRegistraceForm f, String id, String id2, String navrat, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            FotoAdmRegistraceForm form = f;
            if (form == null) {
                form = new FotoAdmRegistraceForm();
            }
            vysledek.put("fotoAdmRegistraceForm", (Object)form);
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("uzivatel.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, FotoAdmRegistraceForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            Uzivatel polozka = (Uzivatel)hsess.load(Uzivatel.class, (Serializable)new Integer(id));
            FotoAdmRegistraceForm form = f;
            if (form == null) {
                form = new FotoAdmRegistraceForm();
                ConvertService.registrujCeske();
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                ConvertService.odregistrujCeske();
            }
            form.setHesloPotvrzeni(form.getHeslo());
            vysledek.put("id", polozka.getId());
            vysledek.put("fotoAdmRegistraceForm", (Object)form);
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("uzivatel.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return this.res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(FotoAdmRegistraceForm form, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("fotoAdmRegistraceForm", (Object)form);
                return vysledek;
            }
            Iterator iter = hsess.createQuery("from Uzivatel uzivatel where uzivatel.uzivJmeno=?").setString(0, form.getUzivJmeno()).iterate();
            if (iter.hasNext()) {
                vysledek.put("validacni_chyba", this.res.getMessage("polozka.chyba_registrace_uzivatel_existuje"));
                form.setCaptcha(null);
                vysledek.put("fotoAdmRegistraceForm", (Object)form);
                return vysledek;
            }
            Iterator iter2 = hsess.createQuery("from Uzivatel uzivatel where uzivatel.email=?").setString(0, form.getEmail()).iterate();
            if (iter2.hasNext()) {
                vysledek.put("validacni_chyba", this.res.getMessage("polozka.chyba_registrace_email_existuje"));
                form.setCaptcha(null);
                vysledek.put("fotoAdmRegistraceForm", (Object)form);
                return vysledek;
            }
            Uzivatel novaPolozka = new Uzivatel();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)novaPolozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            vysledek.put("fotoAdmRegistraceForm", (Object)form);
            hsess.save((Object)novaPolozka);
            vysledek.put("id", novaPolozka.getId());
            hsess.flush();
            UzivatelVO uzivatelVO = new UzivatelVO();
            BeanUtils.copyProperties((Object)uzivatelVO, (Object)novaPolozka);
            vysledek.put("uzivatelVO", uzivatelVO);
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("uzivatel.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("uzivatel.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map zapsatPolozku(FotoAdmRegistraceForm form, String id, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("fotoAdmRegistraceForm", (Object)form);
                return vysledek;
            }
            Uzivatel polozka = (Uzivatel)hsess.load(Uzivatel.class, (Serializable)new Integer(id));
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            vysledek.put("fotoAdmRegistraceForm", (Object)form);
            vysledek.put("id", polozka.getId());
            hsess.flush();
            UzivatelVO uzivatelVO = new UzivatelVO();
            BeanUtils.copyProperties((Object)uzivatelVO, (Object)polozka);
            vysledek.put("uzivatelVO", uzivatelVO);
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("uzivatel.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("uzivatel.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }
}

