/*
 * Decompiled with CFR 0.152.
 */
package cz.triangle.domy.www;

import cz.triangle.domy.Dum;
import cz.triangle.domy.Jazyk;
import cz.triangle.domy.NebytovaProstora;
import cz.triangle.domy.NebytovaProstoraJaz;
import cz.triangle.domy.Podlazi;
import cz.triangle.domy.TypBloku;
import cz.triangle.domy.TypNebytoveProstory;
import cz.triangle.domy.TypStavu;
import cz.triangle.domy.form.AdminNebytovaProstoraForm;
import cz.triangle.domy.www.LokalitaDelegate;
import cz.triangle.util.ConvertService;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;
import org.apache.struts.upload.FormFile;
import org.apache.struts.util.MessageResources;
import org.hibernate.HibernateException;
import org.hibernate.Session;

public class NebytovaProstoraDelegate
implements Serializable {
    private MessageResources res;
    private String localeId;

    public NebytovaProstoraDelegate(MessageResources res, String localeId, Session hsess) {
        this.res = res;
        Jazyk jazyk = (Jazyk)hsess.load(Jazyk.class, (Serializable)((Object)localeId));
        this.localeId = localeId;
    }

    public Map novaPolozka(AdminNebytovaProstoraForm f, String id, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            AdminNebytovaProstoraForm form = f;
            if (form == null) {
                form = new AdminNebytovaProstoraForm();
                form.setDumId(id);
            }
            vysledek.put("adminNebytovaProstoraForm", (Object)form);
            vysledek.put("seznamTypuBloku", this.getSeznamTypuBloku(hsess));
            vysledek.put("seznamDomu", this.getSeznamDomu(id, hsess));
            vysledek.put("seznamTypuStavu", this.getSeznamTypuStavu(hsess));
            List seznamTypuNebytovychProstor = this.getSeznamTypuNebytovychProstor(hsess);
            vysledek.put("seznamTypuNebytovychProstor", seznamTypuNebytovychProstor);
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map editacePolozky(String id, AdminNebytovaProstoraForm f, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            NebytovaProstora polozka = (NebytovaProstora)hsess.load(NebytovaProstora.class, (Serializable)new Integer(id));
            AdminNebytovaProstoraForm form = f;
            if (form == null) {
                form = new AdminNebytovaProstoraForm();
                ConvertService.registrujCeske();
                BeanUtils.copyProperties((Object)((Object)form), (Object)polozka);
                ConvertService.odregistrujCeske();
                form.setDumId(polozka.getDum().getId().toString());
                form.setTypBlokuId(polozka.getTypBloku().getId().toString());
                form.setTypStavuId(polozka.getTypStavu().getId().toString());
                form.setObrazekNazev(polozka.getObrazek());
                form.setLokalitaId(polozka.getDum().getLokalita().getId());
                form.setTypNebytoveProstoryId(polozka.getTypNebytoveProstory().getId());
                List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
                for (Jazyk jazyk : jazyky) {
                    NebytovaProstoraJaz bytJaz = (NebytovaProstoraJaz)polozka.getNebytovaProstoraJazs().get(jazyk.getId());
                    if (bytJaz != null) {
                        form.setPoznamka(jazyk.getId(), bytJaz.getPoznamka());
                        continue;
                    }
                    form.setPoznamka(jazyk.getId(), "");
                }
            }
            vysledek.put("id", polozka.getId());
            vysledek.put("adminNebytovaProstoraForm", (Object)form);
            vysledek.put("seznamTypuBloku", this.getSeznamTypuBloku(hsess));
            vysledek.put("seznamDomu", this.getSeznamDomu(polozka.getDum().getId().toString(), hsess));
            vysledek.put("seznamTypuStavu", this.getSeznamTypuStavu(hsess));
            vysledek.put("seznamTypuNebytovychProstor", this.getSeznamTypuNebytovychProstor(hsess));
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.editace_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    private String validacniChyba(ActionMessages messages) {
        if (messages != null && !messages.isEmpty()) {
            Iterator iter = messages.get();
            ActionMessage message = (ActionMessage)iter.next();
            return this.res.getMessage(message.getKey(), message.getValues());
        }
        return null;
    }

    public Map zapsatNovouPolozku(AdminNebytovaProstoraForm form, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminNebytovaProstoraForm", (Object)form);
                return vysledek;
            }
            NebytovaProstora novaPolozka = new NebytovaProstora();
            ConvertService.registrujCeske();
            BeanUtils.copyProperties((Object)novaPolozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            vysledek.put("adminNebytovaProstoraForm", (Object)form);
            novaPolozka.setTypBloku((TypBloku)hsess.load(TypBloku.class, (Serializable)new Integer(form.getTypBlokuId())));
            Dum dum = (Dum)hsess.load(Dum.class, (Serializable)new Integer(form.getDumId()));
            novaPolozka.setDum(dum);
            novaPolozka.setTypStavu((TypStavu)hsess.load(TypStavu.class, (Serializable)((Object)form.getTypStavuId())));
            novaPolozka.setTypNebytoveProstory((TypNebytoveProstory)hsess.load(TypNebytoveProstory.class, (Serializable)((Object)form.getTypNebytoveProstoryId())));
            hsess.save((Object)novaPolozka);
            long privesek = Math.round(Math.random() * 1000.0);
            FormFile file = form.getObrazekFile();
            if (file != null && file.getFileName().length() > 0) {
                novaPolozka.setObrazek(LokalitaDelegate.ulozSoubor(cesta, dum.getLokalita(), privesek, file, "np_obrazek"));
            }
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                String poznamka = (String)form.getPoznamka(jazyk.getId());
                NebytovaProstoraJaz bytJaz = new NebytovaProstoraJaz();
                bytJaz.setJazyk(jazyk);
                novaPolozka.getNebytovaProstoraJazs().put(jazyk.getId(), bytJaz);
                bytJaz.setNebytovaProstora(novaPolozka);
                if (poznamka != null) {
                    bytJaz.setPoznamka(poznamka);
                } else {
                    bytJaz.setPoznamka("");
                }
                hsess.save((Object)bytJaz);
            }
            vysledek.put("id", novaPolozka.getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map zapsatPolozku(AdminNebytovaProstoraForm form, String id, ActionMapping mapping, HttpServletRequest request, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            ActionErrors errors = form.validate(mapping, request);
            if (errors != null && !errors.isEmpty()) {
                vysledek.put("validacni_chyba", this.validacniChyba((ActionMessages)errors));
                vysledek.put("adminNebytovaProstoraForm", (Object)form);
                return vysledek;
            }
            NebytovaProstora polozka = (NebytovaProstora)hsess.load(NebytovaProstora.class, (Serializable)new Integer(id));
            ConvertService.registrujCeske();
            List jazyky = LokalitaDelegate.getSeznamJazyku(hsess);
            for (Jazyk jazyk : jazyky) {
                String poznamka;
                NebytovaProstoraJaz bytJaz = (NebytovaProstoraJaz)polozka.getNebytovaProstoraJazs().get(jazyk.getId());
                if (bytJaz == null) {
                    bytJaz = new NebytovaProstoraJaz();
                    bytJaz.setJazyk(jazyk);
                    bytJaz.setNebytovaProstora(polozka);
                    hsess.save((Object)bytJaz);
                }
                if ((poznamka = (String)form.getPoznamka(jazyk.getId())) != null) {
                    bytJaz.setPoznamka(poznamka);
                } else {
                    bytJaz.setPoznamka("");
                }
                hsess.save((Object)bytJaz);
            }
            BeanUtils.copyProperties((Object)polozka, (Object)((Object)form));
            ConvertService.odregistrujCeske();
            Dum dum = (Dum)hsess.load(Dum.class, (Serializable)new Integer(form.getDumId()));
            polozka.setDum(dum);
            long privesek = Math.round(Math.random() * 1000.0);
            FormFile file = form.getObrazekFile();
            if (file != null && file.getFileName().length() > 0) {
                polozka.setObrazek(LokalitaDelegate.prepisSoubor(cesta, dum.getLokalita(), privesek, file, polozka.getObrazek(), "byt_obrazek"));
            }
            polozka.setTypStavu((TypStavu)hsess.load(TypStavu.class, (Serializable)((Object)form.getTypStavuId())));
            polozka.setTypNebytoveProstory((TypNebytoveProstory)hsess.load(TypNebytoveProstory.class, (Serializable)((Object)form.getTypNebytoveProstoryId())));
            vysledek.put("adminNebytovaProstoraForm", (Object)form);
            vysledek.put("id", polozka.getId());
            vysledek.put("idDum", polozka.getDum().getId());
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.zapsani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public Map smazatPolozku(String id, String cesta, Session hsess) {
        HashMap<String, Object> vysledek = new HashMap<String, Object>();
        try {
            NebytovaProstora staraPolozka = (NebytovaProstora)hsess.load(NebytovaProstora.class, (Serializable)new Integer(id));
            vysledek.put("idDum", staraPolozka.getDum().getId());
            if (staraPolozka.getObrazek() != null && staraPolozka.getObrazek().length() > 0) {
                LokalitaDelegate.smazatSwf(cesta, staraPolozka.getDum().getLokalita().getId(), staraPolozka.getObrazek());
            }
            hsess.delete((Object)staraPolozka);
            hsess.flush();
        }
        catch (HibernateException e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
            if (hsess.getTransaction().isActive()) {
                hsess.getTransaction().rollback();
            }
        }
        catch (Exception e) {
            vysledek.put("chyba", this.res.getMessage("admin.chyba.smazani_polozky", (Object)e.getMessage()));
        }
        return vysledek;
    }

    public List getSeznamDomu(String id, Session hsess) {
        Dum dum = (Dum)hsess.load(Dum.class, (Serializable)new Integer(id));
        return hsess.createQuery("from Dum dum where dum.lokalita = ? order by dum.razeni").setEntity(0, (Object)dum.getLokalita()).list();
    }

    public List getSeznamPodlazi(String id, Session hsess) {
        List vysledek = null;
        Podlazi podlazi = (Podlazi)hsess.load(Podlazi.class, (Serializable)new Integer(id));
        vysledek = hsess.createQuery("from Podlazi podlazi where podlazi.dum = ? order by typPodlazi.razeni").setEntity(0, (Object)podlazi.getDum()).list();
        return vysledek;
    }

    public List getSeznamTypuProstor(Session hsess) {
        return hsess.createQuery("from TypProstor typProstor order by typProstor.id").list();
    }

    public List getSeznamTypuBloku(Session hsess) {
        return hsess.createQuery("from TypBloku typBloku order by typBloku.razeni").list();
    }

    public List getSeznamTypuStavu(Session hsess) {
        return hsess.createQuery("from TypStavu typStavu order by typStavu.id").list();
    }

    public List getSeznamTypuNebytovychProstor(Session hsess) {
        return hsess.createQuery("from TypNebytoveProstory typNebytoveProstory order by typNebytoveProstory.id").list();
    }
}

