/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSActionObject;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class FSButtonEvent
extends FSTransformObject {
    public static final int RollOver = 1;
    public static final int RollOut = 2;
    public static final int Press = 4;
    public static final int Release = 8;
    public static final int DragOut = 16;
    public static final int DragOver = 32;
    public static final int ReleaseOut = 64;
    public static final int MenuDragOver = 128;
    public static final int MenuDragOut = 256;
    public static final int Left = 512;
    public static final int Right = 1024;
    public static final int Home = 1536;
    public static final int End = 2048;
    public static final int Insert = 2560;
    public static final int Delete = 3072;
    public static final int Backspace = 4096;
    public static final int Enter = 6656;
    public static final int Up = 7168;
    public static final int Down = 7680;
    public static final int Pageup = 8192;
    public static final int Pagedown = 8704;
    public static final int Tab = 9216;
    public static final int Escape = 9728;
    public static final int Space = 16384;
    private int event = 0;
    private int length = 0;
    private ArrayList actions = null;
    private byte[] encodedActions = null;

    public static int codeForKey(char c) {
        return c << 9;
    }

    FSButtonEvent(FSCoder fSCoder, int n) {
        this.length = n - 2;
        if (fSCoder.context[18] == 0) {
            this.encodedActions = new byte[n - 3];
        }
        this.decode(fSCoder);
    }

    public FSButtonEvent(FSCoder fSCoder) {
        this.decode(fSCoder);
    }

    public FSButtonEvent(int n, ArrayList arrayList) {
        this.setEvent(n);
        this.setActions(arrayList);
    }

    public FSButtonEvent(int n, byte[] byArray) {
        this.setEvent(n);
        this.setEncodedActions(byArray);
    }

    public FSButtonEvent(FSButtonEvent fSButtonEvent) {
        this.event = fSButtonEvent.event;
        if (fSButtonEvent.actions != null) {
            this.actions = new ArrayList();
            Iterator iterator = fSButtonEvent.actions.iterator();
            while (iterator.hasNext()) {
                this.actions.add(((FSActionObject)iterator.next()).clone());
            }
        } else {
            this.encodedActions = Transform.clone(fSButtonEvent.encodedActions);
        }
    }

    public void add(FSActionObject fSActionObject) {
        if (this.encodedActions != null) {
            this.actions = FSMovie.decodeActions(this.encodedActions);
            this.encodedActions = null;
        }
        this.actions.add(fSActionObject);
    }

    public int getEvent() {
        return this.event;
    }

    public ArrayList getActions() {
        if (this.encodedActions != null) {
            this.actions = FSMovie.decodeActions(this.encodedActions);
            this.encodedActions = null;
        }
        return this.actions;
    }

    public byte[] getEncodedActions() {
        return this.encodedActions;
    }

    public void setEvent(int n) {
        this.event = n;
    }

    public void setActions(ArrayList arrayList) {
        this.actions = arrayList;
        this.encodedActions = null;
    }

    public void setEncodedActions(byte[] byArray) {
        this.encodedActions = byArray;
        this.actions = null;
    }

    public Object clone() {
        FSButtonEvent fSButtonEvent = (FSButtonEvent)super.clone();
        if (this.actions != null) {
            fSButtonEvent.actions = new ArrayList();
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                fSButtonEvent.actions.add(((FSActionObject)iterator.next()).clone());
            }
        } else {
            fSButtonEvent.encodedActions = Transform.clone(this.encodedActions);
        }
        return fSButtonEvent;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSButtonEvent fSButtonEvent = (FSButtonEvent)object;
            bl = this.event == fSButtonEvent.event;
            bl = this.actions != null ? this.actions.equals(fSButtonEvent.actions) : Transform.equals(this.encodedActions, fSButtonEvent.encodedActions);
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append(this.name());
        if (n > 0) {
            stringBuffer.append(": { ");
            Transform.append(stringBuffer, "event", this.event);
            if (this.actions != null) {
                Transform.append(stringBuffer, "actions", this.actions, n);
            } else {
                stringBuffer.append("actions = <data>; ");
            }
            stringBuffer.append("}");
        }
    }

    public int length(FSCoder fSCoder) {
        this.length = 2;
        if (this.actions != null) {
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                FSActionObject fSActionObject = (FSActionObject)iterator.next();
                this.length += fSActionObject.length(fSCoder);
                this.length += fSActionObject.getType() > 128 ? 3 : 1;
            }
        } else {
            this.length += this.encodedActions.length;
        }
        ++this.length;
        return this.length;
    }

    public void encode(FSCoder fSCoder) {
        fSCoder.writeWord(this.event, 2);
        if (this.actions != null) {
            Iterator iterator = this.actions.iterator();
            while (iterator.hasNext()) {
                FSActionObject fSActionObject = (FSActionObject)iterator.next();
                int n = fSCoder.getPointer();
                int n2 = fSActionObject.getLength();
                int n3 = fSCoder.getPointer() + (fSActionObject.getType() > 128 ? 24 : 8);
                int n4 = n3 + (n2 << 3);
                fSActionObject.encode(fSCoder);
                fSCoder.setPointer(n4);
                int n5 = fSCoder.getPointer() - n4 >> 3;
                if (n5 == 0) continue;
                fSCoder.context[14] = 1;
                fSCoder.context[15] = fSActionObject.getType();
                fSCoder.context[16] = n >>> 3;
                fSCoder.context[17] = n4 - n >>> 3;
                fSCoder.context[13] = n5;
            }
        } else {
            fSCoder.writeBytes(this.encodedActions);
        }
        fSCoder.writeWord(0, 1);
    }

    public void decode(FSCoder fSCoder) {
        this.event = fSCoder.readWord(2, false);
        if (fSCoder.context[18] == 1) {
            this.actions = new ArrayList();
            while (this.length > 1) {
                int n = fSCoder.getPointer();
                this.actions.add(FSMovie.decodeAction(fSCoder));
                this.length -= fSCoder.getPointer() - n >>> 3;
            }
        } else {
            fSCoder.readBytes(this.encodedActions);
        }
        fSCoder.readWord(1, false);
    }
}

