/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform;

import com.flagstone.transform.FSAction;
import com.flagstone.transform.FSActionObject;
import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSButtonColorTransform;
import com.flagstone.transform.FSButtonSound;
import com.flagstone.transform.FSCall;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSCoderException;
import com.flagstone.transform.FSCurve;
import com.flagstone.transform.FSDefineButton;
import com.flagstone.transform.FSDefineButton2;
import com.flagstone.transform.FSDefineFont;
import com.flagstone.transform.FSDefineFont2;
import com.flagstone.transform.FSDefineImage;
import com.flagstone.transform.FSDefineImage2;
import com.flagstone.transform.FSDefineJPEGImage;
import com.flagstone.transform.FSDefineJPEGImage2;
import com.flagstone.transform.FSDefineJPEGImage3;
import com.flagstone.transform.FSDefineMorphShape;
import com.flagstone.transform.FSDefineMovieClip;
import com.flagstone.transform.FSDefineObject;
import com.flagstone.transform.FSDefineShape;
import com.flagstone.transform.FSDefineShape2;
import com.flagstone.transform.FSDefineShape3;
import com.flagstone.transform.FSDefineSound;
import com.flagstone.transform.FSDefineText;
import com.flagstone.transform.FSDefineText2;
import com.flagstone.transform.FSDefineTextField;
import com.flagstone.transform.FSDefineVideo;
import com.flagstone.transform.FSDoAction;
import com.flagstone.transform.FSEnableDebugger;
import com.flagstone.transform.FSEnableDebugger2;
import com.flagstone.transform.FSExceptionHandler;
import com.flagstone.transform.FSExport;
import com.flagstone.transform.FSFontInfo;
import com.flagstone.transform.FSFontInfo2;
import com.flagstone.transform.FSFrameLabel;
import com.flagstone.transform.FSFree;
import com.flagstone.transform.FSGetUrl;
import com.flagstone.transform.FSGetUrl2;
import com.flagstone.transform.FSGotoFrame;
import com.flagstone.transform.FSGotoFrame2;
import com.flagstone.transform.FSGotoLabel;
import com.flagstone.transform.FSIf;
import com.flagstone.transform.FSImport;
import com.flagstone.transform.FSInitialize;
import com.flagstone.transform.FSJPEGEncodingTable;
import com.flagstone.transform.FSJump;
import com.flagstone.transform.FSLimitScript;
import com.flagstone.transform.FSLine;
import com.flagstone.transform.FSMovieEvent;
import com.flagstone.transform.FSMovieListener;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.FSNewFunction;
import com.flagstone.transform.FSNewFunction2;
import com.flagstone.transform.FSPathsArePostscript;
import com.flagstone.transform.FSPlaceObject;
import com.flagstone.transform.FSPlaceObject2;
import com.flagstone.transform.FSPointer;
import com.flagstone.transform.FSProtect;
import com.flagstone.transform.FSPush;
import com.flagstone.transform.FSQuicktimeMovie;
import com.flagstone.transform.FSRegisterCopy;
import com.flagstone.transform.FSRemoveObject;
import com.flagstone.transform.FSRemoveObject2;
import com.flagstone.transform.FSSerialNumber;
import com.flagstone.transform.FSSetBackgroundColor;
import com.flagstone.transform.FSSetTarget;
import com.flagstone.transform.FSShapeStyle;
import com.flagstone.transform.FSShowFrame;
import com.flagstone.transform.FSSoundStreamBlock;
import com.flagstone.transform.FSSoundStreamHead;
import com.flagstone.transform.FSSoundStreamHead2;
import com.flagstone.transform.FSStartSound;
import com.flagstone.transform.FSTabOrder;
import com.flagstone.transform.FSTable;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.FSUnknownAction;
import com.flagstone.transform.FSUnknownObject;
import com.flagstone.transform.FSVideoFrame;
import com.flagstone.transform.FSWaitForFrame;
import com.flagstone.transform.FSWaitForFrame2;
import com.flagstone.transform.FSWith;
import com.flagstone.transform.Transform;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class FSMovie
implements Cloneable {
    private boolean decodeActions = true;
    private boolean decodeShapes = true;
    private boolean decodeGlyphs = true;
    private int identifier = 0;
    private String encoding = "UTF8";
    private String signature = "";
    private int version = 7;
    private FSBounds frameSize = null;
    private int length = 0;
    private float frameRate = 0.0f;
    private int frameCount = 0;
    private ArrayList objects = new ArrayList();

    static void encodeObjects(FSCoder fSCoder, ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            FSMovieObject fSMovieObject = (FSMovieObject)iterator.next();
            int n = fSCoder.getPointer();
            int n2 = fSMovieObject.getLength();
            int n3 = fSCoder.getPointer() + (fSMovieObject.getExtendLength() || n2 >= 63 ? 48 : 16);
            int n4 = n3 + (n2 << 3);
            fSMovieObject.encode(fSCoder);
            fSCoder.setPointer(n4);
            int n5 = fSCoder.getPointer() - n4 >> 3;
            if (n5 == 0) continue;
            fSCoder.context[14] = 1;
            fSCoder.context[15] = fSMovieObject.getType();
            fSCoder.context[16] = n >>> 3;
            fSCoder.context[17] = n4 - n >>> 3;
            fSCoder.context[13] = n5;
        }
    }

    static FSMovieObject decodeObject(FSCoder fSCoder) {
        FSMovieObject fSMovieObject = null;
        int n = fSCoder.getPointer();
        int n2 = fSCoder.scanWord(2, false) >> 6;
        int n3 = fSCoder.scanWord(2, false) & 0x3F;
        int n4 = fSCoder.getPointer() + 16 + (n3 << 3);
        int n5 = 0;
        if (n2 == 0) {
            fSCoder.setPointer(n4);
            return fSMovieObject;
        }
        if (n3 == 63) {
            fSCoder.adjustPointer(16);
            n3 = fSCoder.scanWord(4, false);
            n4 = fSCoder.getPointer() + 32 + (n3 << 3);
            fSCoder.adjustPointer(-16);
        }
        switch (n2) {
            case 1: {
                fSMovieObject = FSShowFrame.getInstance();
                fSCoder.setPointer(n4);
                break;
            }
            case 2: {
                fSMovieObject = new FSDefineShape(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 4: {
                fSMovieObject = new FSPlaceObject(fSCoder);
                break;
            }
            case 5: {
                fSMovieObject = new FSRemoveObject(fSCoder);
                break;
            }
            case 6: {
                fSMovieObject = new FSDefineJPEGImage(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 7: {
                fSMovieObject = new FSDefineButton(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 8: {
                fSMovieObject = new FSJPEGEncodingTable(fSCoder);
                break;
            }
            case 9: {
                fSMovieObject = new FSSetBackgroundColor(fSCoder);
                break;
            }
            case 10: {
                fSMovieObject = new FSDefineFont(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 11: {
                fSMovieObject = new FSDefineText(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 12: {
                fSMovieObject = new FSDoAction(fSCoder);
                break;
            }
            case 13: {
                fSMovieObject = new FSFontInfo(fSCoder);
                break;
            }
            case 14: {
                fSMovieObject = new FSDefineSound(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 15: {
                fSMovieObject = new FSStartSound(fSCoder);
                break;
            }
            case 18: {
                fSMovieObject = new FSSoundStreamHead(fSCoder);
                break;
            }
            case 19: {
                fSMovieObject = new FSSoundStreamBlock(fSCoder);
                break;
            }
            case 17: {
                fSMovieObject = new FSButtonSound(fSCoder);
                break;
            }
            case 20: {
                fSMovieObject = new FSDefineImage(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 21: {
                fSMovieObject = new FSDefineJPEGImage2(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 22: {
                fSMovieObject = new FSDefineShape2(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 23: {
                fSMovieObject = new FSButtonColorTransform(fSCoder);
                break;
            }
            case 24: {
                fSMovieObject = new FSProtect(fSCoder);
                break;
            }
            case 3: {
                fSMovieObject = new FSFree(fSCoder);
                break;
            }
            case 26: {
                fSMovieObject = new FSPlaceObject2(fSCoder);
                break;
            }
            case 28: {
                fSMovieObject = new FSRemoveObject2(fSCoder);
                break;
            }
            case 32: {
                fSMovieObject = new FSDefineShape3(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 33: {
                fSMovieObject = new FSDefineText2(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 34: {
                fSMovieObject = new FSDefineButton2(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 35: {
                fSMovieObject = new FSDefineJPEGImage3(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 36: {
                fSMovieObject = new FSDefineImage2(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 39: {
                fSMovieObject = new FSDefineMovieClip(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 43: {
                fSMovieObject = new FSFrameLabel(fSCoder);
                break;
            }
            case 45: {
                fSMovieObject = new FSSoundStreamHead2(fSCoder);
                break;
            }
            case 46: {
                fSMovieObject = new FSDefineMorphShape(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 48: {
                fSMovieObject = new FSDefineFont2(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 25: {
                fSMovieObject = FSPathsArePostscript.getInstance();
                fSCoder.setPointer(n4);
                break;
            }
            case 37: {
                fSMovieObject = new FSDefineTextField(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 38: {
                fSMovieObject = new FSQuicktimeMovie(fSCoder);
                break;
            }
            case 41: {
                fSMovieObject = new FSSerialNumber(fSCoder);
                break;
            }
            case 1023: {
                fSMovieObject = new FSPointer(fSCoder);
                break;
            }
            case 58: {
                fSMovieObject = new FSEnableDebugger(fSCoder);
                break;
            }
            case 56: {
                fSMovieObject = new FSExport(fSCoder);
                break;
            }
            case 57: {
                fSMovieObject = new FSImport(fSCoder);
                break;
            }
            case 59: {
                fSMovieObject = new FSInitialize(fSCoder);
                break;
            }
            case 60: {
                fSMovieObject = new FSDefineVideo(fSCoder);
                n5 = ((FSDefineObject)fSMovieObject).getIdentifier();
                break;
            }
            case 61: {
                fSMovieObject = new FSVideoFrame(fSCoder);
                break;
            }
            case 62: {
                fSMovieObject = new FSFontInfo2(fSCoder);
                break;
            }
            case 64: {
                fSMovieObject = new FSEnableDebugger2(fSCoder);
                break;
            }
            case 65: {
                fSMovieObject = new FSLimitScript(fSCoder);
                break;
            }
            case 66: {
                fSMovieObject = new FSTabOrder(fSCoder);
                break;
            }
            default: {
                fSMovieObject = new FSUnknownObject(fSCoder);
            }
        }
        int n6 = fSCoder.getPointer() - n4 >> 3;
        if (n6 != 0) {
            fSCoder.context[14] = 1;
            fSCoder.context[15] = fSMovieObject.getType();
            fSCoder.context[16] = n >>> 3;
            fSCoder.context[17] = n4 - n >>> 3;
            fSCoder.context[13] = n6;
        }
        fSCoder.setPointer(n4);
        if (n5 != 0) {
            fSCoder.context[5] = Math.max(fSCoder.context[5], n5);
        }
        return fSMovieObject;
    }

    static FSActionObject decodeAction(FSCoder fSCoder) {
        int n;
        FSActionObject fSActionObject = null;
        int n2 = fSCoder.getPointer();
        int n3 = fSCoder.scanWord(1, false);
        int n4 = 0;
        int n5 = n = fSCoder.getPointer() + 8;
        if (n3 > 128) {
            fSCoder.adjustPointer(8);
            n4 = fSCoder.scanWord(2, false);
            n = fSCoder.getPointer() + 16;
            n5 = n + (n4 << 3);
            fSCoder.adjustPointer(-8);
        }
        switch (n3) {
            case 0: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                fSActionObject = FSAction.getInstance(n3);
                fSCoder.adjustPointer(8);
                break;
            }
            case 131: {
                fSActionObject = new FSGetUrl(fSCoder);
                break;
            }
            case 129: {
                fSActionObject = new FSGotoFrame(fSCoder);
                break;
            }
            case 140: {
                fSActionObject = new FSGotoLabel(fSCoder);
                break;
            }
            case 139: {
                fSActionObject = new FSSetTarget(fSCoder);
                break;
            }
            case 138: {
                fSActionObject = new FSWaitForFrame(fSCoder);
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                fSActionObject = FSAction.getInstance(n3);
                fSCoder.adjustPointer(8);
                break;
            }
            case 158: {
                fSActionObject = FSCall.getInstance();
                fSCoder.setPointer(n5);
                break;
            }
            case 150: {
                fSActionObject = new FSPush(fSCoder);
                break;
            }
            case 141: {
                fSActionObject = new FSWaitForFrame2(fSCoder);
                break;
            }
            case 153: {
                fSActionObject = new FSJump(fSCoder);
                break;
            }
            case 157: {
                fSActionObject = new FSIf(fSCoder);
                break;
            }
            case 154: {
                fSActionObject = new FSGetUrl2(fSCoder);
                break;
            }
            case 159: {
                fSActionObject = new FSGotoFrame2(fSCoder);
                break;
            }
            case 58: 
            case 59: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: 
            case 70: 
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: {
                fSActionObject = FSAction.getInstance(n3);
                fSCoder.adjustPointer(8);
                break;
            }
            case 136: {
                fSActionObject = new FSTable(fSCoder);
                n4 = fSActionObject.getLength();
                n5 = n + (n4 << 3);
                break;
            }
            case 135: {
                fSActionObject = new FSRegisterCopy(fSCoder);
                break;
            }
            case 155: {
                fSActionObject = new FSNewFunction(fSCoder);
                n4 = fSActionObject.getLength();
                n5 = n + (n4 << 3);
                break;
            }
            case 148: {
                fSActionObject = new FSWith(fSCoder);
                n4 = fSActionObject.getLength();
                n5 = n + (n4 << 3);
                break;
            }
            case 84: 
            case 85: 
            case 102: 
            case 103: 
            case 104: {
                fSActionObject = FSAction.getInstance(n3);
                fSCoder.adjustPointer(8);
                break;
            }
            case 42: 
            case 43: 
            case 44: 
            case 105: {
                fSActionObject = FSAction.getInstance(n3);
                fSCoder.adjustPointer(8);
                break;
            }
            case 143: {
                fSActionObject = new FSExceptionHandler(fSCoder);
                break;
            }
            case 142: {
                fSActionObject = new FSNewFunction2(fSCoder);
                n4 = fSActionObject.getLength();
                n5 = n + (n4 << 3);
                break;
            }
            default: {
                fSActionObject = new FSUnknownAction(fSCoder);
            }
        }
        int n6 = fSCoder.getPointer() - n5 >> 3;
        if (n6 != 0) {
            fSCoder.context[14] = 1;
            fSCoder.context[15] = fSActionObject.getType();
            fSCoder.context[16] = n2 >>> 3;
            fSCoder.context[17] = n5 - n2 >>> 3;
            fSCoder.context[13] = n6;
        }
        fSCoder.setPointer(n5);
        return fSActionObject;
    }

    static ArrayList decodeActions(byte[] byArray) {
        int n;
        FSCoder fSCoder = new FSCoder(0, byArray);
        ArrayList<FSActionObject> arrayList = new ArrayList<FSActionObject>();
        for (int i = byArray.length; i > 0; i -= fSCoder.getPointer() - n >>> 3) {
            n = fSCoder.getPointer();
            arrayList.add(FSMovie.decodeAction(fSCoder));
        }
        return arrayList;
    }

    static ArrayList decodeShape(byte[] byArray) {
        FSCoder fSCoder = new FSCoder(0, byArray);
        return FSMovie.decodeShape(fSCoder);
    }

    static ArrayList decodeShape(FSCoder fSCoder) {
        ArrayList<FSTransformObject> arrayList = new ArrayList<FSTransformObject>();
        int n = fSCoder.readBits(4, false);
        int n2 = fSCoder.readBits(4, false);
        fSCoder.context[6] = n;
        fSCoder.context[7] = n2;
        while (fSCoder.scanBits(6, false) > 0) {
            if ((fSCoder.scanBits(6, false) & 0x20) > 0) {
                if ((fSCoder.scanBits(6, false) & 0x10) > 0) {
                    arrayList.add(new FSLine(fSCoder));
                    continue;
                }
                arrayList.add(new FSCurve(fSCoder));
                continue;
            }
            arrayList.add(new FSShapeStyle(fSCoder));
        }
        fSCoder.adjustPointer(6);
        fSCoder.alignToByte();
        return arrayList;
    }

    public FSMovie() {
        this.signature = "CWS";
    }

    public FSMovie(FSBounds fSBounds, float f) {
        this.signature = "CWS";
        this.setFrameSize(fSBounds);
        this.setFrameRate(f);
    }

    public FSMovie(String string, String string2, int n, FSBounds fSBounds, float f, ArrayList arrayList) {
        this.setEncoding(string);
        this.setSignature(string2);
        this.setVersion(n);
        this.setFrameSize(fSBounds);
        this.setFrameRate(f);
        this.setObjects(arrayList);
    }

    public FSMovie(String string) throws IOException, DataFormatException {
        this.decodeFromFile(string);
    }

    public FSMovie(String string, FSMovieListener fSMovieListener) {
        this.decodeFromFile(string, fSMovieListener);
    }

    public FSMovie(byte[] byArray) throws DataFormatException, IOException {
        this.decodeFromData(byArray);
    }

    public FSMovie(byte[] byArray, FSMovieListener fSMovieListener) {
        this.decodeFromData(byArray, fSMovieListener);
    }

    public synchronized int newIdentifier() {
        return ++this.identifier;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int n) {
        this.identifier = n;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setDecodeActions(boolean bl) {
        this.decodeActions = bl;
    }

    public boolean willDecodeActions() {
        return this.decodeActions;
    }

    public void setDecodeShapes(boolean bl) {
        this.decodeShapes = bl;
    }

    public boolean willDecodeShapes() {
        return this.decodeShapes;
    }

    public void setDecodeGlyphs(boolean bl) {
        this.decodeGlyphs = bl;
    }

    public boolean willDecodeGlyphs() {
        return this.decodeGlyphs;
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String string) {
        this.signature = string;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public FSBounds getFrameSize() {
        return this.frameSize;
    }

    public void setFrameSize(FSBounds fSBounds) {
        this.frameSize = fSBounds;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public void setFrameRate(float f) {
        this.frameRate = f;
    }

    public ArrayList getObjects() {
        return this.objects;
    }

    public void setObjects(ArrayList arrayList) {
        this.objects = arrayList;
    }

    public void add(FSMovieObject fSMovieObject) {
        this.objects.add(fSMovieObject);
    }

    public void add(ArrayList arrayList) {
        this.objects.addAll(arrayList);
    }

    public ArrayList getObjectsOfType(int n) {
        ArrayList<FSMovieObject> arrayList = new ArrayList<FSMovieObject>();
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            FSMovieObject fSMovieObject = (FSMovieObject)iterator.next();
            if (fSMovieObject.getType() != n) continue;
            arrayList.add(fSMovieObject);
        }
        return arrayList;
    }

    public void decodeFromFile(String string) throws FileNotFoundException, DataFormatException, IOException {
        FileInputStream fileInputStream = null;
        File file = new File(string);
        fileInputStream = new FileInputStream(file);
        int n = (int)file.length();
        byte[] byArray = new byte[n];
        fileInputStream.read(byArray);
        fileInputStream.close();
        this.decodeFromData(byArray);
    }

    public void decodeFromFile(String string, FSMovieListener fSMovieListener) {
        block6: {
            FileInputStream fileInputStream = null;
            try {
                File file = new File(string);
                fileInputStream = new FileInputStream(file);
                int n = (int)file.length();
                byte[] byArray = new byte[n];
                fileInputStream.read(byArray);
                fileInputStream.close();
                this.decodeFromData(byArray, fSMovieListener);
            }
            catch (SecurityException securityException) {
                if (fSMovieListener != null) {
                    fSMovieListener.logEvent(new FSMovieEvent(1, 2, 0, 0, "FileNotFoundError"));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (fSMovieListener != null) {
                    fSMovieListener.logEvent(new FSMovieEvent(1, 2, 0, 0, "FileNotFoundError"));
                }
            }
            catch (IOException iOException) {
                if (fSMovieListener == null) break block6;
                fSMovieListener.logEvent(new FSMovieEvent(1, 2, 0, 0, "FileReadError"));
            }
        }
    }

    public void decodeFromData(byte[] byArray) throws DataFormatException, IOException {
        FSCoder fSCoder = null;
        FSMovieObject fSMovieObject = null;
        this.isFlash(byArray);
        fSCoder = byArray[0] == 67 ? new FSCoder(0, this.unzip(byArray)) : new FSCoder(0, byArray);
        this.signature = fSCoder.readString(3, "UTF8");
        this.version = fSCoder.readWord(1, false);
        fSCoder.readWord(4, false);
        this.frameSize = new FSBounds(fSCoder);
        this.frameRate = fSCoder.readFixedWord(1, 1);
        this.frameCount = fSCoder.readWord(2, false);
        fSCoder.context[2] = this.version;
        fSCoder.context[18] = this.decodeActions ? 1 : 0;
        fSCoder.context[19] = this.decodeShapes ? 1 : 0;
        int n = fSCoder.context[20] = this.decodeGlyphs ? 1 : 0;
        while ((fSMovieObject = FSMovie.decodeObject(fSCoder)) != null) {
            this.objects.add(fSMovieObject);
            if (fSCoder.context[14] != 1) continue;
            throw new FSCoderException(fSCoder.context[15], fSCoder.context[16], fSCoder.context[17], fSCoder.context[13], fSCoder.context[13] > 0 ? "ObjectOverflow" : "ObjectUnderflow");
        }
        this.identifier = fSCoder.context[5];
    }

    public void decodeFromData(byte[] byArray, FSMovieListener fSMovieListener) {
        FSCoder fSCoder = null;
        FSMovieObject fSMovieObject = null;
        try {
            this.isFlash(byArray);
            fSCoder = byArray[0] == 67 ? new FSCoder(0, this.unzip(byArray)) : new FSCoder(0, byArray);
            fSCoder.context[1] = 1;
            fSCoder.setListener(fSMovieListener);
            fSCoder.beginObject("FSMovie");
            this.signature = fSCoder.readString(3, "UTF8");
            this.version = fSCoder.readWord(1, false);
            this.length = fSCoder.readWord(4, false);
            this.frameSize = new FSBounds(fSCoder);
            this.frameRate = fSCoder.readFixedWord(1, 1);
            this.frameCount = fSCoder.readWord(2, false);
            fSCoder.context[2] = this.version;
            fSCoder.beginObject("ArrayList");
            while ((fSMovieObject = FSMovie.decodeObject(fSCoder)) != null) {
                this.objects.add(fSMovieObject);
            }
            fSCoder.endObject("ArrayList");
            this.identifier = fSCoder.context[5];
            fSCoder.endObject("FSMovie");
        }
        catch (DataFormatException dataFormatException) {
            fSCoder.logError("DataFormatError", 0, 0);
        }
    }

    public void encodeToFile(String string) throws FileNotFoundException, IOException {
        FileOutputStream fileOutputStream = null;
        fileOutputStream = new FileOutputStream(string);
        byte[] byArray = this.encode();
        fileOutputStream.write(byArray);
        fileOutputStream.close();
    }

    public void encodeToFile(String string, FSMovieListener fSMovieListener) {
        block6: {
            FileOutputStream fileOutputStream = null;
            try {
                fileOutputStream = new FileOutputStream(string);
                byte[] byArray = this.encode(fSMovieListener);
                fileOutputStream.write(byArray);
                fileOutputStream.close();
            }
            catch (SecurityException securityException) {
                if (fSMovieListener != null) {
                    fSMovieListener.logEvent(new FSMovieEvent(0, 2, 0, 0, "FileNotFoundError"));
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (fSMovieListener != null) {
                    fSMovieListener.logEvent(new FSMovieEvent(0, 2, 0, 0, "FileNotFoundError"));
                }
            }
            catch (IOException iOException) {
                if (fSMovieListener == null) break block6;
                fSMovieListener.logEvent(new FSMovieEvent(0, 2, 0, 0, "FileWriteError"));
            }
        }
    }

    public byte[] encode() throws IOException {
        FSCoder fSCoder = new FSCoder(0, new byte[0]);
        fSCoder.context[1] = 0;
        fSCoder.context[2] = this.version;
        int n = this.length(fSCoder);
        fSCoder.setData(0, new byte[n]);
        fSCoder.writeString(this.signature, "UTF8");
        fSCoder.writeWord(this.version, 1);
        fSCoder.writeWord(n, 4);
        this.frameSize.encode(fSCoder);
        fSCoder.writeFixedWord(this.frameRate, 1, 1);
        fSCoder.writeWord(this.numberOfFrames(), 2);
        Object object = this.objects.iterator();
        while (object.hasNext()) {
            FSMovieObject fSMovieObject = (FSMovieObject)object.next();
            int n2 = fSMovieObject.getLength();
            int n3 = fSCoder.getPointer() + (fSMovieObject.getExtendLength() || n2 >= 63 ? 48 : 16);
            int n4 = n3 + (n2 << 3);
            fSMovieObject.encode(fSCoder);
            fSCoder.setPointer(n4);
            if (fSCoder.context[14] != 1) continue;
            throw new FSCoderException(fSCoder.context[15], fSCoder.context[16], fSCoder.context[17], fSCoder.context[13], fSCoder.context[13] > 0 ? "ObjectOverflow" : "ObjectUnderflow");
        }
        fSCoder.writeWord(0, 2);
        object = null;
        try {
            object = this.signature.equals("CWS") ? (Object)this.zip(fSCoder.getData(), n) : (Object)fSCoder.getData();
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("Error compressing Flash file.");
        }
        return object;
    }

    public byte[] encode(FSMovieListener fSMovieListener) {
        FSCoder fSCoder = new FSCoder(0, new byte[0]);
        fSCoder.context[1] = 0;
        fSCoder.context[2] = this.version;
        int n = this.length(fSCoder);
        fSCoder.setData(0, new byte[n]);
        fSCoder.setListener(fSMovieListener);
        fSCoder.beginObject("FSMovie");
        fSCoder.writeString(this.signature, "UTF8");
        fSCoder.writeWord(this.version, 1);
        fSCoder.writeWord(n, 4);
        this.frameSize.encode(fSCoder);
        fSCoder.writeFixedWord(this.frameRate, 8, 8);
        fSCoder.writeWord(this.numberOfFrames(), 2);
        fSCoder.beginObject("ArrayList");
        Object object = this.objects.iterator();
        while (object.hasNext()) {
            FSMovieObject fSMovieObject = (FSMovieObject)object.next();
            int n2 = fSMovieObject.getLength();
            int n3 = fSCoder.getPointer() + (fSMovieObject.getExtendLength() || n2 >= 63 ? 48 : 16);
            int n4 = n3 + (n2 << 3);
            fSMovieObject.encode(fSCoder);
            fSCoder.setPointer(n4);
            int n5 = fSCoder.getPointer() - n4 >> 3;
            if (n5 < 0) {
                fSCoder.logError("ObjectOverflow", n4, -n5);
                continue;
            }
            if (n5 <= 0) continue;
            fSCoder.logError("ObjectUnderflow", n4, n5);
        }
        fSCoder.endObject("ArrayList");
        fSCoder.writeWord(0, 2);
        fSCoder.endObject("FSMovie");
        object = null;
        try {
            object = this.signature.equals("CWS") ? (Object)this.zip(fSCoder.getData(), n) : (Object)fSCoder.getData();
        }
        catch (DataFormatException dataFormatException) {
            fSCoder.logError("DataFormatError", 0, 0);
        }
        return object;
    }

    public Object clone() {
        FSMovie fSMovie = null;
        try {
            fSMovie = (FSMovie)super.clone();
            fSMovie.frameSize = this.frameSize != null ? (FSBounds)this.frameSize.clone() : null;
            fSMovie.objects = new ArrayList();
            Iterator iterator = this.objects.iterator();
            while (iterator.hasNext()) {
                fSMovie.objects.add(((FSMovieObject)iterator.next()).clone());
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError("Cannot clone movie.");
        }
        return fSMovie;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (super.equals(object)) {
            FSMovie fSMovie = (FSMovie)object;
            boolean bl2 = bl = this.version == fSMovie.version;
            bl = this.frameSize != null ? bl && this.frameSize.equals(fSMovie.frameSize) : bl && this.frameSize == fSMovie.frameSize;
            bl = bl && this.frameRate == fSMovie.frameRate;
            bl = bl && this.objects.equals(((FSMovie)object).getObjects());
        }
        return bl;
    }

    public void appendDescription(StringBuffer stringBuffer, int n) {
        stringBuffer.append("FSMovie");
        stringBuffer.append(" : { ");
        Transform.append(stringBuffer, "signature", this.signature);
        Transform.append(stringBuffer, "version", this.version);
        Transform.append(stringBuffer, "frameSize", this.frameSize, n);
        Transform.append(stringBuffer, "frameRate", this.frameRate);
        Transform.append(stringBuffer, "objects", this.objects, n);
        stringBuffer.append("}");
    }

    private int length(FSCoder fSCoder) {
        int n = 14;
        n += this.frameSize.length(fSCoder);
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            FSMovieObject fSMovieObject = (FSMovieObject)iterator.next();
            int n2 = fSMovieObject.length(fSCoder);
            n += fSMovieObject.getExtendLength() || n2 >= 63 ? n2 + 6 : n2 + 2;
        }
        return n;
    }

    private int numberOfFrames() {
        int n = 0;
        Iterator iterator = this.objects.iterator();
        while (iterator.hasNext()) {
            if (((FSMovieObject)iterator.next()).getType() != 1) continue;
            ++n;
        }
        return n;
    }

    private void isFlash(byte[] byArray) throws DataFormatException {
        boolean bl;
        if (byArray == null || byArray.length < 8) {
            throw new DataFormatException("Flash data is null or empty.");
        }
        boolean bl2 = bl = (byArray[0] == 67 || byArray[0] == 70) && byArray[1] == 87 && byArray[2] == 83;
        if (!bl) {
            throw new DataFormatException("Data does not start with a valid Flash signature.");
        }
    }

    private byte[] zip(byte[] byArray, int n) throws DataFormatException {
        byte[] byArray2 = null;
        Deflater deflater = new Deflater();
        byte[] byArray3 = new byte[n];
        deflater.setInput(byArray, 8, n - 8);
        deflater.finish();
        int n2 = deflater.deflate(byArray3);
        byArray2 = new byte[8 + n2];
        int n3 = 0;
        int n4 = 0;
        for (n3 = 0; n3 < 8; ++n3) {
            byArray2[n3] = byArray[n3];
        }
        for (n4 = 0; n4 < n2; ++n4) {
            byArray2[n3] = byArray3[n4];
            ++n3;
        }
        return byArray2;
    }

    private byte[] unzip(byte[] byArray) throws DataFormatException {
        int n = 0;
        for (int i = 0; i < 4; ++i) {
            n += (byArray[i + 4] & 0xFF) << i * 8;
        }
        byte[] byArray2 = new byte[n];
        for (int i = 0; i < 8; ++i) {
            byArray2[i] = byArray[i];
        }
        Inflater inflater = new Inflater();
        inflater.setInput(byArray, 8, byArray.length - 8);
        inflater.inflate(byArray2, 8, n - 8);
        return byArray2;
    }
}

