/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util;

public class FSCodec {
    public static final int LITTLE_ENDIAN = 0;
    public static final int BIG_ENDIAN = 1;
    private int byteOrder = 0;
    private byte[] data = null;
    private int ptr = 0;
    private int end = 0;

    public FSCodec(int n, byte[] byArray) {
        this.byteOrder = n;
        this.data = new byte[byArray.length];
        System.arraycopy(byArray, 0, this.data, 0, byArray.length);
        this.end = this.data.length << 3;
    }

    public FSCodec(int n, int n2) {
        this.byteOrder = n;
        this.data = new byte[n2];
        this.end = this.data.length << 3;
    }

    public byte[] getData() {
        int n = this.ptr + 7 >> 3;
        byte[] byArray = new byte[n];
        System.arraycopy(this.data, 0, byArray, 0, n);
        return byArray;
    }

    public void setData(byte[] byArray) {
        this.data = byArray;
        this.ptr = 0;
        this.end = this.data.length << 3;
    }

    public void setData(int n, byte[] byArray) {
        this.byteOrder = n;
        this.data = byArray;
        this.ptr = 0;
        this.end = this.data.length << 3;
    }

    public int getPosition() {
        return this.ptr;
    }

    public void setPosition(int n) {
        this.ptr = n < 0 ? 0 : (n > this.end ? this.end : n);
    }

    public void alignToByte() {
        this.ptr = this.ptr + 7 & 0xFFFFFFF8;
    }

    public boolean eof() {
        return this.ptr >= this.end;
    }

    public boolean findBits(int n, int n2, int n3) {
        boolean bl = false;
        int n4 = this.ptr;
        int n5 = 0;
        if (n2 < 1 || n2 > 32) {
            throw new IllegalArgumentException("Number of bits must be in the range 1..32.");
        }
        while (this.ptr < this.end) {
            n5 = this.readBits(n2, false);
            this.ptr -= n2;
            if (n5 == n) {
                bl = true;
                break;
            }
            this.ptr += n3;
        }
        if (!bl) {
            this.ptr = n4;
        }
        return bl;
    }

    public boolean findWord(int n, int n2, int n3) {
        boolean bl = false;
        int n4 = this.ptr;
        int n5 = 0;
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException("Number of bytes must be in the range 1..4.");
        }
        if ((this.ptr & 7) > 0) {
            this.ptr = this.ptr + 7 & 0xFFFFFFF8;
        }
        while (this.ptr < this.end) {
            n5 = this.readWord(n2, false);
            this.ptr -= n2 * 8;
            if (n5 == n) {
                bl = true;
                break;
            }
            this.ptr += n3;
        }
        if (!bl) {
            this.ptr = n4;
        }
        return bl;
    }

    public int readBits(int n, boolean bl) {
        int n2 = 0;
        if (n < 1 || n > 32) {
            throw new IllegalArgumentException("Number of bits must be in the range 1..32.");
        }
        int n3 = this.ptr >> 3;
        int n4 = this.data.length - n3 > 4 ? 0 : (4 - (this.data.length - n3)) * 8;
        int n5 = 32;
        while (n5 > n4) {
            n2 |= (this.data[n3] & 0xFF) << n5 - 8;
            n5 -= 8;
            ++n3;
        }
        n2 <<= this.ptr % 8;
        n2 = bl ? (n2 >>= 32 - n) : (n2 >>>= 32 - n);
        this.ptr += n;
        if (this.ptr > this.data.length << 3) {
            this.ptr = this.data.length << 3;
        }
        return n2;
    }

    public void writeBits(int n, int n2) {
        int n3;
        if (this.ptr + n2 + 24 > this.end) {
            n3 = (n2 > this.data.length ? n2 : this.data.length) + this.data.length;
            byte[] byArray = new byte[n3];
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            this.data = byArray;
        }
        if (n2 < 1 || n2 > 32) {
            throw new IllegalArgumentException("Number of bits must be in the range 1..32.");
        }
        n3 = this.ptr >> 3;
        n <<= 32 - n2;
        n >>>= this.ptr % 8;
        n |= this.data[n3] << 24;
        int n4 = 24;
        while (n4 >= 0) {
            this.data[n3] = (byte)(n >>> n4);
            n4 -= 8;
            ++n3;
        }
        this.ptr += n2;
        if (this.ptr > this.data.length << 3) {
            this.ptr = this.data.length << 3;
        }
    }

    public int readWord(int n, boolean bl) {
        int n2 = 0;
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Number of bytes must be in the range 1..4.");
        }
        int n3 = this.ptr >> 3;
        if (n3 + n > this.data.length) {
            n = this.data.length - n3;
        }
        int n4 = n * 8;
        if (this.byteOrder == 0) {
            int n5 = 0;
            while (n5 < n4) {
                n2 += (this.data[n3] & 0xFF) << n5;
                n5 += 8;
                this.ptr += 8;
                ++n3;
            }
        } else {
            int n6 = 0;
            while (n6 < n4) {
                n2 <<= 8;
                n2 += this.data[n3] & 0xFF;
                n6 += 8;
                this.ptr += 8;
                ++n3;
            }
        }
        if (bl) {
            n2 <<= 32 - n4;
            n2 >>= 32 - n4;
        }
        return n2;
    }

    public void writeWord(int n, int n2) {
        int n3;
        if (n2 < 1 || n2 > 4) {
            throw new IllegalArgumentException("Number of bytes must be in the range 1..4.");
        }
        int n4 = n2 * 8;
        if (this.ptr + n4 > this.end) {
            n3 = (n4 > this.data.length ? n4 : this.data.length) + this.data.length;
            byte[] byArray = new byte[n3];
            System.arraycopy(this.data, 0, byArray, 0, this.data.length);
            this.data = byArray;
            this.end = this.data.length << 3;
        }
        if (this.byteOrder == 0) {
            n3 = this.ptr >>> 3;
            int n5 = 0;
            while (n5 < n4) {
                this.data[n3] = (byte)n;
                n5 += 8;
                this.ptr += 8;
                n >>>= 8;
                ++n3;
            }
        } else {
            n3 = this.ptr + n4 - 8 >>> 3;
            int n6 = 0;
            while (n6 < n4) {
                this.data[n3] = (byte)n;
                n6 += 8;
                this.ptr += 8;
                n >>>= 8;
                --n3;
            }
        }
    }

    public int readBytes(byte[] byArray) {
        int n = 0;
        if (byArray == null || byArray.length == 0) {
            return n;
        }
        int n2 = this.ptr >>> 3;
        int n3 = byArray.length;
        if (n2 + n3 > this.data.length) {
            n3 = this.data.length - n2;
        }
        int n4 = 0;
        while (n4 < n3) {
            byArray[n4] = this.data[n2];
            ++n4;
            this.ptr += 8;
            ++n2;
            ++n;
        }
        return n;
    }

    public int writeBytes(byte[] byArray) {
        int n;
        int n2 = 0;
        if (this.ptr + (byArray.length << 3) > this.end) {
            n = (byArray.length > this.data.length ? byArray.length : this.data.length) + this.data.length;
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.data, 0, byArray2, 0, this.data.length);
            this.data = byArray;
            this.end = this.data.length << 3;
        }
        if (byArray == null || byArray.length == 0) {
            return n2;
        }
        n = this.ptr >>> 3;
        int n3 = byArray.length;
        int n4 = 0;
        while (n4 < n3) {
            this.data[n] = byArray[n4];
            ++n4;
            this.ptr += 8;
            ++n;
            ++n2;
        }
        return n2;
    }

    byte[] getBuffer() {
        return this.data;
    }

    int getPointer() {
        return this.ptr;
    }

    void setPointer(int n) {
        if (n < 0) {
            n = 0;
        } else if (n > this.end) {
            n = this.end;
        }
        this.ptr = n;
    }

    void adjustPointer(int n) {
        this.ptr += n;
        if (this.ptr < 0) {
            this.ptr = 0;
        } else if (this.ptr >= this.end) {
            this.ptr = this.end;
        }
    }

    int readBits(int n) {
        int n2 = 0;
        if (n == 0) {
            return n2;
        }
        int n3 = this.ptr >> 3;
        int n4 = this.data.length - n3 > 4 ? 0 : (4 - (this.data.length - n3)) * 8;
        int n5 = 32;
        while (n5 > n4) {
            n2 |= (this.data[n3] & 0xFF) << n5 - 8;
            n5 -= 8;
            ++n3;
        }
        n2 <<= this.ptr % 8;
        n2 >>>= 32 - n;
        this.ptr += n;
        if (this.ptr > this.data.length << 3) {
            this.ptr = this.data.length << 3;
        }
        return n2;
    }

    int readByte() {
        int n = this.data[this.ptr >> 3] & 0xFF;
        this.ptr += 8;
        return n;
    }

    int readShort(boolean bl) {
        int n = 0;
        int n2 = this.ptr >> 3;
        if (this.byteOrder == 0) {
            n = this.data[n2++] & 0xFF;
            n += (this.data[n2] & 0xFF) << 8;
        } else {
            n = (this.data[n2++] & 0xFF) << 8;
            n += this.data[n2] & 0xFF;
        }
        if (bl) {
            n <<= 16;
            n >>= 16;
        }
        this.ptr += 16;
        return n;
    }

    int readInt() {
        int n = 0;
        int n2 = this.ptr >> 3;
        if (this.byteOrder == 0) {
            n = this.data[n2++] & 0xFF;
            n += (this.data[n2++] & 0xFF) << 8;
            n += (this.data[n2++] & 0xFF) << 16;
            n += (this.data[n2] & 0xFF) << 24;
        } else {
            n = (this.data[n2++] & 0xFF) << 24;
            n += (this.data[n2++] & 0xFF) << 16;
            n += (this.data[n2++] & 0xFF) << 8;
            n += this.data[n2] & 0xFF;
        }
        this.ptr += 32;
        return n;
    }

    float readFixedBits(int n, int n2) {
        float f = 0.0f;
        float f2 = 1 << n2;
        f = (float)this.readBits(n, true) / f2;
        return f;
    }
}

