/*
 * Decompiled with CFR 0.152.
 */
package com.flagstone.transform.util;

import com.flagstone.transform.FSBounds;
import com.flagstone.transform.FSCharacter;
import com.flagstone.transform.FSCoder;
import com.flagstone.transform.FSColor;
import com.flagstone.transform.FSCoordTransform;
import com.flagstone.transform.FSCurve;
import com.flagstone.transform.FSDefineFont;
import com.flagstone.transform.FSDefineFont2;
import com.flagstone.transform.FSDefineShape3;
import com.flagstone.transform.FSDefineText;
import com.flagstone.transform.FSDefineText2;
import com.flagstone.transform.FSFontInfo;
import com.flagstone.transform.FSLine;
import com.flagstone.transform.FSMovie;
import com.flagstone.transform.FSMovieObject;
import com.flagstone.transform.FSShape;
import com.flagstone.transform.FSShapeStyle;
import com.flagstone.transform.FSSolidFill;
import com.flagstone.transform.FSText;
import com.flagstone.transform.FSTransformObject;
import com.flagstone.transform.util.FSShapeConstructor;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.zip.DataFormatException;

public class FSTextConstructor {
    private static final int OS_2 = 1330851634;
    private static final int HEAD = 1751474532;
    private static final int HHEA = 1751672161;
    private static final int MAXP = 1835104368;
    private static final int LOCA = 1819239265;
    private static final int CMAP = 1668112752;
    private static final int HMTX = 1752003704;
    private static final int NAME = 1851878757;
    private static final int GLYF = 1735162214;
    private static final int ITLF_SHORT = 0;
    private static final int ITLF_LONG = 1;
    private static final int FONT_WEIGHT_THIN = 100;
    private static final int FONT_WEIGHT_EXTRALIGHT = 200;
    private static final int FONT_WEIGHT_LIGHT = 300;
    private static final int FONT_WEIGHT_NORMAL = 400;
    private static final int FONT_WEIGHT_MEDIUM = 500;
    private static final int FONT_WEIGHT_SEMIBOLD = 600;
    private static final int FONT_WEIGHT_BOLD = 700;
    private static final int FONT_WEIGHT_EXTRABOLD = 800;
    private static final int FONT_WEIGHT_BLACK = 900;
    private static final int ON_CURVE = 1;
    private static final int X_SHORT = 2;
    private static final int Y_SHORT = 4;
    private static final int REPEAT_FLAG = 8;
    private static final int X_SAME = 16;
    private static final int Y_SAME = 32;
    private static final int X_POSITIVE = 16;
    private static final int Y_POSITIVE = 32;
    private static final int ARG_1_AND_2_ARE_WORDS = 1;
    private static final int ARGS_ARE_XY_VALUES = 2;
    private static final int WE_HAVE_A_SCALE = 8;
    private static final int WE_HAVE_AN_X_AND_Y_SCALE = 64;
    private static final int WE_HAVE_A_TWO_BY_TWO = 128;
    private static final int MORE_COMPONENTS = 16;
    private static final int NUMBER_OF_METRICS = 0;
    private static final int SCALE = 1;
    private static final int GLYPH_OFFSET_SIZE = 2;
    private int identifier = 0;
    private String name = "";
    private int encoding = 0;
    private float size = 0.0f;
    private boolean isBold = false;
    private boolean isItalic = false;
    private int baseline = 0;
    private float ascent = 0.0f;
    private float descent = 0.0f;
    private float leading = 0.0f;
    private short[] orderTable = new short[65536];
    private short[] characterTable = new short[65536];
    private FSGlyph[] glyphTable = null;
    private int numberOfGlyphs = 0;
    private int missingGlyph = 0;
    private ArrayList kernings = new ArrayList();
    private int[] attributes = new int[8];

    public FSTextConstructor(int n, String string) throws IOException, DataFormatException {
        this.identifier = n;
        for (int i = 0; i < 65536; ++i) {
            this.orderTable[i] = -1;
        }
        if (string.toLowerCase().endsWith(".swf")) {
            this.decodeSWFFont(string);
        } else if (string.toLowerCase().endsWith(".otf")) {
            this.decodeOpenTypeFont(string);
        } else if (string.toLowerCase().endsWith(".ttf")) {
            this.decodeOpenTypeFont(string);
        } else {
            this.decodeAWTFont(string);
        }
    }

    public FSTextConstructor(int n, Font font) {
        this.identifier = n;
        for (int i = 0; i < 65536; ++i) {
            this.orderTable[i] = -1;
        }
        this.decodeAWTFont(font);
    }

    public void reset(int n) {
        this.identifier = n;
        for (int i = 0; i < 65536; ++i) {
            this.orderTable[i] = -1;
        }
    }

    public int canDisplay(char[] cArray) {
        int n = -1;
        for (int i = 0; i < cArray.length; ++i) {
            if (this.canDisplay(cArray[i])) continue;
            n = i;
            break;
        }
        return n;
    }

    public int canDisplay(String string) {
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (this.canDisplay(string.charAt(i))) continue;
            n = i;
            break;
        }
        return n;
    }

    public void willDisplay(char[] cArray) {
        block0: for (int i = 0; i < cArray.length; ++i) {
            short s = this.characterTable[cArray[i]];
            for (int j = 0; j < 65536 && this.orderTable[j] != s; ++j) {
                if (this.orderTable[j] != -1) continue;
                this.orderTable[j] = s;
                continue block0;
            }
        }
    }

    public FSDefineFont2 defineFont() {
        FSDefineFont2 fSDefineFont2 = null;
        int n = 0;
        for (n = 0; this.orderTable[n] != -1 && n < this.orderTable.length; ++n) {
        }
        ArrayList<FSShape> arrayList = new ArrayList<FSShape>(n);
        ArrayList<Integer> arrayList2 = new ArrayList<Integer>(n);
        ArrayList<Integer> arrayList3 = new ArrayList<Integer>(n);
        ArrayList<FSBounds> arrayList4 = new ArrayList<FSBounds>(n);
        for (int i = 0; i < n; ++i) {
            short s = this.orderTable[i];
            int n2 = 0;
            while (this.characterTable[n2] != s) {
                ++n2;
            }
            arrayList.add(this.glyphTable[s].shape);
            arrayList2.add(new Integer(n2));
            arrayList3.add(new Integer(this.glyphTable[s].advance));
            arrayList4.add(this.glyphTable[s].bounds);
        }
        fSDefineFont2 = new FSDefineFont2(this.identifier, this.name);
        fSDefineFont2.setEncoding(this.encoding);
        fSDefineFont2.setItalic(this.isItalic);
        fSDefineFont2.setBold(this.isBold);
        fSDefineFont2.setAscent((int)this.ascent);
        fSDefineFont2.setDescent((int)this.descent);
        fSDefineFont2.setLeading((int)this.leading);
        fSDefineFont2.setShapes(arrayList);
        fSDefineFont2.setCodes(arrayList2);
        fSDefineFont2.setAdvances(arrayList3);
        fSDefineFont2.setBounds(arrayList4);
        fSDefineFont2.setKernings(this.kernings);
        return fSDefineFont2;
    }

    public FSDefineText2 defineText(int n, String string, int n2, FSColor fSColor) {
        FSCoordTransform fSCoordTransform = new FSCoordTransform(0, 0);
        float f = (float)n2 / 1024.0f;
        int[] nArray = this.glyphIndicesForString(string);
        int[] nArray2 = this.advancesForGlyphIndices(nArray, f);
        FSText fSText = new FSText(this.identifier, fSColor, 0, this.scaleBaseline(f), n2, this.charactersForGlyphs(nArray, nArray2));
        ArrayList<FSText> arrayList = new ArrayList<FSText>();
        arrayList.add(fSText);
        return new FSDefineText2(n, this.boundsForText(nArray, nArray2, n2), fSCoordTransform, arrayList);
    }

    public FSDefineText2 defineTextBlock(int n, ArrayList arrayList, int n2, FSColor fSColor, int n3) {
        FSCoordTransform fSCoordTransform = new FSCoordTransform(0, 0);
        float f = (float)n2 / 1024.0f;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = this.scaleBaseline(f);
        ArrayList<FSText> arrayList2 = new ArrayList<FSText>();
        int n10 = 0;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            int[] nArray = this.glyphIndicesForString(string);
            int[] nArray2 = this.advancesForGlyphIndices(nArray, f);
            FSBounds fSBounds = this.boundsForText(nArray, nArray2, n2);
            if (n10 == 0) {
                n5 = fSBounds.getMinY();
                n7 = fSBounds.getMaxY();
            } else {
                n7 += n3;
            }
            if (n10 == arrayList.size() - 1) {
                n7 += fSBounds.getHeight();
            }
            n4 = n4 < fSBounds.getMinX() ? n4 : fSBounds.getMinX();
            n6 = n6 > fSBounds.getMaxX() ? n6 : fSBounds.getMaxX();
            FSText fSText = new FSText(this.identifier, fSColor, n8, n9, n2, this.charactersForGlyphs(nArray, nArray2));
            arrayList2.add(fSText);
            n9 += n3;
            ++n10;
        }
        return new FSDefineText2(n, new FSBounds(n4, n5, n6, n7), fSCoordTransform, arrayList2);
    }

    public FSBounds boundsForText(String string, int n) {
        float f = (float)n / 1024.0f;
        int[] nArray = this.glyphIndicesForString(string);
        int[] nArray2 = this.advancesForGlyphIndices(nArray, f);
        return this.boundsForText(nArray, nArray2, n);
    }

    public int advanceForChar(char c, int n) {
        float f = (float)n / 1024.0f;
        short s = this.characterTable[c];
        int n2 = (int)((float)this.glyphTable[s].advance * f);
        return n2;
    }

    public FSDefineShape3 defineShape(int n, String string, int n2, FSColor fSColor) {
        FSShapeConstructor fSShapeConstructor = new FSShapeConstructor();
        fSShapeConstructor.add(new FSSolidFill(fSColor));
        fSShapeConstructor.selectFillStyle(0);
        float f = (float)n2 / 1024.0f;
        int[] nArray = this.glyphIndicesForString(string);
        int[] nArray2 = this.advancesForGlyphIndices(nArray, f);
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            ArrayList arrayList = this.glyphTable[this.orderTable[nArray[i]]].shape.getObjects();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                int n4;
                int n5;
                FSTransformObject fSTransformObject;
                FSTransformObject fSTransformObject2 = (FSTransformObject)iterator.next();
                if (fSTransformObject2 instanceof FSShapeStyle) {
                    fSTransformObject = (FSShapeStyle)fSTransformObject2;
                    n5 = (int)((double)((float)((FSShapeStyle)fSTransformObject).getMoveX() * f) + (((FSShapeStyle)fSTransformObject).getMoveX() < 0 ? -0.5 : 0.5));
                    n4 = (int)((double)((float)((FSShapeStyle)fSTransformObject).getMoveY() * f) + (((FSShapeStyle)fSTransformObject).getMoveY() < 0 ? -0.5 : 0.5));
                    fSShapeConstructor.closePath();
                    fSShapeConstructor.move(n5 + n3, n4);
                    continue;
                }
                if (fSTransformObject2 instanceof FSLine) {
                    fSTransformObject = (FSLine)fSTransformObject2;
                    n5 = (int)((double)((float)((FSLine)fSTransformObject).getX() * f) + (((FSLine)fSTransformObject).getX() < 0 ? -0.5 : 0.5));
                    n4 = (int)((double)((float)((FSLine)fSTransformObject).getY() * f) + (((FSLine)fSTransformObject).getY() < 0 ? -0.5 : 0.5));
                    fSShapeConstructor.rline(n5, n4);
                    continue;
                }
                if (!(fSTransformObject2 instanceof FSCurve)) continue;
                fSTransformObject = (FSCurve)fSTransformObject2;
                n5 = (int)((double)((float)((FSCurve)fSTransformObject).getControlX() * f) + (((FSCurve)fSTransformObject).getControlX() < 0 ? -0.5 : 0.5));
                n4 = (int)((double)((float)((FSCurve)fSTransformObject).getControlY() * f) + (((FSCurve)fSTransformObject).getControlY() < 0 ? -0.5 : 0.5));
                int n6 = (int)((double)((float)((FSCurve)fSTransformObject).getAnchorX() * f) + (((FSCurve)fSTransformObject).getAnchorX() < 0 ? -0.5 : 0.5));
                int n7 = (int)((double)((float)((FSCurve)fSTransformObject).getAnchorY() * f) + (((FSCurve)fSTransformObject).getAnchorY() < 0 ? -0.5 : 0.5));
                fSShapeConstructor.rcurve(n5, n4, n6, n7);
            }
            fSShapeConstructor.closePath();
            n3 += nArray2[i];
        }
        return fSShapeConstructor.defineTransparentShape(n);
    }

    private void decodeSWFFont(String string) throws IOException, DataFormatException {
        Object object;
        FSMovie fSMovie = new FSMovie(string);
        FSDefineFont fSDefineFont = null;
        FSFontInfo fSFontInfo = null;
        FSDefineText fSDefineText = null;
        FSText fSText = null;
        Iterator iterator = fSMovie.getObjects().iterator();
        while (iterator.hasNext()) {
            object = (FSMovieObject)iterator.next();
            if (object instanceof FSDefineFont) {
                fSDefineFont = (FSDefineFont)object;
                continue;
            }
            if (object instanceof FSFontInfo) {
                fSFontInfo = (FSFontInfo)object;
                continue;
            }
            if (!(object instanceof FSDefineText)) continue;
            fSDefineText = (FSDefineText)object;
        }
        fSText = (FSText)fSDefineText.getObjects().get(0);
        this.name = fSFontInfo.getName();
        this.encoding = fSFontInfo.getEncoding();
        this.size = fSText.getHeight();
        this.isBold = fSFontInfo.isBold();
        this.isItalic = fSFontInfo.isItalic();
        if (this.encoding == 1) {
            this.encoding = 0;
        }
        this.glyphTable = new FSGlyph[fSDefineFont.getShapes().size()];
        int n = 0;
        object = fSDefineFont.getShapes().iterator();
        while (object.hasNext()) {
            this.glyphTable[n] = new FSGlyph((FSShape)object.next(), new FSBounds(0, 0, 0, 0));
            ++n;
        }
        n = 0;
        object = fSFontInfo.getCodes().iterator();
        while (object.hasNext()) {
            this.characterTable[((Integer)object.next()).intValue()] = (short)n;
            ++n;
        }
        object = fSText.getCharacters().iterator();
        while (object.hasNext()) {
            FSCharacter fSCharacter = (FSCharacter)object.next();
            this.glyphTable[fSCharacter.getGlyphIndex()].advance = (int)((double)fSCharacter.getAdvance() * (1024.0 / (double)this.size));
        }
        this.orderTable[0] = 0;
    }

    private void decodeAWTFont(String string) {
        double d;
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        Font font = new Font(string, 0, 1);
        if (font == null) {
            throw new IllegalArgumentException("No such font: " + string);
        }
        this.name = string;
        this.encoding = 0;
        Rectangle2D rectangle2D = this.transformToEMSquare(font, fontRenderContext);
        double d2 = d = 1024.0;
        double d3 = 1024.0 - rectangle2D.getX() * 1024.0;
        double d4 = 1024.0 - rectangle2D.getY() * 1024.0;
        this.size = (float)d;
        font = font.deriveFont((float)d2);
        this.missingGlyph = font.getMissingGlyphCode();
        this.isBold = font.isBold();
        this.isItalic = font.isItalic();
        int n = font.getNumGlyphs();
        int n2 = 0;
        this.glyphTable = new FSGlyph[n];
        for (int i = 0; n2 < n && i < 65535; ++n2, ++i) {
            LineMetrics lineMetrics;
            int n3;
            Shape shape;
            GlyphVector glyphVector;
            char c = (char)i;
            if (font.canDisplay(c)) {
                glyphVector = font.createGlyphVector(fontRenderContext, new char[]{c});
                shape = glyphVector.getGlyphOutline(0);
                n3 = (int)glyphVector.getGlyphMetrics(0).getAdvance();
                this.characterTable[c] = (short)n2;
                this.glyphTable[n2] = new FSGlyph(this.convertShape(shape), new FSBounds(0, 0, 0, 0));
                this.glyphTable[n2].advance = n3;
                if (font.hasUniformLineMetrics()) continue;
                lineMetrics = font.getLineMetrics(new char[]{c}, 0, 1, fontRenderContext);
                this.ascent = 0.0f;
                this.descent = 0.0f;
                this.leading = 0.0f;
                continue;
            }
            glyphVector = font.createGlyphVector(fontRenderContext, new char[]{(char)this.missingGlyph});
            shape = glyphVector.getGlyphOutline(0);
            n3 = (int)glyphVector.getGlyphMetrics(0).getAdvance();
            this.characterTable[c] = (short)n2;
            this.glyphTable[n2] = new FSGlyph(this.convertShape(shape), new FSBounds(0, 0, 0, 0));
            this.glyphTable[n2].advance = n3;
            if (font.hasUniformLineMetrics()) continue;
            lineMetrics = font.getLineMetrics(new char[]{c}, 0, 1, fontRenderContext);
            this.ascent = 0.0f;
            this.descent = 0.0f;
            this.leading = 0.0f;
        }
        this.orderTable[0] = (short)this.missingGlyph;
    }

    private void decodeAWTFont(Font font) {
        double d;
        FontRenderContext fontRenderContext = new FontRenderContext(new AffineTransform(), true, true);
        font = font.deriveFont(1.0f);
        this.name = font.getName();
        this.encoding = 0;
        Rectangle2D rectangle2D = this.transformToEMSquare(font, fontRenderContext);
        double d2 = d = 1024.0;
        double d3 = 1024.0 - rectangle2D.getX() * 1024.0;
        double d4 = 1024.0 - rectangle2D.getY() * 1024.0;
        this.size = (float)d;
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(d3, d4);
        font = font.deriveFont(affineTransform);
        font = font.deriveFont((float)d2);
        this.missingGlyph = font.getMissingGlyphCode();
        this.isBold = font.isBold();
        this.isItalic = font.isItalic();
        int n = font.getNumGlyphs();
        int n2 = 0;
        this.glyphTable = new FSGlyph[n];
        for (int i = 0; n2 < n && i < 65535; ++n2, ++i) {
            LineMetrics lineMetrics;
            int n3;
            Shape shape;
            GlyphVector glyphVector;
            char c = (char)i;
            if (font.canDisplay(c)) {
                glyphVector = font.createGlyphVector(fontRenderContext, new char[]{c});
                shape = glyphVector.getGlyphOutline(0);
                n3 = (int)glyphVector.getGlyphMetrics(0).getAdvance();
                this.characterTable[c] = (short)n2;
                this.glyphTable[n2] = new FSGlyph(this.convertShape(shape), new FSBounds(0, 0, 0, 0));
                this.glyphTable[n2].advance = n3;
                if (font.hasUniformLineMetrics()) continue;
                lineMetrics = font.getLineMetrics(new char[]{c}, 0, 1, fontRenderContext);
                this.ascent = 0.0f;
                this.descent = 0.0f;
                this.leading = 0.0f;
                continue;
            }
            glyphVector = font.createGlyphVector(fontRenderContext, new char[]{(char)this.missingGlyph});
            shape = glyphVector.getGlyphOutline(0);
            n3 = (int)glyphVector.getGlyphMetrics(0).getAdvance();
            this.characterTable[c] = (short)n2;
            this.glyphTable[n2] = new FSGlyph(this.convertShape(shape), new FSBounds(0, 0, 0, 0));
            this.glyphTable[n2].advance = n3;
            if (font.hasUniformLineMetrics()) continue;
            lineMetrics = font.getLineMetrics(new char[]{c}, 0, 1, fontRenderContext);
            this.ascent = 0.0f;
            this.descent = 0.0f;
            this.leading = 0.0f;
        }
        this.orderTable[0] = (short)this.missingGlyph;
    }

    private Rectangle2D transformToEMSquare(Font font, FontRenderContext fontRenderContext) {
        int n = font.getNumGlyphs();
        int n2 = 0;
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        for (int i = 0; n2 < n && i < 65535; ++i) {
            char c = (char)i;
            if (!font.canDisplay(c)) continue;
            GlyphVector glyphVector = font.createGlyphVector(fontRenderContext, new char[]{c});
            Rectangle2D rectangle2D = glyphVector.getGlyphOutline(0).getBounds2D();
            d = Math.min(rectangle2D.getX(), d);
            d2 = Math.min(rectangle2D.getY(), d2);
            d3 = Math.max(rectangle2D.getWidth(), d3);
            d4 = Math.max(rectangle2D.getHeight(), d4);
            ++n2;
        }
        return new Rectangle2D.Double(d, d2, d3, d4);
    }

    private FSShape convertShape(Shape shape) {
        PathIterator pathIterator = shape.getPathIterator(null);
        FSShapeConstructor fSShapeConstructor = new FSShapeConstructor();
        double[] dArray = new double[6];
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        while (!pathIterator.isDone()) {
            int n = pathIterator.currentSegment(dArray);
            int n2 = (int)dArray[0];
            int n3 = (int)dArray[1];
            int n4 = (int)dArray[2];
            int n5 = (int)dArray[3];
            int n6 = (int)dArray[4];
            int n7 = (int)dArray[5];
            switch (n) {
                case 0: {
                    fSShapeConstructor.closePath();
                    fSShapeConstructor.move(n2, n3);
                    break;
                }
                case 1: {
                    fSShapeConstructor.line(n2, n3);
                    break;
                }
                case 2: {
                    fSShapeConstructor.curve(n2, n3, n4, n5);
                    break;
                }
                case 3: {
                    fSShapeConstructor.curve(n2, n3, n4, n5, n6, n7);
                    break;
                }
                case 4: {
                    fSShapeConstructor.closePath();
                }
            }
            pathIterator.next();
        }
        if (fSShapeConstructor.objects.size() > 0) {
            FSShapeStyle fSShapeStyle = (FSShapeStyle)fSShapeConstructor.objects.get(0);
            fSShapeStyle.setLineStyle(0);
            fSShapeStyle.setAltFillStyle(1);
        }
        return fSShapeConstructor.shape();
    }

    private FSBounds boundsForText(int[] nArray, int[] nArray2, int n) {
        float f = (float)n / 1024.0f;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        int n6 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            ArrayList arrayList = null;
            arrayList = this.glyphTable[this.orderTable[nArray[i]]] == null ? this.glyphTable[this.missingGlyph].shape.getObjects() : this.glyphTable[this.orderTable[nArray[i]]].shape.getObjects();
            int n7 = n6;
            int n8 = 0;
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                FSTransformObject fSTransformObject;
                FSTransformObject fSTransformObject2 = (FSTransformObject)iterator.next();
                if (fSTransformObject2 instanceof FSShapeStyle) {
                    fSTransformObject = (FSShapeStyle)fSTransformObject2;
                    n7 = n6 + ((FSShapeStyle)fSTransformObject).getMoveX();
                    n8 = ((FSShapeStyle)fSTransformObject).getMoveY();
                } else if (fSTransformObject2 instanceof FSLine) {
                    fSTransformObject = (FSLine)fSTransformObject2;
                    n7 += ((FSLine)fSTransformObject).getX();
                    n8 += ((FSLine)fSTransformObject).getY();
                } else if (fSTransformObject2 instanceof FSCurve) {
                    fSTransformObject = (FSCurve)fSTransformObject2;
                    n7 += ((FSCurve)fSTransformObject).getControlX() + ((FSCurve)fSTransformObject).getAnchorX();
                    n8 += ((FSCurve)fSTransformObject).getControlY() + ((FSCurve)fSTransformObject).getAnchorY();
                }
                if (bl) {
                    n2 = Math.min(n2, n7);
                    n3 = Math.max(n3, n7);
                    n4 = Math.min(n4, n8);
                    n5 = Math.max(n5, n8);
                    continue;
                }
                n2 = n3 = n7;
                n4 = n5 = n8;
                bl = true;
            }
            n6 = (int)((float)n6 + (float)nArray2[i] / f);
        }
        n2 = (int)((float)n2 * f);
        n3 = (int)((float)n3 * f);
        n4 = (int)((float)n4 * f) + this.scaleBaseline(f);
        n5 = (int)((float)n5 * f) + this.scaleBaseline(f);
        return new FSBounds(n2, n4, n3, n5);
    }

    private ArrayList charactersForGlyphs(int[] nArray, int[] nArray2) {
        ArrayList<FSCharacter> arrayList = new ArrayList<FSCharacter>(nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(new FSCharacter(nArray[i], nArray2[i]));
        }
        return arrayList;
    }

    private boolean canDisplay(char c) {
        boolean bl = false;
        if (c < this.characterTable.length && this.characterTable[c] != 0) {
            bl = true;
        }
        return bl;
    }

    private int[] glyphIndicesForString(String string) {
        int[] nArray = new int[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            short s = this.characterTable[c];
            int n = 0;
            for (n = 0; n < 65536 && this.orderTable[n] != s; ++n) {
                if (this.orderTable[n] != -1) continue;
                this.orderTable[n] = s;
                break;
            }
            nArray[i] = n;
        }
        return nArray;
    }

    private int[] advancesForGlyphIndices(int[] nArray, float f) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            short s = this.orderTable[nArray[i]];
            nArray2[i] = (int)((float)this.glyphTable[s].advance * f);
        }
        return nArray2;
    }

    private int scaleBaseline(float f) {
        int n = (int)((float)this.baseline * f);
        n += 20 - n % 20;
        return n;
    }

    private byte[] dataFromFile(String string) throws FileNotFoundException, IOException {
        File file = new File(string);
        FileInputStream fileInputStream = null;
        byte[] byArray = new byte[(int)file.length()];
        fileInputStream = new FileInputStream(file);
        fileInputStream.read(byArray);
        fileInputStream.close();
        return byArray;
    }

    private void decodeOpenTypeFont(String string) throws IOException, DataFormatException {
        int n;
        int n2;
        FSCoder fSCoder = new FSCoder(1, this.dataFromFile(string));
        float f = fSCoder.readFixedBits(32, 16);
        int n3 = fSCoder.readWord(2, false);
        int n4 = fSCoder.readWord(2, false);
        int n5 = fSCoder.readWord(2, false);
        int n6 = fSCoder.readWord(2, false);
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        int n22 = 0;
        int n23 = 0;
        int n24 = 0;
        int n25 = 0;
        int n26 = 0;
        int n27 = 0;
        int n28 = 0;
        block11: for (n2 = 0; n2 < n3; ++n2) {
            n25 = fSCoder.readWord(4, false);
            n26 = fSCoder.readWord(4, false);
            n27 = fSCoder.readWord(4, false) << 3;
            n28 = fSCoder.readWord(4, false);
            switch (n25) {
                case 1330851634: {
                    n7 = n27;
                    n16 = n28;
                    continue block11;
                }
                case 1668112752: {
                    n12 = n27;
                    n21 = n28;
                    continue block11;
                }
                case 1735162214: {
                    n13 = n27;
                    n24 = n28;
                    continue block11;
                }
                case 1751474532: {
                    n8 = n27;
                    n17 = n28;
                    continue block11;
                }
                case 1751672161: {
                    n9 = n27;
                    n18 = n28;
                    continue block11;
                }
                case 1752003704: {
                    n14 = n27;
                    n22 = n28;
                    continue block11;
                }
                case 1819239265: {
                    n11 = n27;
                    n20 = n28;
                    continue block11;
                }
                case 1835104368: {
                    n10 = n27;
                    n19 = n28;
                    continue block11;
                }
                case 1851878757: {
                    n15 = n27;
                    n23 = n28;
                    continue block11;
                }
            }
        }
        n2 = 0;
        if (n10 != 0) {
            fSCoder.setPointer(n10);
            this.decodeMAXP(fSCoder);
            n2 = fSCoder.getPointer() - n10 >> 3;
        }
        if (n7 != 0) {
            fSCoder.setPointer(n7);
            this.decodeOS_2(fSCoder);
            n2 = fSCoder.getPointer() - n7 >> 3;
        }
        if (n8 != 0) {
            fSCoder.setPointer(n8);
            this.decodeHEAD(fSCoder);
            n2 = fSCoder.getPointer() - n8 >> 3;
        }
        if (n9 != 0) {
            fSCoder.setPointer(n9);
            this.decodeHHEA(fSCoder);
            n2 = fSCoder.getPointer() - n9 >> 3;
        }
        if (n15 != 0) {
            fSCoder.setPointer(n15);
            this.decodeNAME(fSCoder);
            n2 = fSCoder.getPointer() - n15 >> 3;
        }
        this.glyphTable = new FSGlyph[this.numberOfGlyphs];
        if (n11 != 0) {
            fSCoder.setPointer(n11);
            this.decodeGlyphs(fSCoder, n13);
            n2 = fSCoder.getPointer() - n11 >> 3;
        }
        if (n14 != 0) {
            fSCoder.setPointer(n14);
            this.decodeHMTX(fSCoder);
            n2 = fSCoder.getPointer() - n14 >> 3;
        }
        if (n12 != 0) {
            fSCoder.setPointer(n12);
            this.decodeCMAP(fSCoder);
            n2 = fSCoder.getPointer() - n12 >> 3;
        }
        this.orderTable[0] = this.characterTable[32];
        for (n = 0; n < this.characterTable.length; ++n) {
            if (this.characterTable[n] < this.glyphTable.length) continue;
            this.characterTable[n] = (short)this.missingGlyph;
        }
        n = this.characterTable[32];
        this.glyphTable[n].shape = new FSShape();
        this.glyphTable[n].advance = 250;
    }

    private void decodeHEAD(FSCoder fSCoder) {
        byte[] byArray = new byte[8];
        fSCoder.readFixedBits(32, 16);
        fSCoder.readFixedBits(32, 16);
        fSCoder.readWord(4, false);
        fSCoder.readWord(4, false);
        fSCoder.readBits(1, false);
        fSCoder.readBits(1, false);
        fSCoder.readBits(1, false);
        fSCoder.readBits(1, false);
        fSCoder.readBits(1, false);
        fSCoder.readBits(11, false);
        this.attributes[1] = fSCoder.readWord(2, false) / 1024;
        if (this.attributes[1] == 0) {
            this.attributes[1] = 1;
        }
        fSCoder.readBytes(byArray);
        fSCoder.readBytes(byArray);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        this.isBold = fSCoder.readBits(1, false) != 0;
        this.isItalic = fSCoder.readBits(1, false) != 0;
        fSCoder.readBits(14, false);
        fSCoder.readWord(2, false);
        fSCoder.readWord(2, true);
        this.attributes[2] = fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
    }

    private void decodeHHEA(FSCoder fSCoder) {
        fSCoder.readFixedBits(32, 16);
        this.ascent = fSCoder.readWord(2, true);
        this.descent = fSCoder.readWord(2, true);
        this.leading = fSCoder.readWord(2, true);
        fSCoder.readWord(2, false);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, false);
        fSCoder.readWord(2, false);
        fSCoder.readWord(2, false);
        fSCoder.readWord(2, false);
        fSCoder.readWord(2, true);
        this.attributes[0] = fSCoder.readWord(2, false);
    }

    private void decodeOS_2(FSCoder fSCoder) {
        byte[] byArray = new byte[10];
        int[] nArray = new int[4];
        byte[] byArray2 = new byte[4];
        int n = fSCoder.readWord(2, false);
        fSCoder.readWord(2, true);
        switch (fSCoder.readWord(2, false)) {
            case 700: {
                this.isBold = true;
                break;
            }
        }
        fSCoder.readWord(2, false);
        fSCoder.readWord(2, false);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readWord(2, true);
        fSCoder.readBytes(byArray);
        for (int i = 0; i < 4; ++i) {
            nArray[i] = fSCoder.readWord(4, false);
        }
        fSCoder.readBytes(byArray2);
        this.isItalic = fSCoder.readBits(1, false) != 0;
        fSCoder.readBits(4, false);
        this.isBold = fSCoder.readBits(1, false) != 0;
        fSCoder.readBits(10, false);
        fSCoder.readWord(2, false);
        fSCoder.readWord(2, false);
        this.ascent = fSCoder.readWord(2, false);
        this.descent = fSCoder.readWord(2, false);
        this.leading = fSCoder.readWord(2, false);
        fSCoder.readWord(2, false);
        fSCoder.readWord(2, false);
        if (n > 0) {
            fSCoder.readWord(4, false);
            fSCoder.readWord(4, false);
            if (n > 1) {
                fSCoder.readWord(2, true);
                fSCoder.readWord(2, true);
                this.missingGlyph = fSCoder.readWord(2, false);
                fSCoder.readWord(2, false);
                fSCoder.readWord(2, false);
            }
        }
    }

    private void decodeNAME(FSCoder fSCoder) {
        int n = fSCoder.readWord(2, false);
        int n2 = fSCoder.readWord(2, false);
        int n3 = fSCoder.readWord(2, false);
        for (int i = 0; i < n2; ++i) {
            int n4 = fSCoder.readWord(2, false);
            int n5 = fSCoder.readWord(2, false);
            int n6 = fSCoder.readWord(2, false);
            int n7 = fSCoder.readWord(2, false);
            int n8 = fSCoder.readWord(2, false);
            int n9 = fSCoder.readWord(2, false);
            int n10 = fSCoder.getPointer();
            fSCoder.setPointer(n3 + n9 << 3);
            byte[] byArray = new byte[n8];
            fSCoder.readBytes(byArray);
            String string = "UTF-8";
            if (n4 == 0) {
                string = "UTF-16";
            } else if (n4 == 1) {
                if (n5 == 0 && n6 == 0) {
                    string = "ISO8859-1";
                }
            } else if (n4 == 3) {
                switch (n5) {
                    case 1: {
                        string = "UTF-16";
                        break;
                    }
                    case 2: {
                        string = "SJIS";
                        break;
                    }
                    case 4: {
                        string = "Big5";
                    }
                }
            }
            try {
                if (n7 == 1) {
                    this.name = new String(byArray, string);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                this.name = new String(byArray);
            }
            fSCoder.setPointer(n10);
        }
    }

    private void decodeMAXP(FSCoder fSCoder) {
        float f = fSCoder.readFixedBits(32, 16);
        this.numberOfGlyphs = fSCoder.readWord(2, false);
        if ((double)f == 1.0) {
            fSCoder.readWord(2, false);
            fSCoder.readWord(2, false);
            fSCoder.readWord(2, false);
            fSCoder.readWord(2, false);
            fSCoder.readWord(2, false);
            fSCoder.readWord(2, false);
            fSCoder.readWord(2, false);
            fSCoder.readWord(2, false);
            fSCoder.readWord(2, false);
            fSCoder.readWord(2, false);
            fSCoder.readWord(2, false);
            fSCoder.readWord(2, false);
            fSCoder.readWord(2, false);
        }
    }

    private void decodeHMTX(FSCoder fSCoder) {
        int n = 0;
        for (n = 0; n < this.attributes[0]; ++n) {
            this.glyphTable[n].advance = fSCoder.readWord(2, false) / this.attributes[1];
            fSCoder.readWord(2, true);
        }
        int n2 = this.glyphTable[n - 1].advance;
        while (n < this.numberOfGlyphs) {
            this.glyphTable[n].advance = n2;
            ++n;
        }
        while (n < this.numberOfGlyphs) {
            fSCoder.readWord(2, true);
            ++n;
        }
    }

    private void decodeCMAP(FSCoder fSCoder) {
        int n = fSCoder.getPointer();
        int n2 = fSCoder.readWord(2, false);
        int n3 = fSCoder.readWord(2, false);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        int[] nArray4 = null;
        int[] nArray5 = null;
        int n12 = 0;
        int n13 = 0;
        for (n12 = 0; n12 < n3; ++n12) {
            n4 = fSCoder.readWord(2, false);
            n5 = fSCoder.readWord(2, false);
            n6 = fSCoder.readWord(4, false) << 3;
            n7 = fSCoder.getPointer();
            if (n4 == 0) {
                this.encoding = 0;
            } else if (n4 == 1) {
                switch (n5) {
                    case 1: {
                        this.encoding = 2;
                        break;
                    }
                    default: {
                        this.encoding = 1;
                        break;
                    }
                }
            } else if (n4 == 3) {
                switch (n5) {
                    case 1: {
                        this.encoding = 0;
                        break;
                    }
                    case 2: {
                        this.encoding = 2;
                        break;
                    }
                    default: {
                        this.encoding = 1;
                    }
                }
            }
            fSCoder.setPointer(n + n6);
            n8 = fSCoder.readWord(2, false);
            n9 = fSCoder.readWord(2, false);
            n10 = fSCoder.readWord(2, false);
            switch (n8) {
                case 0: {
                    for (n13 = 0; n13 < 256; ++n13) {
                        this.characterTable[n13] = (short)fSCoder.readWord(1, false);
                    }
                    break;
                }
                case 4: {
                    n11 = fSCoder.readWord(2, false) / 2;
                    fSCoder.readWord(2, false);
                    fSCoder.readWord(2, false);
                    fSCoder.readWord(2, false);
                    nArray = new int[n11];
                    nArray2 = new int[n11];
                    nArray3 = new int[n11];
                    nArray4 = new int[n11];
                    nArray5 = new int[n11];
                    for (n13 = 0; n13 < n11; ++n13) {
                        nArray2[n13] = fSCoder.readWord(2, false);
                    }
                    fSCoder.readWord(2, false);
                    for (n13 = 0; n13 < n11; ++n13) {
                        nArray[n13] = fSCoder.readWord(2, false);
                    }
                    for (n13 = 0; n13 < n11; ++n13) {
                        nArray3[n13] = fSCoder.readWord(2, true);
                    }
                    for (n13 = 0; n13 < n11; ++n13) {
                        nArray5[n13] = fSCoder.getPointer() >> 3;
                        nArray4[n13] = fSCoder.readWord(2, true);
                    }
                    int n14 = 0;
                    int n15 = 0;
                    for (n13 = 0; n13 < n11; ++n13) {
                        for (int i = nArray[n13]; i <= nArray2[n13]; ++i) {
                            if (nArray4[n13] != 0) {
                                n15 = nArray5[n13] + nArray4[n13] + (i - nArray[n13] << 1);
                                fSCoder.setPointer(n15 << 3);
                                n14 = fSCoder.readWord(2, false);
                                if (n14 != 0) {
                                    n14 = (n14 + nArray3[n13]) % 65536;
                                }
                            } else {
                                n14 = (nArray3[n13] + i) % 65536;
                            }
                            this.characterTable[i] = (short)n14;
                        }
                    }
                    break;
                }
                case 2: 
                case 6: {
                    System.err.println("Unimplemented encoding table format: " + n8);
                    break;
                }
                default: {
                    System.err.println("Illegal value for encoding table format: " + n8);
                }
            }
            fSCoder.setPointer(n7);
        }
        this.encoding = 2;
    }

    private void decodeGlyphs(FSCoder fSCoder, int n) {
        int n2;
        int n3 = 0;
        boolean bl = false;
        int n4 = fSCoder.getPointer();
        int n5 = 0;
        int[] nArray = new int[this.numberOfGlyphs];
        nArray[0] = this.attributes[2] == 0 ? n + (fSCoder.readWord(2, false) * 2 << 3) : n + (fSCoder.readWord(4, false) << 3);
        for (n2 = 1; n2 < this.numberOfGlyphs; ++n2) {
            nArray[n2] = this.attributes[2] == 0 ? n + (fSCoder.readWord(2, false) * 2 << 3) : n + (fSCoder.readWord(4, false) << 3);
            if (nArray[n2] != nArray[n2 - 1]) continue;
            nArray[n2 - 1] = 0;
        }
        n5 = fSCoder.getPointer();
        for (n2 = 0; n2 < this.numberOfGlyphs; ++n2) {
            if (nArray[n2] == 0) {
                this.glyphTable[n2] = new FSGlyph(new FSShape(), new FSBounds(0, 0, 0, 0));
                continue;
            }
            fSCoder.setPointer(nArray[n2]);
            n3 = fSCoder.readWord(2, true);
            if (n3 < 0) continue;
            this.decodeSimpleGlyph(fSCoder, n2, n3);
        }
        fSCoder.setPointer(n4);
        for (n2 = 0; n2 < this.numberOfGlyphs; ++n2) {
            if (nArray[n2] == 0) continue;
            fSCoder.setPointer(nArray[n2]);
            if (fSCoder.readWord(2, true) != -1) continue;
            this.decodeCompositeGlyph(fSCoder, n2);
        }
        fSCoder.setPointer(n5);
    }

    private void decodeSimpleGlyph(FSCoder fSCoder, int n, int n2) {
        int n3;
        int n4;
        int n5;
        int n6;
        int n7 = fSCoder.readWord(2, true) / this.attributes[1];
        int n8 = fSCoder.readWord(2, true) / this.attributes[1];
        int n9 = fSCoder.readWord(2, true) / this.attributes[1];
        int n10 = fSCoder.readWord(2, true) / this.attributes[1];
        int[] nArray = new int[n2];
        for (n6 = 0; n6 < n2; ++n6) {
            nArray[n6] = fSCoder.readWord(2, false);
        }
        n6 = fSCoder.readWord(2, false);
        int[] nArray2 = new int[n6];
        for (n5 = 0; n5 < n6; ++n5) {
            nArray2[n5] = fSCoder.readWord(1, false);
        }
        n5 = n2 == 0 ? 0 : nArray[nArray.length - 1] + 1;
        int[] nArray3 = new int[n5];
        int[] nArray4 = new int[n5];
        int[] nArray5 = new int[n5];
        boolean[] blArray = new boolean[n5];
        int n11 = 0;
        int n12 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            if (n11 > 0) {
                nArray3[n4] = n12;
                --n11;
            } else {
                nArray3[n4] = fSCoder.readWord(1, false);
                if ((nArray3[n4] & 8) > 0) {
                    n11 = fSCoder.readWord(1, false);
                    n12 = nArray3[n4];
                }
            }
            blArray[n4] = (nArray3[n4] & 1) > 0;
        }
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if ((nArray3[n3] & 2) > 0) {
                if ((nArray3[n3] & 0x10) > 0) {
                    n4 = nArray4[n3] = n4 + fSCoder.readWord(1, false);
                    continue;
                }
                n4 = nArray4[n3] = n4 - fSCoder.readWord(1, false);
                continue;
            }
            n4 = (nArray3[n3] & 0x10) > 0 ? (nArray4[n3] = n4) : (nArray4[n3] = n4 + fSCoder.readWord(2, true));
        }
        n4 = 0;
        for (n3 = 0; n3 < n5; ++n3) {
            if ((nArray3[n3] & 4) > 0) {
                if ((nArray3[n3] & 0x20) > 0) {
                    n4 = nArray5[n3] = n4 + fSCoder.readWord(1, false);
                    continue;
                }
                n4 = nArray5[n3] = n4 - fSCoder.readWord(1, false);
                continue;
            }
            n4 = (nArray3[n3] & 0x20) > 0 ? (nArray5[n3] = n4) : (nArray5[n3] = n4 + fSCoder.readWord(2, true));
        }
        FSShapeConstructor fSShapeConstructor = new FSShapeConstructor();
        boolean bl = true;
        boolean bl2 = false;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        for (int i = 0; i < n5; ++i) {
            n14 = nArray4[i] / this.attributes[1];
            n15 = nArray5[i] / this.attributes[1];
            if (blArray[i]) {
                if (bl) {
                    fSShapeConstructor.moveForFont(n14, -n15);
                    bl = false;
                    n18 = n14;
                    n19 = n15;
                } else if (bl2) {
                    fSShapeConstructor.curve(n16, -n17, n14, -n15);
                    bl2 = false;
                } else {
                    fSShapeConstructor.line(n14, -n15);
                }
            } else {
                if (bl2) {
                    fSShapeConstructor.curve(n16, -n17, (n14 + n16) / 2, -(n15 + n17) / 2);
                }
                n16 = n14;
                n17 = n15;
                bl2 = true;
            }
            if (i != nArray[n13]) continue;
            if (bl2) {
                fSShapeConstructor.curve(n14, -n15, n18, -n19);
            } else {
                fSShapeConstructor.closePath();
            }
            bl = true;
            bl2 = false;
            n16 = 0;
            n17 = 0;
            ++n13;
        }
        this.glyphTable[n] = new FSGlyph(fSShapeConstructor.shape(), new FSBounds(n7, -n10, n9, -n8));
        this.glyphTable[n].xCoordinates = nArray4;
        this.glyphTable[n].yCoordinates = nArray5;
        this.glyphTable[n].onCurve = blArray;
        this.glyphTable[n].endPoints = nArray;
    }

    private void decodeCompositeGlyph(FSCoder fSCoder, int n) {
        FSShape fSShape = new FSShape();
        FSCoordTransform fSCoordTransform = null;
        int n2 = fSCoder.readWord(2, true);
        int n3 = fSCoder.readWord(2, true);
        int n4 = fSCoder.readWord(2, true);
        int n5 = fSCoder.readWord(2, true);
        FSGlyph fSGlyph = null;
        int n6 = 0;
        int[] nArray = null;
        int[] nArray2 = null;
        int[] nArray3 = null;
        boolean[] blArray = null;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 0;
        int n11 = 0;
        int n12 = 0;
        do {
            int n13;
            fSCoordTransform = new FSCoordTransform();
            n7 = fSCoder.readWord(2, false);
            n8 = fSCoder.readWord(2, false);
            if (n8 >= this.glyphTable.length || this.glyphTable[n8] == null) {
                this.glyphTable[n] = new FSGlyph();
                this.glyphTable[n].bounds = new FSBounds(n2, n3, n4, n5);
                return;
            }
            fSGlyph = this.glyphTable[n8];
            n6 = fSGlyph.xCoordinates.length;
            nArray = new int[fSGlyph.endPoints.length];
            for (n13 = 0; n13 < fSGlyph.endPoints.length; ++n13) {
                nArray[n13] = fSGlyph.endPoints[n13];
            }
            nArray2 = new int[n6];
            for (n13 = 0; n13 < n6; ++n13) {
                nArray2[n13] = fSGlyph.xCoordinates[n13];
            }
            nArray3 = new int[n6];
            for (n13 = 0; n13 < n6; ++n13) {
                nArray3[n13] = fSGlyph.yCoordinates[n13];
            }
            blArray = new boolean[n6];
            for (n13 = 0; n13 < n6; ++n13) {
                blArray[n13] = fSGlyph.onCurve[n13];
            }
            if ((n7 & 1) == 0 && (n7 & 2) == 0) {
                n12 = fSCoder.readWord(1, false);
                n11 = fSCoder.readWord(1, false);
                fSCoordTransform.translate(0, 0);
            } else if ((n7 & 1) == 0 && (n7 & 2) > 0) {
                n9 = fSCoder.readWord(1, false) << 24 >> 24;
                n10 = fSCoder.readWord(1, false) << 24 >> 24;
                fSCoordTransform.translate(n9, n10);
            } else if ((n7 & 1) > 0 && (n7 & 2) == 0) {
                n12 = fSCoder.readWord(2, false);
                n11 = fSCoder.readWord(2, false);
                fSCoordTransform.translate(0, 0);
            } else {
                n9 = fSCoder.readWord(2, true);
                n10 = fSCoder.readWord(2, true);
                fSCoordTransform.translate(n9, n10);
            }
            if ((n7 & 8) > 0) {
                float f = fSCoder.readFixedBits(16, 14);
                fSCoordTransform.scale(f, f);
            } else if ((n7 & 0x40) > 0) {
                float f = fSCoder.readFixedBits(16, 14);
                float f2 = fSCoder.readFixedBits(16, 14);
                fSCoordTransform.scale(f, f2);
            } else if ((n7 & 0x80) > 0) {
                float f = fSCoder.readFixedBits(16, 14);
                float f3 = fSCoder.readFixedBits(16, 14);
                float f4 = fSCoder.readFixedBits(16, 14);
                float f5 = fSCoder.readFixedBits(16, 14);
                float[][] fArrayArray = new float[][]{{f, f3, 0.0f}, {f4, f5, 0.0f}, {0.0f, 0.0f, 1.0f}};
                fSCoordTransform.composite(new FSCoordTransform(fArrayArray));
            }
            for (int i = 0; i < n6; ++i) {
                int[] nArray4 = fSCoordTransform.transformPoint(nArray2[i], nArray3[i]);
                nArray2[i] = nArray4[0];
                nArray3[i] = nArray4[1];
            }
            FSShapeConstructor fSShapeConstructor = new FSShapeConstructor();
            boolean bl = true;
            boolean bl2 = false;
            int n14 = 0;
            int n15 = 0;
            int n16 = 0;
            int n17 = 0;
            int n18 = 0;
            int n19 = 0;
            int n20 = 0;
            for (int i = 0; i < n6; ++i) {
                n15 = nArray2[i] / this.attributes[1];
                n16 = nArray3[i] / this.attributes[1];
                if (blArray[i]) {
                    if (bl) {
                        fSShapeConstructor.moveForFont(n15, -n16);
                        bl = false;
                        n19 = n15;
                        n20 = n16;
                    } else if (bl2) {
                        fSShapeConstructor.curve(n17, -n18, n15, -n16);
                        bl2 = false;
                    } else {
                        fSShapeConstructor.line(n15, -n16);
                    }
                } else {
                    if (bl2) {
                        fSShapeConstructor.curve(n17, -n18, (n15 + n17) / 2, -(n16 + n18) / 2);
                    }
                    n17 = n15;
                    n18 = n16;
                    bl2 = true;
                }
                if (i != nArray[n14]) continue;
                if (bl2) {
                    fSShapeConstructor.curve(n15, -n16, n19, -n20);
                } else {
                    fSShapeConstructor.closePath();
                }
                bl = true;
                bl2 = false;
                n17 = 0;
                n18 = 0;
                ++n14;
            }
            fSShape.getObjects().addAll(fSShapeConstructor.shape().getObjects());
        } while ((n7 & 0x10) > 0);
        this.glyphTable[n] = new FSGlyph(fSShape, new FSBounds(n2, n3, n4, n5));
        this.glyphTable[n].xCoordinates = nArray2;
        this.glyphTable[n].yCoordinates = nArray3;
        this.glyphTable[n].onCurve = blArray;
        this.glyphTable[n].endPoints = nArray;
    }

    private class FSGlyph {
        FSShape shape = null;
        FSBounds bounds = new FSBounds(0, 0, 0, 0);
        int advance = 0;
        int[] xCoordinates = null;
        int[] yCoordinates = null;
        boolean[] onCurve = null;
        int[] endPoints = null;

        FSGlyph() {
            this.shape = new FSShape();
            this.bounds = new FSBounds(0, 0, 0, 0);
            this.advance = 0;
            this.xCoordinates = new int[0];
            this.yCoordinates = new int[0];
            this.onCurve = new boolean[0];
            this.endPoints = new int[0];
        }

        FSGlyph(FSShape fSShape, FSBounds fSBounds) {
            this.shape = fSShape;
            this.bounds = fSBounds;
            this.advance = 0;
            this.xCoordinates = new int[0];
            this.yCoordinates = new int[0];
            this.onCurve = new boolean[0];
            this.endPoints = new int[0];
        }
    }
}

